/*
 * Decompiled with CFR 0.152.
 */
package pikater.agents.computing;

import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import pikater.agents.computing.Agent_ComputingAgent;
import pikater.gui.java.MyWekaOption;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Instance;
import pikater.ontology.messages.Interval;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instances;
import weka.core.Option;

public class Agent_WekaCA
extends Agent_ComputingAgent {
    private static final long serialVersionUID = -3594051562022044000L;
    private Classifier cls = null;
    private String agentType = null;
    private String wekaClassName = null;

    protected Classifier getModelObject() {
        return this.cls;
    }

    protected boolean setModelObject(Classifier _cls) {
        this.cls = _cls;
        this.agentType = null;
        this.setWekaClassName(this.cls.getClass().getName());
        return true;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public void setWekaClassName(String _className) {
        this.wekaClassName = _className;
        String[] namelst = this.wekaClassName.split("\\.");
        if (namelst.length > 0) {
            this.agentType = namelst[namelst.length - 1];
        }
    }

    public void createClassifierClass() {
        if (this.wekaClassName == null || this.wekaClassName.length() == 0) {
            return;
        }
        try {
            this.cls = Classifier.forName((String)this.wekaClassName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void train() throws Exception {
        this.working = true;
        System.out.println("Agent " + this.getLocalName() + ": Training...");
        this.cls = null;
        this.createClassifierClass();
        if (this.cls == null) {
            throw new Exception("Weka classifier class hasn't been created (Wrong type?).");
        }
        if (this.OPTIONS.length > 0) {
            this.cls.setOptions(this.OPTIONS);
        }
        this.cls.buildClassifier(this.train);
        this.state = Agent_ComputingAgent.states.TRAINED;
        this.OPTIONS = this.cls.getOptions();
        System.out.println(this.getLocalName() + " " + this.getOptions());
        this.working = false;
    }

    protected String getOptFileName() {
        return "/options/" + this.getAgentType() + ".opt";
    }

    protected Evaluation test() throws Exception {
        this.working = true;
        System.out.println("Agent " + this.getLocalName() + ": Testing...");
        Evaluation eval = null;
        eval = new Evaluation(this.train);
        eval.evaluateModel(this.cls, this.test, new Object[0]);
        System.out.println(eval.toSummaryString(this.getLocalName() + " agent: " + "\nResults\n=======\n", false));
        this.working = false;
        return eval;
    }

    protected pikater.ontology.messages.Evaluation evaluateCA() throws Exception {
        float defaultValue = 2.1474836E9f;
        Evaluation eval = this.test();
        pikater.ontology.messages.Evaluation result = new pikater.ontology.messages.Evaluation();
        result.setError_rate((float)eval.errorRate());
        try {
            result.setKappa_statistic((float)eval.kappa());
        }
        catch (Exception e) {
            result.setKappa_statistic(defaultValue);
        }
        result.setMean_absolute_error((float)eval.meanAbsoluteError());
        try {
            result.setRelative_absolute_error((float)eval.relativeAbsoluteError());
        }
        catch (Exception e) {
            result.setRelative_absolute_error(defaultValue);
        }
        result.setRoot_mean_squared_error((float)eval.rootMeanSquaredError());
        result.setRoot_relative_squared_error((float)eval.rootRelativeSquaredError());
        return result;
    }

    protected DataInstances getPredictions(Instances test, DataInstances onto_test) {
        int i;
        double[] pre = new double[test.numInstances()];
        for (i = 0; i < test.numInstances(); ++i) {
            try {
                pre[i] = this.getModelObject().classifyInstance(test.instance(i));
                continue;
            }
            catch (Exception e) {
                pre[i] = 2.147483647E9;
            }
        }
        i = 0;
        for (Instance next_instance : onto_test.getInstances()) {
            next_instance.setPrediction(pre[i]);
            ++i;
        }
        return onto_test;
    }

    private pikater.ontology.messages.Option convertOption(MyWekaOption _weka_opt) {
        pikater.ontology.messages.Option opt = new pikater.ontology.messages.Option();
        Interval interval = null;
        opt.setMutable(_weka_opt.mutable);
        interval = new Interval();
        interval.setMin(Float.valueOf(_weka_opt.lower));
        interval.setMax(Float.valueOf(_weka_opt.upper));
        opt.setRange(interval);
        if (_weka_opt.set != null) {
            ArrayList set = new ArrayList();
            for (int i = 0; i < _weka_opt.set.length; ++i) {
                set.add((Object)_weka_opt.set[i]);
            }
            opt.setSet((List)set);
        }
        opt.setIs_a_set(_weka_opt.isASet);
        interval = new Interval();
        interval.setMin(Float.valueOf(_weka_opt.numArgsMin));
        interval.setMax(Float.valueOf(_weka_opt.numArgsMax));
        opt.setNumber_of_args(interval);
        opt.setData_type(_weka_opt.type.toString());
        opt.setDescription(_weka_opt.description);
        opt.setName(_weka_opt.name);
        opt.setSynopsis(_weka_opt.synopsis);
        opt.setDefault_value(_weka_opt.default_value);
        opt.setValue(_weka_opt.default_value);
        return opt;
    }

    protected void getParameters() {
        if (this.OPTIONS_ARGS == null || this.OPTIONS_ARGS.length != 1) {
            System.err.println("Wrong arguments of WekaCA");
            return;
        }
        this.setWekaClassName(this.OPTIONS_ARGS[0]);
        this.createClassifierClass();
        System.out.println(this.getLocalName() + ": The options are: ");
        String optPath = System.getProperty("user.dir") + this.getOptFileName();
        this.agent_options = new Agent();
        this.agent_options.setName(this.getLocalName());
        this.agent_options.setType(this.getAgentType());
        try {
            FileReader input = new FileReader(optPath);
            System.out.println("OK:" + optPath);
            BufferedReader bufRead = new BufferedReader(input);
            int count = 0;
            String line = bufRead.readLine();
            ++count;
            ArrayList _options = new ArrayList();
            while (line != null) {
                System.out.println("    " + count + ": " + line);
                String delims = "[ ]+";
                String[] params = line.split(delims, 7);
                if (params[0].equals("$")) {
                    MyWekaOption.dataType dt = MyWekaOption.dataType.BOOLEAN;
                    if (params[2].equals("boolean")) {
                        dt = MyWekaOption.dataType.BOOLEAN;
                    }
                    if (params[2].equals("float")) {
                        dt = MyWekaOption.dataType.FLOAT;
                    }
                    if (params[2].equals("int")) {
                        dt = MyWekaOption.dataType.INT;
                    }
                    if (params[2].equals("mixed")) {
                        dt = MyWekaOption.dataType.MIXED;
                    }
                    String[] default_options = this.getModelObject().getOptions();
                    Enumeration en = this.getModelObject().listOptions();
                    while (en.hasMoreElements()) {
                        Option next = (Option)en.nextElement();
                        String default_value = "False";
                        for (int i = 0; i < default_options.length; ++i) {
                            if (!default_options[i].equals("-" + next.name()) || !default_options[i].startsWith("-")) continue;
                            default_value = i == default_options.length - 1 ? "True" : (default_options[i + 1].matches("\\-[A-Z]") ? "True" : default_options[i + 1]);
                        }
                        if (!next.name().equals(params[1])) continue;
                        MyWekaOption o = params.length > 4 ? new MyWekaOption(next.description(), next.name(), next.numArguments(), next.synopsis(), dt, new Integer(params[3]), new Integer(params[4]), params[5], default_value, params[6]) : new MyWekaOption(next.description(), next.name(), next.numArguments(), next.synopsis(), dt, 0, 0, "", default_value, "");
                        _options.add((Object)this.convertOption(o));
                    }
                }
                line = bufRead.readLine();
                ++count;
            }
            this.agent_options.setOptions((List)_options);
            bufRead.close();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java ReadFile filename\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(this.getLocalName() + ": Reading options from .opt file failed.");
        }
    }
}

