/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.Agent;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import pikater.Agent_GUI;
import pikater.DataManagerService;
import pikater.gui.java.improved.AgentOptionsDialog;
import pikater.gui.java.improved.DataInputFrame;
import pikater.gui.java.improved.FileBrowserFrame;
import pikater.gui.java.improved.FileDetailsFrame;
import pikater.gui.java.improved.FileGroup;
import pikater.gui.java.improved.MainWindow;
import pikater.gui.java.improved.NewExperimentFrame;
import pikater.gui.java.improved.ResultsBrowserFrame;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Evaluation;
import pikater.ontology.messages.Execute;
import pikater.ontology.messages.GetData;
import pikater.ontology.messages.GetFileInfo;
import pikater.ontology.messages.Instance;
import pikater.ontology.messages.LoadResults;
import pikater.ontology.messages.Metadata;
import pikater.ontology.messages.Option;
import pikater.ontology.messages.Results;
import pikater.ontology.messages.Task;

public class Agent_GUI_Java
extends Agent_GUI {
    private static final long serialVersionUID = -3678714827126048550L;
    protected transient MainWindow myGUI;
    private HashMap<Integer, Integer> experimentTasks = new HashMap();
    private HashMap<Integer, Integer> finishedTasks = new HashMap();

    public Agent_GUI_Java() {
        this.myGUI = new MainWindow(this);
        this.myGUI.setVisible(true);
        this.myGUI.showInfo(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("PIKATER_START"));
    }

    protected void DisplayWrongOption(int problemGuiId, String agentName, String optionName, String errorMessage) {
        this.myGUI.showError("Agent " + agentName + ": " + errorMessage);
    }

    protected void allOptionsReceived(int problemId) {
        this.sendProblem(problemId);
        this.myGUI.showInfo(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("STARTING_EXPERIMENT") + (problemId + 1));
    }

    private void showResult(Task t) {
        int problemID = Integer.parseInt(t.getId().split("_")[1]);
        int finished = this.finishedTasks.get(problemID) + 1;
        this.finishedTasks.put(problemID, finished);
        int total = this.experimentTasks.get(problemID);
        String finTot = " (" + finished + "/" + total + ")";
        this.myGUI.showInfo(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("GOT_RESULTS") + (problemID + 1) + finTot);
        String testInternalFilename = t.getData().getTest_file_name();
        String trainInternalFilename = t.getData().getTrain_file_name();
        String[] path = testInternalFilename.split(Pattern.quote(System.getProperty("file.separator")));
        testInternalFilename = path[path.length - 1];
        path = trainInternalFilename.split(Pattern.quote(System.getProperty("file.separator")));
        trainInternalFilename = path[path.length - 1];
        t.getData().setTest_file_name(DataManagerService.translateFilename((Agent)this, 1, null, testInternalFilename));
        t.getData().setTrain_file_name(DataManagerService.translateFilename((Agent)this, 1, null, trainInternalFilename));
        if (t.getResult().getStatus() == null) {
            this.myGUI.addResult(t);
        } else {
            this.myGUI.showError("Error: " + t.getResult().getStatus());
        }
    }

    protected void displayPartialResult(ACLMessage inform) {
        if (inform.getPerformative() != 7) {
            System.err.println("Received FAILURE");
            this.myGUI.showError(inform.getContent());
            return;
        }
        try {
            Result r = (Result)this.getContentManager().extractContent(inform);
            Results res = (Results)r.getValue();
            List tasks = res.getResults();
            this.myGUI.showInfo(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("GOT_RESULTS") + ((Task)tasks.get(0)).getId().split("_")[1]);
            for (Task t : tasks) {
                this.showResult(t);
            }
        }
        catch (UngroundedException e) {
            e.printStackTrace();
            this.myGUI.showError("Ungrounded exception: " + e.getLocalizedMessage());
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
            this.myGUI.showError("Codec exception: " + e.getLocalizedMessage());
        }
        catch (OntologyException e) {
            e.printStackTrace();
            this.myGUI.showError("Ontology exception: " + e.getLocalizedMessage());
        }
    }

    public List getAgentOptionsSynchronous(String agentType) {
        java.util.LinkedList<String> filterOptions = new java.util.LinkedList<String>();
        try {
            FileReader in = new FileReader("guiDisplayOptions");
            Scanner s = new Scanner(in);
            while (s.hasNextLine()) {
                filterOptions.add(s.nextLine());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        List options = null;
        try {
            options = this.getOptions(agentType);
            for (int i = options.size() - 1; i >= 0; --i) {
                Option o = (Option)options.get(i);
                if (filterOptions.contains(agentType + "-" + o.getName())) continue;
                options.remove((Object)o);
            }
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
            this.myGUI.showError("Codec Error: " + ce.getLocalizedMessage());
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
            this.myGUI.showError("Ontology Error: " + oe.getLocalizedMessage());
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
            this.myGUI.showError("FIPA error: " + fe.getLocalizedMessage());
        }
        if (options == null) {
            options = new LinkedList();
        }
        return options;
    }

    protected void displayResult(ACLMessage inform) {
        this.displayPartialResult(inform);
    }

    protected String getAgentType() {
        return "Java GUI Agent";
    }

    protected void mySetup() {
    }

    protected void onGuiEvent(GuiEvent ev) {
        switch (ev.getType()) {
            case 0: {
                GetFileInfo gfi;
                if (ev.getSource() instanceof FileBrowserFrame) {
                    FileBrowserFrame fm = (FileBrowserFrame)ev.getSource();
                    gfi = (GetFileInfo)((Object)ev.getParameter(0));
                    fm.setFiles(DataManagerService.getFilesInfo((Agent)this, gfi));
                }
                if (!(ev.getSource() instanceof NewExperimentFrame)) break;
                NewExperimentFrame nef = (NewExperimentFrame)ev.getSource();
                gfi = (GetFileInfo)((Object)ev.getParameter(0));
                nef.setFiles(DataManagerService.getFilesInfo((Agent)this, gfi));
                break;
            }
            case 1: {
                Metadata update = (Metadata)ev.getParameter(0);
                DataManagerService.updateMetadata((Agent)this, update);
                break;
            }
            case 3: {
                System.err.println(ev.getParameter(0).toString());
                String internalFilename = DataManagerService.translateFilename((Agent)this, 1, (String)ev.getParameter(0), null);
                internalFilename = "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + internalFilename;
                ServiceDescription sd = new ServiceDescription();
                sd.setType("ARFFReader");
                DFAgentDescription dfd = new DFAgentDescription();
                dfd.addServices(sd);
                try {
                    JFrame source;
                    DFAgentDescription[] readers = DFService.search((Agent)this, (DFAgentDescription)dfd);
                    if (readers.length == 0) {
                        System.err.println("No readers found");
                        break;
                    }
                    AID reader = readers[0].getName();
                    GetData gd = new GetData();
                    gd.setFile_name(internalFilename);
                    Action a = new Action();
                    a.setAction((Concept)gd);
                    a.setActor(this.getAID());
                    ACLMessage req = new ACLMessage(16);
                    req.addReceiver(reader);
                    req.setLanguage(this.codec.getName());
                    req.setOntology(this.ontology.getName());
                    req.setProtocol("fipa-request");
                    this.getContentManager().fillContent(req, (ContentElement)a);
                    ACLMessage response = FIPAService.doFipaRequestClient((Agent)this, (ACLMessage)req);
                    if (response.getPerformative() != 7) {
                        System.err.println("Error reading file");
                    }
                    Result res = (Result)this.getContentManager().extractContent(response);
                    DataInstances di = (DataInstances)res.getValue();
                    if (ev.getSource() instanceof FileDetailsFrame) {
                        source = (FileDetailsFrame)ev.getSource();
                        ((FileDetailsFrame)source).setInstances(di);
                    }
                    if (ev.getSource() instanceof ResultsBrowserFrame) {
                        source = (ResultsBrowserFrame)ev.getSource();
                        ((ResultsBrowserFrame)source).addTrainingFile((String)ev.getParameter(0), di);
                    }
                    if (!(ev.getSource() instanceof DataInputFrame)) break;
                    DataInputFrame did = (DataInputFrame)ev.getSource();
                    did.setDataInstances(di);
                }
                catch (Exception e) {
                    this.myGUI.showError("Error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                LoadResults lr = (LoadResults)((Object)ev.getParameter(0));
                Action a = new Action(this.getAID(), (Concept)lr);
                System.err.println(lr.asText());
                System.err.println(lr.asSQLCondition());
                ACLMessage req = new ACLMessage(16);
                req.addReceiver(new AID("dataManager", false));
                req.setLanguage(this.codec.getName());
                req.setOntology(this.ontology.getName());
                req.setProtocol("fipa-request");
                try {
                    this.getContentManager().fillContent(req, (ContentElement)a);
                    ACLMessage response = FIPAService.doFipaRequestClient((Agent)this, (ACLMessage)req);
                    if (response.getPerformative() != 7) {
                        System.err.println("Error getting results");
                    }
                    Result res = (Result)this.getContentManager().extractContent(response);
                    List l = (List)res.getValue();
                    if (!(ev.getSource() instanceof ResultsBrowserFrame)) break;
                    ResultsBrowserFrame source = (ResultsBrowserFrame)ev.getSource();
                    source.showResults(l);
                }
                catch (Codec.CodecException e) {
                    this.myGUI.showError("COdec error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    this.myGUI.showError("Ontology error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                catch (FIPAException e) {
                    this.myGUI.showError("FIPA error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
                break;
            }
            case 5: {
                System.err.println("GET_AGENT_TYPES");
                java.util.LinkedList<String> filterAgents = new java.util.LinkedList<String>();
                try {
                    FileReader in = new FileReader("guiDisplayAgents");
                    Scanner s = new Scanner(in);
                    while (s.hasNextLine()) {
                        filterAgents.add(s.nextLine());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                NewExperimentFrame nef = (NewExperimentFrame)ev.getSource();
                Vector<String> typesBF = this.offerAgentTypes();
                typesBF.add(0, "?");
                Vector<String> types = new Vector<String>();
                if (filterAgents.size() > 0) {
                    for (String s : typesBF) {
                        if (!filterAgents.contains(s)) continue;
                        types.add(s);
                    }
                }
                String[] agentTypes = new String[types.size()];
                for (int i = 0; i < agentTypes.length; ++i) {
                    agentTypes[i] = (String)types.get(i);
                }
                nef.setAgentTypes(agentTypes);
                break;
            }
            case 6: {
                java.util.LinkedList<String> filterOptions = new java.util.LinkedList<String>();
                try {
                    FileReader in = new FileReader("guiDisplayOptions");
                    Scanner s = new Scanner(in);
                    while (s.hasNextLine()) {
                        filterOptions.add(s.nextLine());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                AgentOptionsDialog aop = (AgentOptionsDialog)ev.getSource();
                String agentType = (String)ev.getParameter(0);
                try {
                    Option o;
                    int i;
                    List options = this.getOptions(agentType);
                    for (i = options.size() - 1; i >= 0; --i) {
                        o = (Option)options.get(i);
                        System.err.println(agentType + "-" + o.getName());
                        if (!filterOptions.contains(agentType + "-" + o.getName())) {
                            options.remove((Object)o);
                        }
                        System.err.println("-" + o.getName() + " : " + o.getSynopsis());
                    }
                    if (options == null) {
                        options = new LinkedList();
                    }
                    aop.setAgentOptions(options);
                    for (i = 0; i < options.size(); ++i) {
                        o = (Option)options.get(i);
                        System.err.println("-" + o.getName() + " : " + o.getSynopsis());
                    }
                    break;
                }
                catch (Codec.CodecException ce) {
                    ce.printStackTrace();
                    this.myGUI.showError("Codec Error: " + ce.getLocalizedMessage());
                    break;
                }
                catch (OntologyException oe) {
                    oe.printStackTrace();
                    this.myGUI.showError("Ontology Error: " + oe.getLocalizedMessage());
                    break;
                }
                catch (FIPAException fe) {
                    fe.printStackTrace();
                    this.myGUI.showError("FIPA error: " + fe.getLocalizedMessage());
                    break;
                }
            }
            case 7: {
                int i;
                LinkedList optionManager = (LinkedList)ev.getParameter(0);
                java.util.ArrayList agents = (java.util.ArrayList)ev.getParameter(1);
                java.util.ArrayList files = (java.util.ArrayList)ev.getParameter(2);
                int tasks = (Integer)ev.getParameter(3);
                int problemID = this.createNewProblem("10000", "after_each_task");
                this.experimentTasks.put(problemID, tasks);
                this.finishedTasks.put(problemID, 0);
                if (optionManager.get(0).equals("Random")) {
                    this.addMethodToProblem(problemID, optionManager.get(0).toString(), optionManager.get(1).toString(), optionManager.get(2).toString());
                }
                if (optionManager.get(0).equals("ChooseXValues")) {
                    this.addMethodToProblem(problemID, optionManager.get(0).toString(), null, null);
                    this.setDefault_number_of_values_to_try((Integer)optionManager.get(1));
                }
                for (i = 0; i < files.size(); ++i) {
                    this.addDatasetToProblem(problemID, ((FileGroup)files.get(i)).getTrainFile(), ((FileGroup)files.get(i)).getTestFile(), null, "predictions", null);
                }
                try {
                    for (i = 0; i < agents.size(); ++i) {
                        if (((pikater.ontology.messages.Agent)agents.get(i)).getType().equals("?")) {
                            System.err.println("? agent");
                            this.addAgentToProblem(problemID, null, ((pikater.ontology.messages.Agent)agents.get(i)).getType(), null);
                            continue;
                        }
                        int aid = this.addAgentToProblem(problemID, null, ((pikater.ontology.messages.Agent)agents.get(i)).getType(), null);
                        for (int j = 0; j < ((pikater.ontology.messages.Agent)agents.get(i)).getOptions().size(); ++j) {
                            String tries;
                            Option o = (Option)((pikater.ontology.messages.Agent)agents.get(i)).getOptions().get(j);
                            String string = tries = o.getNumber_of_values_to_try() != 0 ? String.valueOf(o.getNumber_of_values_to_try()) : null;
                            if (o.getIs_a_set()) {
                                String set = "";
                                for (int k = 0; k < o.getSet().size(); ++k) {
                                    set = set + o.getSet().get(k);
                                    if (k >= o.getSet().size() - 1) continue;
                                    set = set + ",";
                                }
                                System.err.println("SET PARAM: " + set);
                                this.addOptionToAgent(problemID, aid, o.getName(), o.getValue(), null, null, String.valueOf(o.getSet().size()), set);
                                continue;
                            }
                            this.addOptionToAgent(problemID, aid, o.getName(), o.getValue(), o.getRange().getMin().toString(), o.getRange().getMax().toString(), tries, null);
                        }
                    }
                    break;
                }
                catch (FailureException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case 8: {
                String fileContent = (String)ev.getParameter(0);
                String fileName = (String)ev.getParameter(1);
                DataManagerService.importFile((Agent)this, 1, fileName, fileContent, true);
                if (!(ev.getSource() instanceof DataInputFrame)) break;
                GuiEvent ge = new GuiEvent(ev.getSource(), 3);
                ge.addParameter((Object)fileName);
                this.postGuiEvent(ge);
                break;
            }
            case 9: {
                String fileContent = (String)ev.getParameter(0);
                String fileName = (String)ev.getParameter(1);
                DataManagerService.importFile((Agent)this, 1, fileName, fileContent, true);
                Execute ex = (Execute)((Object)ev.getParameter(2));
                try {
                    this.loadAgent(ex.getTask().getAgent().getName(), ex, ex.getTask().getAgent().getObject());
                    break;
                }
                catch (FIPAException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    protected void displayResurrectedResult(ACLMessage inform) {
        try {
            Result r = (Result)this.getContentManager().extractContent(inform);
            Evaluation eval = (Evaluation)r.getValue();
            DataInputFrame did = this.myGUI.getDataInputDialog();
            if (did == null) {
                return;
            }
            if (eval.getLabeled_data() == null || eval.getLabeled_data().size() == 0) {
                System.err.println("No data instances");
            }
            DataInstances di = (DataInstances)eval.getLabeled_data().get(0);
            int cIdx = di.getClass_index();
            for (int i = 0; i < di.getInstances().size(); ++i) {
                Instance inst = (Instance)di.getInstances().get(i);
                ArrayList newMissing = new ArrayList();
                for (int j = 0; j < inst.getMissing().size(); ++j) {
                    if (j == cIdx) {
                        newMissing.add((Object)false);
                        continue;
                    }
                    newMissing.add(inst.getMissing().get(j));
                }
                inst.setMissing((List)newMissing);
            }
            did.setDataInstances((DataInstances)eval.getLabeled_data().get(0));
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
    }

    protected void displayFileImportProgress(int completed, int all) {
        this.myGUI.showFileImportProgress(completed, all);
    }

    protected void displayTaskResult(ACLMessage inform) {
        if (inform.getPerformative() != 7) {
            this.myGUI.showError(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("TASK_FAILURE") + inform.getContent());
            return;
        }
        try {
            Result r = (Result)this.getContentManager().extractContent(inform);
            Task t = (Task)r.getValue();
            this.showResult(t);
        }
        catch (Codec.CodecException ex) {
            ex.printStackTrace();
        }
        catch (UngroundedException ex) {
            ex.printStackTrace();
        }
        catch (OntologyException ex) {
            ex.printStackTrace();
        }
    }
}

