/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pikater.ontology.messages.Option;

public class BooleanOptionPanel
extends JPanel {
    private ButtonGroup buttonGroup1;
    private JRadioButton keepDefaultRadio;
    private JRadioButton manualValueRadio;
    private JRadioButton setByOptManRadio;
    private JCheckBox userSpecifiedValue;

    public boolean isSetByOptionManager() {
        return this.setByOptManRadio.isSelected();
    }

    public boolean isUserSpecified() {
        return this.manualValueRadio.isSelected();
    }

    public String getUserSpecifiedValue() {
        return this.userSpecifiedValue.isSelected() ? "True" : "False";
    }

    public boolean isDefault() {
        return this.keepDefaultRadio.isSelected();
    }

    public void setOption(Option o) {
        if (o.getMutable()) {
            this.setByOptManRadio.setSelected(true);
        } else {
            this.manualValueRadio.setSelected(true);
            this.userSpecifiedValue.setSelected(o.getValue().equals("True"));
        }
    }

    public BooleanOptionPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.keepDefaultRadio = new JRadioButton();
        this.setByOptManRadio = new JRadioButton();
        this.manualValueRadio = new JRadioButton();
        this.userSpecifiedValue = new JCheckBox();
        this.buttonGroup1.add(this.keepDefaultRadio);
        this.keepDefaultRadio.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.keepDefaultRadio.setText(bundle.getString("KEEP DEFAULT VALUE"));
        this.buttonGroup1.add(this.setByOptManRadio);
        this.setByOptManRadio.setText(bundle.getString("OPTION IS SET BY OPTION MANAGER"));
        this.buttonGroup1.add(this.manualValueRadio);
        this.manualValueRadio.setText(bundle.getString("SPECIFY MANUAL VALUE"));
        this.manualValueRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BooleanOptionPanel.this.manualValueRadioStateChanged(evt);
            }
        });
        this.userSpecifiedValue.setText(bundle.getString("OPTION IS SET"));
        this.userSpecifiedValue.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.userSpecifiedValue)).addComponent(this.keepDefaultRadio).addComponent(this.setByOptManRadio).addComponent(this.manualValueRadio));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.keepDefaultRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setByOptManRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualValueRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userSpecifiedValue)));
    }

    private void manualValueRadioStateChanged(ChangeEvent evt) {
        this.userSpecifiedValue.setEnabled(this.manualValueRadio.isSelected());
    }
}

