/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import pikater.gui.java.improved.DataInstancesTableModel;
import pikater.gui.java.improved.ResultsBrowserFrame;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.Data;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Execute;
import pikater.ontology.messages.Task;

public class DataInputFrame
extends JFrame {
    DataInstancesTableModel sampleModel;
    DataInstancesTableModel model;
    DataInstances sampleInstances;
    GuiAgent myAgent;
    ResultsBrowserFrame rbf;
    byte[] object;
    private JButton addRowButton;
    private JButton clearButton;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton loadCSVButton;
    private JButton okButton;
    private JButton saveCSVButton;

    public DataInputFrame(ResultsBrowserFrame rbf, DataInstances sampleInstances, GuiAgent myAgent, byte[] object) {
        super("");
        this.rbf = rbf;
        this.initComponents();
        this.myAgent = myAgent;
        this.sampleInstances = sampleInstances;
        this.object = object;
        DataInstances myData = new DataInstances();
        myData.setAttributes(sampleInstances.getAttributes());
        myData.setClass_index(sampleInstances.getClass_index());
        myData.setName(sampleInstances.getName());
        myData.setInstances((List)new ArrayList());
        this.model = new DataInstancesTableModel(myData);
        this.sampleModel = new DataInstancesTableModel(sampleInstances);
        this.jTable1.setModel(this.model);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.okButton = new JButton();
        this.loadCSVButton = new JButton();
        this.saveCSVButton = new JButton();
        this.addRowButton = new JButton();
        this.clearButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.setTitle(bundle.getString("LABEL_DATA_FRAME"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DataInputFrame.this.formWindowClosing(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.okButton.setText(bundle.getString("LABEL_DATA_BUTTON"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataInputFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.loadCSVButton.setText(bundle.getString("LOAD_DATA"));
        this.loadCSVButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataInputFrame.this.loadCSVButtonActionPerformed(evt);
            }
        });
        this.saveCSVButton.setText(bundle.getString("SAVE_CSV"));
        this.saveCSVButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataInputFrame.this.saveCSVButtonActionPerformed(evt);
            }
        });
        this.addRowButton.setText(bundle.getString("ADD_ROW"));
        this.addRowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataInputFrame.this.addRowButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText(bundle.getString("CLEAR"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataInputFrame.this.clearButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.saveCSVButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.loadCSVButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addRowButton, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, 139, -2)).addComponent(this.jScrollPane1, -1, 784, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.addRowButton, this.clearButton, this.loadCSVButton, this.okButton, this.saveCSVButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.saveCSVButton).addComponent(this.loadCSVButton).addComponent(this.addRowButton).addComponent(this.clearButton)).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void addRowButtonActionPerformed(ActionEvent evt) {
        this.model.addNewInstance();
    }

    public String getArffData() {
        String fileName = "tempLabelFile";
        String arffHeader = "";
        arffHeader = arffHeader + "@RELATION " + fileName + "\n";
        for (int i = 0; i < this.model.getColumnCount() - 1; ++i) {
            arffHeader = arffHeader + "@ATTRIBUTE " + this.model.getColumnName(i) + " NUMERIC\n";
        }
        String[] classes = this.sampleModel.getClasses();
        String classList = "{";
        for (int i = 0; i < classes.length - 1; ++i) {
            classList = classList + classes[i] + ",";
        }
        classList = classList + classes[classes.length - 1] + "}";
        arffHeader = arffHeader + "@ATTRIBUTE " + this.model.getColumnName(this.model.getColumnCount() - 1) + " " + classList;
        String CSVString = this.model.getCSVString();
        if (CSVString.isEmpty()) {
            return null;
        }
        return arffHeader + "\n@DATA\n" + CSVString;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String arffData = this.getArffData();
        if (arffData == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("ERROR_EMPTY_DATA"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("ERROR"), 0);
            return;
        }
        this.saveCSVButton.setEnabled(false);
        this.loadCSVButton.setEnabled(false);
        this.addRowButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.okButton.setEnabled(false);
        this.okButton.setText(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("PLEASE_WAIT"));
        String fileName = "tempLabelFile_" + System.currentTimeMillis();
        GuiEvent ge = new GuiEvent((Object)this, 9);
        ge.addParameter((Object)arffData);
        ge.addParameter((Object)fileName);
        Agent a = new Agent();
        a.setName("agent" + System.currentTimeMillis());
        a.setObject(this.object);
        a.setGui_id("trained agent");
        Data d = new Data();
        d.setMode("test_only");
        d.setTest_file_name("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + "temp" + System.getProperty("file.separator") + fileName);
        d.setTrain_file_name("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + "temp" + System.getProperty("file.separator") + fileName);
        d.setExternal_test_file_name(fileName);
        d.setExternal_train_file_name(fileName);
        d.setOutput("predictions");
        Task t = new Task();
        t.setAgent(a);
        t.setData(d);
        t.setGet_results("after_each_computation");
        t.setGui_agent(this.myAgent.getName());
        t.setId("pokusny task pro pokusneho oziveneho agenta");
        t.setComputation_id("neni soucasti zadne computation");
        t.setProblem_id("neni soucasti zadneho problemu");
        Execute ex = new Execute();
        ex.setTask(t);
        ge.addParameter((Object)ex);
        this.myAgent.postGuiEvent(ge);
    }

    private void loadCSVButtonActionPerformed(ActionEvent evt) {
        Scanner s;
        JFileChooser openFile = new JFileChooser();
        FileNameExtensionFilter fnf = new FileNameExtensionFilter("CSV (*.csv)", "csv");
        openFile.setFileFilter(fnf);
        int result = openFile.showOpenDialog(this);
        if (result != 0) {
            return;
        }
        File f = openFile.getSelectedFile();
        String[] nameParts = f.getName().split("\\.");
        String extension = nameParts[nameParts.length - 1];
        String arffData = "";
        if (extension.equals("arff")) {
            try {
                s = new Scanner(f);
                while (s.hasNextLine()) {
                    arffData = arffData + s.nextLine() + "\n";
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        }
        if (extension.equals("csv")) {
            try {
                s = new Scanner(f);
                String line = s.nextLine();
                while (line.isEmpty()) {
                    line = s.nextLine();
                }
                String[] columns = line.split("[,;]");
                String arffHeader = "";
                arffHeader = arffHeader + "@RELATION " + f.getName() + "\n";
                for (int i = 0; i < columns.length - 1; ++i) {
                    arffHeader = arffHeader + "@ATTRIBUTE " + columns[i].trim() + " NUMERIC\n";
                }
                String arffContent = "@DATA\n";
                java.util.ArrayList<String> classes = new java.util.ArrayList<String>();
                while (s.hasNextLine()) {
                    line = s.nextLine();
                    if (line.isEmpty()) continue;
                    arffContent = arffContent + line.replaceAll("[;,]", ",") + "\n";
                    String className = line.split("[;,]")[columns.length - 1];
                    if (classes.contains(className)) continue;
                    classes.add(className);
                }
                String classList = "{";
                for (int i = 0; i < classes.size() - 1; ++i) {
                    classList = classList + (String)classes.get(i) + ",";
                }
                classList = classList + (String)classes.get(classes.size() - 1) + "}";
                arffHeader = arffHeader + "@ATTRIBUTE " + columns[columns.length - 1].trim() + " " + classList;
                arffData = arffHeader + "\n" + arffContent;
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        }
        GuiEvent ge = new GuiEvent((Object)this, 8);
        ge.addParameter((Object)arffData);
        ge.addParameter((Object)("tempLabelFile_" + System.currentTimeMillis()));
        this.myAgent.postGuiEvent(ge);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.rbf.dataInputDialogClosed();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        DataInstances myData = new DataInstances();
        myData.setAttributes(this.sampleInstances.getAttributes());
        myData.setClass_index(this.sampleInstances.getClass_index());
        myData.setName(this.sampleInstances.getName());
        myData.setInstances((List)new ArrayList());
        this.model = new DataInstancesTableModel(myData);
        this.jTable1.setModel(this.model);
    }

    private void saveCSVButtonActionPerformed(ActionEvent evt) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.showSaveDialog(this);
        File output = fChooser.getSelectedFile();
        if (output == null) {
            return;
        }
        try {
            FileWriter out = new FileWriter(output);
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                out.write("\"" + this.model.getColumnName(i) + "\"");
                if (i == this.model.getColumnCount() - 1) continue;
                out.write(",");
            }
            out.write("\n");
            out.write(this.model.getCSVString());
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void setDataInstances(DataInstances di) {
        this.okButton.setEnabled(true);
        this.saveCSVButton.setEnabled(true);
        this.loadCSVButton.setEnabled(true);
        this.addRowButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.okButton.setText(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("LABEL_DATA_BUTTON"));
        if (di.getAttributes() != null && di.getAttributes().size() != this.sampleInstances.getAttributes().size()) {
            JOptionPane.showMessageDialog(this, "Incompatible data sets", "Error", 0);
            return;
        }
        DataInstances myData = new DataInstances();
        myData.setAttributes(this.sampleInstances.getAttributes());
        myData.setClass_index(this.sampleInstances.getClass_index());
        myData.setName(this.sampleInstances.getName());
        myData.setInstances(di.getInstances());
        this.model = new DataInstancesTableModel(myData);
        this.jTable1.setModel(this.model);
    }
}

