/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import pikater.ontology.messages.Attribute;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Instance;

public class DataInstancesTableModel
extends AbstractTableModel {
    DataInstances instance = null;
    String[] classes;
    private static final long serialVersionUID = 8207067033399270730L;

    public int getClassIndex() {
        if (this.instance.getClass_index() >= 0) {
            return this.instance.getClass_index();
        }
        return ((Instance)this.instance.getInstances().get(0)).getValues().size() - 1;
    }

    public Instance getInstance(int rowIndex) {
        return (Instance)this.instance.getInstances().get(rowIndex);
    }

    public String[] getClasses() {
        HashMap<String, Integer> classCounts = new HashMap<String, Integer>();
        int classIndex = this.getClassIndex();
        for (int i = 0; i < this.instance.getInstances().size(); ++i) {
            Instance inst = (Instance)this.instance.getInstances().get(i);
            String iClass = this.getValueAt(i, classIndex).toString();
            if (classCounts.get(iClass) != null) {
                classCounts.put(iClass, (Integer)classCounts.get(iClass) + 1);
                continue;
            }
            classCounts.put(iClass, 1);
        }
        Object[] oClasses = classCounts.keySet().toArray();
        String[] classes = new String[oClasses.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = (String)oClasses[i];
        }
        return classes;
    }

    public DataInstancesTableModel(DataInstances instance) {
        this.instance = instance;
    }

    public int getColumnCount() {
        return this.instance.getAttributes().size();
    }

    public int getRowCount() {
        return this.instance.getInstances().size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.instance.toString(rowIndex, columnIndex);
    }

    public String getColumnName(int column) {
        return ((Attribute)this.instance.getAttributes().get(column)).getName();
    }

    public boolean isCellEditable(int row, int column) {
        return column < this.getColumnCount() - 1;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Instance inst = (Instance)this.instance.getInstances().get(rowIndex);
        List values = inst.getValues();
        List missing = inst.getMissing();
        try {
            ArrayList newValues = new ArrayList();
            ArrayList newMissing = new ArrayList();
            for (int i = 0; i < values.size(); ++i) {
                if (i == columnIndex) {
                    newValues.add((Object)(aValue.toString().equals("?") ? -1.0 : NumberFormat.getInstance().parse(aValue.toString()).doubleValue()));
                    newMissing.add((Object)(aValue.toString().equals("?") ? 1 : 0));
                    continue;
                }
                newValues.add(values.get(i));
                newMissing.add(missing.get(i));
            }
            inst.setValues((List)newValues);
            inst.setMissing((List)newMissing);
            super.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
    }

    public String getCSVString() {
        String output = "";
        for (int j = 0; j < this.getRowCount(); ++j) {
            boolean allMissing = true;
            String line = "";
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!this.getValueAt(j, i).equals("?")) {
                    allMissing = false;
                }
                line = i < this.getColumnCount() - 1 ? line + this.getValueAt(j, i).toString() + "," : line + this.getValueAt(j, i).toString() + "\n";
            }
            if (allMissing) continue;
            output = output + line;
        }
        return output;
    }

    public void addNewInstance() {
        List instances = this.instance.getInstances();
        Instance inst = new Instance();
        ArrayList values = new ArrayList();
        ArrayList missing = new ArrayList();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            values.add((Object)-1.0);
            missing.add((Object)true);
        }
        inst.setMissing((List)missing);
        inst.setValues((List)values);
        this.instance.getInstances().add((Object)inst);
        this.fireTableDataChanged();
    }
}

