/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.util.leap.ArrayList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import pikater.gui.java.improved.FileDetailsFrame;
import pikater.gui.java.improved.GuiConstants;
import pikater.gui.java.improved.TableColumnAdjuster;
import pikater.ontology.messages.GetFileInfo;
import pikater.ontology.messages.Metadata;

public class FileBrowserFrame
extends JFrame
implements GuiConstants {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
    GuiAgent myAgent;
    FilesTableModel fileListModel;
    private JComboBox attType;
    private JComboBox defaultTask;
    private JTextField filenameText;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JComboBox missAttr;
    private JCheckBox nAttrActive;
    private JSpinner nAttrLower;
    private JSpinner nAttrUpper;
    private JCheckBox nInstActive;
    private JSpinner nInstLower;
    private JSpinner nInstUpper;
    private JButton okButton;
    private JButton showDetailsButton;

    public FileBrowserFrame(GuiAgent myAgent) {
        this.initComponents();
        this.myAgent = myAgent;
        this.fileListModel = new FilesTableModel();
    }

    public void reloadFileInfo() {
        GuiEvent ge = new GuiEvent((Object)this, 0);
        GetFileInfo gfi = new GetFileInfo();
        gfi.setUserID(1);
        ge.addParameter((Object)gfi);
        this.myAgent.postGuiEvent(ge);
    }

    public void setFiles(ArrayList data) {
        this.fileListModel.setFiles(data);
        this.jTable1.setModel(this.fileListModel);
        this.jTable1.createDefaultColumnsFromModel();
        TableColumnAdjuster tca = new TableColumnAdjuster(this.jTable1);
        tca.adjustColumns();
    }

    public FileBrowserFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.missAttr = new JComboBox();
        this.jLabel8 = new JLabel();
        this.attType = new JComboBox();
        this.jLabel9 = new JLabel();
        this.defaultTask = new JComboBox();
        this.jLabel10 = new JLabel();
        this.filenameText = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.nInstActive = new JCheckBox();
        this.nInstUpper = new JSpinner();
        this.jLabel6 = new JLabel();
        this.nInstLower = new JSpinner();
        this.nAttrActive = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.nAttrUpper = new JSpinner();
        this.jLabel7 = new JLabel();
        this.nAttrLower = new JSpinner();
        this.jLabel4 = new JLabel();
        this.okButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.showDetailsButton = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.jMenuItem1.setLabel(bundle.getString("VIEW..."));
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FileBrowserFrame.this.jMenuItem1MouseClicked(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.setTitle(bundle.getString("PIKATER_FILE_BROWSER"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("FILTER")));
        ResourceBundle bundle1 = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.jLabel1.setText(bundle1.getString("MISSING VALUES"));
        this.missAttr.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "Yes", "No"}));
        this.jLabel8.setText(bundle1.getString("ATTRIUTES TYPE"));
        this.attType.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "Numeric", "Categorical", "Multivariate"}));
        this.jLabel9.setText(bundle1.getString("DEFAULT TASK"));
        this.defaultTask.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "Classification", "Regression"}));
        this.jLabel10.setText(bundle1.getString("FILENAME"));
        this.jLabel2.setText(bundle1.getString("NUMBER OF INSTANCES"));
        this.jLabel5.setText("<=");
        this.nInstActive.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FileBrowserFrame.this.nInstActiveStateChanged(evt);
            }
        });
        this.nInstUpper.setEnabled(false);
        this.jLabel6.setText(bundle1.getString("NUMBER OF ATTRIBUTES"));
        this.nInstLower.setEnabled(false);
        this.nAttrActive.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FileBrowserFrame.this.nAttrActiveStateChanged(evt);
            }
        });
        this.jLabel3.setText("<=");
        this.nAttrUpper.setEnabled(false);
        this.jLabel7.setText("<=");
        this.nAttrLower.setEnabled(false);
        this.jLabel4.setText("<=");
        this.okButton.setText(bundle1.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileBrowserFrame.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultTask, -2, -1, -2).addComponent(this.missAttr, -2, 91, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.filenameText).addComponent(this.attType, 0, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nAttrLower).addComponent(this.nInstLower, -2, 57, -2)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nInstUpper, -2, 70, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nAttrUpper))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nAttrActive).addComponent(this.nInstActive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.nInstLower, this.nInstUpper);
        jPanel1Layout.linkSize(0, this.jLabel2, this.jLabel6);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.missAttr, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.attType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultTask, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.filenameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nInstLower, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.nInstUpper, -2, -1, -2).addComponent(this.nInstActive)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.nAttrLower, -2, -1, -2).addComponent(this.nAttrUpper, -2, -1, -2).addComponent(this.nAttrActive))).addComponent(this.okButton)).addContainerGap()));
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setSelectionMode(0);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FileBrowserFrame.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.showDetailsButton.setText(bundle.getString("SHOW_FILES_DETAILS"));
        this.showDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileBrowserFrame.this.showDetailsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 485, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.showDetailsButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showDetailsButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.jTable1.getSelectedRowCount() > 0) {
            this.jPopupMenu1.setVisible(true);
            this.jPopupMenu1.setLocation(evt.getLocationOnScreen());
        } else {
            this.jPopupMenu1.setVisible(false);
        }
    }

    private void jMenuItem1MouseClicked(MouseEvent evt) {
        this.jPopupMenu1.setVisible(false);
        String filename = this.jTable1.getModel().getValueAt(this.jTable1.getSelectedRow(), 0).toString();
        FileDetailsFrame fdf = new FileDetailsFrame(filename, this.myAgent);
        fdf.setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        GetFileInfo gfi = new GetFileInfo();
        gfi.setUserID(1);
        if (this.nAttrActive.isSelected()) {
            gfi.setAttrUpper((Integer)this.nAttrUpper.getValue());
            gfi.setAttrLower((Integer)this.nAttrLower.getValue());
        }
        if (this.nInstActive.isSelected()) {
            gfi.setInstLower((Integer)this.nInstLower.getValue());
            gfi.setInstUpper((Integer)this.nInstUpper.getValue());
        }
        if (!this.filenameText.getText().isEmpty()) {
            gfi.setFilename(this.filenameText.getText());
        }
        if (this.missAttr.getSelectedIndex() > 0) {
            gfi.setMissingValues(this.missAttr.getSelectedIndex() == 1);
        }
        if (this.attType.getSelectedIndex() > 0) {
            gfi.setAttributeType(this.attType.getSelectedItem().toString());
        }
        if (this.defaultTask.getSelectedIndex() > 0) {
            gfi.setDefaultTask(this.defaultTask.getSelectedItem().toString());
        }
        GuiEvent ge = new GuiEvent((Object)this, 0);
        ge.addParameter((Object)gfi);
        this.myAgent.postGuiEvent(ge);
    }

    private void nInstActiveStateChanged(ChangeEvent evt) {
        this.nInstLower.setEnabled(this.nInstActive.isSelected());
        this.nInstUpper.setEnabled(this.nInstActive.isSelected());
    }

    private void nAttrActiveStateChanged(ChangeEvent evt) {
        this.nAttrLower.setEnabled(this.nAttrActive.isSelected());
        this.nAttrUpper.setEnabled(this.nAttrActive.isSelected());
    }

    private void showDetailsButtonActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRow() > 0) {
            this.jMenuItem1MouseClicked(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5772409714155549244L;
        ArrayList data = new ArrayList();

        private String columnName(int index) {
            switch (index) {
                case 0: {
                    return bundle.getString("FILENAME");
                }
                case 1: {
                    return bundle.getString("NUMBER_OF_ATTRIBUTES");
                }
                case 2: {
                    return bundle.getString("ATTRIBUTES_TYPE");
                }
                case 3: {
                    return bundle.getString("NUMBER_OF_INSTANCES");
                }
                case 4: {
                    return bundle.getString("MISSING_VALUES");
                }
                case 5: {
                    return bundle.getString("DEFAULT_TASK");
                }
            }
            return "";
        }

        private Object getColumnValue(Metadata m, int index) {
            switch (index) {
                case 0: {
                    return m.getExternal_name();
                }
                case 1: {
                    return m.getNumber_of_attributes();
                }
                case 2: {
                    return m.getAttribute_type();
                }
                case 3: {
                    return m.getNumber_of_instances();
                }
                case 4: {
                    return m.getMissing_values();
                }
                case 5: {
                    return m.getDefault_task();
                }
            }
            return "";
        }

        private void setColumnValue(Metadata m, int index, Object value) {
            switch (index) {
                case 0: {
                    m.setExternal_name((String)value);
                    break;
                }
                case 1: {
                    m.setNumber_of_attributes((Integer)value);
                    break;
                }
                case 2: {
                    m.setAttribute_type((String)value);
                    break;
                }
                case 3: {
                    m.setNumber_of_instances((Integer)value);
                    break;
                }
                case 4: {
                    m.setMissing_values((Boolean)value);
                    break;
                }
                case 5: {
                    m.setDefault_task((String)value);
                }
            }
        }

        public void setFiles(ArrayList data) {
            this.data = data;
        }

        public FilesTableModel() {
            FileBrowserFrame.this.reloadFileInfo();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.data == null) {
                return String.class;
            }
            Object value = this.getColumnValue((Metadata)this.data.get(0), columnIndex);
            if (value == null) {
                return String.class;
            }
            return this.getColumnValue((Metadata)this.data.get(0), columnIndex).getClass();
        }

        @Override
        public int getColumnCount() {
            if (this.data == null || this.data.size() == 0) {
                return 0;
            }
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnName(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = this.getColumnValue((Metadata)this.data.get(rowIndex), columnIndex);
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Metadata update = (Metadata)this.data.get(rowIndex);
            this.setColumnValue(update, columnIndex, aValue);
            GuiEvent ge = new GuiEvent((Object)this, 1);
            ge.addParameter((Object)update);
            FileBrowserFrame.this.myAgent.postGuiEvent(ge);
        }
    }
}

