/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pikater.gui.java.improved.verifiers.FloatSetInputVerifier;
import pikater.gui.java.improved.verifiers.IntegerSetInputVerifier;
import pikater.ontology.messages.Option;

public class IntegerOptionPanel
extends JPanel {
    String dataType;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JRadioButton defaultValueRadio;
    private JSpinner fromSpinner;
    private JRadioButton intervalRadio;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSpinner manualSpinner;
    private JRadioButton manualValue;
    private JRadioButton setRadio;
    private JTextField setTextField;
    private JSpinner toSpinner;
    private JSpinner triesSpinner;
    private JRadioButton valueSetByOptMan;

    public boolean isDefault() {
        return this.defaultValueRadio.isSelected();
    }

    public boolean isSetByOptionManager() {
        return this.valueSetByOptMan.isSelected();
    }

    public boolean isUserSpecified() {
        return this.manualValue.isSelected();
    }

    public boolean isInterval() {
        return this.intervalRadio.isSelected();
    }

    public boolean isSet() {
        return this.setRadio.isSelected();
    }

    public String getSet() {
        try {
            if (this.dataType.equals("INT")) {
                return this.setTextField.getText();
            }
            String[] numbers = this.setTextField.getText().split(" ");
            String outNumbers = "";
            NumberFormat nf = NumberFormat.getInstance();
            for (int i = 0; i < numbers.length; ++i) {
                ParsePosition pos = new ParsePosition(0);
                outNumbers = i < numbers.length - 1 ? outNumbers + nf.parse(numbers[i], pos).floatValue() + " " : outNumbers + nf.parse(numbers[i], pos).floatValue();
                if (pos.getIndex() == numbers[i].length()) continue;
                throw new ParseException("Incorrect string", pos.getIndex());
            }
            return outNumbers;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Incorrect number format", "Error", 0);
            return null;
        }
    }

    public Float getLowerLimit() {
        return Float.valueOf(Float.parseFloat(this.fromSpinner.getValue().toString()));
    }

    public Float getUpperLimit() {
        return Float.valueOf(Float.parseFloat(this.toSpinner.getValue().toString()));
    }

    public int getNumberOfTries() {
        return (Integer)this.triesSpinner.getValue();
    }

    public String getUserSpecifiedValue() {
        return this.manualSpinner.getValue().toString();
    }

    public void setOption(Option o) {
        int i;
        String set;
        System.err.println(o.getName());
        if (this.dataType.equals("INT")) {
            if (o.getValue().contains("?")) {
                this.valueSetByOptMan.setSelected(true);
                if (o.getRange().getMin() != null && o.getRange().getMax() != null) {
                    this.intervalRadio.setSelected(true);
                    this.fromSpinner.setValue(o.getRange().getMin().intValue());
                    this.toSpinner.setValue(o.getRange().getMax().intValue());
                }
                if (o.getIs_a_set()) {
                    this.setRadio.setSelected(true);
                    set = "";
                    for (i = 0; i < o.getSet().size(); ++i) {
                        set = set + o.getSet().get(i).toString();
                        if (i == o.getSet().size() - 1) continue;
                        set = set + " ";
                    }
                    this.setTextField.setText(set);
                }
                this.triesSpinner.setValue(o.getNumber_of_values_to_try());
            } else {
                this.manualValue.setSelected(true);
                this.manualSpinner.setValue(Integer.parseInt(o.getValue()));
            }
        }
        if (this.dataType.equals("FLOAT")) {
            if (o.getValue().contains("?")) {
                this.valueSetByOptMan.setSelected(true);
                if (o.getRange().getMin() != null && o.getRange().getMax() != null) {
                    this.fromSpinner.setValue(o.getRange().getMin());
                    this.toSpinner.setValue(o.getRange().getMax());
                }
                if (o.getIs_a_set()) {
                    this.setRadio.setSelected(true);
                    set = "";
                    for (i = 0; i < o.getSet().size(); ++i) {
                        set = set + o.getSet().get(i).toString();
                        if (i == o.getSet().size() - 1) continue;
                        set = set + " ";
                    }
                    this.setTextField.setText(set);
                }
                this.triesSpinner.setValue(o.getNumber_of_values_to_try());
            } else {
                this.manualValue.setSelected(true);
                this.manualSpinner.setValue(Float.valueOf(Float.parseFloat(o.getValue())));
            }
        }
    }

    public IntegerOptionPanel() {
        this.initComponents();
    }

    public IntegerOptionPanel(int lower, int upper, int tries, int defaultValue) {
        this.dataType = "INT";
        this.initComponents();
        this.fromSpinner.setModel(new SpinnerNumberModel(lower, lower, upper, 1));
        this.toSpinner.setModel(new SpinnerNumberModel(upper, lower, upper, 1));
        this.manualSpinner.setModel(new SpinnerNumberModel(defaultValue, lower, upper, 1));
        this.triesSpinner.setModel(new SpinnerNumberModel(tries, 0, 100, 1));
        this.jPanel1.setVisible(false);
        this.jPanel2.setVisible(false);
        this.setTextField.setInputVerifier(new IntegerSetInputVerifier(this));
    }

    public IntegerOptionPanel(double lower, double upper, int tries, double defaultValue) {
        this.dataType = "FLOAT";
        this.initComponents();
        this.fromSpinner.setModel(new SpinnerNumberModel(lower, lower, upper, 0.01));
        this.toSpinner.setModel(new SpinnerNumberModel(upper, lower, upper, 0.01));
        this.manualSpinner.setModel(new SpinnerNumberModel(defaultValue, lower, upper, 0.01));
        this.triesSpinner.setModel(new SpinnerNumberModel(tries, 0, 100, 1));
        this.jPanel1.setVisible(false);
        this.jPanel2.setVisible(false);
        this.setTextField.setInputVerifier(new FloatSetInputVerifier(this));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.toSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.fromSpinner = new JSpinner();
        this.triesSpinner = new JSpinner();
        this.intervalRadio = new JRadioButton();
        this.setRadio = new JRadioButton();
        this.setTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.manualSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.defaultValueRadio = new JRadioButton();
        this.valueSetByOptMan = new JRadioButton();
        this.manualValue = new JRadioButton();
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("AUTO_SETTINGS")));
        this.jPanel1.setEnabled(false);
        ResourceBundle bundle1 = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.jLabel3.setText(bundle1.getString("TO"));
        this.jLabel3.setEnabled(false);
        this.jLabel4.setText(bundle1.getString("MAXIMUM TRIES"));
        this.jLabel4.setEnabled(false);
        this.toSpinner.setEnabled(false);
        this.jLabel2.setText(bundle1.getString("TRY VALUES FROM"));
        this.jLabel2.setEnabled(false);
        this.fromSpinner.setEnabled(false);
        this.triesSpinner.setEnabled(false);
        this.buttonGroup2.add(this.intervalRadio);
        this.intervalRadio.setSelected(true);
        this.intervalRadio.setText(bundle1.getString("INTERVAL"));
        this.intervalRadio.setEnabled(false);
        this.buttonGroup2.add(this.setRadio);
        this.setRadio.setText(bundle1.getString("SET"));
        this.setRadio.setEnabled(false);
        this.setTextField.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.triesSpinner, -2, 53, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intervalRadio).addComponent(this.setRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.fromSpinner, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.toSpinner, -2, 70, -2)).addComponent(this.setTextField, -1, 179, Short.MAX_VALUE)).addGap(36, 36, 36))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.fromSpinner, this.toSpinner);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.intervalRadio).addComponent(this.toSpinner, -2, -1, -2).addComponent(this.fromSpinner, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setRadio).addComponent(this.setTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.triesSpinner, -2, -1, -2)).addGap(17, 17, 17)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("MANUAL_SETTINGS")));
        this.jPanel2.setEnabled(false);
        this.manualSpinner.setEnabled(false);
        this.jLabel1.setLabelFor(this.manualSpinner);
        this.jLabel1.setText(bundle1.getString("VALUE"));
        this.jLabel1.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualSpinner, -2, 96, -2).addContainerGap(117, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.manualSpinner, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap()));
        this.buttonGroup1.add(this.defaultValueRadio);
        this.defaultValueRadio.setSelected(true);
        this.defaultValueRadio.setText(bundle1.getString("KEEP DEFAULT VALUE"));
        this.defaultValueRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IntegerOptionPanel.this.defaultValueRadioActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.valueSetByOptMan);
        this.valueSetByOptMan.setText(bundle1.getString("VALUE IS SET BY OPTION MANAGER"));
        this.valueSetByOptMan.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                IntegerOptionPanel.this.valueSetByOptManStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.manualValue);
        this.manualValue.setText(bundle1.getString("SPECIFY MANUAL VALUE"));
        this.manualValue.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                IntegerOptionPanel.this.manualValueStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.defaultValueRadio).addComponent(this.valueSetByOptMan).addComponent(this.manualValue).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, 281, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.defaultValueRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueSetByOptMan).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 123, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(24, 24, 24)));
    }

    private void defaultValueRadioActionPerformed(ActionEvent evt) {
    }

    private void valueSetByOptManStateChanged(ChangeEvent evt) {
        this.jPanel1.setVisible(this.valueSetByOptMan.isSelected());
        for (Component c : this.jPanel1.getComponents()) {
            c.setEnabled(this.valueSetByOptMan.isSelected());
        }
    }

    private void manualValueStateChanged(ChangeEvent evt) {
        this.jPanel2.setVisible(this.manualValue.isSelected());
        for (Component c : this.jPanel2.getComponents()) {
            c.setEnabled(this.manualValue.isSelected());
        }
    }
}

