/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.core.Agent;
import jade.gui.GuiAgent;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import pikater.DataManagerService;
import pikater.gui.java.improved.AboutDialog;
import pikater.gui.java.improved.DataInputFrame;
import pikater.gui.java.improved.FileBrowserFrame;
import pikater.gui.java.improved.FileImportProgressDialog;
import pikater.gui.java.improved.NewExperimentFrame;
import pikater.gui.java.improved.ResultsBrowserFrame;
import pikater.gui.java.improved.TableColumnAdjuster;
import pikater.ontology.messages.Task;

public class MainWindow
extends JFrame {
    GuiAgent myAgent;
    ResultsBrowserFrame rbf;
    NewExperimentFrame nef;
    TableColumnAdjuster tca;
    FileImportProgressDialog fipd = null;
    Thread fipdThread = null;
    ArrayList<Integer> experimentOptions = new ArrayList();
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JToolBar jToolBar1;
    private JTable logTable;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JButton resultsBrowserButton;

    public MainWindow() {
        this.initComponents();
    }

    public MainWindow(GuiAgent myAgent) {
        this.myAgent = myAgent;
        this.rbf = new ResultsBrowserFrame(myAgent);
        this.nef = new NewExperimentFrame((Frame)this, true, myAgent);
        this.initComponents();
        this.logTable.getColumnModel().getColumn(0).setHeaderValue(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("LOG_TIME"));
        this.logTable.getColumnModel().getColumn(1).setHeaderValue(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("LOG_EVENT"));
        this.tca = new TableColumnAdjuster(this.logTable);
        this.jButton3.setIcon(new ImageIcon("images/Virginia_Iris.png"));
        this.jButton4.setIcon(new ImageIcon("images/Muybridge_runner.jpg"));
    }

    public DataInputFrame getDataInputDialog() {
        return this.rbf.getDataInputDialog();
    }

    public void showFileImportProgress(int completed, int all) {
        if (all == 0) {
            return;
        }
        if (this.fipd == null) {
            this.fipd = new FileImportProgressDialog((Frame)this, true);
            this.fipd.setMax(all);
            this.fipd.setValue(completed);
            this.fipdThread = new Thread(new Runnable(){

                public void run() {
                    MainWindow.this.fipd.setVisible(true);
                }
            });
            this.fipdThread.start();
        } else {
            this.fipd.setValue(completed);
            if (completed == all) {
                this.fipd.setVisible(false);
                try {
                    this.fipdThread.join();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    public void showInfo(String info) {
        String infoText = "<html><body><font color = green>" + info + "<br></font></body></html>";
        String date = "<html><body><font color = green>" + DateFormat.getDateTimeInstance(3, 3).format(new Date()) + "<br></font></body></html>";
        DefaultTableModel dtm = (DefaultTableModel)this.logTable.getModel();
        Object[] row = new Object[]{date, infoText};
        dtm.addRow(row);
        this.tca.adjustColumns();
    }

    public void showError(String error) {
        String infoText = "<html><body><font color = red>" + error + "<br></font></body></html>";
        String date = "<html><body><font color = red>" + DateFormat.getDateTimeInstance(3, 3).format(new Date()) + "<br></font></body></html>";
        DefaultTableModel dtm = (DefaultTableModel)this.logTable.getModel();
        Object[] row = new Object[]{date, infoText};
        dtm.addRow(row);
        this.tca.adjustColumns();
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.jToolBar1 = new JToolBar();
        this.resultsBrowserButton = new JButton();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.logTable = new JTable();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle("BANG 1.0");
        this.setMinimumSize(this.getPreferredSize());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainWindow.this.formWindowClosing(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.resultsBrowserButton.setText(bundle.getString("RESULTS_BROWSER"));
        this.resultsBrowserButton.setFocusable(false);
        this.resultsBrowserButton.setHorizontalTextPosition(0);
        this.resultsBrowserButton.setVerticalTextPosition(3);
        this.resultsBrowserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.resultsBrowserButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.resultsBrowserButton);
        this.jButton2.setText(bundle.getString("FILE_BROWSER"));
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton1.setText(bundle.getString("NEW_EXPERIMENT"));
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton3.setText("Iris");
        this.jButton3.setToolTipText(bundle.getString("IRIS_TOOLTIP"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText(bundle.getString("OWN_EXPERIMENT"));
        this.jButton4.setToolTipText(bundle.getString("CUSTOM_TOOLTIP"));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.jButton4ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton3, -2, 162, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4, -2, 190, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jButton3, this.jButton4);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton4, GroupLayout.Alignment.LEADING, -1, 155, Short.MAX_VALUE).addComponent(this.jButton3, GroupLayout.Alignment.LEADING, -2, 155, -2)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButton3, this.jButton4);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("LOG_BORDER_TITLE")));
        this.logTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.logTable);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 376, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 158, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.fileMenu.setText(bundle.getString("FILE"));
        this.openMenuItem.setText(bundle.getString("OPEN"));
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setText(bundle.getString("EXIT"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText(bundle.getString("HELP"));
        this.contentsMenuItem.setText(bundle.getString("CONTENTS"));
        this.contentsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.contentsMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText(bundle.getString("ABOUT"));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 422, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        FileBrowserFrame fileBrowserFrame = new FileBrowserFrame(this.myAgent);
        fileBrowserFrame.setVisible(true);
    }

    private void resultsBrowserButtonActionPerformed(ActionEvent evt) {
        this.rbf.setVisible(true);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.nef = new NewExperimentFrame((Frame)this, true, this.myAgent);
        this.nef.setVisible(true);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.nef = new NewExperimentFrame((Frame)this, true, this.myAgent);
        this.nef.loadXML(new File("iris.xml"));
        this.nef.setVisible(true);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.nef = new NewExperimentFrame((Frame)this, true, this.myAgent);
        if (!this.nef.openFileDialog()) {
            return;
        }
        this.nef.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        DataManagerService.deleteTempFiles((Agent)this.myAgent);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog ad = new AboutDialog((Frame)this, false);
        ad.setVisible(true);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        FileNameExtensionFilter fnf = new FileNameExtensionFilter("XML Files (*.bxml)", "bxml");
        jfc.setFileFilter(fnf);
        int result = jfc.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.nef = new NewExperimentFrame((Frame)this, true, this.myAgent);
        this.nef.loadXML(jfc.getSelectedFile());
        this.nef.setVisible(true);
    }

    private void contentsMenuItemActionPerformed(ActionEvent evt) {
        String helpHS = "BANGHelp.hs";
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        HelpSet hs = null;
        try {
            URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
            hs = new HelpSet(null, hsURL);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.out.println("HelpSet " + ee.getMessage());
            System.out.println("HelpSet " + helpHS + " not found");
            return;
        }
        HelpBroker hb = hs.createHelpBroker();
        hb.setDisplayed(true);
    }

    public void addResult(Task t) {
        this.rbf.addResult(t);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainWindow().setVisible(true);
            }
        });
    }
}

