/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.util.leap.ArrayList;
import jade.util.leap.LinkedList;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import pikater.gui.java.Agent_GUI_Java;
import pikater.gui.java.improved.AgentOptionsDialog;
import pikater.gui.java.improved.FileGroup;
import pikater.gui.java.improved.FileGroupsPanel;
import pikater.gui.java.improved.OptionManagerDialog;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.GetFileInfo;
import pikater.ontology.messages.Interval;
import pikater.ontology.messages.Metadata;
import pikater.ontology.messages.Option;

public class NewExperimentFrame
extends JDialog {
    java.util.ArrayList<String> files = new java.util.ArrayList();
    java.util.ArrayList<AgentOptionsDialog> agentDialogs = new java.util.ArrayList();
    AgentsListModel agentList = new AgentsListModel();
    FileGroupsModel fileGroups = new FileGroupsModel();
    String[] agentTypes;
    GuiAgent myAgent;
    OptionManagerDialog omd = new OptionManagerDialog((Frame)this.getParent(), true);
    private JButton addAgentButton;
    private JButton addFilesButton;
    private JList agentJList;
    private JButton editAgentButton;
    private JButton editOptionManagerButton;
    private JFileChooser fileDialog;
    private JList filesJList;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel optManagerLabel;
    private JButton removeAgentButton;
    private JButton removeFilesButton;
    private JButton startExperimentButton;

    public int getNumberOfTasks() {
        int sum = 0;
        for (Agent a : this.agentList.agents) {
            int product = 1;
            for (int i = 0; i < a.getOptions().size(); ++i) {
                Option o = (Option)a.getOptions().get(i);
                product *= o.getNumberOfOptions();
            }
            sum += product;
        }
        return sum;
    }

    public boolean openFileDialog() {
        this.addFilesButtonActionPerformed(null);
        return this.fileGroups.getSize() > 0;
    }

    public void setFiles(ArrayList files) {
        this.files.clear();
        for (int i = 0; i < files.size(); ++i) {
            this.files.add(((Metadata)files.get(i)).getExternal_name());
            System.err.println(files.get(i));
        }
    }

    public NewExperimentFrame(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public NewExperimentFrame(Frame parent, boolean modal, GuiAgent myAgent) {
        super(parent, modal);
        this.initComponents();
        this.myAgent = myAgent;
        this.optManagerLabel.setText(this.omd.getGuiString());
        GuiEvent ge = new GuiEvent((Object)this, 5);
        myAgent.postGuiEvent(ge);
        GetFileInfo gfi = new GetFileInfo();
        gfi.setUserID(1);
        if (new File("studentMode").exists()) {
            this.remove(this.jPanel1);
            this.pack();
        }
        ge = new GuiEvent((Object)this, 0);
        ge.addParameter((Object)gfi);
        myAgent.postGuiEvent(ge);
    }

    public void setAgentTypes(String[] agentTypes) {
        this.agentTypes = agentTypes;
        for (String s : agentTypes) {
            System.err.println("agent: " + s);
        }
    }

    private void initComponents() {
        this.fileDialog = new JFileChooser();
        this.jPanel1 = new JPanel();
        this.optManagerLabel = new JLabel();
        this.editOptionManagerButton = new JButton();
        this.jPanel2 = new JPanel();
        this.addAgentButton = new JButton();
        this.removeAgentButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.agentJList = new JList();
        this.editAgentButton = new JButton();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.filesJList = new JList();
        this.addFilesButton = new JButton();
        this.removeFilesButton = new JButton();
        this.startExperimentButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.fileDialog.setDialogTitle(bundle.getString("LOAD XML"));
        this.fileDialog.setFileFilter(null);
        ResourceBundle bundle1 = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.setTitle(bundle1.getString("NEW_EXPERIMENT_FRAME_TITLE"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle1.getString("OPTION_MANAGER")));
        this.optManagerLabel.setText("Random -E 0.1 -M 5");
        this.editOptionManagerButton.setText(bundle.getString("EDIT"));
        this.editOptionManagerButton.setMaximumSize(new Dimension(59, 25));
        this.editOptionManagerButton.setMinimumSize(new Dimension(59, 25));
        this.editOptionManagerButton.setPreferredSize(new Dimension(59, 25));
        this.editOptionManagerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.editOptionManagerButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.optManagerLabel, -1, 261, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.editOptionManagerButton, -2, 83, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optManagerLabel).addComponent(this.editOptionManagerButton, -2, -1, -2)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle1.getString("AGENTS")));
        this.addAgentButton.setText(bundle.getString("ADD"));
        this.addAgentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.addAgentButtonActionPerformed(evt);
            }
        });
        this.removeAgentButton.setText(bundle.getString("REMOVE"));
        this.removeAgentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.removeAgentButtonActionPerformed(evt);
            }
        });
        this.agentJList.setModel(this.agentList);
        this.agentJList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.agentJList);
        this.editAgentButton.setText(bundle.getString("EDIT"));
        this.editAgentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.editAgentButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 236, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addAgentButton, -1, 105, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editAgentButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeAgentButton, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.addAgentButton, this.editAgentButton, this.removeAgentButton);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.addAgentButton, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAgentButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.editAgentButton))).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(bundle1.getString("FILE_GROUPS")));
        this.filesJList.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.filesJList);
        this.addFilesButton.setText(bundle.getString("ADD"));
        this.addFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.addFilesButtonActionPerformed(evt);
            }
        });
        this.removeFilesButton.setText(bundle.getString("REMOVE"));
        this.removeFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.removeFilesButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 236, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addFilesButton, -2, 105, -2).addComponent(this.removeFilesButton, -2, 105, -2)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.addFilesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeFilesButton))).addContainerGap(-1, Short.MAX_VALUE)));
        this.startExperimentButton.setText(bundle.getString("START EXPERIMENT"));
        this.startExperimentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.startExperimentButtonActionPerformed(evt);
            }
        });
        this.jMenu1.setText(bundle.getString("FILE"));
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItem1.setText(bundle.getString("LOAD XML"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewExperimentFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, 0, 381, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(129, 129, 129).addComponent(this.startExperimentButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startExperimentButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void removeFilesButtonActionPerformed(ActionEvent evt) {
        for (int i : this.filesJList.getSelectedIndices()) {
            this.fileGroups.remove(i);
        }
    }

    private void addAgentButtonActionPerformed(ActionEvent evt) {
        AgentOptionsDialog aod = new AgentOptionsDialog((Frame)this.getParent(), true, this.agentTypes, this.myAgent);
        aod.setVisible(true);
        System.err.println("AgentOptionsDialog closed");
        this.agentDialogs.add(aod);
        Agent a = new Agent();
        a.setType(aod.getAgentType());
        a.setOptions(aod.getAgentOptions());
        this.agentList.add(a);
        this.agentJList.setModel(this.agentList);
        this.agentJList.revalidate();
        this.agentJList.repaint();
    }

    private void addFilesButtonActionPerformed(ActionEvent evt) {
        FileGroupsPanel fgp = new FileGroupsPanel((Frame)this.getParent(), true, this.files, this.myAgent);
        fgp.setVisible(true);
        FileGroup fg = fgp.getFileGroup();
        if (fg == null) {
            return;
        }
        this.fileGroups.add(fg);
        for (int i = 0; i < this.fileGroups.getSize(); ++i) {
            System.err.println(this.fileGroups.getElementAt(i).toString());
        }
        this.filesJList.setModel(this.fileGroups);
        this.filesJList.revalidate();
        this.filesJList.repaint();
    }

    private void startExperimentButtonActionPerformed(ActionEvent evt) {
        if (this.agentList.isEmpty() || this.fileGroups.isEmpty()) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("ERROR_AGENTS_FILES"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("ERROR"), 0);
            return;
        }
        LinkedList optManOptions = new LinkedList();
        optManOptions.add((Object)this.omd.getType());
        if (this.omd.getType().equals("Random")) {
            optManOptions.add((Object)this.omd.getError());
            optManOptions.add((Object)this.omd.getMaxTries());
        }
        if (this.omd.getType().equals("ChooseXValues")) {
            optManOptions.add((Object)this.omd.getNumTries());
        }
        GuiEvent ge = new GuiEvent((Object)this, 7);
        ge.addParameter((Object)optManOptions);
        ge.addParameter(this.agentList.getAgents());
        ge.addParameter(this.fileGroups.getFileGroups());
        ge.addParameter((Object)this.getNumberOfTasks());
        this.myAgent.postGuiEvent(ge);
        this.setVisible(false);
    }

    private void removeAgentButtonActionPerformed(ActionEvent evt) {
        for (int i : this.agentJList.getSelectedIndices()) {
            this.agentList.remove(i);
            this.agentDialogs.remove(i);
        }
    }

    public void loadXML(File xml) {
        try {
            SAXBuilder builder = new SAXBuilder();
            FileInputStream fis = new FileInputStream(xml);
            Document doc = builder.build((InputStream)fis);
            Element root_element = doc.getRootElement();
            List _problems = root_element.getChildren("experiment");
            for (Element next_problem : _problems) {
                List method = next_problem.getChildren("method");
                Iterator m_itr = method.iterator();
                if (method.size() == 0) {
                    // empty if block
                }
                if (method.size() > 1) {
                    // empty if block
                }
                while (m_itr.hasNext()) {
                    String numTries;
                    Element next_method = (Element)m_itr.next();
                    this.omd.setType(next_method.getAttributeValue("name"));
                    if (this.omd.getType().equals("Random")) {
                        String maxTries;
                        String errRate = next_method.getAttributeValue("error_rate");
                        if (errRate != null) {
                            this.omd.setError(Double.parseDouble(errRate));
                        }
                        if ((maxTries = next_method.getAttributeValue("maximum_tries")) != null) {
                            this.omd.setMaxTries(Integer.parseInt(maxTries));
                        }
                    }
                    if (!this.omd.getType().equals("ChooseXValues") || (numTries = next_method.getAttributeValue("number_of_values_to_try")) == null) continue;
                    this.omd.setNumTries(Integer.parseInt(numTries));
                }
                this.optManagerLabel.setText(this.omd.getGuiString());
                List dataset = next_problem.getChildren("dataset");
                for (Element next_dataset : dataset) {
                    FileGroup fg = new FileGroup();
                    fg.setTestFile(next_dataset.getAttributeValue("test"));
                    fg.setTrainFile(next_dataset.getAttributeValue("train"));
                    this.fileGroups.add(fg);
                    this.filesJList.setModel(this.fileGroups);
                    List metadata = next_dataset.getChildren("metadata");
                }
                List _agents = next_problem.getChildren("agent");
                for (Element next_agent : _agents) {
                    String agent_name = next_agent.getAttributeValue("name");
                    String agent_type = next_agent.getAttributeValue("type");
                    AgentOptionsDialog aod = new AgentOptionsDialog((Frame)this.getParent(), true, this.agentTypes, this.myAgent, false);
                    if (!agent_type.equals("?")) {
                        aod.setAgentOptions(((Agent_GUI_Java)this.myAgent).getAgentOptionsSynchronous(agent_type));
                        System.err.println("OPTIONS COUNT:" + aod.getAgentOptions().size());
                    }
                    aod.setAgentType(agent_type);
                    aod.setAgentTypeChangedEventEnabled(true);
                    System.err.println("Here");
                    List _options = next_agent.getChildren("parameter");
                    Iterator o_itr = _options.iterator();
                    ArrayList options = new ArrayList();
                    while (o_itr.hasNext()) {
                        String set;
                        Element next_option = (Element)o_itr.next();
                        Option o = new Option();
                        o.setName(next_option.getAttributeValue("name"));
                        o.setValue(next_option.getAttributeValue("value"));
                        if (o.getValue().contains("?")) {
                            o.setMutable(true);
                        }
                        if ((set = next_option.getAttributeValue("set")) != null) {
                            LinkedList l = new LinkedList();
                            for (String s : set.split(",[ ]*")) {
                                l.add((Object)s);
                            }
                            o.setSet((jade.util.leap.List)l);
                            o.setIs_a_set(true);
                        }
                        Interval range = new Interval();
                        if (next_option.getAttributeValue("lower") != null) {
                            range.setMin(Float.valueOf(Float.parseFloat(next_option.getAttributeValue("lower"))));
                        }
                        if (next_option.getAttributeValue("upper") != null) {
                            range.setMax(Float.valueOf(Float.parseFloat(next_option.getAttributeValue("upper"))));
                        }
                        o.setRange(range);
                        if (next_option.getAttributeValue("number_of_values_to_try") != null) {
                            o.setNumber_of_values_to_try(Integer.parseInt(next_option.getAttributeValue("number_of_values_to_try")));
                        }
                        aod.setOption(o);
                    }
                    this.agentDialogs.add(aod);
                    Agent a = new Agent();
                    a.setType(aod.getAgentType());
                    a.setOptions(aod.getAgentOptions());
                    this.agentList.add(a);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        FileNameExtensionFilter fnf = new FileNameExtensionFilter("XML Files (*.bxml)", "bxml");
        this.fileDialog.setFileFilter(fnf);
        int result = this.fileDialog.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.loadXML(this.fileDialog.getSelectedFile());
    }

    private void editAgentButtonActionPerformed(ActionEvent evt) {
        for (int i : this.agentJList.getSelectedIndices()) {
            AgentOptionsDialog aod = this.agentDialogs.get(i);
            aod.setVisible(true);
            Agent a = this.agentList.getAgents().get(i);
            a.setOptions(aod.getAgentOptions());
            a.setType(aod.getAgentType());
            this.agentList.remove(i);
            this.agentList.insert(a, i);
            this.agentJList.setModel(this.agentList);
        }
    }

    private void editOptionManagerButtonActionPerformed(ActionEvent evt) {
        this.omd.setVisible(true);
        this.optManagerLabel.setText(this.omd.getGuiString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileGroupsModel
    extends DefaultListModel {
        java.util.ArrayList<FileGroup> fileGroups = new java.util.ArrayList();

        FileGroupsModel() {
        }

        @Override
        public int getSize() {
            return this.fileGroups.size();
        }

        @Override
        public Object getElementAt(int index) {
            return super.get(index);
        }

        public void add(FileGroup fg) {
            this.fileGroups.add(fg);
            super.addElement(fg);
        }

        public java.util.ArrayList<FileGroup> getFileGroups() {
            return this.fileGroups;
        }

        public Object remove(int index) {
            this.fileGroups.remove(index);
            return super.remove(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AgentsListModel
    extends DefaultListModel {
        java.util.ArrayList<Agent> agents = new java.util.ArrayList();

        AgentsListModel() {
        }

        @Override
        public int getSize() {
            return this.agents.size();
        }

        @Override
        public int size() {
            return this.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return super.get(index);
        }

        public void add(Agent a) {
            this.agents.add(a);
            super.addElement(a.getType() + " " + a.toGuiString());
            for (int i = 0; i < this.agents.size(); ++i) {
                System.err.println(this.getElementAt(i).toString());
            }
        }

        public void insert(Agent a, int index) {
            this.agents.add(index, a);
            super.add(index, a.getType() + " " + a.toGuiString());
            for (int i = 0; i < this.agents.size(); ++i) {
                System.err.println(this.getElementAt(i).toString());
            }
        }

        public java.util.ArrayList<Agent> getAgents() {
            return this.agents;
        }

        public Object remove(int index) {
            this.agents.remove(index);
            return super.remove(index);
        }
    }
}

