/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import pikater.gui.java.improved.BooleanOptionPanel;
import pikater.gui.java.improved.IntegerOptionPanel;
import pikater.gui.java.improved.MixedOptionPanel;
import pikater.ontology.messages.Interval;
import pikater.ontology.messages.Option;

public class OptionPanel
extends JPanel {
    Option o;
    JPanel optionPanel;
    String agentType;
    private JScrollPane jScrollPane1;
    private JTextPane optionDescription;
    private JPanel optionsPanel;

    public Option getOption() {
        String[] elems;
        LinkedList l;
        Interval range;
        this.o.setIs_a_set(false);
        if (this.o.getData_type().equals("BOOLEAN")) {
            BooleanOptionPanel bop = (BooleanOptionPanel)this.optionPanel;
            if (bop.isDefault()) {
                return null;
            }
            if (bop.isUserSpecified()) {
                this.o.setValue(bop.getUserSpecifiedValue());
                this.o.setUser_value(bop.getUserSpecifiedValue());
                this.o.setMutable(false);
                this.o.setNumberOfOptions(1);
            } else {
                this.o.setUser_value("?");
                this.o.setValue("?");
                this.o.setMutable(true);
                this.o.setNumberOfOptions(2);
            }
        }
        if (this.o.getData_type().equals("INT") || this.o.getData_type().equals("FLOAT")) {
            IntegerOptionPanel iop = (IntegerOptionPanel)this.optionPanel;
            if (iop.isDefault()) {
                return null;
            }
            if (iop.isUserSpecified()) {
                this.o.setValue(iop.getUserSpecifiedValue());
                this.o.setUser_value(iop.getUserSpecifiedValue());
                this.o.setMutable(false);
                this.o.setNumber_of_values_to_try(0);
                this.o.setNumberOfOptions(1);
                return this.o;
            }
            this.o.setUser_value("?");
            this.o.setValue("?");
            this.o.setMutable(true);
            if (iop.isInterval()) {
                range = new Interval();
                range.setMin(Float.valueOf(iop.getLowerLimit().floatValue()));
                range.setMax(Float.valueOf(iop.getUpperLimit().floatValue()));
                this.o.setRange(range);
                if (this.o.getData_type().equals("INT")) {
                    this.o.setNumberOfOptions(Math.min((int)(range.getMax().floatValue() - range.getMin().floatValue()) + 1, iop.getNumberOfTries()));
                } else {
                    this.o.setNumberOfOptions(iop.getNumberOfTries());
                }
            }
            if (iop.isSet()) {
                l = new LinkedList();
                for (String elem : elems = iop.getSet().split(" ")) {
                    l.add((Object)elem);
                }
                this.o.setSet((List)l);
                this.o.setIs_a_set(true);
                this.o.setNumberOfOptions(Math.min(l.size(), iop.getNumberOfTries()));
            }
            this.o.setNumber_of_values_to_try(iop.getNumberOfTries());
        }
        if (this.o.getData_type().equals("MIXED")) {
            MixedOptionPanel mop = (MixedOptionPanel)this.optionPanel;
            if (mop.isDefault()) {
                return null;
            }
            if (mop.isUserValue()) {
                this.o.setValue(mop.getUserValue());
                this.o.setUser_value(mop.getUserValue());
                this.o.setMutable(false);
                this.o.setNumber_of_values_to_try(0);
                this.o.setNumberOfOptions(1);
                return this.o;
            }
            this.o.setValue(mop.getPattern());
            this.o.setUser_value(mop.getPattern());
            this.o.setMutable(true);
            if (mop.isRange()) {
                range = new Interval();
                range.setMin(Float.valueOf(Float.parseFloat(mop.getLower())));
                range.setMax(Float.valueOf(Float.parseFloat(mop.getUpper())));
                this.o.setRange(range);
                this.o.setNumberOfOptions(Math.min((int)(range.getMax().floatValue() - range.getMin().floatValue()) + 1, mop.getTries()));
            }
            if (mop.isSet()) {
                l = new LinkedList();
                for (String e : elems = mop.getSet().split(" ")) {
                    l.add((Object)e);
                }
                this.o.setSet((List)l);
                this.o.setIs_a_set(true);
                this.o.setNumberOfOptions(Math.min(l.size(), mop.getTries()));
            }
            this.o.setNumber_of_values_to_try(mop.getTries());
        }
        return this.o;
    }

    public void setOption(Option o) {
        System.err.println(this.o.getData_type());
        if (this.o.getData_type().equals("BOOLEAN")) {
            BooleanOptionPanel bop = (BooleanOptionPanel)this.optionPanel;
            bop.setOption(o);
        }
        if (this.o.getData_type().equals("INT") || this.o.getData_type().equals("FLOAT")) {
            IntegerOptionPanel iop = (IntegerOptionPanel)this.optionPanel;
            iop.setOption(o);
        }
        if (this.o.getData_type().equals("MIXED")) {
            MixedOptionPanel mop = (MixedOptionPanel)this.optionPanel;
            mop.setOption(o);
        }
    }

    public String getOptionName() {
        return this.o.getName();
    }

    public OptionPanel() {
        this.initComponents();
    }

    public OptionPanel(Option o, String agentName) {
        Number upper;
        Number lower;
        Number defaultValue;
        this.initComponents();
        this.agentType = agentName;
        this.o = o;
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/AgentStrings");
        String synopsis = bundle.getString(this.agentType + "-" + o.getName() + "-S");
        synopsis = synopsis.replaceAll("<", "&lt;");
        synopsis = synopsis.replaceAll(">", "&gt;");
        String description = bundle.getString(this.agentType + "-" + o.getName() + "-D");
        this.optionDescription.setText("<html><b>" + synopsis + "</b><br>" + description + "</html>");
        System.err.println(o.getData_type());
        if (o.getData_type().equals("BOOLEAN")) {
            this.optionPanel = new BooleanOptionPanel();
            this.optionsPanel.add(this.optionPanel);
        }
        if (o.getData_type().equals("INT")) {
            defaultValue = null;
            lower = null;
            upper = null;
            try {
                lower = o.getRange().getMin().intValue();
                upper = o.getRange().getMax().intValue();
                defaultValue = Integer.parseInt(o.getDefault_value());
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error processing option:" + o.getSynopsis());
                System.err.println(nfe.getMessage());
            }
            if (defaultValue == null) {
                defaultValue = lower;
            }
            this.optionPanel = new IntegerOptionPanel((Integer)lower, (Integer)upper, 5, (Integer)defaultValue);
            this.optionsPanel.add(this.optionPanel);
        }
        if (o.getData_type().equals("FLOAT")) {
            defaultValue = null;
            lower = null;
            upper = null;
            try {
                lower = o.getRange().getMin().doubleValue();
                upper = o.getRange().getMax().doubleValue();
                defaultValue = Double.parseDouble(o.getDefault_value());
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error processing option:" + o.getSynopsis());
                System.err.println(nfe.getMessage());
            }
            if (defaultValue == null) {
                defaultValue = lower;
            }
            this.optionPanel = new IntegerOptionPanel((Double)lower, (Double)upper, 5, (Double)defaultValue);
            this.optionsPanel.add(this.optionPanel);
        }
        if (o.getData_type().equals("MIXED")) {
            this.optionPanel = new MixedOptionPanel(o);
            this.optionsPanel.add(this.optionPanel);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.optionDescription = new JTextPane();
        this.optionsPanel = new JPanel();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.optionDescription.setContentType("text/html");
        this.optionDescription.setEditable(false);
        this.optionDescription.setMaximumSize(new Dimension(330, 110));
        this.jScrollPane1.setViewportView(this.optionDescription);
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.optionsPanel, GroupLayout.Alignment.LEADING, -1, 291, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 291, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

