/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import pikater.gui.java.improved.DataInstancesTableModel;

public class VisualisationPanel
extends JPanel {
    DataInstancesTableModel data;

    public VisualisationPanel(DataInstancesTableModel data) {
        this.initComponents();
        this.data = data;
        float[][] floatData = new float[2][data.getRowCount()];
        for (int i = 0; i < data.getRowCount(); ++i) {
            floatData[0][i] = Float.parseFloat(data.getValueAt(i, 0).toString());
            floatData[1][i] = Float.parseFloat(data.getValueAt(i, 1).toString());
        }
        NumberAxis domainAxis = new NumberAxis("X");
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis("Y");
        rangeAxis.setAutoRangeIncludesZero(false);
        FastScatterPlot plot = new FastScatterPlot(floatData, (ValueAxis)domainAxis, (ValueAxis)rangeAxis);
        JFreeChart chart = new JFreeChart("Fast Scatter Plot", (Plot)plot);
        chart.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartPanel panel = new ChartPanel(chart, true);
        panel.setPreferredSize(new Dimension(500, 270));
        panel.setMinimumDrawHeight(10);
        panel.setMaximumDrawHeight(2000);
        panel.setMinimumDrawWidth(20);
        panel.setMaximumDrawWidth(2000);
        this.add((Component)panel);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

