/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved.verifiers;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ResourceBundle;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class IntegerSetInputVerifier
extends InputVerifier {
    JComponent comp = null;
    String additionalChars = "";

    public IntegerSetInputVerifier(JComponent comp, String additionalChars) {
        this(comp);
        this.additionalChars = additionalChars;
    }

    public IntegerSetInputVerifier(JComponent comp) {
        this.comp = comp;
    }

    public boolean verify(JComponent input) {
        String[] values;
        JTextField textField = (JTextField)input;
        for (String value : values = textField.getText().split(" ")) {
            if ((value = value.trim()).length() == 1 && this.additionalChars.indexOf(value) != -1) continue;
            ParsePosition pos = new ParsePosition(0);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.parse(value, pos);
            if (pos.getIndex() == value.length()) continue;
            JOptionPane.showMessageDialog(this.comp, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("INTEGER_SET_ERROR"), null, 0);
            return false;
        }
        return true;
    }
}

