/*
 * Decompiled with CFR 0.152.
 */
package pikater.ontology.messages;

import jade.content.Concept;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.Date;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;

public class Attribute
implements Concept {
    private static final long serialVersionUID = 4335994730042008739L;
    public static final String NUMERIC_TYPE = "NUMERIC";
    public static final String NOMINAL_TYPE = "NOMINAL";
    public static final String STRING_TYPE = "STRING";
    public static final String DATE_TYPE = "DATE";
    public static final String RELATIONAL_TYPE = "RELATIONAL";
    private String name;
    private String type;
    private List values;
    private String date_format;

    public String getDate_format() {
        return this.date_format;
    }

    public void setDate_format(String dateFormat) {
        this.date_format = dateFormat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List getValues() {
        return this.values;
    }

    public void setValues(List values) {
        this.values = values;
    }

    public weka.core.Attribute toWekaAttribute() {
        if (this.values != null && this.values.size() > 0) {
            FastVector my_nominal_values = new FastVector();
            for (String val : this.values) {
                my_nominal_values.addElement((Object)val);
            }
            return new weka.core.Attribute(this.name, my_nominal_values);
        }
        if (this.type.equals(DATE_TYPE)) {
            return new weka.core.Attribute(this.name, this.date_format);
        }
        if (this.type.equals(RELATIONAL_TYPE)) {
            Instances winst = null;
            return new weka.core.Attribute(this.name, winst);
        }
        return new weka.core.Attribute(this.name);
    }

    public void fillWekaAttribute(weka.core.Attribute wattr) {
        this.setName(wattr.name());
        switch (wattr.type()) {
            case 0: {
                this.setType(NUMERIC_TYPE);
                break;
            }
            case 1: {
                this.setType(NOMINAL_TYPE);
                break;
            }
            case 2: {
                this.setType(STRING_TYPE);
                break;
            }
            case 3: {
                this.setType(DATE_TYPE);
                this.setDate_format(wattr.getDateFormat());
                break;
            }
            case 4: {
                this.setType(RELATIONAL_TYPE);
                break;
            }
        }
        ArrayList attr_values = new ArrayList();
        for (int j = 0; j < wattr.numValues(); ++j) {
            attr_values.add((Object)wattr.value(j));
        }
        this.setValues((List)attr_values);
    }

    String stringValue(double _dval) {
        if (this.values != null && this.values.size() > 0) {
            return Utils.quote((String)((String)this.values.get((int)_dval)));
        }
        if (this.type.equals(NUMERIC_TYPE)) {
            return Utils.doubleToString((double)_dval, (int)6);
        }
        if (this.type.equals(DATE_TYPE)) {
            Date d = new Date((long)_dval);
            return Utils.quote((String)d.toString());
        }
        return null;
    }
}

