/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.Adler32;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibrary;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.EnsembleSelection;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibraryModel;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class EnsembleSelectionLibrary
extends EnsembleLibrary
implements Serializable {
    private static final long serialVersionUID = -6444026512552917835L;
    private File m_workingDirectory;
    private String m_modelListFile = null;
    private Instances[] m_trainingData;
    private Instances[] m_hillclimbData;
    private double[][][] m_predictions;
    private int m_seed;
    private int m_folds;
    private double m_validationRatio;
    private transient PropertyChangeSupport m_workingDirectoryPropertySupport = new PropertyChangeSupport(this);
    public transient boolean m_Debug = true;

    public EnsembleSelectionLibrary() {
        this.m_workingDirectory = new File(EnsembleSelection.getDefaultWorkingDirectory());
    }

    public EnsembleSelectionLibrary(String dir, int seed, int folds, double validationRatio) {
        if (dir != null) {
            this.m_workingDirectory = new File(dir);
        }
        this.m_seed = seed;
        this.m_folds = folds;
        this.m_validationRatio = validationRatio;
    }

    public EnsembleSelectionLibrary(String libraryFileName) {
        File libraryFile = new File(libraryFileName);
        try {
            EnsembleLibrary.loadLibrary(libraryFile, (EnsembleLibrary)this);
        }
        catch (Exception e) {
            System.err.println("Could not load specified library file: " + libraryFileName);
        }
    }

    public EnsembleSelectionLibrary(InputStream stream) {
        try {
            EnsembleLibrary.loadLibrary(stream, (EnsembleLibrary)this);
        }
        catch (Exception e) {
            System.err.println("Could not load library from XML stream: " + e);
        }
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
        Iterator it = this.getModels().iterator();
        while (it.hasNext()) {
            ((EnsembleSelectionLibraryModel)it.next()).setDebug(this.m_Debug);
        }
    }

    public void setValidationRatio(double validationRatio) {
        this.m_validationRatio = validationRatio;
    }

    public void setNumFolds(int numFolds) {
        this.m_folds = numFolds;
    }

    public Instances trainAll(Instances data, String directory, int algorithm) throws Exception {
        Instances validationSet;
        this.createWorkingDirectory(directory);
        String dataDirectoryName = EnsembleSelectionLibrary.getDataDirectoryName(data);
        File dataDirectory = new File(directory, dataDirectoryName);
        if (!dataDirectory.exists()) {
            dataDirectory.mkdirs();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm");
        String modelListFileName = formatter.format(new Date()) + "_" + this.size() + "_models.mlf";
        File modelListFile = new File(dataDirectory.getPath(), modelListFileName);
        EnsembleLibrary.saveLibrary(modelListFile, this, null);
        modelListFileName = formatter.format(new Date()) + "_" + this.size() + "_models.model.xml";
        modelListFile = new File(dataDirectory.getPath(), modelListFileName);
        EnsembleLibrary.saveLibrary(modelListFile, this, null);
        String arf = data.toString();
        FileWriter f = new FileWriter(new File(dataDirectory.getPath(), dataDirectory.getName() + ".arff"));
        f.write(arf);
        f.close();
        this.m_trainingData = new Instances[this.m_folds];
        this.m_hillclimbData = new Instances[this.m_folds];
        if (this.m_folds > 1) {
            int i;
            validationSet = new Instances(data, data.numInstances());
            for (i = 0; i < this.m_folds; ++i) {
                this.m_trainingData[i] = data.trainCV(this.m_folds, i);
                this.m_hillclimbData[i] = data.testCV(this.m_folds, i);
            }
            for (i = 0; i < this.m_folds; ++i) {
                for (int j = 0; j < this.m_hillclimbData[i].numInstances(); ++j) {
                    validationSet.add(this.m_hillclimbData[i].instance(j));
                }
            }
        } else {
            int validation_size = (int)((double)data.numInstances() * this.m_validationRatio);
            this.m_trainingData[0] = new Instances(data, 0, data.numInstances() - validation_size);
            this.m_hillclimbData[0] = new Instances(data, data.numInstances() - validation_size, validation_size);
            validationSet = this.m_hillclimbData[0];
        }
        Iterator it = this.m_Models.iterator();
        int model_index = 0;
        this.m_predictions = new double[this.m_Models.size()][validationSet.numInstances()][data.numClasses()];
        HashSet<EnsembleSelectionLibraryModel> invalidModels = new HashSet<EnsembleSelectionLibraryModel>();
        while (it.hasNext()) {
            EnsembleSelectionLibraryModel model = (EnsembleSelectionLibraryModel)it.next();
            model.setDebug(this.m_Debug);
            model.setFolds(this.m_folds);
            model.setSeed(this.m_seed);
            model.setValidationRatio(this.m_validationRatio);
            model.setChecksum(EnsembleSelectionLibrary.getInstancesChecksum(data));
            try {
                model.createModel(this.m_trainingData, this.m_hillclimbData, dataDirectory.getPath(), algorithm);
            }
            catch (Exception e) {
                System.out.println("**Couldn't create model " + model.getStringRepresentation() + " because of following exception: " + e.getMessage());
                invalidModels.add(model);
                continue;
            }
            if (invalidModels.contains(model)) continue;
            this.m_predictions[model_index] = model.getValidationPredictions();
            ++model_index;
            model.releaseModel();
        }
        for (EnsembleSelectionLibraryModel model : invalidModels) {
            if (this.m_Debug) {
                System.out.println("removing invalid library model: " + model.getStringRepresentation());
            }
            this.m_Models.remove(model);
        }
        if (this.m_Debug) {
            System.out.println("model index: " + model_index + " tree set size: " + this.m_Models.size());
        }
        if (invalidModels.size() > 0) {
            double[][][] tmpPredictions = new double[this.m_Models.size()][][];
            for (int i = 0; i < this.m_Models.size(); ++i) {
                tmpPredictions[i] = this.m_predictions[i];
            }
            this.m_predictions = tmpPredictions;
        }
        if (this.m_Debug) {
            System.out.println("Finished remapping models");
        }
        return validationSet;
    }

    public void createWorkingDirectory(String dirName) {
        File directory = new File(dirName);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public void removeModel(String modelKey) {
        this.m_Models.remove(modelKey);
    }

    public Set getModelNames() {
        TreeSet<String> names = new TreeSet<String>();
        Iterator it = this.m_Models.iterator();
        while (it.hasNext()) {
            names.add(((EnsembleLibraryModel)it.next()).getStringRepresentation());
        }
        return names;
    }

    public double[][][] getHillclimbPredictions() {
        return this.m_predictions;
    }

    public File getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.m_workingDirectory = workingDirectory;
        if (this.m_workingDirectoryPropertySupport != null) {
            this.m_workingDirectoryPropertySupport.firePropertyChange(null, null, null);
        }
    }

    public String getModelListFile() {
        return this.m_modelListFile;
    }

    public void setModelListFile(String modelListFile) {
        this.m_modelListFile = modelListFile;
    }

    public EnsembleLibraryModel createModel(Classifier classifier) {
        EnsembleSelectionLibraryModel model = new EnsembleSelectionLibraryModel(classifier);
        model.setDebug(this.m_Debug);
        return model;
    }

    public EnsembleLibraryModel createModel(String modelString) {
        String[] splitString = modelString.split("\\s+");
        String className = splitString[0];
        String argString = modelString.replaceAll(splitString[0], "");
        String[] optionStrings = argString.split("\\s+");
        EnsembleSelectionLibraryModel model = null;
        try {
            model = new EnsembleSelectionLibraryModel(Classifier.forName(className, optionStrings));
            model.setDebug(this.m_Debug);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static String getInstancesChecksum(Instances instances) {
        String checksumString = null;
        try {
            Adler32 checkSummer = new Adler32();
            byte[] utf8 = instances.toString().getBytes("UTF8");
            checkSummer.update(utf8);
            checksumString = Long.toHexString(checkSummer.getValue());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return checksumString;
    }

    public static String getDataDirectoryName(Instances instances) {
        String directory = null;
        directory = new String(instances.numInstances() + "_instances_" + EnsembleSelectionLibrary.getInstancesChecksum(instances));
        return directory;
    }

    public void addWorkingDirectoryListener(PropertyChangeListener listener) {
        if (this.m_workingDirectoryPropertySupport != null) {
            this.m_workingDirectoryPropertySupport.addPropertyChangeListener(listener);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

