/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibrary;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibraryModel;
import weka.gui.EnsembleSelectionLibraryEditor;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;
import weka.gui.ensembleLibraryEditor.ModelList;

public class LoadModelsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    private static final long serialVersionUID = -6961209378227736515L;
    private ListModelsPanel m_ListModelsPanel;
    private JLabel m_LoadingLabel;
    private JLabel m_DirectoryLabel;
    private JButton m_RefreshListButton;
    private JButton m_RemoveSelectedButton;
    private JButton m_AddAllButton;
    private JButton m_AddSelectedButton;
    private ModelList m_ModelList;
    private EnsembleSelectionLibrary m_Library;
    private EnsembleSelectionLibraryEditor m_EnsembleLibraryEditor;
    private boolean m_workingDirectoryChanged = false;

    public LoadModelsPanel(ListModelsPanel listModelsPanel, EnsembleSelectionLibraryEditor editor) {
        this.m_ListModelsPanel = listModelsPanel;
        this.m_EnsembleLibraryEditor = editor;
        this.createLoadModelsPanel();
    }

    private void createLoadModelsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.m_RefreshListButton = new JButton("Reload List");
        this.m_RefreshListButton.setToolTipText("Discover the set of models existing in the current working directory");
        this.m_RefreshListButton.addActionListener(this);
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_RefreshListButton, gbc);
        this.m_DirectoryLabel = new JLabel("");
        this.updateDirectoryLabel();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        this.add((Component)this.m_DirectoryLabel, gbc);
        this.m_LoadingLabel = new JLabel("");
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        this.add((Component)this.m_LoadingLabel, gbc);
        JPanel modelListPanel = new JPanel();
        modelListPanel.setBorder(BorderFactory.createTitledBorder("Working Set of Loadable Models"));
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = 4557836979081722983L;

            public void actionPerformed(ActionEvent evt) {
                Object[] currentModels = LoadModelsPanel.this.m_ModelList.getSelectedValues();
                ModelList.SortedListModel dataModel = (ModelList.SortedListModel)LoadModelsPanel.this.m_ModelList.getModel();
                for (int i = 0; i < currentModels.length; ++i) {
                    dataModel.removeElement((EnsembleLibraryModel)currentModels[i]);
                }
                int[] selected = new int[]{LoadModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                LoadModelsPanel.this.m_ModelList.setSelectedIndices(selected);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setLayoutOrientation(0);
        ToolTipManager.sharedInstance().registerComponent(this.m_ModelList);
        JScrollPane listView = new JScrollPane(this.m_ModelList);
        listView.setHorizontalScrollBarPolicy(30);
        listView.setPreferredSize(new Dimension(150, 50));
        modelListPanel.setLayout(new BorderLayout());
        modelListPanel.add((Component)listView, "Center");
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.add((Component)modelListPanel, gbc);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.setToolTipText("Remove all selected models from the above list");
        this.m_RemoveSelectedButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gbc);
        this.m_AddSelectedButton = new JButton("Add Selected");
        this.m_AddSelectedButton.setToolTipText("Add selected models in the above list to the model library");
        this.m_AddSelectedButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_AddSelectedButton, gbc);
        this.m_AddAllButton = new JButton("Add All");
        this.m_AddAllButton.setToolTipText("Add all models in the above list to the model library");
        this.m_AddAllButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_AddAllButton, gbc);
    }

    public void setLibrary(EnsembleSelectionLibrary library) {
        this.m_Library = library;
        this.updateDirectoryLabel();
        this.loadModels();
    }

    public void loadModels() {
        ModelList.SortedListModel dataModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        int directoryCount = 0;
        int modelCount = 0;
        dataModel.clear();
        File directory = this.m_Library.getWorkingDirectory();
        File[] subDirectories = directory.listFiles();
        if (subDirectories != null) {
            for (int i = 0; i < subDirectories.length; ++i) {
                if (!subDirectories[i].isDirectory() || !subDirectories[i].getName().matches(".*_instances_.*")) continue;
                ++directoryCount;
                File[] subDirectoryFiles = subDirectories[i].listFiles();
                for (int j = 0; j < subDirectoryFiles.length; ++j) {
                    if (!subDirectoryFiles[j].getName().matches(".*.elm")) continue;
                    EnsembleSelectionLibraryModel model = EnsembleSelectionLibraryModel.loadModel(subDirectoryFiles[j].getPath());
                    model.releaseModel();
                    if (dataModel.contains(model)) continue;
                    ++modelCount;
                    dataModel.add(model);
                }
            }
        }
        this.updateLoadingLabel(modelCount, directoryCount);
    }

    public void updateDirectoryLabel() {
        if (this.m_Library != null) {
            this.m_DirectoryLabel.setText("Directory: " + this.m_Library.getWorkingDirectory());
        }
    }

    public void updateLoadingLabel(int modelCount, int directoryCount) {
        this.m_LoadingLabel.setText(" " + modelCount + " unique model descriptions found in " + directoryCount + " directories");
    }

    public void actionPerformed(ActionEvent e) {
        ModelList.SortedListModel dataModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        if (e.getSource() == this.m_RefreshListButton) {
            this.updateDirectoryLabel();
            this.loadModels();
        } else if (e.getSource() == this.m_RemoveSelectedButton) {
            Object[] currentModels = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < currentModels.length; ++i) {
                dataModel.removeElement(currentModels[i]);
            }
            if (this.m_ModelList.getSelectedIndices().length > 0) {
                int[] selected = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(selected);
            }
        } else if (e.getSource() == this.m_AddAllButton) {
            Iterator it = dataModel.iterator();
            while (it.hasNext()) {
                EnsembleLibraryModel currentModel = (EnsembleLibraryModel)it.next();
                this.m_ListModelsPanel.addModel(currentModel);
            }
            dataModel.clear();
        } else if (e.getSource() == this.m_AddSelectedButton) {
            Object[] currentModels = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < currentModels.length; ++i) {
                this.m_ListModelsPanel.addModel((EnsembleLibraryModel)currentModels[i]);
                dataModel.removeElement(currentModels[i]);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_EnsembleLibraryEditor.isLoadModelsPanelSelected()) {
            this.updateDirectoryLabel();
            this.loadModels();
        } else {
            this.m_workingDirectoryChanged = true;
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        if (pane.getSelectedComponent().equals(this) && this.m_workingDirectoryChanged) {
            this.updateDirectoryLabel();
            this.loadModels();
            this.m_workingDirectoryChanged = false;
        }
    }
}

