/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionTable
extends Expression {
    boolean isTable;
    boolean ordinality = false;

    ExpressionTable(Expression expression, SubQuery subQuery, boolean bl) {
        super(26);
        this.nodes = new Expression[]{expression};
        this.subQuery = subQuery;
        this.ordinality = bl;
    }

    @Override
    public String getSQL() {
        if (this.isTable) {
            return "TABLE";
        }
        return "UNNEST";
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        if (this.isTable) {
            stringBuffer.append("TABLE").append(' ');
        } else {
            stringBuffer.append("UNNEST").append(' ');
        }
        stringBuffer.append(this.nodes[0].describe(session, n));
        return stringBuffer.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        if (this.nodes[0].dataType.isRowType()) {
            this.isTable = true;
            this.nodeDataTypes = ((RowType)this.nodes[0].dataType).getTypesArray();
            this.subQuery.prepareTable(session);
            this.subQuery.getTable().columnList = ((FunctionSQLInvoked)this.nodes[0]).routine.getTable().columnList;
        } else {
            this.isTable = false;
            n = this.ordinality ? 2 : 1;
            this.nodeDataTypes = new Type[n];
            this.nodeDataTypes[0] = this.nodes[0].dataType.collectionBaseType();
            if (this.ordinality) {
                this.nodeDataTypes[1] = Type.SQL_INTEGER;
            }
            this.subQuery.prepareTable(session);
        }
    }

    @Override
    public Result getResult(Session session) {
        switch (this.opType) {
            case 26: {
                RowSetNavigatorData rowSetNavigatorData = this.subQuery.getNavigator(session);
                Result result = Result.newResult(rowSetNavigatorData);
                result.metaData = this.subQuery.queryExpression.getMetaData();
                return result;
            }
        }
        throw Error.runtimeError(201, "ExpressionTable");
    }

    @Override
    public Object[] getRowValue(Session session) {
        switch (this.opType) {
            case 26: {
                return this.subQuery.queryExpression.getValues(session);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    Object getValue(Session session, Type type) {
        switch (this.opType) {
            case 26: {
                this.materialise(session);
                Object[] objectArray = this.subQuery.getValues(session);
                if (objectArray.length == 1) {
                    return objectArray[0];
                }
                return objectArray;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public Object getValue(Session session) {
        return this.valueData;
    }

    @Override
    void insertValuesIntoSubqueryTable(Session session, PersistentStore persistentStore) {
        if (this.isTable) {
            Result result = this.nodes[0].getResult(session);
            RowSetNavigator rowSetNavigator = result.navigator;
            int n = rowSetNavigator.getSize();
            while (rowSetNavigator.hasNext()) {
                Object[] objectArray = rowSetNavigator.getNext();
                Row row = (Row)persistentStore.getNewCachedObject(session, objectArray);
                try {
                    persistentStore.indexRow(session, row);
                }
                catch (HsqlException hsqlException) {}
            }
        } else {
            Object[] objectArray = (Object[])this.nodes[0].getValue(session);
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2 = this.ordinality ? new Object[]{objectArray[i], ValuePool.getInt(i)} : new Object[]{objectArray[i]};
                Row row = (Row)persistentStore.getNewCachedObject(session, objectArray2);
                try {
                    persistentStore.indexRow(session, row);
                    continue;
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }
}

