/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{54, 120};
    static final short[] startStatementTokens = new short[]{54, 120, 4, 87};
    static final short[] startStatementTokensSchema = new short[]{54, 120};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(String string) {
        super.reset(string);
    }

    StatementSchema compileCreate() {
        int n = 4;
        boolean bl = false;
        this.read();
        switch (this.token.tokenType) {
            case 119: {
                this.read();
                this.readThis(523);
                this.readIfThis(584);
                this.readThis(277);
                bl = true;
                n = 3;
                break;
            }
            case 597: {
                this.read();
                this.readThis(277);
                bl = true;
                n = 3;
                break;
            }
            case 523: {
                this.read();
                this.readThis(277);
                bl = true;
                n = 3;
                break;
            }
            case 584: {
                this.read();
                this.readThis(277);
                bl = true;
                break;
            }
            case 558: {
                this.read();
                this.readThis(277);
                bl = true;
                n = 5;
                break;
            }
            case 598: {
                this.read();
                this.readThis(277);
                bl = true;
                n = 7;
                break;
            }
            case 277: {
                this.read();
                bl = true;
                n = this.database.schemaManager.getDefaultTableType();
                break;
            }
        }
        if (bl) {
            return this.compileCreateTable(n);
        }
        switch (this.token.tokenType) {
            case 551: {
                return this.compileCreateAlias();
            }
            case 505: {
                return this.compileCreateSequence();
            }
            case 497: {
                return this.compileCreateSchema();
            }
            case 290: {
                return this.compileCreateTrigger();
            }
            case 304: {
                return this.compileCreateUser();
            }
            case 490: {
                return this.compileCreateRole();
            }
            case 545: {
                return this.compileCreateView(false);
            }
            case 393: {
                return this.compileCreateDomain();
            }
            case 535: {
                return this.compileCreateType();
            }
            case 34: {
                return this.compileCreateCharacterSet();
            }
            case 298: {
                this.read();
                this.checkIsThis(578);
                return this.compileCreateIndex(true);
            }
            case 578: {
                return this.compileCreateIndex(false);
            }
            case 116: 
            case 214: 
            case 552: {
                return this.compileCreateProcedureOrFunction();
            }
        }
        throw this.unexpectedToken();
    }

    void processAlter() {
        this.session.setScripting(true);
        this.readThis(4);
        switch (this.token.tokenType) {
            case 277: {
                this.read();
                this.processAlterTable();
                break;
            }
            case 393: {
                this.read();
                this.processAlterDomain();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 578: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
                this.readThis(593);
                this.readThis(284);
                return this.compileRenameObject(hsqlName, 20);
            }
            case 497: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                this.readThis(593);
                this.readThis(284);
                return this.compileRenameObject(hsqlName, 2);
            }
            case 348: {
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.checkValidCatalogName(string);
                this.read();
                this.readThis(593);
                this.readThis(284);
                return this.compileRenameObject(this.database.getCatalogName(), 1);
            }
            case 505: {
                return this.compileAlterSequence();
            }
            case 277: {
                return this.compileAlterTable();
            }
            case 304: {
                return this.compileAlterUser();
            }
            case 393: {
                return this.compileAlterDomain();
            }
            case 545: {
                return this.compileCreateView(true);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileDrop() {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        HsqlNameManager.HsqlName hsqlName = null;
        HsqlNameManager.HsqlName hsqlName2 = this.database.getCatalogName();
        this.read();
        int n3 = this.token.tokenType;
        switch (n3) {
            case 578: {
                this.read();
                n2 = 1078;
                n = 20;
                bl3 = true;
                hsqlName = hsqlName2;
                break;
            }
            case 339: {
                this.read();
                n2 = 24;
                n = 6;
                bl = true;
                break;
            }
            case 258: {
                this.read();
                switch (this.token.tokenType) {
                    case 116: 
                    case 214: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 30;
                n = 24;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 214: {
                this.read();
                n2 = 30;
                n = 17;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 116: {
                this.read();
                n2 = 30;
                n = 16;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 497: {
                this.read();
                n2 = 31;
                n = 2;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 505: {
                this.read();
                n2 = 135;
                n = 7;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 290: {
                this.read();
                n2 = 34;
                n = 8;
                hsqlName = hsqlName2;
                bl = false;
                bl3 = true;
                break;
            }
            case 304: {
                this.read();
                n2 = 1080;
                n = 11;
                hsqlName = hsqlName2;
                bl = true;
                break;
            }
            case 490: {
                this.read();
                n2 = 29;
                n = 11;
                hsqlName = hsqlName2;
                bl = true;
                break;
            }
            case 393: {
                this.read();
                n2 = 27;
                n = 13;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 535: {
                this.read();
                n2 = 35;
                n = 12;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 34: {
                this.read();
                this.readThis(253);
                n2 = 25;
                n = 14;
                hsqlName = hsqlName2;
                bl = false;
                bl3 = true;
                break;
            }
            case 545: {
                this.read();
                n2 = 36;
                n = 4;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            case 277: {
                this.read();
                n2 = 32;
                n = 3;
                hsqlName = hsqlName2;
                bl = true;
                bl3 = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (bl3 && this.token.tokenType == 412) {
            int n4 = this.getPosition();
            this.read();
            if (this.token.tokenType == 100) {
                this.read();
                bl4 = true;
            } else {
                this.rewind(n4);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName hsqlName3 = null;
        switch (n3) {
            case 304: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                User user = this.database.getUserManager().get(this.token.tokenString);
                hsqlName3 = user.getName();
                this.read();
                break;
            }
            case 490: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                Grantee grantee = this.database.getGranteeManager().getRole(this.token.tokenString);
                hsqlName3 = grantee.getName();
                this.read();
                break;
            }
            case 497: {
                hsqlName3 = this.readNewSchemaName();
                hsqlName = hsqlName2;
                break;
            }
            case 277: {
                boolean bl5 = this.token.namePrePrefix == null && "MODULE".equals(this.token.namePrefix);
                hsqlName3 = this.readNewSchemaObjectName(n, false);
                if (!bl5) break;
                Object[] objectArray = new Object[]{hsqlName3, bl4};
                return new StatementSession(32, objectArray);
            }
            default: {
                hsqlName3 = this.readNewSchemaObjectName(n, false);
            }
        }
        if (!bl4 && bl3 && this.token.tokenType == 412) {
            this.read();
            this.readThis(100);
            bl4 = true;
        }
        if (bl) {
            if (this.token.tokenType == 347) {
                bl2 = true;
                this.read();
            } else if (this.token.tokenType == 485) {
                this.read();
            }
        }
        Object[] objectArray = new Object[]{hsqlName3, new Integer(n), bl2, bl4};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, n2, objectArray, null, hsqlName);
        return statementSchema;
    }

    private void processAlterTable() {
        String string = this.token.tokenString;
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Table table = this.database.schemaManager.getUserTable(this.session, string, hsqlName.name);
        if (table.isView()) {
            throw Error.error(5501, string);
        }
        this.read();
        switch (this.token.tokenType) {
            case 593: {
                this.read();
                this.readThis(284);
                this.processAlterTableRename(table);
                return;
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName hsqlName2 = null;
                if (this.token.tokenType == 47) {
                    this.read();
                    hsqlName2 = this.readNewDependentSchemaObjectName(table.getName(), 5);
                    this.database.schemaManager.checkSchemaObjectNotExists(hsqlName2);
                }
                switch (this.token.tokenType) {
                    case 112: {
                        this.read();
                        this.readThis(427);
                        this.processAlterTableAddForeignKeyConstraint(table, hsqlName2);
                        return;
                    }
                    case 298: {
                        this.read();
                        this.processAlterTableAddUniqueConstraint(table, hsqlName2);
                        return;
                    }
                    case 36: {
                        this.read();
                        this.processAlterTableAddCheckConstraint(table, hsqlName2);
                        return;
                    }
                    case 213: {
                        this.read();
                        this.readThis(427);
                        this.processAlterTableAddPrimaryKey(table, hsqlName2);
                        return;
                    }
                    case 42: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        this.processAlterTableAddColumn(table);
                        return;
                    }
                }
                if (hsqlName2 != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                this.processAlterTableAddColumn(table);
                return;
            }
            case 87: {
                this.read();
                switch (this.token.tokenType) {
                    case 213: {
                        boolean bl = false;
                        this.read();
                        this.readThis(427);
                        if (this.token.tokenType == 347) {
                            this.read();
                            bl = true;
                        }
                        if (!table.hasPrimaryKey()) {
                            throw Error.error(5501);
                        }
                        this.processAlterTableDropConstraint(table, table.getPrimaryConstraint().getName().name, bl);
                        return;
                    }
                    case 47: {
                        boolean bl = false;
                        this.read();
                        SchemaObject schemaObject = this.readSchemaObjectName(table.getName(), 5);
                        if (this.token.tokenType == 485) {
                            this.read();
                        } else if (this.token.tokenType == 347) {
                            this.read();
                            bl = true;
                        }
                        this.processAlterTableDropConstraint(table, schemaObject.getName().name, bl);
                        return;
                    }
                    case 42: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String string2 = this.token.tokenString;
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 485) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    bl = true;
                }
                this.processAlterTableDropColumn(table, string2, bl);
                return;
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 42) {
                    this.read();
                }
                int n = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n);
                this.read();
                this.processAlterColumn(table, columnSchema, n);
                return;
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterTable() {
        this.read();
        String string = this.token.tokenString;
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        Table table = this.database.schemaManager.getUserTable(this.session, string, hsqlName.name);
        this.read();
        switch (this.token.tokenType) {
            case 593: {
                this.read();
                this.readThis(284);
                return this.compileRenameObject(table.getName(), 3);
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName hsqlName2 = null;
                if (this.token.tokenType == 47) {
                    this.read();
                    hsqlName2 = this.readNewDependentSchemaObjectName(table.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 112: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddForeignKeyConstraint(table, hsqlName2);
                    }
                    case 298: {
                        this.read();
                        return this.compileAlterTableAddUniqueConstraint(table, hsqlName2);
                    }
                    case 36: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(table, hsqlName2);
                    }
                    case 213: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddPrimaryKey(table, hsqlName2);
                    }
                    case 42: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(table);
                    }
                }
                if (hsqlName2 != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(table);
            }
            case 87: {
                this.read();
                switch (this.token.tokenType) {
                    case 213: {
                        boolean bl = false;
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableDropPrimaryKey(table);
                    }
                    case 47: {
                        this.read();
                        return this.compileAlterTableDropConstraint(table);
                    }
                    case 42: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String string2 = this.token.tokenString;
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 485) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    bl = true;
                }
                return this.compileAlterTableDropColumn(table, string2, bl);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 42) {
                    this.read();
                }
                int n = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n);
                this.read();
                return this.compileAlterColumn(table, columnSchema, n);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean bl = false;
        SchemaObject schemaObject = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            bl = true;
        }
        Object[] objectArray = new Object[]{schemaObject.getName(), ValuePool.getInt(5), bl, false};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 1079, objectArray);
        statementSchema.writeTableNames = this.getReferenceArray(table.getName(), bl);
        return statementSchema;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean bl = false;
        if (this.token.tokenType == 485) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            bl = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        Constraint constraint = table.getPrimaryConstraint();
        Object[] objectArray = new Object[]{constraint.getName(), ValuePool.getInt(5), bl, false};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 1079, objectArray);
        statementSchema.writeTableNames = this.getReferenceArray(table.getName(), bl);
        return statementSchema;
    }

    HsqlNameManager.HsqlName[] getReferenceArray(HsqlNameManager.HsqlName hsqlName, boolean bl) {
        if (bl) {
            Object[] objectArray;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            this.database.schemaManager.getCascadingReferencingObjectNames(hsqlName, orderedHashSet);
            Iterator iterator = orderedHashSet.iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                if (objectArray.type == 3) continue;
                iterator.remove();
            }
            orderedHashSet.add(hsqlName);
            objectArray = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(objectArray);
            return objectArray;
        }
        return new HsqlNameManager.HsqlName[]{hsqlName};
    }

    StatementSession compileDeclareLocalTableOrNull() {
        int n = super.getPosition();
        try {
            this.readThis(76);
            this.readThis(156);
            this.readThis(523);
            this.readThis(277);
        }
        catch (Exception exception) {
            this.rewind(n);
            return null;
        }
        if (this.token.namePrePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.namePrePrefix != null || this.token.namePrefix != null && !"MODULE".equals(this.token.namePrefix)) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.schema = SqlInvariants.MODULE_HSQLNAME;
        Table table = TableUtil.newTable(this.database, 3, hsqlName);
        StatementSchema statementSchema = this.compileCreateTableBody(table);
        HsqlArrayList hsqlArrayList = (HsqlArrayList)statementSchema.arguments[1];
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Constraint constraint = (Constraint)hsqlArrayList.get(i);
            if (constraint.getConstraintType() != 0) continue;
            throw this.unexpectedToken("FOREIGN");
        }
        StatementSession statementSession = new StatementSession(1068, statementSchema.arguments);
        return statementSession;
    }

    StatementSchema compileCreateTable(int n) {
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Table table = TableUtil.newTable(this.database, n, hsqlName);
        return this.compileCreateTableBody(table);
    }

    StatementSchema compileCreateTableBody(Table table) {
        Object[] objectArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        if (this.token.tokenType == 9) {
            return this.readTableAsSubqueryDefinition(table);
        }
        int n = this.getPosition();
        this.readThis(786);
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        block6: while (!bl3) {
            switch (this.token.tokenType) {
                case 153: {
                    objectArray = this.readLikeTable(table);
                    for (int i = 0; i < objectArray.length; ++i) {
                        table.addColumn(objectArray[i]);
                    }
                    bl = false;
                    bl2 = false;
                    continue block6;
                }
                case 36: 
                case 47: 
                case 112: 
                case 213: 
                case 298: {
                    if (!bl2) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, hsqlArrayList);
                    bl = false;
                    bl2 = false;
                    continue block6;
                }
                case 774: {
                    if (bl2) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl2 = true;
                    continue block6;
                }
                case 772: {
                    this.read();
                    bl3 = true;
                    continue block6;
                }
            }
            if (!bl2) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            objectArray = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, (HsqlNameManager.HsqlName)objectArray, hsqlArrayList);
            if (columnSchema == null) {
                if (bl) {
                    this.rewind(n);
                    return this.readTableAsSubqueryDefinition(table);
                }
                throw Error.error(5000);
            }
            table.addColumn(columnSchema);
            bl = false;
            bl2 = false;
        }
        if (this.token.tokenType == 193) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(43);
            if (this.token.tokenType != 78 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(244);
        }
        objectArray = new Object[]{table, hsqlArrayList, null};
        String string = this.getLastPart();
        return new StatementSchema(string, 77, objectArray);
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Table table2 = this.readTableName();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        while (true) {
            boolean bl4;
            boolean bl5 = bl4 = this.token.tokenType == 416;
            if (!bl4 && this.token.tokenType != 399) break;
            this.read();
            switch (this.token.tokenType) {
                case 407: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl = bl4;
                    break;
                }
                case 127: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl2 = bl4;
                    break;
                }
                case 381: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    bl3 = bl4;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnSchemaArray = new ColumnSchema[table2.getColumnCount()];
        for (int i = 0; i < columnSchemaArray.length; ++i) {
            ColumnSchema columnSchema = table2.getColumn(i).duplicate();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), columnSchema.getName());
            columnSchema.setName(hsqlName);
            columnSchema.setNullable(true);
            columnSchema.setPrimaryKey(false);
            if (bl2) {
                if (columnSchema.isIdentity()) {
                    columnSchema.setIdentity(columnSchema.getIdentitySequence().duplicate());
                }
            } else {
                columnSchema.setIdentity(null);
            }
            if (!bl3) {
                columnSchema.setDefaultExpression(null);
            }
            if (!bl) {
                columnSchema.setGeneratingExpression(null);
            }
            columnSchemaArray[i] = columnSchema;
        }
        return columnSchemaArray;
    }

    StatementSchema readTableAsSubqueryDefinition(Table table) {
        HsqlNameManager.HsqlName hsqlName = null;
        boolean bl = true;
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        StatementQuery statementQuery = null;
        if (this.token.tokenType == 786) {
            hsqlNameArray = this.readColumnNames(table.getName());
        }
        this.readThis(9);
        this.readThis(786);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(772);
        this.readThis(318);
        if (this.token.tokenType == 179) {
            this.read();
            bl = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(378);
        if (this.token.tokenType == 193) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(43);
            if (this.token.tokenType != 78 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(244);
        }
        if (hsqlNameArray == null) {
            hsqlNameArray = queryExpression.getResultColumnNames();
        } else if (hsqlNameArray.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, hsqlNameArray, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (bl) {
            statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
            hsqlName = statementQuery.getTableNamesForRead()[0];
        }
        Object[] objectArray = new Object[]{table, null, statementQuery};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, 77, objectArray, hsqlName, null);
        return statementSchema;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2, boolean bl) {
        Constraint constraint = (Constraint)hsqlArrayList.get(0);
        String string = constraint.getName() == null ? null : constraint.getName().name;
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.newAutoName("IDX", string, table.getSchemaName(), table.getName(), 20);
        constraint.setColumnsIndexes(table);
        table.createPrimaryKey(hsqlName, constraint.core.mainCols, true);
        if (constraint.core.mainCols != null) {
            Constraint constraint2 = new Constraint(constraint.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(constraint2);
            if (bl) {
                session.database.schemaManager.addSchemaObject(constraint2);
            }
        }
        block7: for (int i = 1; i < hsqlArrayList.size(); ++i) {
            constraint = (Constraint)hsqlArrayList.get(i);
            switch (constraint.constType) {
                case 2: {
                    constraint.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(constraint.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    hsqlName = session.database.nameManager.newAutoName("IDX", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
                    SchemaObject schemaObject = table.createAndAddIndexStructure(session, hsqlName, constraint.core.mainCols, null, null, true, true, false);
                    Constraint constraint3 = new Constraint(constraint.getName(), table, (Index)schemaObject, 2);
                    table.addConstraint(constraint3);
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint3);
                    continue block7;
                }
                case 0: {
                    ParserDDL.addForeignKey(session, table, constraint, hsqlArrayList2);
                    continue block7;
                }
                case 3: {
                    SchemaObject schemaObject;
                    try {
                        constraint.prepareCheckConstraint(session, table, false);
                    }
                    catch (HsqlException hsqlException) {
                        if (session.isProcessingScript()) continue block7;
                        throw hsqlException;
                    }
                    table.addConstraint(constraint);
                    if (constraint.isNotNull()) {
                        schemaObject = table.getColumn(constraint.notNullColumnIndex);
                        schemaObject.setNullable(false);
                        table.setColumnTypeVars(constraint.notNullColumnIndex);
                    }
                    if (!bl) continue block7;
                    session.database.schemaManager.addSchemaObject(constraint);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint constraint, HsqlArrayList hsqlArrayList) {
        SchemaObject schemaObject;
        HsqlNameManager.HsqlName hsqlName = constraint.getMainTableName();
        if (hsqlName == table.getName()) {
            constraint.core.mainTable = table;
        } else {
            schemaObject = session.database.schemaManager.findUserTable(session, hsqlName.name, hsqlName.schema.name);
            if (schemaObject == null) {
                if (hsqlArrayList == null) {
                    throw Error.error(5501, hsqlName.name);
                }
                hsqlArrayList.add(constraint);
                return;
            }
            constraint.core.mainTable = schemaObject;
        }
        constraint.setColumnsIndexes(table);
        schemaObject = constraint.core.mainTable.getUniqueConstraintForColumns(constraint.core.mainCols, constraint.core.refCols);
        if (schemaObject == null) {
            throw Error.error(5523);
        }
        Index index = ((Constraint)schemaObject).getMainIndex();
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.checkCreateForeignKey(constraint);
        boolean bl = constraint.core.mainTable.getSchemaName() != table.getSchemaName();
        int n = session.database.schemaManager.getTableIndex(table);
        if (n != -1 && n < session.database.schemaManager.getTableIndex(constraint.core.mainTable)) {
            bl = true;
        }
        HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newAutoName("IDX", table.getSchemaName(), table.getName(), 20);
        Index index2 = table.createAndAddIndexStructure(session, hsqlName2, constraint.core.refCols, null, null, false, true, bl);
        HsqlNameManager.HsqlName hsqlName3 = session.database.nameManager.newAutoName("REF", constraint.getName().name, table.getSchemaName(), table.getName(), 20);
        constraint.core.uniqueName = ((Constraint)schemaObject).getName();
        constraint.core.mainName = hsqlName3;
        constraint.core.mainIndex = index;
        constraint.core.refTable = table;
        constraint.core.refName = constraint.getName();
        constraint.core.refIndex = index2;
        constraint.isForward = bl;
        table.addConstraint(constraint);
        constraint.core.mainTable.addConstraint(new Constraint(hsqlName3, constraint));
        session.database.schemaManager.addSchemaObject(constraint);
    }

    private Constraint readFKReferences(Table table, HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        HsqlNameManager.HsqlName hsqlName2;
        OrderedHashSet orderedHashSet2 = null;
        this.readThis(221);
        HsqlNameManager.HsqlName hsqlName3 = this.token.namePrefix == null ? table.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (table.getSchemaName() == hsqlName3 && table.getName().name.equals(this.token.tokenString)) {
            hsqlName2 = table.getName();
            this.read();
        } else {
            hsqlName2 = this.readFKTableName(hsqlName3);
        }
        if (this.token.tokenType == 786) {
            orderedHashSet2 = this.readColumnNames(false);
        } else if (hsqlName2 == table.getName()) {
            // empty if block
        }
        int n = 59;
        if (this.token.tokenType == 161) {
            this.read();
            switch (this.token.tokenType) {
                case 511: {
                    this.read();
                    break;
                }
                case 470: {
                    throw super.unsupportedFeature();
                }
                case 115: {
                    this.read();
                    n = 61;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int n2 = 3;
        int n3 = 3;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 193) {
            this.read();
            if (!orderedIntHashSet.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 78) {
                this.read();
                if (this.token.tokenType == 253) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 77: {
                            this.read();
                            n2 = 4;
                            continue block13;
                        }
                        case 185: {
                            this.read();
                            n2 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    n2 = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(179);
                this.readThis(332);
                continue;
            }
            if (this.token.tokenType == 302) {
                this.read();
                if (this.token.tokenType == 253) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 77: {
                            this.read();
                            n2 = 4;
                            continue block13;
                        }
                        case 185: {
                            this.read();
                            n2 = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    n3 = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(179);
                this.readThis(332);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        return new Constraint(hsqlName, table.getName(), orderedHashSet, hsqlName2, orderedHashSet2, 0, n2, n3, n);
    }

    private HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName hsqlName) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.session, this.token.tokenString, hsqlName.name);
        HsqlNameManager.HsqlName hsqlName2 = table == null ? this.database.nameManager.newHsqlName(hsqlName, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return hsqlName2;
    }

    StatementSchema compileCreateView(boolean bl) {
        QueryExpression queryExpression;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(4, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        if (this.token.tokenType == 786) {
            hsqlNameArray = this.readColumnNames(hsqlName);
        }
        this.readThis(9);
        this.startRecording();
        int n = this.getPosition();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTable();
        }
        Token[] tokenArray = this.getRecordedStatement();
        int n2 = 0;
        if (this.token.tokenType == 318) {
            this.read();
            n2 = 2;
            if (this.readIfThis(156)) {
                n2 = 1;
            } else {
                this.readIfThis(27);
            }
            this.readThis(36);
            this.readThis(455);
        }
        View view = new View(this.database, hsqlName, hsqlNameArray, n2);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        view.setStatement(Token.getSQL(tokenArray));
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{view};
        int n3 = bl ? 1071 : 84;
        StatementSchema statementSchema = new StatementSchema(string, n3, objectArray);
        StatementQuery statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
        statementSchema.readTableNames = statementQuery.readTableNames;
        return statementSchema;
    }

    StatementSchema compileCreateSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(7, false);
        NumberSequence numberSequence = new NumberSequence(hsqlName, Type.SQL_INTEGER);
        this.readSequenceOptions(numberSequence, true, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence};
        return new StatementSchema(string, 133, objectArray);
    }

    StatementSchema compileCreateDomain() {
        Object[] objectArray;
        int n;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(13, false);
        this.readIfThis(9);
        Type type = this.readTypeDefinition(false).duplicate();
        Expression expression = null;
        if (this.readIfThis(77)) {
            expression = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        userTypeModifier.setDefaultClause(expression);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            n = 0;
            switch (this.token.tokenType) {
                case 36: 
                case 47: {
                    this.readConstraint(type, hsqlArrayList);
                    break;
                }
                default: {
                    n = 1;
                }
            }
        } while (n == 0);
        this.compileContext.currentDomain = null;
        for (n = 0; n < hsqlArrayList.size(); ++n) {
            objectArray = (Object[])hsqlArrayList.get(n);
            objectArray.prepareCheckConstraint(this.session, null, false);
            userTypeModifier.addConstraint((Constraint)objectArray);
        }
        String string = this.getLastPart();
        objectArray = new Object[]{type};
        return new StatementSchema(string, 23, objectArray);
    }

    StatementSchema compileCreateType() {
        UserTypeModifier userTypeModifier;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(12, false);
        this.readThis(9);
        Type type = this.readTypeDefinition(false).duplicate();
        this.readIfThis(400);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(hsqlName, 12, type);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{type};
        return new StatementSchema(string, 83, objectArray);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(253);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(14, false);
        this.readIfThis(9);
        this.readThis(118);
        String string = this.session.getSchemaName(this.token.namePrefix);
        Charset charset = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, string, 14);
        this.read();
        if (this.token.tokenType == 358) {
            this.read();
            this.readThis(114);
            this.readThis(77);
        }
        Charset charset2 = new Charset(hsqlName);
        charset2.base = charset.getName();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{charset2};
        return new StatementSchema(string2, 8, objectArray);
    }

    StatementSchema compileCreateAlias() {
        Object[] objectArray;
        Object object;
        String string;
        HsqlNameManager.HsqlName hsqlName = null;
        Routine[] routineArray = null;
        String string2 = null;
        if (!this.session.isProcessingScript()) {
            throw super.unsupportedFeature();
        }
        this.read();
        try {
            string = this.token.tokenString;
            this.read();
            this.readThis(111);
            string2 = this.token.tokenString;
            this.read();
        }
        catch (HsqlException hsqlException) {
            string = null;
        }
        if (string != null) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            hsqlName = this.database.nameManager.newHsqlName((HsqlNameManager.HsqlName)object, string, 16);
            objectArray = Routine.getMethods(string2);
            routineArray = Routine.newRoutines(this.session, (Method[])objectArray);
        }
        object = this.getLastPart();
        objectArray = new Object[]{hsqlName, routineArray};
        return new StatementSchema((String)object, 1073, objectArray);
    }

    StatementSchema compileCreateTrigger() {
        Object[] objectArray;
        Object object;
        int n;
        int n2;
        Boolean bl = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        HsqlNameManager.HsqlName hsqlName = null;
        OrderedHashSet orderedHashSet = null;
        int[] nArray = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(8, true);
        switch (this.token.tokenType) {
            case 422: {
                n2 = TriggerDef.getTiming(422);
                this.read();
                this.readThis(190);
                break;
            }
            case 336: 
            case 343: {
                n2 = TriggerDef.getTiming(this.token.tokenType);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (this.token.tokenType) {
            case 78: 
            case 134: {
                n = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                break;
            }
            case 302: {
                n = TriggerDef.getOperationType(this.token.tokenType);
                this.read();
                if (this.token.tokenType != 190 || n2 == 6) break;
                this.read();
                orderedHashSet = new OrderedHashSet();
                this.readColumnNameList(orderedHashSet, null, false);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(193);
        Table table = this.readTableName();
        if (this.token.tokenType == 343) {
            this.read();
            this.checkIsSimpleName();
            hsqlName = this.readNewSchemaObjectName(8, true);
        }
        hsqlName2.setSchemaIfNull(table.getSchemaName());
        this.checkSchemaUpdateAuthorisation(hsqlName2.schema);
        if (n2 == 6 ? !table.isView() || ((View)table).getCheckOption() == 2 : table.isView()) {
            throw Error.error(5538, hsqlName2.schema.name);
        }
        if (hsqlName2.schema != table.getSchemaName()) {
            throw Error.error(5505, hsqlName2.schema.name);
        }
        hsqlName2.parent = table.getName();
        this.database.schemaManager.checkSchemaObjectNotExists(hsqlName2);
        if (orderedHashSet != null) {
            nArray = table.getColumnIndexes(orderedHashSet);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != -1) continue;
                throw Error.error(5544, (String)orderedHashSet.get(i));
            }
        }
        Expression expression = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Table[] tableArray = new Table[4];
        RangeVariable[] rangeVariableArray = new RangeVariable[4];
        String string5 = null;
        if (this.token.tokenType == 222) {
            this.read();
            if (this.token.tokenType != 192 && this.token.tokenType != 178) {
                throw this.unexpectedToken();
            }
            while (true) {
                RangeVariable rangeVariable;
                String string6;
                if (this.token.tokenType == 192) {
                    if (n == 50) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 277) {
                        if (Boolean.TRUE.equals(bl) || string != null || n2 == 4) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(9);
                        this.checkIsSimpleName();
                        this.read();
                        string6 = string = this.token.tokenString;
                        if (string6.equals(string2) || string6.equals(string3) || string6.equals(string4)) {
                            throw this.unexpectedToken();
                        }
                        bl = Boolean.FALSE;
                        object = this.database.nameManager.newHsqlName(table.getSchemaName(), string6, this.isDelimitedIdentifier(), 10);
                        objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                        rangeVariable = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                        tableArray[2] = objectArray;
                        rangeVariableArray[2] = rangeVariable;
                        continue;
                    }
                    if (Boolean.FALSE.equals(bl) || string3 != null) {
                        throw this.unexpectedToken();
                    }
                    this.readIfThis(242);
                    this.readIfThis(9);
                    this.checkIsSimpleName();
                    string3 = this.token.tokenString;
                    this.read();
                    string6 = string3;
                    if (string6.equals(string2) || string6.equals(string) || string6.equals(string4)) {
                        throw this.unexpectedToken();
                    }
                    bl = Boolean.TRUE;
                    object = this.database.nameManager.newHsqlName(table.getSchemaName(), string6, this.isDelimitedIdentifier(), 10);
                    objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                    rangeVariable = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                    tableArray[0] = objectArray;
                    rangeVariableArray[0] = rangeVariable;
                    continue;
                }
                if (this.token.tokenType != 178) break;
                if (n == 19) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 277) {
                    if (Boolean.TRUE.equals(bl) || string2 != null || n2 == 4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readIfThis(9);
                    this.checkIsSimpleName();
                    string2 = this.token.tokenString;
                    this.read();
                    bl = Boolean.FALSE;
                    string6 = string2;
                    if (string6.equals(string) || string6.equals(string3) || string6.equals(string4)) {
                        throw this.unexpectedToken();
                    }
                    object = this.database.nameManager.newHsqlName(table.getSchemaName(), string6, this.isDelimitedIdentifier(), 10);
                    objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                    rangeVariable = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                    tableArray[3] = objectArray;
                    rangeVariableArray[3] = rangeVariable;
                    continue;
                }
                if (Boolean.FALSE.equals(bl) || string4 != null) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(242);
                this.readIfThis(9);
                this.checkIsSimpleName();
                string4 = this.token.tokenString;
                this.read();
                bl = Boolean.TRUE;
                string6 = string4;
                if (string6.equals(string) || string6.equals(string2) || string6.equals(string3)) {
                    throw this.unexpectedToken();
                }
                object = this.database.nameManager.newHsqlName(table.getSchemaName(), string6, this.isDelimitedIdentifier(), 10);
                objectArray = new Table(table, (HsqlNameManager.HsqlName)object);
                rangeVariable = new RangeVariable((Table)objectArray, null, null, null, this.compileContext);
                tableArray[1] = objectArray;
                rangeVariableArray[1] = rangeVariable;
            }
        }
        if (Boolean.TRUE.equals(bl) && this.token.tokenType != 111) {
            throw this.unexpectedTokenRequire("FOR");
        }
        if (this.token.tokenType == 111) {
            this.read();
            this.readThis(89);
            if (this.token.tokenType == 242) {
                if (Boolean.FALSE.equals(bl)) {
                    throw this.unexpectedToken();
                }
                bl = Boolean.TRUE;
            } else if (this.token.tokenType == 517) {
                if (Boolean.TRUE.equals(bl) || n2 == 4) {
                    throw this.unexpectedToken();
                }
                bl = Boolean.FALSE;
            } else {
                throw this.unexpectedToken();
            }
            this.read();
        }
        if (rangeVariableArray[2] != null) {
            // empty if block
        }
        if (rangeVariableArray[3] != null) {
            // empty if block
        }
        if ("QUEUE".equals(this.token.tokenString)) {
            this.read();
            n3 = this.readInteger();
            bl3 = true;
        }
        if ("NOWAIT".equals(this.token.tokenString)) {
            this.read();
            bl2 = true;
        }
        if (this.token.tokenType == 313 && n2 != 6) {
            this.read();
            this.readThis(786);
            int n4 = this.getPosition();
            this.isCheckOrTriggerCondition = true;
            expression = this.XreadBooleanValueExpression();
            string5 = this.getLastPart(n4);
            this.isCheckOrTriggerCondition = false;
            this.readThis(772);
            object = expression.resolveColumnReferences(rangeVariableArray, null);
            ExpressionColumn.checkColumnsResolved((HsqlList)object);
            expression.resolveTypes(this.session, null);
            if (expression.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (this.token.tokenType == 24) {
            int n5 = this.getPosition();
            try {
                this.read();
                this.checkIsSimpleName();
                this.checkIsDelimitedIdentifier();
                String string7 = this.token.tokenString;
                this.read();
                TriggerDef triggerDef = new TriggerDef(hsqlName2, n2, n, bl, table, tableArray, rangeVariableArray, expression, string5, nArray, string7, bl2, n3);
                object = this.getLastPart();
                objectArray = new Object[]{triggerDef, hsqlName};
                return new StatementSchema((String)object, 80, objectArray, null, table.getName());
            }
            catch (HsqlException hsqlException) {
                this.rewind(n5);
            }
        }
        if (bl3) {
            throw this.unexpectedToken("QUEUE");
        }
        if (bl2) {
            throw this.unexpectedToken("NOWAIT");
        }
        Routine routine = this.compileTriggerRoutine(table, rangeVariableArray, n2, n);
        TriggerDefSQL triggerDefSQL = new TriggerDefSQL(hsqlName2, n2, n, bl, table, tableArray, rangeVariableArray, expression, string5, nArray, routine);
        object = this.getLastPart();
        objectArray = new Object[]{triggerDefSQL, hsqlName};
        return new StatementSchema((String)object, 80, objectArray, null, table.getName());
    }

    Routine compileTriggerRoutine(Table table, RangeVariable[] rangeVariableArray, int n, int n2) {
        int n3 = n == 4 ? 3 : 4;
        Routine routine = new Routine(table, rangeVariableArray, n3, n, n2);
        this.startRecording();
        Statement statement = this.compileSQLProcedureStatementOrNull(routine, null);
        if (statement == null) {
            throw this.unexpectedToken();
        }
        Token[] tokenArray = this.getRecordedStatement();
        String string = Token.getSQL(tokenArray);
        statement.setSQL(string);
        routine.setProcedure(statement);
        routine.resolve(this.session);
        return routine;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList hsqlArrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Expression expression = null;
        boolean bl5 = true;
        Expression expression2 = null;
        Type type = null;
        NumberSequence numberSequence = null;
        if (this.token.tokenType == 407) {
            this.read();
            this.readThis(337);
            bl = true;
            bl4 = true;
            throw this.unexpectedToken("GENERATED");
        }
        if (this.token.tokenType == 127) {
            this.read();
            bl2 = true;
            bl3 = true;
            type = Type.SQL_INTEGER;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        } else {
            if (this.token.tokenType == 774) {
                return null;
            }
            if (this.token.tokenType == 772) {
                return null;
            }
            type = this.readTypeDefinition(true);
        }
        if (!bl && !bl2) {
            if (this.token.tokenType == 77) {
                this.read();
                expression2 = this.readDefaultClause(type);
            } else if (this.token.tokenType == 407 && !bl2) {
                this.read();
                if (this.token.tokenType == 23) {
                    this.read();
                    this.readThis(77);
                } else {
                    this.readThis(337);
                    bl4 = true;
                }
                this.readThis(9);
                if (this.token.tokenType == 127) {
                    this.read();
                    numberSequence = new NumberSequence(null, type);
                    numberSequence.setAlways(bl4);
                    if (this.token.tokenType == 786) {
                        this.read();
                        this.readSequenceOptions(numberSequence, false, false);
                        this.readThis(772);
                    }
                    bl2 = true;
                } else if (this.token.tokenType == 786) {
                    if (!bl4) {
                        throw super.unexpectedTokenRequire("ALWAYS");
                    }
                    bl = true;
                }
            } else if (this.token.tokenType == 127 && !bl2) {
                this.read();
                bl2 = true;
                bl3 = true;
                numberSequence = new NumberSequence(null, 0L, 1L, type);
            }
        }
        if (bl) {
            this.readThis(786);
            expression = this.XreadValueExpression();
            this.readThis(772);
        }
        ColumnSchema columnSchema = new ColumnSchema(hsqlName, type, bl5, false, expression2);
        columnSchema.setGeneratingExpression(expression);
        this.readColumnConstraints(table, columnSchema, hsqlArrayList);
        if (this.token.tokenType == 127 && !bl2) {
            this.read();
            bl2 = true;
            bl3 = true;
            numberSequence = new NumberSequence(null, 0L, 1L, type);
        }
        if (bl2) {
            columnSchema.setIdentity(numberSequence);
        }
        if (bl3 && !columnSchema.isPrimaryKey()) {
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            orderedHashSet.add(columnSchema.getName().name);
            HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint constraint = new Constraint(hsqlName2, orderedHashSet, 4);
            hsqlArrayList.set(0, constraint);
            columnSchema.setPrimaryKey(true);
        }
        return columnSchema;
    }

    private void readSequenceOptions(NumberSequence numberSequence, boolean bl, boolean bl2) {
        boolean bl3;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        do {
            bl3 = false;
            if (orderedIntHashSet.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 9: {
                    if (bl) {
                        this.read();
                        Type type = this.readTypeDefinition(true);
                        numberSequence.setDefaults(numberSequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 266: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(318);
                    long l = this.readBigint();
                    numberSequence.setStartValueNoCheck(l);
                    break;
                }
                case 484: {
                    if (!bl2) {
                        bl3 = true;
                        break;
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(318)) {
                        long l = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l);
                        break;
                    }
                    numberSequence.setStartValueDefault();
                    break;
                }
                case 417: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    this.readThis(23);
                    long l = this.readBigint();
                    numberSequence.setIncrement(l);
                    break;
                }
                case 179: {
                    this.read();
                    if (this.token.tokenType == 438) {
                        numberSequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 442) {
                        numberSequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 70) {
                        numberSequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 438: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMaxValueNoCheck(l);
                    break;
                }
                case 442: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    long l = this.readBigint();
                    numberSequence.setMinValueNoCheck(l);
                    break;
                }
                case 70: {
                    orderedIntHashSet.add(this.token.tokenType);
                    this.read();
                    numberSequence.setCycle(true);
                    break;
                }
                default: {
                    bl3 = true;
                }
            }
        } while (!bl3);
        numberSequence.checkValues();
    }

    private void readConstraint(SchemaObject schemaObject, HsqlArrayList hsqlArrayList) {
        HsqlNameManager.HsqlName hsqlName = null;
        if (this.token.tokenType == 47) {
            this.read();
            hsqlName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 213: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                if (constraint.constType == 4) {
                    throw Error.error(5532);
                }
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint2 = new Constraint(hsqlName, orderedHashSet, 4);
                hsqlArrayList.set(0, constraint2);
                break;
            }
            case 298: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, orderedHashSet, 2);
                hsqlArrayList.add(constraint);
                break;
            }
            case 112: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                Constraint constraint = this.readFKReferences((Table)schemaObject, hsqlName, orderedHashSet);
                hsqlArrayList.add(constraint);
                break;
            }
            case 36: {
                this.read();
                if (hsqlName == null) {
                    hsqlName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint constraint = new Constraint(hsqlName, null, 3);
                this.readCheckConstraintCondition(constraint);
                hsqlArrayList.add(constraint);
                break;
            }
            default: {
                if (hsqlName == null) break;
                throw super.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema columnSchema, HsqlArrayList hsqlArrayList) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        do {
            HsqlNameManager.HsqlName hsqlName = null;
            if (this.token.tokenType == 47) {
                this.read();
                hsqlName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 213: {
                    if (bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(427);
                    Object object = (Constraint)hsqlArrayList.get(0);
                    if (((Constraint)object).constType == 4) {
                        throw Error.error(5532);
                    }
                    Object object2 = new OrderedHashSet();
                    ((HashSet)object2).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint constraint = new Constraint(hsqlName, (OrderedHashSet)object2, 4);
                    hsqlArrayList.set(0, constraint);
                    columnSchema.setPrimaryKey(true);
                    bl4 = true;
                    break;
                }
                case 298: {
                    this.read();
                    Object object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object2 = new Constraint(hsqlName, (OrderedHashSet)object, 2);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 112: {
                    this.read();
                    this.readThis(427);
                }
                case 221: {
                    Object object = new OrderedHashSet();
                    ((HashSet)object).add(columnSchema.getName().name);
                    Object object2 = this.readFKReferences(table, hsqlName, (OrderedHashSet)object);
                    hsqlArrayList.add(object2);
                    break;
                }
                case 36: {
                    this.read();
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object = new Constraint(hsqlName, null, 3);
                    this.readCheckConstraintCondition((Constraint)object);
                    Object object2 = ((Constraint)object).getCheckColumnExpressions();
                    for (int i = 0; i < ((BaseHashMap)object2).size(); ++i) {
                        ExpressionColumn expressionColumn = (ExpressionColumn)((OrderedHashSet)object2).get(i);
                        if (columnSchema.getName().name.equals(expressionColumn.getColumnName())) {
                            if (expressionColumn.getSchemaName() == null || expressionColumn.getSchemaName() == table.getSchemaName().name) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    hsqlArrayList.add(object);
                    break;
                }
                case 182: {
                    if (bl2 || bl3) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(185);
                    if (hsqlName == null) {
                        hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Object object = new Constraint(hsqlName, null, 3);
                    ((Constraint)object).check = new ExpressionLogical(columnSchema);
                    hsqlArrayList.add(object);
                    bl2 = true;
                    break;
                }
                case 185: {
                    if (bl2 || bl3 || bl4) {
                        throw this.unexpectedToken();
                    }
                    if (hsqlName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl3 = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
    }

    void readCheckConstraintCondition(Constraint constraint) {
        this.readThis(786);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression expression = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokenArray = this.getRecordedStatement();
        this.readThis(772);
        constraint.check = expression;
    }

    private int[] readColumnList(Table table, boolean bl) {
        OrderedHashSet orderedHashSet = this.readColumnNames(bl);
        return table.getColumnIndexes(orderedHashSet);
    }

    StatementSchema compileCreateIndex(boolean bl) {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        this.readThis(193);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName hsqlName2 = table.getSchemaName();
        hsqlName.setSchemaIfNull(hsqlName2);
        hsqlName.parent = table.getName();
        if (hsqlName.schema != hsqlName2) {
            throw Error.error(5505);
        }
        hsqlName.schema = table.getSchemaName();
        int[] nArray = this.readColumnList(table, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, hsqlName, bl};
        return new StatementSchema(string, 1074, objectArray, null, table.getName());
    }

    StatementSchema compileCreateSchema() {
        boolean bl;
        Grantee grantee;
        HsqlNameManager.HsqlName hsqlName = null;
        String string = null;
        this.read();
        if (this.token.tokenType != 14) {
            hsqlName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 14) {
            this.read();
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            if (hsqlName == null) {
                grantee = this.database.getGranteeManager().get(string);
                if (grantee == null) {
                    throw Error.error(4001, string);
                }
                hsqlName = this.database.nameManager.newHsqlName(grantee.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(string)) {
            throw Error.error(4002, string);
        }
        Grantee grantee2 = grantee = string == null ? this.session.getGrantee() : this.database.getGranteeManager().get(string);
        if (grantee == null) {
            throw Error.error(4001, string);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2000, this.session.getGrantee().getNameString());
        }
        if (this.database.schemaManager.schemaExists(hsqlName.name)) {
            throw Error.error(5504, hsqlName.name);
        }
        if (hsqlName.name.equals("SYSTEM_LOBS")) {
            hsqlName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            grantee = hsqlName.owner;
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, grantee};
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        StatementSchema statementSchema = new StatementSchema(string2, 64, objectArray, null, null);
        statementSchema.setSchemaHsqlName(hsqlName);
        hsqlArrayList.add(statementSchema);
        this.getCompiledStatementBody(hsqlArrayList);
        StatementSchema[] statementSchemaArray = new StatementSchema[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementSchemaArray);
        do {
            bl = false;
            for (int i = 0; i < statementSchemaArray.length - 1; ++i) {
                if (statementSchemaArray[i].order <= statementSchemaArray[i + 1].order) continue;
                StatementSchema statementSchema2 = statementSchemaArray[i + 1];
                statementSchemaArray[i + 1] = statementSchemaArray[i];
                statementSchemaArray[i] = statementSchema2;
                bl = true;
            }
        } while (bl);
        return new StatementSchemaDefinition(statementSchemaArray);
    }

    void getCompiledStatementBody(HsqlList hsqlList) {
        boolean bl = false;
        while (!bl) {
            StatementSchema statementSchema = null;
            int n = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 54: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 298: 
                        case 304: 
                        case 497: {
                            throw this.unexpectedToken();
                        }
                        case 578: {
                            int n2 = 1074;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                        case 505: {
                            statementSchema = this.compileCreateSequence();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 490: {
                            statementSchema = this.compileCreateRole();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 393: {
                            int n2 = 23;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                        case 535: {
                            statementSchema = this.compileCreateType();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 34: {
                            statementSchema = this.compileCreateCharacterSet();
                            statementSchema.sql = this.getLastPart(n);
                            break block0;
                        }
                        case 339: {
                            throw this.unexpectedToken();
                        }
                        case 119: 
                        case 277: 
                        case 523: 
                        case 558: 
                        case 584: 
                        case 597: 
                        case 598: {
                            int n2 = 77;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                        case 290: {
                            int n2 = 80;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                        case 545: {
                            int n2 = 84;
                            String string = this.getStatement(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                        case 116: {
                            int n2 = 14;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                        case 214: {
                            int n2 = 14;
                            String string = this.getStatementForRoutine(n, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n2, null);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 120: {
                    statementSchema = this.compileGrantOrRevoke();
                    statementSchema.sql = this.getLastPart(n);
                    break;
                }
                case 791: {
                    this.read();
                    bl = true;
                    break;
                }
                case 848: {
                    bl = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (statementSchema == null) continue;
            statementSchema.isSchemaDefinition = true;
            hsqlList.add(statementSchema);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName};
        return new StatementSchema(string, 61, objectArray);
    }

    StatementSchema compileCreateUser() {
        boolean bl = false;
        Grantee grantee = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        this.readThis(588);
        String string = this.readPassword();
        if (this.token.tokenType == 335) {
            this.read();
            bl = true;
        }
        this.checkDatabaseUpdateAuthorisation();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, string, grantee, bl};
        return new StatementSchema(string2, 1075, objectArray);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedIdentifier();
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl, 11);
        this.read();
        return hsqlName;
    }

    String readPassword() {
        String string = this.token.tokenString;
        this.read();
        return string;
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        return new StatementSchema(string, 1082, objectArray);
    }

    void processAlterTableRename(Table table) {
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, true);
        hsqlName.setSchemaIfNull(table.getSchemaName());
        if (table.getSchemaName() != hsqlName.schema) {
            throw Error.error(5505);
        }
        this.database.schemaManager.renameSchemaObject(table.getName(), hsqlName);
    }

    void processAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] nArray = this.readColumnList(table, false);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addUniqueConstraint(nArray, hsqlName);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] nArray = this.readColumnList(table, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{nArray, hsqlName};
        return new StatementSchema(string, 4, objectArray, null, table.getName());
    }

    void processAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = this.readFKReferences(table, hsqlName, orderedHashSet);
        HsqlNameManager.HsqlName hsqlName2 = constraint.getMainTableName();
        constraint.core.mainTable = this.database.schemaManager.getTable(this.session, hsqlName2.name, hsqlName2.schema.name);
        constraint.setColumnsIndexes(table);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addForeignKey(constraint);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = this.readFKReferences(table, hsqlName, orderedHashSet);
        HsqlNameManager.HsqlName hsqlName2 = constraint.getMainTableName();
        constraint.core.mainTable = this.database.schemaManager.getTable(this.session, hsqlName2.name, hsqlName2.schema.name);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{constraint};
        return new StatementSchema(string, 4, objectArray, constraint.core.mainTableName, table.getName());
    }

    void processAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint constraint = new Constraint(hsqlName, null, 3);
        this.readCheckConstraintCondition(constraint);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addCheckConstraint(constraint);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint constraint = new Constraint(hsqlName, null, 3);
        this.readCheckConstraintCondition(constraint);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{constraint};
        return new StatementSchema(string, 4, objectArray, null, table.getName());
    }

    void processAlterTableAddColumn(Table table) {
        int n = table.getColumnCount();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            n = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        TableWorks tableWorks = new TableWorks(this.session, table);
        this.session.commit(false);
        tableWorks.addColumn(columnSchema, n, hsqlArrayList);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int n = table.getColumnCount();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        hsqlArrayList.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            n = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{columnSchema, new Integer(n), hsqlArrayList};
        return new StatementSchema(string, 4, objectArray, null, table.getName());
    }

    void processAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
        constraint.setColumnsIndexes(table);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addPrimaryKey(constraint, hsqlName);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            hsqlName = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{constraint};
        return new StatementSchema(string, 4, objectArray, null, table.getName());
    }

    void processAlterTableDropColumn(Table table, String string, boolean bl) {
        int n = table.getColumnIndex(string);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.dropColumn(n, bl);
    }

    Statement compileAlterTableDropColumn(Table table, String string, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = null;
        int n = table.getColumnIndex(string);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        Object[] objectArray = new Object[]{table.getColumn(n).getName(), ValuePool.getInt(5), bl, false};
        if (!table.isTemp()) {
            hsqlName = table.getName();
        }
        return new StatementSchema(null, 1077, objectArray, null, hsqlName);
    }

    void processAlterTableDropConstraint(Table table, String string, boolean bl) {
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.dropConstraint(string, bl);
    }

    void processAlterColumn(Table table, ColumnSchema columnSchema, int n) {
        int n2 = this.getPosition();
        switch (this.token.tokenType) {
            case 593: {
                this.read();
                this.readThis(284);
                this.processAlterColumnRename(table, columnSchema);
                return;
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    TableWorks tableWorks = new TableWorks(this.session, table);
                    tableWorks.setColDefaultExpression(n, null);
                    return;
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    columnSchema.setIdentity(null);
                    table.setColumnTypeVars(n);
                    return;
                }
                throw this.unexpectedToken();
            }
            case 253: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(535);
                        this.processAlterColumnDataType(table, columnSchema);
                        return;
                    }
                    case 77: {
                        this.read();
                        TableWorks tableWorks = new TableWorks(this.session, table);
                        Type type = columnSchema.getDataType();
                        Expression expression = this.readDefaultClause(type);
                        tableWorks.setColDefaultExpression(n, expression);
                        return;
                    }
                    case 182: {
                        this.read();
                        this.readThis(185);
                        this.session.commit(false);
                        TableWorks tableWorks = new TableWorks(this.session, table);
                        tableWorks.setColNullability(columnSchema, false);
                        return;
                    }
                    case 185: {
                        this.read();
                        this.session.commit(false);
                        TableWorks tableWorks = new TableWorks(this.session, table);
                        tableWorks.setColNullability(columnSchema, true);
                        return;
                    }
                }
                this.rewind(n2);
                this.read();
            }
        }
        if (this.token.tokenType == 253 || this.token.tokenType == 484) {
            if (!columnSchema.isIdentity()) {
                throw Error.error(5535);
            }
            this.processAlterColumnSequenceOptions(columnSchema);
            return;
        }
        this.processAlterColumnType(table, columnSchema, true);
    }

    Statement compileAlterColumn(Table table, ColumnSchema columnSchema, int n) {
        int n2 = this.getPosition();
        switch (this.token.tokenType) {
            case 593: {
                this.read();
                this.readThis(284);
                return this.compileAlterColumnRename(table, columnSchema);
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    return this.compileAlterColumnDropDefault(table, columnSchema, n);
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    return this.compileAlterColumnDropGenerated(table, columnSchema, n);
                }
                throw this.unexpectedToken();
            }
            case 253: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(535);
                        return this.compileAlterColumnDataType(table, columnSchema);
                    }
                    case 77: {
                        this.read();
                        Type type = columnSchema.getDataType();
                        Expression expression = this.readDefaultClause(type);
                        return this.compileAlterColumnSetDefault(table, columnSchema, expression);
                    }
                    case 182: {
                        this.read();
                        this.readThis(185);
                        return this.compileAlterColumnSetNullability(table, columnSchema, false);
                    }
                    case 185: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, columnSchema, true);
                    }
                }
                this.rewind(n2);
                this.read();
            }
        }
        if (this.token.tokenType == 253 || this.token.tokenType == 484) {
            if (!columnSchema.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, columnSchema);
        }
        return this.compileAlterColumnType(table, columnSchema);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema columnSchema) {
        Object var3_3 = null;
        Type type = this.readTypeDefinition(false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, columnSchema, type};
        return new StatementSchema(string, 4, null, null, table.getName());
    }

    private Statement compileAlterColumnType(Table table, ColumnSchema columnSchema) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 4, null, table.getName());
    }

    private Statement compileAlterColumnSequenceOptions(Table table, ColumnSchema columnSchema) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 4, null, table.getName());
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema columnSchema, boolean bl) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 4, null, table.getName());
    }

    private Statement compileAlterColumnSetDefault(Table table, ColumnSchema columnSchema, Expression expression) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 4, null, table.getName());
    }

    private Statement compileAlterColumnDropGenerated(Table table, ColumnSchema columnSchema, int n) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 4, null, table.getName());
    }

    private Statement compileAlterColumnDropDefault(Table table, ColumnSchema columnSchema, int n) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 4, null, table.getName());
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, hsqlName.name, true);
        this.read();
        if (this.token.tokenType == 593) {
            this.read();
            this.readThis(284);
            return this.compileRenameObject(numberSequence.getName(), 7);
        }
        NumberSequence numberSequence2 = numberSequence.duplicate();
        this.readSequenceOptions(numberSequence2, false, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, numberSequence2};
        return new StatementSchema(string, 134, objectArray);
    }

    void processAlterColumnSequenceOptions(ColumnSchema columnSchema) {
        boolean bl;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        NumberSequence numberSequence = columnSchema.getIdentitySequence().duplicate();
        do {
            bl = false;
            block0 : switch (this.token.tokenType) {
                case 484: {
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(318);
                    long l = this.readBigint();
                    numberSequence.setStartValue(l);
                    break;
                }
                case 253: {
                    long l;
                    this.read();
                    switch (this.token.tokenType) {
                        case 417: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(23);
                            l = this.readBigint();
                            numberSequence.setIncrement(l);
                            break block0;
                        }
                        case 179: {
                            this.read();
                            if (this.token.tokenType == 438) {
                                numberSequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 442) {
                                numberSequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 70) {
                                numberSequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 438: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMaxValueNoCheck(l);
                            break block0;
                        }
                        case 442: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l = this.readBigint();
                            numberSequence.setMinValueNoCheck(l);
                            break block0;
                        }
                        case 70: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            numberSequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw super.unexpectedToken();
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        numberSequence.checkValues();
        columnSchema.getIdentitySequence().reset(numberSequence);
    }

    private void processAlterColumnDataType(Table table, ColumnSchema columnSchema) {
        this.processAlterColumnType(table, columnSchema, false);
    }

    private void processAlterColumnType(Table table, ColumnSchema columnSchema, boolean bl) {
        ColumnSchema columnSchema2;
        Object object;
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        if (bl) {
            object = new HsqlArrayList();
            Constraint constraint = table.getPrimaryConstraint();
            if (constraint == null) {
                constraint = new Constraint(null, null, 5);
            }
            ((HsqlArrayList)object).add(constraint);
            columnSchema2 = this.readColumnDefinitionOrNull(table, columnSchema.getName(), (HsqlArrayList)object);
            if (columnSchema2 == null) {
                throw Error.error(5000);
            }
            if (columnSchema.isIdentity() && columnSchema2.isIdentity()) {
                throw Error.error(5525);
            }
            if (((HsqlArrayList)object).size() > 1) {
                throw Error.error(5524);
            }
        } else {
            object = this.readTypeDefinition(true);
            if (columnSchema.isIdentity() && !((Type)object).isIntegralType()) {
                throw Error.error(5561);
            }
            columnSchema2 = columnSchema.duplicate();
            columnSchema2.setType((Type)object);
        }
        object = new TableWorks(this.session, table);
        ((TableWorks)object).retypeColumn(columnSchema, columnSchema2);
    }

    private void processAlterColumnRename(Table table, ColumnSchema columnSchema) {
        this.checkIsSimpleName();
        if (table.findColumn(this.token.tokenString) > -1) {
            throw Error.error(5504, this.token.tokenString);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), columnSchema.getName());
        this.session.commit(false);
        table.renameColumn(columnSchema, this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema columnSchema) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(hsqlName.name) > -1) {
            throw Error.error(5504, hsqlName.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), columnSchema.getName());
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{columnSchema.getName(), hsqlName};
        return new StatementSchema(string, 1082, objectArray);
    }

    Statement compileAlterSchemaRename() {
        HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
        this.checkSchemaUpdateAuthorisation(hsqlName);
        this.readThis(593);
        this.readThis(284);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaName();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        return new StatementSchema(string, 1082, objectArray);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        User user = this.database.getUserManager().get(hsqlName.name);
        if (hsqlName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        this.readThis(253);
        if (this.token.tokenType == 588) {
            this.read();
            String string = this.readPassword();
            Object[] objectArray = new Object[]{user, string};
            return new StatementCommand(1062, objectArray);
        }
        if (this.token.tokenType == 579) {
            this.read();
            this.readThis(497);
            HsqlNameManager.HsqlName hsqlName2 = this.token.tokenType == 77 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
            this.read();
            Object[] objectArray = new Object[]{user, hsqlName2};
            return new StatementCommand(1061, objectArray);
        }
        throw this.unexpectedToken();
    }

    void processAlterDomain() {
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Type type = this.database.schemaManager.getDomain(this.token.tokenString, hsqlName.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 593: {
                this.read();
                this.readThis(284);
                HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(13, true);
                hsqlName2.setSchemaIfNull(hsqlName);
                if (type.getSchemaName() != hsqlName2.schema) {
                    throw Error.error(5505, hsqlName2.schema.name);
                }
                this.checkSchemaUpdateAuthorisation(hsqlName);
                this.database.schemaManager.renameSchemaObject(type.getName(), hsqlName2);
                return;
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    type.userTypeModifier.removeDefaultClause();
                    return;
                }
                if (this.token.tokenType == 47) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName hsqlName3 = this.database.schemaManager.getSchemaObjectName(type.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    this.database.schemaManager.removeSchemaObject(hsqlName3);
                    return;
                }
                throw this.unexpectedToken();
            }
            case 253: {
                this.read();
                this.readThis(77);
                Expression expression = this.readDefaultClause(type);
                type.userTypeModifier.setDefaultClause(expression);
                return;
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 47 && this.token.tokenType != 36) break;
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                this.readConstraint(type, hsqlArrayList);
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                type.userTypeModifier.addConstraint(constraint);
                this.database.schemaManager.addSchemaObject(constraint);
                return;
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        Type type = this.database.schemaManager.getDomain(this.token.tokenString, hsqlName.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 593: {
                this.read();
                this.readThis(284);
                return this.compileRenameObject(type.getName(), 13);
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    return this.compileAlterDomainDropDefault(type);
                }
                if (this.token.tokenType == 47) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.schemaManager.getSchemaObjectName(type.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    return this.compileAlterDomainDropConstraint(type, hsqlName2);
                }
                throw this.unexpectedToken();
            }
            case 253: {
                this.read();
                this.readThis(77);
                Expression expression = this.readDefaultClause(type);
                return this.compileAlterDomainSetDefault(type, expression);
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 47 && this.token.tokenType != 36) break;
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                this.readConstraint(type, hsqlArrayList);
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                return this.compileAlterDomainAddConstraint(type, constraint);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterDomainAddConstraint(Type type, Constraint constraint) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 3, null, null);
    }

    private Statement compileAlterDomainSetDefault(Type type, Expression expression) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 3, null, null);
    }

    private Statement compileAlterDomainDropConstraint(Type type, HsqlNameManager.HsqlName hsqlName) {
        String string = super.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 3, null, null);
    }

    private Statement compileAlterDomainDropDefault(Type type) {
        String string = this.getStatement(this.getParsePosition(), startStatementTokens);
        return new StatementSchema(string, 3, null, null);
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 78: 
            case 99: 
            case 134: 
            case 221: 
            case 250: 
            case 302: 
            case 540: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean bl = this.token.tokenType == 120;
        this.read();
        if (this.isGrantToken() || !bl && (this.token.tokenType == 120 || this.token.tokenType == 411)) {
            return this.compileRightGrantOrRevoke(bl);
        }
        return this.compileRoleGrantOrRevoke(bl);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean bl) {
        Object object;
        int n;
        int n2;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        Grantee grantee = null;
        Right right = null;
        HsqlNameManager.HsqlName hsqlName = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl) {
            if (this.token.tokenType == 120) {
                this.read();
                this.readThis(455);
                this.readThis(111);
                bl6 = true;
            } else if (this.token.tokenType == 411) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 478) {
                this.read();
            }
            right = Right.fullRights;
            bl5 = true;
        } else {
            right = new Right();
            n2 = 1;
            block20: while (n2 != 0) {
                this.checkIsNotQuoted();
                n = GranteeManager.getCheckSingleRight(this.token.tokenString);
                int n3 = this.token.tokenType;
                object = null;
                this.read();
                switch (n3) {
                    case 134: 
                    case 221: 
                    case 250: 
                    case 302: {
                        if (this.token.tokenType == 786) {
                            object = this.readColumnNames(false);
                        }
                    }
                    case 78: 
                    case 290: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(n, (OrderedHashSet)object);
                        bl2 = true;
                        break;
                    }
                    case 540: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl3 = true;
                        n2 = 0;
                        continue block20;
                    }
                    case 99: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl4 = true;
                        n2 = 0;
                        continue block20;
                    }
                }
                if (this.token.tokenType != 774) break;
                this.read();
            }
        }
        this.readThis(193);
        n2 = 0;
        switch (this.token.tokenType) {
            case 561: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                n2 = 16;
                hsqlName = this.readNewSchemaObjectName(16, false);
                break;
            }
            case 258: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 116: 
                    case 214: 
                    case 491: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n2 = 24;
                break;
            }
            case 116: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 16;
                break;
            }
            case 214: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 17;
                break;
            }
            case 491: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 18;
                break;
            }
            case 535: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 12;
                break;
            }
            case 393: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 13;
                break;
            }
            case 505: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n2 = 7;
                break;
            }
            case 34: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(253);
                n2 = 14;
                break;
            }
            default: {
                if (!bl2 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(277);
                n2 = 3;
            }
        }
        hsqlName = this.readNewSchemaObjectName(n2, false);
        if (bl) {
            this.readThis(284);
        } else {
            this.readThis(114);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl) {
            if (this.token.tokenType == 318) {
                this.read();
                this.readThis(120);
                this.readThis(455);
                bl6 = true;
            }
            if (this.token.tokenType == 410) {
                this.read();
                this.readThis(23);
                if (this.token.tokenType == 68) {
                    this.read();
                } else {
                    this.readThis(63);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantee = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 347) {
            bl7 = true;
            this.read();
        } else {
            this.readThis(485);
        }
        n = bl ? 48 : 59;
        Object[] objectArray = new Object[]{orderedHashSet, hsqlName, right, grantee, bl7, bl6};
        object = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema((String)object, n, objectArray);
        return statementSchema;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean bl) {
        Grantee grantee = this.session.getGrantee();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        boolean bl2 = false;
        if (!bl && this.token.tokenType == 335) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl) {
            this.readThis(284);
        } else {
            this.readThis(114);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet2.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 774) break;
            this.read();
        }
        if (bl && this.token.tokenType == 318) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 410) {
            this.read();
            this.readThis(23);
            if (this.token.tokenType == 68) {
                this.read();
            } else {
                this.readThis(63);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantee = this.session.getRole();
            }
        }
        if (!bl) {
            if (this.token.tokenType == 347) {
                bl2 = true;
                this.read();
            } else {
                this.readThis(485);
            }
        }
        int n = bl ? 49 : 129;
        Object[] objectArray = new Object[]{orderedHashSet2, orderedHashSet, grantee, bl2};
        String string = this.getLastPart();
        StatementSchema statementSchema = new StatementSchema(string, n, objectArray);
        return statementSchema;
    }

    void checkSchemaUpdateAuthorisation(HsqlNameManager.HsqlName hsqlName) {
        if (this.session.isProcessingLog) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        if (this.isSchemaDefinition) {
            if (hsqlName != this.session.getCurrentSchemaHsqlName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName.name);
        }
        this.session.checkDDLWrite();
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        HsqlNameManager.HsqlName hsqlName;
        this.readThis(562);
        this.readThis(193);
        switch (this.token.tokenType) {
            case 277: 
            case 491: {
                int n = this.token.tokenType == 491 ? 18 : 3;
                this.read();
                this.checkIsSchemaObjectName();
                hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, n);
                hsqlName.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
                this.read();
                break;
            }
            case 42: {
                this.read();
                this.checkIsSchemaObjectName();
                hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, 9);
                if (this.token.namePrefix == null) {
                    throw Error.error(5501);
                }
                hsqlName.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
                hsqlName.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 3);
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(141);
        String string = this.readQuotedString();
        Object[] objectArray = new Object[]{hsqlName, string};
        return new StatementSchema(null, 1072, objectArray);
    }
}

