/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.ScaledRAInterface;

final class ScaledRAFileNIO
implements ScaledRAInterface {
    private final Database database;
    private final boolean readOnly;
    private final long bufferLength;
    private RandomAccessFile file;
    private MappedByteBuffer buffer;
    private FileChannel channel;
    private boolean bufferModified;
    private static final String JVM_ERROR = "JVM threw unsupported Exception";

    ScaledRAFileNIO(Database database, String string, boolean bl, int n) throws Throwable {
        block17: {
            long l;
            this.database = database;
            if (n < 262144) {
                n = 262144;
            }
            this.file = new RandomAccessFile(string, bl ? "r" : "rw");
            try {
                l = this.file.length();
            }
            catch (Throwable throwable) {
                this.file.close();
                throw throwable;
            }
            if (l > 0x10000000L) {
                this.file.close();
                throw new IOException("length exceeds nio limit");
            }
            if ((long)n < l) {
                n = (int)l;
            }
            n = ScaledRAFileNIO.newNIOBufferSize(n);
            if (bl) {
                n = (int)l;
            }
            if (l < (long)n) {
                try {
                    this.file.seek(n - 1);
                    this.file.writeByte(0);
                    this.file.getFD().sync();
                    this.file.close();
                    this.file = new RandomAccessFile(string, bl ? "r" : "rw");
                }
                catch (Throwable throwable) {
                    this.file.close();
                    throw throwable;
                }
            }
            this.readOnly = bl;
            this.bufferLength = n;
            this.channel = this.file.getChannel();
            try {
                this.buffer = this.channel.map(bl ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, n);
                Error.printSystemOut("NIO file instance created. mode: " + bl);
                if (bl) break block17;
                long l2 = (long)n - l;
                if (l2 > 262144L) {
                    l2 = 262144L;
                }
                byte[] byArray = new byte[(int)l2];
                try {
                    long l3;
                    for (l3 = l; l3 < (long)n - l2; l3 += l2) {
                        this.buffer.position((int)l3);
                        this.buffer.put(byArray, 0, byArray.length);
                    }
                    this.buffer.position((int)l3);
                    this.buffer.put(byArray, 0, (int)((long)n - l3));
                    this.buffer.force();
                }
                catch (Throwable throwable) {
                    database.logger.logWarningEvent("JVM threw unsupported Exception length: " + n, throwable);
                }
                this.buffer.position(0);
            }
            catch (Throwable throwable) {
                Error.printSystemOut("NIO constructor failed:  " + n);
                this.buffer = null;
                this.channel = null;
                this.file.close();
                throw throwable;
            }
        }
    }

    @Override
    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            this.database.logger.logWarningEvent("nio", iOException);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void seek(long l) throws IOException {
        try {
            this.buffer.position((int)l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.database.logger.logWarningEvent("nio", illegalArgumentException);
            IOException iOException = new IOException(illegalArgumentException.getMessage());
            try {
                iOException.initCause(illegalArgumentException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw iOException;
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        try {
            return this.buffer.position();
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.buffer.get(byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.put(byArray, n, n2);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void writeInt(int n) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putInt(n);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void writeLong(long l) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putLong(l);
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent(JVM_ERROR, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            Error.printSystemOut("NIO close() start - fileLength = " + this.bufferLength);
            if (this.buffer != null && this.bufferModified) {
                try {
                    this.buffer.force();
                }
                catch (Throwable throwable) {
                    try {
                        this.buffer.force();
                    }
                    catch (Throwable throwable2) {
                        this.database.logger.logWarningEvent("JVM threw unsupported Exception length: " + this.bufferLength, throwable);
                    }
                }
            }
            this.buffer = null;
            this.channel = null;
            this.file.close();
        }
        catch (Throwable throwable) {
            this.database.logger.logWarningEvent("length: " + this.bufferLength, throwable);
            IOException iOException = new IOException(throwable.getMessage());
            try {
                iOException.initCause(throwable);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            throw iOException;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean wasNio() {
        return true;
    }

    @Override
    public boolean canAccess(int n) {
        return (long)(this.buffer.position() + n) <= this.bufferLength;
    }

    @Override
    public boolean canSeek(long l) {
        return l <= this.bufferLength;
    }

    @Override
    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.buffer.force();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static int newNIOBufferSize(int n) {
        int n2 = 0;
        for (int i = 20; i < 30 && (n2 = 1 << i) < n; ++i) {
        }
        return n2;
    }
}

