/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

class LADT {
    private Map agents;

    public LADT(int size) {
        this.agents = new HashMap(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent put(AID aid, Agent a) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(aid);
        }
        if (r == null) {
            this.agents.put(aid, new Row(a));
            return null;
        }
        r.lock();
        Agent old = r.get();
        if (a != old) {
            this.agents.put(aid, new Row(a));
        }
        r.unlock();
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent remove(AID key) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(key);
        }
        if (r == null) {
            return null;
        }
        r.lock();
        this.agents.remove(key);
        Agent a = r.get();
        r.clear();
        r.unlock();
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent acquire(AID key) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(key);
        }
        if (r == null) {
            return null;
        }
        r.lock();
        return r.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(AID key) {
        Row r;
        Map map = this.agents;
        synchronized (map) {
            r = (Row)this.agents.get(key);
        }
        if (r != null) {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AID[] keys() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objs = this.agents.keySet().toArray();
            AID[] result = new AID[objs.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (AID)objs[i];
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent[] values() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objs = this.agents.values().toArray();
            Agent[] result = new Agent[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                Row r = (Row)objs[i];
                result[i] = r.get();
            }
            return result;
        }
    }

    synchronized boolean contains(AID key) {
        return this.agents.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStatus() {
        Map map = this.agents;
        synchronized (map) {
            Object[] objs = this.agents.values().toArray();
            String[] status = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                Row r = (Row)objs[i];
                status[i] = r.toString();
            }
            return status;
        }
    }

    private static class Row {
        private Agent value;
        private Thread owner;
        private long depth;

        public Row(Agent a) {
            this.value = a;
            this.depth = 0L;
        }

        public synchronized Agent get() {
            return this.value;
        }

        public synchronized void clear() {
            this.value = null;
        }

        public synchronized void lock() {
            if (this.value != null) {
                try {
                    Thread me = Thread.currentThread();
                    while (this.owner != null && this.owner != me) {
                        this.wait();
                        if (this.value != null) continue;
                        return;
                    }
                    this.owner = me;
                    ++this.depth;
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }

        public synchronized void unlock() {
            if (this.owner != Thread.currentThread()) {
                return;
            }
            --this.depth;
            if (this.depth == 0L || this.value == null) {
                this.owner = null;
                this.notifyAll();
            }
        }

        public String toString() {
            if (this.value != null) {
                return "(" + this.value.getName() + " :owner " + (this.owner != null ? this.owner.toString() : "null") + ")";
            }
            return "null";
        }
    }
}

