/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CommandProcessor;
import jade.core.IMTPManager;
import jade.core.MainContainerImpl;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public abstract class Profile {
    public static final String MAIN = "main";
    public static final String MAIN_PROTO = "proto";
    public static final String MAIN_HOST = "host";
    public static final String MAIN_PORT = "port";
    public static final String DETECT_MAIN = "detect-main";
    public static final String LOCAL_HOST = "local-host";
    public static final String LOCAL_PORT = "local-port";
    public static final String GUI = "gui";
    public static final String LOCAL_SERVICE_MANAGER = "backupmain";
    public static final String DUMP_OPTIONS = "dump-options";
    public static final String NO_DISPLAY = "no-display";
    public static final String OWNER = "owner";
    public static final String DEFAULT_SERVICES = "jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService";
    public static final String DEFAULT_SERVICES_NOMOBILITY = "jade.core.event.NotificationService";
    public static final String PLATFORM_ID = "platform-id";
    public static final String USERAUTH_KEY = "userauth-key";
    public static final String AGENTS = "agents";
    public static final String SERVICES = "services";
    public static final String REMOTE_SERVICE_MANAGER_ADDRESSES = "smaddrs";
    public static final String MTPS = "mtps";
    public static final String NO_MTP = "nomtp";
    public static final String IMTP = "imtp";
    public static final String CONTAINER_NAME = "container-name";
    public static final String ACLCODECS = "aclcodecs";
    public static final String ACCEPT_FOREIGN_AGENTS = "accept-foreign-agents";
    public static final String STYLE_3_X = "style3-x";
    public static final String FILE_DIR = "file-dir";
    public static final int DEFAULT_PORT = 1099;
    public static final String LOCALHOST_CONSTANT = "localhost";
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String LEAP_IMTP = "LEAP";
    public static final String RMI_IMTP = "RMI";
    public static final String JVM = "jvm";
    public static final String J2SE = "j2se";
    public static final String PJAVA = "pjava";
    public static final String MIDP = "midp";

    protected abstract ServiceManager getServiceManager() throws ProfileException;

    protected abstract ServiceFinder getServiceFinder() throws ProfileException;

    protected abstract CommandProcessor getCommandProcessor() throws ProfileException;

    protected abstract MainContainerImpl getMain() throws ProfileException;

    protected abstract IMTPManager getIMTPManager() throws ProfileException;

    public abstract ResourceManager getResourceManager() throws ProfileException;

    public abstract Properties getBootProperties();

    public abstract String getParameter(String var1, String var2);

    public abstract boolean getBooleanProperty(String var1, boolean var2);

    public abstract List getSpecifiers(String var1) throws ProfileException;

    public abstract void setParameter(String var1, String var2);

    public abstract void setSpecifiers(String var1, List var2);

    public static String getDefaultNetworkName() {
        String host = LOCALHOST_CONSTANT;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
            if (LOOPBACK_ADDRESS.equals(host)) {
                host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host;
    }

    public static boolean isLocalHost(String host) {
        if (LOCALHOST_CONSTANT.equalsIgnoreCase(host)) {
            return true;
        }
        try {
            InetAddress localHostAddr = InetAddress.getByName(host);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface nextIface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = nextIface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!ip.equals(localHostAddr)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean compareHostNames(String host1, String host2) {
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        try {
            if (host1.equalsIgnoreCase(LOCALHOST_CONSTANT)) {
                return Profile.isLocalHost(host2);
            }
            if (host2 != null && host2.equalsIgnoreCase(LOCALHOST_CONSTANT)) {
                return Profile.isLocalHost(host2);
            }
            InetAddress[] host1Addrs = InetAddress.getAllByName(host1);
            InetAddress[] host2Addrs = InetAddress.getAllByName(host2);
            boolean isEqual = false;
            for (int i = 0; !isEqual && i < host1Addrs.length; ++i) {
                for (int j = 0; !isEqual && j < host2Addrs.length; ++j) {
                    isEqual = host1Addrs[i].equals(host2Addrs[j]);
                }
            }
            return isEqual;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }
}

