/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.BackEnd;
import jade.core.FEConnectionManager;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.Specifier;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndStub;
import jade.imtp.leap.ConnectionListener;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndSkel;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPProtocol;
import jade.imtp.leap.MicroSkeleton;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Vector;

public class FrontEndDispatcher
implements FEConnectionManager,
Dispatcher,
TimerListener,
Runnable {
    private static final int RESPONSE_TIMEOUT = 30000;
    private MicroSkeleton mySkel = null;
    private BackEndStub myStub = null;
    protected String myMediatorClass = "jade.imtp.leap.nio.BackEndDispatcher";
    private Properties myProperties;
    private String[] backEndAddresses;
    private TransportAddress mediatorTA;
    private String myMediatorID;
    private long retryTime = 10000L;
    private long maxDisconnectionTime = 600000L;
    private long keepAliveTime = -1L;
    private long connectionDropDownTime = -1L;
    private Timer kaTimer;
    private Timer cdTimer;
    private IncomingCommandServer myCommandServer;
    private ConnectionReader myConnectionReader;
    private Connection myConnection = null;
    public boolean refreshingConnection = false;
    private Object connectionLock = new Object();
    private Object responseLock = new Object();
    private ConnectionListener myConnectionListener;
    private boolean active = true;
    private boolean connectionDropped = false;
    private boolean waitingForFlush = false;
    private byte lastSid = (byte)15;
    private int outCnt = 0;
    private JICPPacket lastOutgoingResponse = null;
    private Thread terminator;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private int cnt = 0;

    public BackEnd getBackEnd(FrontEnd fe, Properties props) throws IMTPException {
        this.myProperties = props;
        this.myMediatorID = this.myProperties.getProperty("mediator-id");
        try {
            String tmp = props.getProperty("beaddrs");
            this.backEndAddresses = this.parseBackEndAddresses(tmp);
            String host = props.getProperty("host");
            if (host == null) {
                host = "localhost";
            }
            int port = 1099;
            try {
                port = Integer.parseInt(props.getProperty("port"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.mediatorTA = JICPProtocol.getInstance().buildAddress(host, String.valueOf(port), null, null);
            this.mediatorTA = JICPProtocol.getInstance().buildAddress(host, String.valueOf(port), null, null);
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Remote URL=" + JICPProtocol.getInstance().addrToString(this.mediatorTA));
            }
            if ((tmp = props.getProperty("mediator-class")) != null) {
                this.myMediatorClass = tmp;
            } else {
                props.setProperty("mediator-class", this.myMediatorClass);
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Mediator class=" + this.myMediatorClass);
            }
            tmp = props.getProperty("reconnection-retry-time");
            try {
                this.retryTime = Long.parseLong(tmp);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Reconnection time=" + this.retryTime);
            }
            tmp = props.getProperty("max-disconnection-time");
            try {
                this.maxDisconnectionTime = Long.parseLong(tmp);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Max discon. time=" + this.maxDisconnectionTime);
            }
            tmp = props.getProperty("keep-alive-time");
            try {
                this.keepAliveTime = Long.parseLong(tmp);
            }
            catch (Exception e) {
                props.setProperty("keep-alive-time", String.valueOf(this.keepAliveTime));
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Keep-alive time=" + this.keepAliveTime);
            }
            tmp = props.getProperty("drop-down-time");
            try {
                this.connectionDropDownTime = Long.parseLong(tmp);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Connection-drop-down time=" + this.connectionDropDownTime);
            }
            try {
                Object obj = props.get("connection-listener");
                this.myConnectionListener = obj instanceof ConnectionListener ? (ConnectionListener)obj : (ConnectionListener)Class.forName(obj.toString()).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.mySkel = new FrontEndSkel(fe);
            this.myStub = new BackEndStub(this);
            JICPConnection c = this.createBackEnd();
            this.active = true;
            this.startConnectionReader(c);
            return this.myStub;
        }
        catch (ICPException icpe) {
            throw new IMTPException("Connection error", icpe);
        }
    }

    private JICPConnection createBackEnd() throws IMTPException {
        StringBuffer sb = BackEndStub.encodeCreateMediatorRequest(this.myProperties);
        if (this.myMediatorID != null) {
            BackEndStub.appendProp(sb, "mediator-id", this.myMediatorID);
            BackEndStub.appendProp(sb, "outcnt", String.valueOf(this.outCnt));
            BackEndStub.appendProp(sb, "lastsid", String.valueOf(this.lastSid));
        }
        JICPPacket pkt = new JICPPacket(22, 0, null, sb.toString().getBytes());
        for (int i = -1; i < this.backEndAddresses.length; ++i) {
            if (i >= 0) {
                String addr = this.backEndAddresses[i];
                int colonPos = addr.indexOf(58);
                String host = addr.substring(0, colonPos);
                String port = addr.substring(colonPos + 1, addr.length());
                this.mediatorTA = new JICPAddress(host, port, this.myMediatorID, "");
            }
            try {
                this.myLogger.log(Logger.INFO, "Creating BackEnd on jicp://" + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort());
                JICPConnection con = this.openConnection(this.mediatorTA);
                this.writePacket(pkt, con);
                pkt = con.readPacket();
                String replyMsg = new String(pkt.getData());
                if (pkt.getType() != 100) {
                    BackEndStub.parseCreateMediatorResponse(replyMsg, this.myProperties);
                    this.myMediatorID = this.myProperties.getProperty("mediator-id");
                    this.mediatorTA = new JICPAddress(this.mediatorTA.getHost(), this.mediatorTA.getPort(), this.myMediatorID, null);
                    this.myLogger.log(Logger.INFO, "BackEnd OK: mediator-id = " + this.myMediatorID);
                    return con;
                }
                this.myLogger.log(Logger.WARNING, "Mediator error: " + replyMsg);
                if (this.myConnectionListener == null || replyMsg == null || !replyMsg.startsWith("Not-authorized")) continue;
                this.myConnectionListener.handleConnectionEvent(7, replyMsg);
                continue;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connection error. " + ioe.toString());
            }
        }
        throw new IMTPException("Error creating the BackEnd.");
    }

    private String[] parseBackEndAddresses(String addressesText) {
        Vector addrs = Specifier.parseList(addressesText, ';');
        String[] result = new String[addrs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)addrs.elementAt(i);
        }
        return result;
    }

    public synchronized void shutdown() {
        if (this.active) {
            this.active = false;
            this.terminator = Thread.currentThread();
            if (this.terminator != this.myCommandServer) {
                JICPPacket terminationPacket = null;
                try {
                    if (this.connectionDropped) {
                        this.myConnection = this.openConnection(this.mediatorTA);
                        terminationPacket = new JICPPacket(23, 64, this.mediatorTA.getFile(), null);
                    } else {
                        terminationPacket = new JICPPacket(0, 64, null);
                    }
                    if (this.myConnection != null) {
                        this.myLogger.log(Logger.INFO, "Sending termination notification");
                        this.writePacket(terminationPacket, this.myConnection);
                        this.myConnection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        if (this.connectionDropped) {
            this.myLogger.log(Logger.INFO, "Dispatching with connection dropped. Reconnecting...");
            this.undrop();
            throw new ICPException("Connection dropped");
        }
        if (this.myConnection != null) {
            if (this.waitingForFlush && !flush) {
                throw new ICPException("Upsetting dispatching order");
            }
            this.waitingForFlush = false;
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Issuing outgoing command " + this.outCnt);
            }
            JICPPacket pkt = new JICPPacket(0, 0, payload);
            pkt.setSessionID((byte)this.outCnt);
            try {
                this.lastOutgoingResponse = null;
                System.out.println("Sending command to BE " + pkt.getSessionID());
                this.writePacket(pkt, this.myConnection);
                System.out.println("Waiting for response from BE " + pkt.getSessionID());
                JICPPacket response = this.waitForResponse(this.outCnt, 30000L);
                if (response != null) {
                    System.out.println("Response received from BE " + response.getSessionID());
                    if (this.myLogger.isLoggable(Logger.FINER)) {
                        this.myLogger.log(Logger.FINER, "Response received " + response.getSessionID());
                    }
                    if (response.getType() == 100) {
                        throw new ICPException(new String(response.getData()));
                    }
                    this.outCnt = this.outCnt + 1 & 0xF;
                    return response.getData();
                }
                this.myLogger.log(Logger.WARNING, "Response timeout expired " + pkt.getSessionID());
                this.handleDisconnection();
                throw new ICPException("Response timeout expired");
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, ioe.toString());
                this.handleDisconnection();
                throw new ICPException("Dispatching error.", ioe);
            }
        }
        throw new ICPException("Unreachable");
    }

    private void startConnectionReader(Connection c) {
        this.myConnection = c;
        this.refreshingConnection = false;
        this.myConnectionReader = new ConnectionReader(this.myConnection);
        this.myConnectionReader.start();
    }

    private JICPPacket handleIncomingCommand(JICPPacket cmd) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Incoming command received " + cmd.getSessionID());
        }
        byte[] rspData = this.mySkel.handleCommand(cmd.getData());
        if (this.myLogger.isLoggable(Logger.FINER)) {
            this.myLogger.log(Logger.FINER, "Incoming command served " + cmd.getSessionID());
        }
        return new JICPPacket(1, 0, rspData);
    }

    private JICPPacket handleIncomingKeepAlive(JICPPacket ka) {
        return new JICPPacket(1, 0, null);
    }

    private JICPConnection openConnection(TransportAddress ta) throws IOException {
        if (this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(1, null);
        }
        JICPConnection c = this.getConnection(ta);
        return c;
    }

    protected JICPConnection getConnection(TransportAddress ta) throws IOException {
        return new JICPConnection(ta);
    }

    private synchronized void writePacket(JICPPacket pkt, Connection c) throws IOException {
        c.writePacket(pkt);
        if (Thread.currentThread() == this.terminator) {
            this.myConnection.close();
        } else {
            this.updateKeepAlive();
            if (pkt.getType() != 2 && pkt.getType() != 30) {
                this.updateConnectionDropDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JICPPacket waitForResponse(int sessionID, long timeout) {
        Object object = this.responseLock;
        synchronized (object) {
            try {
                while (this.lastOutgoingResponse == null) {
                    this.responseLock.wait(timeout);
                    if (this.lastOutgoingResponse != null && sessionID != -1 && this.lastOutgoingResponse.getSessionID() != sessionID) {
                        this.myLogger.log(Logger.WARNING, "Wrong sessionID in response from BE: type=" + this.lastOutgoingResponse.getType() + " info=" + this.lastOutgoingResponse.getInfo() + " SID=" + this.lastOutgoingResponse.getSessionID() + " while " + sessionID + " was expected.");
                        this.lastOutgoingResponse = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.lastOutgoingResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOutgoingResponseReceived(JICPPacket rsp) {
        Object object = this.responseLock;
        synchronized (object) {
            this.lastOutgoingResponse = rsp;
            this.responseLock.notifyAll();
        }
    }

    public void run() {
        int cnt = 0;
        long startTime = System.currentTimeMillis();
        boolean backEndExists = true;
        while (this.active) {
            try {
                JICPConnection c;
                if (backEndExists) {
                    this.myLogger.log(Logger.INFO, "Connecting to " + this.mediatorTA.getHost() + ":" + this.mediatorTA.getPort() + " " + cnt);
                    c = this.openConnection(this.mediatorTA);
                    JICPPacket pkt = new JICPPacket(23, 0, this.mediatorTA.getFile(), null);
                    this.writePacket(pkt, c);
                    pkt = ((Connection)c).readPacket();
                    if (pkt.getType() == 100) {
                        String errorMsg = new String(pkt.getData());
                        ((Connection)c).close();
                        if (errorMsg.equals("Not-found")) {
                            this.handleBENotFound();
                            backEndExists = false;
                            continue;
                        }
                        this.handleReconnectionError("JICP Error. " + errorMsg);
                        return;
                    }
                    this.myProperties.setProperty("local-host", new String(pkt.getData()));
                    this.myLogger.log(Logger.INFO, "Connect OK");
                    this.handleReconnection(c);
                    return;
                }
                c = this.createBackEnd();
                this.handleReconnection(c);
                return;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Connect failed. " + ioe);
            }
            catch (IMTPException imtpe) {
                this.myLogger.log(Logger.WARNING, "BE recreation failed.");
            }
            if (System.currentTimeMillis() - startTime > this.maxDisconnectionTime) {
                this.handleReconnectionError("Max disconnection time expired (" + System.currentTimeMillis() + ")");
                return;
            }
            ++cnt;
            this.waitABit(this.retryTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            if (!this.refreshingConnection) {
                this.refreshingConnection = true;
                if (this.myConnection != null) {
                    try {
                        this.myConnection.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.myConnection = null;
                    if (this.myConnectionListener != null) {
                        this.myConnectionListener.handleConnectionEvent(2, null);
                    }
                }
                Thread t = new Thread(this);
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReconnection(Connection c) {
        Object object = this.connectionLock;
        synchronized (object) {
            this.startConnectionReader(c);
            this.waitingForFlush = this.myStub.flush();
            if (this.myConnectionListener != null) {
                this.myConnectionListener.handleConnectionEvent(3, null);
            }
        }
    }

    private void handleReconnectionError(String msg) {
        this.myLogger.log(Logger.SEVERE, "Can't reconnect: " + msg);
        if (this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(5, null);
        }
        this.active = false;
    }

    private void handleBENotFound() {
        if (this.myConnectionListener != null) {
            this.myConnectionListener.handleConnectionEvent(6, null);
        }
    }

    private void waitABit(long period) {
        try {
            Thread.sleep(period);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void updateKeepAlive() {
        if (this.keepAliveTime > 0L) {
            TimerDispatcher td = TimerDispatcher.getTimerDispatcher();
            if (this.kaTimer != null) {
                td.remove(this.kaTimer);
            }
            this.kaTimer = td.add(new Timer(System.currentTimeMillis() + this.keepAliveTime, this));
        }
    }

    private synchronized void updateConnectionDropDown() {
        if (this.connectionDropDownTime > 0L) {
            TimerDispatcher td = TimerDispatcher.getTimerDispatcher();
            if (this.cdTimer != null) {
                td.remove(this.cdTimer);
            }
            this.cdTimer = td.add(new Timer(System.currentTimeMillis() + this.connectionDropDownTime, this));
        }
    }

    public synchronized void doTimeOut(Timer t) {
        if (t == this.kaTimer) {
            this.sendKeepAlive();
        } else if (t == this.cdTimer) {
            this.dropDownConnection();
        }
    }

    protected void sendKeepAlive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDownConnection() {
        block10: {
            if (this.myConnection != null && !this.connectionDropped) {
                this.myLogger.log(Logger.INFO, "Writing DROP_DOWN request");
                JICPPacket pkt = this.prepareDropDownRequest();
                try {
                    this.writePacket(pkt, this.myConnection);
                    JICPPacket rsp = this.waitForResponse(-1, 30000L);
                    this.myLogger.log(Logger.INFO, "DROP_DOWN response received");
                    if (rsp.getType() != 100) {
                        Object object = this.connectionLock;
                        synchronized (object) {
                            try {
                                this.myConnection.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.myConnection = null;
                            this.connectionDropped = true;
                            if (this.myConnectionListener != null) {
                                this.myConnectionListener.handleConnectionEvent(4, null);
                            }
                            this.myLogger.log(Logger.INFO, "Connection dropped");
                            break block10;
                        }
                    }
                    this.myLogger.log(Logger.INFO, "DROP_DOWN refused");
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Exception sending DROP_DOWN request. " + e);
                    this.handleDisconnection();
                }
            }
        }
    }

    protected JICPPacket prepareDropDownRequest() {
        return new JICPPacket(30, 0, null);
    }

    protected void undrop() {
        this.connectionDropped = false;
        this.handleDisconnection();
    }

    private void serveCommand(JICPPacket command) {
        if (this.myCommandServer == null) {
            this.myCommandServer = new IncomingCommandServer();
            this.myCommandServer.start();
        }
        this.myCommandServer.serve(command);
    }

    private class IncomingCommandServer
    extends Thread {
        private JICPPacket currentCommand = null;
        private JICPPacket lastResponse = null;

        public IncomingCommandServer() {
            this.setName("CommandServer");
        }

        public synchronized void serve(JICPPacket command) {
            try {
                while (this.currentCommand != null) {
                    this.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentCommand = command;
            this.notifyAll();
        }

        public void run() {
            while (FrontEndDispatcher.this.active) {
                this.acquireCurrentCommand();
                byte sid = this.currentCommand.getSessionID();
                if (sid == FrontEndDispatcher.this.lastSid) {
                    FrontEndDispatcher.this.myLogger.log(Logger.WARNING, "Duplicated command from BE: info=" + this.currentCommand.getInfo() + " SID=" + sid);
                } else {
                    System.out.println("Serving command. " + this.currentCommand.getSessionID());
                    this.lastResponse = FrontEndDispatcher.this.handleIncomingCommand(this.currentCommand);
                    if (Thread.currentThread() == FrontEndDispatcher.this.terminator) {
                        this.lastResponse.setTerminatedInfo(true);
                    }
                    this.lastResponse.setSessionID(sid);
                    FrontEndDispatcher.this.lastSid = sid;
                }
                System.out.println("COMMAND served. " + this.currentCommand.getSessionID());
                try {
                    FrontEndDispatcher.this.writePacket(this.lastResponse, FrontEndDispatcher.this.myConnection);
                }
                catch (Exception e) {
                    FrontEndDispatcher.this.myLogger.log(Logger.WARNING, "Communication error sending back response. " + e);
                }
                this.releaseCurrentCommand();
            }
        }

        private synchronized void acquireCurrentCommand() {
            try {
                while (this.currentCommand == null) {
                    this.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private synchronized void releaseCurrentCommand() {
            this.currentCommand = null;
            this.notifyAll();
        }
    }

    private class ConnectionReader
    extends Thread {
        private int myId;
        private Connection myConnection = null;

        public ConnectionReader(Connection c) {
            this.myConnection = c;
            this.setName("ConnectionReader-" + this.myId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.myId = FrontEndDispatcher.this.cnt++;
            FrontEndDispatcher.this.myLogger.log(Logger.INFO, "CR-" + this.myId + " started");
            try {
                while (this.isConnected()) {
                    JICPPacket pkt = this.myConnection.readPacket();
                    if ((pkt = this.handleIncomingPacket(pkt)) == null) continue;
                    FrontEndDispatcher.this.writePacket(pkt, this.myConnection);
                }
            }
            catch (IOException ioe) {
                Object object = FrontEndDispatcher.this.connectionLock;
                synchronized (object) {
                    if (FrontEndDispatcher.this.active && !FrontEndDispatcher.this.connectionDropped) {
                        FrontEndDispatcher.this.myLogger.log(Logger.WARNING, "CR Exception " + ioe);
                        if (this == FrontEndDispatcher.this.myConnectionReader) {
                            FrontEndDispatcher.this.handleDisconnection();
                        }
                    }
                }
            }
            FrontEndDispatcher.this.myLogger.log(Logger.INFO, "CR-" + this.myId + " terminated");
        }

        private JICPPacket handleIncomingPacket(JICPPacket pkt) {
            switch (pkt.getType()) {
                case 0: {
                    System.out.println("COMMAND received from BE. " + pkt.getSessionID());
                    FrontEndDispatcher.this.serveCommand(pkt);
                    break;
                }
                case 2: {
                    return FrontEndDispatcher.this.handleIncomingKeepAlive(pkt);
                }
                case 1: 
                case 100: {
                    System.out.println("RESPONSE/ERROR received from BE. " + pkt.getSessionID());
                    FrontEndDispatcher.this.notifyOutgoingResponseReceived(pkt);
                    break;
                }
                default: {
                    FrontEndDispatcher.this.myLogger.log(Logger.WARNING, "Unexpected incoming packet type: " + pkt.getType());
                }
            }
            return null;
        }

        private final boolean isConnected() {
            return this.myConnection != null;
        }
    }
}

