/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.SSLHelper;
import jade.imtp.leap.nio.BufferTransformer;
import jade.imtp.leap.nio.NIOHelper;
import jade.imtp.leap.nio.NIOJICPConnection;
import jade.imtp.leap.nio.PacketIncompleteException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class SSLEngineHelper
implements BufferTransformer {
    public static final ByteBuffer EMPTY_BUFFER = NIOHelper.EMPTY_BUFFER;
    public static final int INCREASE_SIZE = 5120;
    private SSLEngine ssle = null;
    private ByteBuffer wrapData;
    private ByteBuffer unwrapData;
    private ByteBuffer sendData;
    private NIOJICPConnection connection = null;
    private static Logger log = Logger.getLogger(SSLEngineHelper.class.getName());

    public SSLEngineHelper(String host, int port, NIOJICPConnection connection) throws ICPException {
        SSLContext context = SSLHelper.createContext();
        this.ssle = context.createSSLEngine(host, port);
        this.ssle.setUseClientMode(false);
        this.ssle.setNeedClientAuth(SSLHelper.needAuth());
        if (!SSLHelper.needAuth()) {
            this.ssle.setEnabledCipherSuites(SSLHelper.getSupportedKeys());
        }
        SSLSession session = this.ssle.getSession();
        this.unwrapData = ByteBuffer.allocateDirect(session.getApplicationBufferSize() + 1500);
        this.wrapData = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.sendData = ByteBuffer.allocateDirect(this.wrapData.capacity());
        this.connection = connection;
    }

    private SSLEngineResult encode(ByteBuffer source) throws SSLException {
        return this.ssle.wrap(source, this.wrapData);
    }

    private SSLEngineResult.HandshakeStatus runHandshakeTasks() {
        Runnable task = null;
        while ((task = this.ssle.getDelegatedTask()) != null) {
            task.run();
        }
        return this.ssle.getHandshakeStatus();
    }

    public void close() throws IOException {
        this.ssle.closeOutbound();
        this.sendSSLClose();
        this.ssle.closeInbound();
    }

    private void sendSSLClose() {
        try {
            while (!this.ssle.isOutboundDone()) {
                this.wrapAndSend();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, "unable to send ssl close packet", e);
        }
    }

    private final int writeToChannel(ByteBuffer b) throws IOException {
        int m = b.remaining();
        int n = this.connection.writeToChannel(b);
        if (n != m) {
            throw new IOException("should write " + m + ", written " + n);
        }
        return n;
    }

    private String getRemoteHost() {
        return this.connection.getRemoteHost();
    }

    private SSLEngineResult unwrapData(ByteBuffer socketData) throws SSLException {
        SSLEngineResult result = null;
        do {
            try {
                result = this.ssle.unwrap(socketData, this.unwrapData);
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Decoded " + result.bytesConsumed() + " bytes; Produced " + result.bytesProduced() + " application-data bytes [" + this.getRemoteHost() + "]");
            }
            catch (SSLException e) {
                log.log(Level.WARNING, "Unwrap failure [" + this.getRemoteHost() + "]", e);
                try {
                    this.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw e;
            }
        } while (result.getStatus().equals((Object)SSLEngineResult.Status.OK) && result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return result;
    }

    private void checkStatusAfterHandshakeTasks(SSLEngineResult.HandshakeStatus handshakeStatus) throws SSLException, IOException {
        if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
            log.warning("Unexpected FINISHED SSL handshake status after execution of handshake tasks [" + this.getRemoteHost() + "]");
        } else if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)) {
            log.warning("Unexpected NEED_TASK SSL handshake status after execution of handshake tasks [" + this.getRemoteHost() + "]");
        } else if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Need more data to proceed with Handshake [" + this.getRemoteHost() + "]");
            }
        } else if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Send back Handshake data after task execution [" + this.getRemoteHost() + "]");
            }
            this.wrapAndSend();
        } else if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
            log.warning("Unexpected NOT_HANDSHAKING SSL handshake status after execution of handshake tasks [" + this.getRemoteHost() + "]");
        }
    }

    private synchronized int decrypt(ByteBuffer socketData) throws SSLException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Decrypt incoming data: remaining = " + socketData.remaining() + ", position = " + socketData.position() + ", limit = " + socketData.limit() + " [" + this.getRemoteHost() + "]");
        }
        SSLEngineResult result = this.unwrapData(socketData);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Checking handshake result [" + this.getRemoteHost() + "]");
        }
        int n = 0;
        SSLEngineResult.Status status = result.getStatus();
        SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
        if (status.equals((Object)SSLEngineResult.Status.OK)) {
            if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Handshake finished [" + this.getRemoteHost() + "]");
                }
            } else if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Activate Handshake task [" + this.getRemoteHost() + "]");
                }
                handshakeStatus = this.runHandshakeTasks();
                this.checkStatusAfterHandshakeTasks(handshakeStatus);
            } else {
                if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)) {
                    throw new SSLException("Unexpected NEED_UNWRAP SSL handshake status! [" + this.getRemoteHost() + "]");
                }
                if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Send back Handshake data [" + this.getRemoteHost() + "]");
                    }
                    this.wrapAndSend();
                } else if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
                    n = result.bytesProduced();
                }
            }
        } else if (status.equals((Object)SSLEngineResult.Status.CLOSED)) {
            log.info(" sslengine closed [" + this.getRemoteHost() + "]");
            this.close();
        } else {
            if (status.equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Not enough data to decode a meaningful SSL block. " + socketData.remaining() + " unprocessed bytes. [" + this.getRemoteHost() + "]");
                }
                return n;
            }
            if (status.equals((Object)SSLEngineResult.Status.BUFFER_OVERFLOW)) {
                if (log.isLoggable(Level.FINE)) {
                    NIOHelper.logBuffer(socketData, "socketData");
                    NIOHelper.logBuffer(this.unwrapData, "overflow unwrapData");
                    log.fine("enlarging unwrap buffer with5120");
                }
                log.info("Buffer overflow. Enlarge buffer and retry [" + this.getRemoteHost() + "]");
                this.unwrapData.flip();
                this.unwrapData = NIOHelper.enlargeAndFillBuffer(this.unwrapData, 5120);
                return this.decrypt(socketData);
            }
        }
        if (socketData.hasRemaining()) {
            n += this.decrypt(socketData);
        }
        return n;
    }

    private int wrapAndSend() throws SSLException, IOException {
        this.wrapData.clear();
        int n = 0;
        SSLEngineResult result = this.encode(EMPTY_BUFFER);
        if (log.isLoggable(Level.FINE)) {
            log.fine("wrapped " + result);
        }
        if (result.bytesProduced() > 0) {
            this.wrapData.flip();
            n = this.writeToChannel(this.wrapData);
            if (result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)) {
                n += this.wrapAndSend();
            }
            return n;
        }
        log.warning("wrap produced no data " + this.getRemoteHost());
        return n;
    }

    private SSLEngineResult wrapAppData(ByteBuffer b) throws SSLException, IOException {
        this.wrapData.clear();
        SSLEngineResult result = this.encode(b);
        if (log.isLoggable(Level.FINE)) {
            log.fine("wrapped " + result);
        }
        if (result.bytesProduced() > 0) {
            this.wrapData.flip();
            return result;
        }
        throw new IOException("wrap produced no data " + this.getRemoteHost());
    }

    public synchronized ByteBuffer preprocessBufferToWrite(ByteBuffer dataToSend) throws IOException {
        this.sendData.clear();
        while (dataToSend.hasRemaining()) {
            SSLEngineResult res = this.wrapAppData(dataToSend);
            if (this.wrapData.remaining() > this.sendData.remaining()) {
                int extra = this.wrapData.remaining() - this.sendData.remaining();
                this.sendData.flip();
                this.sendData = NIOHelper.enlargeAndFillBuffer(this.sendData, extra);
            }
            NIOHelper.copyAsMuchAsFits(this.sendData, this.wrapData);
        }
        this.sendData.flip();
        return this.sendData;
    }

    public synchronized ByteBuffer postprocessBufferRead(ByteBuffer socketData) throws PacketIncompleteException, IOException {
        this.unwrapData.clear();
        int n = this.decrypt(socketData);
        if (n > 0) {
            this.unwrapData.flip();
            return this.unwrapData;
        }
        return EMPTY_BUFFER;
    }

    public boolean needSocketData() {
        return false;
    }
}

