/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.ContainerID;
import jade.core.ServiceException;
import jade.core.behaviours.SenderBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.FIPAAgentManagement.APService;
import jade.domain.FIPAAgentManagement.GetDescription;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.JADEAgentManagement.CreateAgent;
import jade.domain.JADEAgentManagement.InstallMTP;
import jade.domain.JADEAgentManagement.KillAgent;
import jade.domain.JADEAgentManagement.KillContainer;
import jade.domain.JADEAgentManagement.ShutdownPlatform;
import jade.domain.JADEAgentManagement.UninstallMTP;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.AddedMTP;
import jade.domain.introspection.BornAgent;
import jade.domain.introspection.ChangedAgentOwnership;
import jade.domain.introspection.DeadAgent;
import jade.domain.introspection.Event;
import jade.domain.introspection.FrozenAgent;
import jade.domain.introspection.MovedAgent;
import jade.domain.introspection.PlatformDescription;
import jade.domain.introspection.RemovedContainer;
import jade.domain.introspection.RemovedMTP;
import jade.domain.introspection.ResetEvents;
import jade.domain.introspection.ResumedAgent;
import jade.domain.introspection.SuspendedAgent;
import jade.domain.introspection.ThawedAgent;
import jade.domain.mobility.CloneAction;
import jade.domain.mobility.MobileAgentDescription;
import jade.domain.mobility.MobilityOntology;
import jade.domain.mobility.MoveAction;
import jade.domain.persistence.FreezeAgent;
import jade.domain.persistence.LoadAgent;
import jade.domain.persistence.LoadContainer;
import jade.domain.persistence.PersistenceOntology;
import jade.domain.persistence.SaveAgent;
import jade.domain.persistence.SaveContainer;
import jade.domain.persistence.ThawAgent;
import jade.gui.AgentTreeModel;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.tools.ToolAgent;
import jade.tools.rma.MainWindow;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;

public class rma
extends ToolAgent {
    private APDescription myPlatformProfile;
    private SequentialBehaviour AMSSubscribe = new SequentialBehaviour();
    private transient MainWindow myGUI;
    private String myContainerName;

    protected void toolSetup() {
        this.logger = Logger.getMyLogger(this.getName());
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerOntology(PersistenceOntology.getInstance());
        this.AMSSubscribe.addSubBehaviour(new SenderBehaviour(this, this.getSubscribe()));
        this.AMSSubscribe.addSubBehaviour(new RMAAMSListenerBehaviour());
        this.addBehaviour(this.AMSSubscribe);
        this.myGUI = new MainWindow(this);
        this.myGUI.ShowCorrect();
    }

    protected void toolTakeDown() {
        this.send(this.getCancel());
        if (this.myGUI != null) {
            this.myGUI.disposeAsync();
        }
    }

    protected void beforeMove() {
        super.beforeMove();
        this.myGUI.disposeAsync();
        this.send(this.getCancel());
    }

    protected void afterMove() {
        super.afterMove();
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerOntology(PersistenceOntology.getInstance());
        this.myGUI = new MainWindow(this);
        this.myGUI.ShowCorrect();
        this.send(this.getSubscribe());
    }

    protected void afterClone() {
        super.afterClone();
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerOntology(PersistenceOntology.getInstance());
        ACLMessage AMSSubscription = this.getSubscribe();
        this.send(AMSSubscription);
        this.myGUI = new MainWindow(this);
        this.myGUI.ShowCorrect();
    }

    public void afterLoad() {
        super.afterLoad();
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerOntology(PersistenceOntology.getInstance());
        ACLMessage AMSSubscription = this.getSubscribe();
        this.send(AMSSubscription);
        this.myGUI = new MainWindow(this);
        this.myGUI.ShowCorrect();
    }

    public void beforeReload() {
        super.beforeReload();
        this.myGUI.disposeAsync();
        this.send(this.getCancel());
    }

    public void afterReload() {
        super.afterReload();
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerOntology(PersistenceOntology.getInstance());
        this.myGUI = new MainWindow(this);
        this.myGUI.ShowCorrect();
        this.send(this.getSubscribe());
    }

    public void beforeFreeze() {
        super.beforeFreeze();
        this.myGUI.disposeAsync();
        this.send(this.getCancel());
    }

    public void afterThaw() {
        super.afterThaw();
        this.getContentManager().registerOntology(MobilityOntology.getInstance());
        this.getContentManager().registerOntology(PersistenceOntology.getInstance());
        this.myGUI = new MainWindow(this);
        this.myGUI.ShowCorrect();
        this.send(this.getSubscribe());
    }

    public AgentTreeModel getModel() {
        return this.myGUI.getModel();
    }

    public void newAgent(String agentName, String className, Object[] arg, String containerName) {
        this.newAgent(agentName, className, arg, null, containerName);
    }

    public void newAgent(String agentName, String className, Object[] arg, String ownerName, String containerName) {
        CreateAgent ca = new CreateAgent();
        if (containerName.equals("")) {
            containerName = "Main-Container";
        }
        JADEPrincipal intendedOwner = null;
        Credentials initialCredentials = null;
        if (ownerName == null || ownerName.trim().length() == 0) {
            try {
                JADEPrincipal rmaOwner = null;
                Credentials rmaCredentials = null;
                CredentialsHelper ch = (CredentialsHelper)((Object)this.getHelper("jade.core.security.Security"));
                if (ch != null) {
                    rmaCredentials = ch.getCredentials();
                }
                if (rmaCredentials != null) {
                    rmaOwner = rmaCredentials.getOwner();
                }
                intendedOwner = rmaOwner;
            }
            catch (ServiceException se) {
                intendedOwner = null;
                initialCredentials = null;
            }
        } else {
            try {
                Class<?> c = Class.forName("jade.security.impl.JADEPrincipalImpl");
                intendedOwner = (JADEPrincipal)c.newInstance();
                Method setName = c.getDeclaredMethod("setName", String.class);
                setName.invoke((Object)intendedOwner, ownerName);
            }
            catch (Exception e) {
                intendedOwner = null;
                initialCredentials = null;
            }
        }
        ca.setOwner(intendedOwner);
        ca.setInitialCredentials(initialCredentials);
        ca.setAgentName(agentName);
        ca.setClassName(className);
        ca.setContainer(new ContainerID(containerName, null));
        if (arg != null) {
            for (int i = 0; i < arg.length; ++i) {
                ca.addArguments(arg[i]);
            }
        }
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(ca);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("CreateAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void suspendAgent(AID name) {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(name);
        amsd.setState("suspended");
        Modify m = new Modify();
        m.setDescription(amsd);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(m);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("FIPA-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("SuspendAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void suspendContainer(String name) {
    }

    public void resumeAgent(AID name) {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(name);
        amsd.setState("active");
        Modify m = new Modify();
        m.setDescription(amsd);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(m);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("FIPA-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("ResumeAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void changeAgentOwnership(AID name, String ownership) {
        AMSAgentDescription amsd = new AMSAgentDescription();
        amsd.setName(name);
        amsd.setState("active");
        amsd.setOwnership(ownership);
        Modify m = new Modify();
        m.setDescription(amsd);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(m);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("FIPA-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("ChangeAgentOwnership", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void resumeContainer(String name) {
    }

    public void killAgent(AID name) {
        KillAgent ka = new KillAgent();
        ka.setAgent(name);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(ka);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("KillAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void saveContainer(String name, String repository) {
        SaveContainer saveAct = new SaveContainer();
        saveAct.setContainer(new ContainerID(name, null));
        saveAct.setRepository(repository);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(saveAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Persistence");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("SaveContainer", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void loadContainer(String name, String repository) {
        LoadContainer saveAct = new LoadContainer();
        saveAct.setContainer(new ContainerID(name, null));
        saveAct.setRepository(repository);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(saveAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Persistence");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("LoadContainer", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void killContainer(String name) {
        KillContainer kc = new KillContainer();
        kc.setContainer(new ContainerID(name, null));
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(kc);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("KillContainer", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void moveAgent(AID name, String container) {
        MoveAction moveAct = new MoveAction();
        MobileAgentDescription desc = new MobileAgentDescription();
        desc.setName(name);
        ContainerID dest = new ContainerID(container, null);
        desc.setDestination(dest);
        moveAct.setMobileAgentDescription(desc);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(moveAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("jade-mobility-ontology");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("MoveAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void cloneAgent(AID name, String newName, String container) {
        CloneAction cloneAct = new CloneAction();
        MobileAgentDescription desc = new MobileAgentDescription();
        desc.setName(name);
        ContainerID dest = new ContainerID(container, null);
        desc.setDestination(dest);
        cloneAct.setMobileAgentDescription(desc);
        cloneAct.setNewName(newName);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(cloneAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("jade-mobility-ontology");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("CloneAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void saveAgent(AID name, String repository) {
        SaveAgent saveAct = new SaveAgent();
        saveAct.setAgent(name);
        saveAct.setRepository(repository);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(saveAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Persistence");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("SaveAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void loadAgent(AID name, String repository, String container) {
        LoadAgent loadAct = new LoadAgent();
        loadAct.setAgent(name);
        loadAct.setRepository(repository);
        ContainerID where = new ContainerID(container, null);
        loadAct.setWhere(where);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(loadAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Persistence");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("LoadAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void freezeAgent(AID name, String repository) {
        FreezeAgent freezeAct = new FreezeAgent();
        freezeAct.setAgent(name);
        freezeAct.setRepository(repository);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(freezeAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Persistence");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("FreezeAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void thawAgent(AID name, String repository, ContainerID newContainer) {
        ThawAgent thawAct = new ThawAgent();
        thawAct.setAgent(name);
        thawAct.setRepository(repository);
        thawAct.setNewContainer(newContainer);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(thawAct);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Persistence");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("ThawAgent", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void exit() {
        if (this.myGUI.showExitDialog("Exit this container")) {
            this.killContainer(this.myContainerName);
        }
    }

    public void shutDownPlatform() {
        if (this.myGUI.showExitDialog("Shut down the platform")) {
            ShutdownPlatform sp = new ShutdownPlatform();
            try {
                Action a = new Action();
                a.setActor(this.getAMS());
                a.setAction(sp);
                ACLMessage requestMsg = this.getRequest();
                requestMsg.setOntology("JADE-Agent-Management");
                this.getContentManager().fillContent(requestMsg, a);
                this.addBehaviour(new AMSClientBehaviour("ShutdownPlatform", requestMsg));
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
    }

    public void installMTP(String containerName) {
        InstallMTP imtp = new InstallMTP();
        imtp.setContainer(new ContainerID(containerName, null));
        if (this.myGUI.showInstallMTPDialog(imtp)) {
            try {
                Action a = new Action();
                a.setActor(this.getAMS());
                a.setAction(imtp);
                ACLMessage requestMsg = this.getRequest();
                requestMsg.setOntology("JADE-Agent-Management");
                this.getContentManager().fillContent(requestMsg, a);
                this.addBehaviour(new AMSClientBehaviour("InstallMTP", requestMsg));
            }
            catch (Exception fe) {
                fe.printStackTrace();
            }
        }
    }

    public void uninstallMTP(String containerName) {
        UninstallMTP umtp = new UninstallMTP();
        umtp.setContainer(new ContainerID(containerName, null));
        if (this.myGUI.showUninstallMTPDialog(umtp)) {
            this.uninstallMTP(umtp.getContainer().getName(), umtp.getAddress());
        }
    }

    public void uninstallMTP(String containerName, String address) {
        UninstallMTP umtp = new UninstallMTP();
        umtp.setContainer(new ContainerID(containerName, null));
        umtp.setAddress(address);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(umtp);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("JADE-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("UninstallMTP", requestMsg));
        }
        catch (Exception fe) {
            fe.printStackTrace();
        }
    }

    public void addRemotePlatform(AID remoteAMS) {
        if (this.logger.isLoggable(Logger.FINE)) {
            this.logger.log(Logger.FINE, "AddRemotePlatform" + remoteAMS.toString());
        }
        try {
            ACLMessage requestMsg = new ACLMessage(16);
            requestMsg.setSender(this.getAID());
            requestMsg.clearAllReceiver();
            requestMsg.addReceiver(remoteAMS);
            requestMsg.setProtocol("fipa-request");
            requestMsg.setLanguage("fipa-sl0");
            requestMsg.setOntology("FIPA-Agent-Management");
            GetDescription action = new GetDescription();
            Action a = new Action();
            a.setActor(remoteAMS);
            a.setAction(action);
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new handleAddRemotePlatformBehaviour("GetDescription", requestMsg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRemotePlatformFromURL(String url) {
        try {
            String inputLine;
            URL AP_URL = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(AP_URL.openStream()));
            StringBuffer buf = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.equals("")) continue;
                buf.append(inputLine);
                buf.append(" ");
            }
            ACLMessage dummyMsg = new ACLMessage(10);
            dummyMsg.setOntology("FIPA-Agent-Management");
            dummyMsg.setLanguage("fipa-sl0");
            String content = "(( result (action ( agent-identifier :name ams :addresses (sequence IOR:00000000000000) :resolvers (sequence ) ) (get-description ) ) (sequence " + buf.toString() + " ) ) )";
            dummyMsg.setContent(content);
            try {
                Result r = (Result)this.getContentManager().extractContent(dummyMsg);
                Iterator i = r.getItems().iterator();
                APDescription APDesc = null;
                while (i.hasNext() && (APDesc = (APDescription)i.next()) != null) {
                    String amsName = "ams@" + APDesc.getName();
                    if (amsName.equalsIgnoreCase(this.getAMS().getName())) {
                        if (!this.logger.isLoggable(Logger.WARNING)) continue;
                        this.logger.log(Logger.WARNING, "ERROR: Action not allowed.");
                        continue;
                    }
                    AID ams2 = new AID(amsName, true);
                    Iterator is = APDesc.getAllAPServices();
                    while (is.hasNext()) {
                        APService s = (APService)is.next();
                        Iterator js = s.getAllAddresses();
                        while (js.hasNext()) {
                            ams2.addAddresses(js.next().toString());
                        }
                    }
                    this.myGUI.addRemotePlatformFolder();
                    this.myGUI.addRemotePlatform(ams2, APDesc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            in.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void viewAPDescription(String title) {
        this.myGUI.viewAPDescriptionDialog(this.myPlatformProfile, title);
    }

    public void viewAPDescription(APDescription remoteAP, String title) {
        this.myGUI.viewAPDescriptionDialog(remoteAP, title);
    }

    public void removeRemotePlatform(APDescription platform) {
        this.myGUI.removeRemotePlatform(platform.getName());
    }

    public void refreshRemoteAgent(APDescription platform, AID ams2) {
        try {
            ACLMessage request = new ACLMessage(16);
            request.setProtocol("fipa-request");
            request.setLanguage("fipa-sl0");
            request.setOntology("FIPA-Agent-Management");
            AMSAgentDescription amsd = new AMSAgentDescription();
            SearchConstraints constraints = new SearchConstraints();
            constraints.setMaxResults(new Long(-1L));
            Search s = new Search();
            s.setDescription(amsd);
            s.setConstraints(constraints);
            Action act = new Action();
            act.setAction(s);
            request.clearAllReceiver();
            request.addReceiver(ams2);
            act.setActor(ams2);
            this.getContentManager().fillContent(request, act);
            this.addBehaviour(new handleRefreshRemoteAgentBehaviour("search", request, platform));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerRemoteAgentWithAMS(AMSAgentDescription amsd) {
        Register register_act = new Register();
        register_act.setDescription(amsd);
        try {
            Action a = new Action();
            a.setActor(this.getAMS());
            a.setAction(register_act);
            ACLMessage requestMsg = this.getRequest();
            requestMsg.setOntology("FIPA-Agent-Management");
            this.getContentManager().fillContent(requestMsg, a);
            this.addBehaviour(new AMSClientBehaviour("Register", requestMsg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class RMAAMSListenerBehaviour
    extends ToolAgent.AMSListenerBehaviour {
        RMAAMSListenerBehaviour() {
        }

        protected void installHandlers(Map handlersTable) {
            handlersTable.put("meta_reset-events", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ResetEvents re = (ResetEvents)ev;
                    rma.this.myGUI.resetTree();
                }
            });
            handlersTable.put("added-container", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    AddedContainer ac = (AddedContainer)ev;
                    ContainerID cid = ac.getContainer();
                    String name = cid.getName();
                    String address = cid.getAddress();
                    try {
                        InetAddress addr = InetAddress.getByName(address);
                        rma.this.myGUI.addContainer(name, addr);
                    }
                    catch (UnknownHostException uhe) {
                        rma.this.myGUI.addContainer(name, null);
                    }
                }
            });
            handlersTable.put("removed-container", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    RemovedContainer rc = (RemovedContainer)ev;
                    ContainerID cid = rc.getContainer();
                    String name = cid.getName();
                    rma.this.myGUI.removeContainer(name);
                }
            });
            handlersTable.put("born-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    BornAgent ba = (BornAgent)ev;
                    ContainerID cid = ba.getWhere();
                    String container = cid.getName();
                    AID agent = ba.getAgent();
                    rma.this.myGUI.addAgent(container, agent, ba.getState(), ba.getOwnership());
                    if (agent.equals(rma.this.getAID())) {
                        rma.this.myContainerName = container;
                    }
                }
            });
            handlersTable.put("dead-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    DeadAgent da = (DeadAgent)ev;
                    ContainerID cid = da.getWhere();
                    String container = cid.getName();
                    AID agent = da.getAgent();
                    rma.this.myGUI.removeAgent(container, agent);
                }
            });
            handlersTable.put("suspended-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    SuspendedAgent sa = (SuspendedAgent)ev;
                    ContainerID cid = sa.getWhere();
                    String container = cid.getName();
                    AID agent = sa.getAgent();
                    rma.this.myGUI.modifyAgent(container, agent, "suspended", null);
                }
            });
            handlersTable.put("resumed-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ResumedAgent ra = (ResumedAgent)ev;
                    ContainerID cid = ra.getWhere();
                    String container = cid.getName();
                    AID agent = ra.getAgent();
                    rma.this.myGUI.modifyAgent(container, agent, "active", null);
                }
            });
            handlersTable.put("frozen-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    FrozenAgent fa = (FrozenAgent)ev;
                    String oldContainer = fa.getWhere().getName();
                    String newContainer = fa.getBufferContainer().getName();
                    AID agent = fa.getAgent();
                    rma.this.myGUI.modifyFrozenAgent(oldContainer, newContainer, agent);
                }
            });
            handlersTable.put("thawed-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ThawedAgent ta = (ThawedAgent)ev;
                    String oldContainer = ta.getWhere().getName();
                    String newContainer = ta.getBufferContainer().getName();
                    AID agent = ta.getAgent();
                    rma.this.myGUI.modifyThawedAgent(oldContainer, newContainer, agent);
                }
            });
            handlersTable.put("changed-agent-ownership", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    ChangedAgentOwnership cao = (ChangedAgentOwnership)ev;
                    ContainerID cid = cao.getWhere();
                    String container = cid.getName();
                    AID agent = cao.getAgent();
                    rma.this.myGUI.modifyAgent(container, agent, null, cao.getTo());
                }
            });
            handlersTable.put("moved-agent", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    MovedAgent ma = (MovedAgent)ev;
                    AID agent = ma.getAgent();
                    ContainerID from = ma.getFrom();
                    ContainerID to = ma.getTo();
                    rma.this.myGUI.moveAgent(from.getName(), to.getName(), agent);
                }
            });
            handlersTable.put("added-mtp", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    AddedMTP amtp = (AddedMTP)ev;
                    String address = amtp.getAddress();
                    ContainerID where = amtp.getWhere();
                    rma.this.myGUI.addAddress(address, where.getName());
                }
            });
            handlersTable.put("removed-mtp", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    RemovedMTP rmtp = (RemovedMTP)ev;
                    String address = rmtp.getAddress();
                    ContainerID where = rmtp.getWhere();
                    rma.this.myGUI.removeAddress(address, where.getName());
                }
            });
            handlersTable.put("platform-description", new AMSSubscriber.EventHandler(){

                public void handle(Event ev) {
                    PlatformDescription pd = (PlatformDescription)ev;
                    APDescription APdesc = pd.getPlatform();
                    rma.this.myPlatformProfile = APdesc;
                    rma.this.myGUI.refreshLocalPlatformName(rma.this.myPlatformProfile.getName());
                }
            });
        }
    }

    private class handleRefreshRemoteAgentBehaviour
    extends AMSClientBehaviour {
        private APDescription platform;

        public handleRefreshRemoteAgentBehaviour(String an, ACLMessage request, APDescription ap) {
            super(an, request);
            this.platform = ap;
        }

        protected void handleInform(ACLMessage msg) {
            if (rma.this.logger.isLoggable(Logger.FINE)) {
                rma.this.logger.log(Logger.FINE, "arrived a new agents from a remote platform");
            }
            try {
                AID sender = msg.getSender();
                Result r = (Result)rma.this.getContentManager().extractContent(msg);
                Iterator i = r.getItems().iterator();
                rma.this.myGUI.refreshRemoteAgentsInRemotePlatform(this.platform, i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class handleAddRemotePlatformBehaviour
    extends AMSClientBehaviour {
        public handleAddRemotePlatformBehaviour(String an, ACLMessage request) {
            super(an, request);
        }

        protected void handleInform(ACLMessage msg) {
            if (rma.this.logger.isLoggable(Logger.FINE)) {
                rma.this.logger.log(Logger.FINE, "arrived a new APDescription");
            }
            try {
                AID sender = msg.getSender();
                Result r = (Result)rma.this.getContentManager().extractContent(msg);
                Iterator i = r.getItems().iterator();
                APDescription APDesc = (APDescription)i.next();
                if (APDesc != null) {
                    rma.this.myGUI.addRemotePlatformFolder();
                    rma.this.myGUI.addRemotePlatform(sender, APDesc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class AMSClientBehaviour
    extends SimpleAchieveREInitiator {
        private String actionName;

        public AMSClientBehaviour(String an, ACLMessage request) {
            super(rma.this, request);
            this.actionName = an;
        }

        protected void handleNotUnderstood(ACLMessage reply) {
            rma.this.myGUI.showErrorDialog("NOT-UNDERSTOOD received by RMA during " + this.actionName, reply);
        }

        protected void handleRefuse(ACLMessage reply) {
            rma.this.myGUI.showErrorDialog("REFUSE received during " + this.actionName, reply);
        }

        protected void handleAgree(ACLMessage reply) {
            if (rma.this.logger.isLoggable(Logger.FINE)) {
                rma.this.logger.log(Logger.FINE, "AGREE received" + reply);
            }
        }

        protected void handleFailure(ACLMessage reply) {
            rma.this.myGUI.showErrorDialog("FAILURE received during " + this.actionName, reply);
        }

        protected void handleInform(ACLMessage reply) {
            if (rma.this.logger.isLoggable(Logger.FINE)) {
                rma.this.logger.log(Logger.FINE, "INFORM received" + reply);
            }
        }
    }
}

