/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import pikater.DataManagerService;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.GetData;
import pikater.ontology.messages.Instance;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Metadata;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instances;

public class Agent_ARFFReader
extends Agent {
    private static final long serialVersionUID = 7116837600070711675L;
    private Codec codec = new SLCodec();
    private Ontology ontology = MessagesOntology.getInstance();
    private String fileName;
    protected Instances data;
    private String path = System.getProperty("user.dir") + System.getProperty("file.separator");
    private boolean working = false;

    boolean ReadFromFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            this.data = new Instances((Reader)reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.out.println("Reading of data from file " + fileName + " failed.");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Reading of data from file " + fileName + " failed.");
            return false;
        }
        System.out.println("Reading of data from file " + fileName + " succesful.");
        return true;
    }

    protected void setup() {
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        DFAgentDescription dfd = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("ARFFReader");
        sd.setName(this.getName());
        dfd.setName(this.getAID());
        dfd.addServices(sd);
        try {
            DFService.register((Agent)this, (DFAgentDescription)dfd);
        }
        catch (FIPAException e) {
            System.err.println(this.getLocalName() + " registration with DF unsucceeded. Reason: " + e.getMessage());
            this.doDelete();
        }
        MessageTemplate template = MessageTemplate.MatchPerformative((int)16);
        this.addBehaviour((Behaviour)new GetDataResponder(this, template));
        System.out.println("Agent " + this.getLocalName() + " is ready!");
    }

    protected ACLMessage sendData(ACLMessage request) {
        ACLMessage msgOut = request.createReply();
        msgOut.setPerformative(7);
        try {
            ContentElement content = this.getContentManager().extractContent(request);
            GetData gd = (GetData)((Action)content).getAction();
            String file_name = gd.getFile_name();
            boolean saveMetadata = gd.getSaveMetadata();
            DataInstances instances = new DataInstances();
            this.working = true;
            boolean file_read = this.ReadFromFile(file_name);
            this.working = false;
            if (!file_read) {
                throw new FailureException("File haven't been read. Wrong file-name?");
            }
            instances.fillWekaInstances(this.data);
            boolean missing = false;
            ArrayList<Integer> types = new ArrayList<Integer>();
            for (int i = 0; i < this.data.numAttributes(); ++i) {
                Attribute a = this.data.attribute(i);
                AttributeStats as = this.data.attributeStats(i);
                if (as.missingCount > 0) {
                    missing = true;
                }
                if (i == (this.data.classIndex() >= 0 ? this.data.classIndex() : this.data.numAttributes() - 1) || types.contains(a.type())) continue;
                types.add(a.type());
                System.err.println(a.type());
            }
            if (saveMetadata) {
                Metadata m = new Metadata();
                if (types.size() > 1) {
                    m.setAttribute_type("Multivariate");
                } else {
                    switch ((Integer)types.get(0)) {
                        case 1: {
                            m.setAttribute_type("Categorical");
                            break;
                        }
                        case 0: {
                            m.setAttribute_type("Numeric");
                        }
                    }
                }
                if (this.data.attribute(this.data.classIndex() >= 0 ? this.data.classIndex() : this.data.numAttributes() - 1).type() == 0) {
                    m.setDefault_task("Regression");
                } else {
                    m.setDefault_task("Classification");
                }
                m.setInternal_name(file_name);
                m.setMissing_values(missing);
                int ninst = instances.getInstances().size();
                System.err.println("Reader: " + ninst);
                if (ninst > 0) {
                    m.setNumber_of_attributes(((Instance)instances.getInstances().iterator().next()).getValues().size());
                }
                m.setNumber_of_instances(instances.getInstances().size());
                DataManagerService.saveMetadata(this, m);
            }
            Result result = new Result((Concept)((Action)content), (Object)instances);
            try {
                this.getContentManager().fillContent(msgOut, (ContentElement)result);
            }
            catch (Codec.CodecException ce) {
                ce.printStackTrace();
            }
            catch (OntologyException oe) {
                oe.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgOut;
    }

    private class GetDataResponder
    extends AchieveREResponder {
        private static final long serialVersionUID = 4340928332826216394L;

        public GetDataResponder(Agent a, MessageTemplate mt) {
            super(a, mt);
        }

        protected ACLMessage prepareResponse(ACLMessage request) {
            ACLMessage agree = request.createReply();
            agree.setPerformative(1);
            return agree;
        }

        protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) {
            try {
                ContentElement content = Agent_ARFFReader.this.getContentManager().extractContent(request);
                if (((Action)content).getAction() instanceof GetData) {
                    return Agent_ARFFReader.this.sendData(request);
                }
            }
            catch (Codec.CodecException ce) {
                ce.printStackTrace();
            }
            catch (OntologyException oe) {
                oe.printStackTrace();
            }
            ACLMessage notUnderstood = request.createReply();
            notUnderstood.setPerformative(10);
            return notUnderstood;
        }
    }
}

