/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.behaviours.Behaviour;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.util.leap.ArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.DeleteTempFiles;
import pikater.ontology.messages.GetAllMetadata;
import pikater.ontology.messages.GetFileInfo;
import pikater.ontology.messages.GetFiles;
import pikater.ontology.messages.GetTheBestAgent;
import pikater.ontology.messages.ImportFile;
import pikater.ontology.messages.LoadResults;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Metadata;
import pikater.ontology.messages.SaveMetadata;
import pikater.ontology.messages.SaveResults;
import pikater.ontology.messages.SavedResult;
import pikater.ontology.messages.Task;
import pikater.ontology.messages.TranslateFilename;
import pikater.ontology.messages.UpdateMetadata;

public class Agent_DataManager
extends jade.core.Agent {
    private static final long serialVersionUID = 1L;
    Connection db;
    Logger log;
    Codec codec = new SLCodec();
    Ontology ontology = MessagesOntology.getInstance();

    public Agent_DataManager() {
        try {
            this.db = DriverManager.getConnection("jdbc:hsqldb:file:data/db/pikaterdb", "", "");
            Logger.getRootLogger().addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %-5p %c - %m%n"), "log"));
            this.log = Logger.getLogger(Agent_DataManager.class);
            this.log.setLevel(Level.TRACE);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setup() {
        super.setup();
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        LinkedList<String> tableNames = new LinkedList<String>();
        LinkedList<String> triggerNames = new LinkedList<String>();
        try {
            String[] types = new String[]{"TABLE", "VIEW"};
            ResultSet tables = this.db.getMetaData().getTables(null, null, "%", types);
            while (tables.next()) {
                tableNames.add(tables.getString(3));
            }
            ResultSet triggers = this.db.createStatement().executeQuery("SELECT trigger_name FROM INFORMATION_SCHEMA.TRIGGERS");
            while (triggers.next()) {
                triggerNames.add(triggers.getString("trigger_name"));
            }
        }
        catch (SQLException e) {
            this.log.error((Object)("Error getting tables list: " + e.getMessage()));
            e.printStackTrace();
        }
        this.log.info((Object)"Found the following tables: ");
        for (String s : tableNames) {
            this.log.info((Object)s);
        }
        this.log.info((Object)"Found the following triggers: ");
        for (String s : triggerNames) {
            this.log.info((Object)s);
        }
        File data = new File("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + "temp");
        if (!data.exists()) {
            this.log.info((Object)"Creating directory data/files");
            if (data.mkdirs()) {
                this.log.info((Object)"Succesfully created directory data/files");
            } else {
                this.log.error((Object)"Error creating directory data/files");
            }
        }
        try {
            if (!tableNames.contains("FILEMAPPING")) {
                this.log.info((Object)"Creating table FILEMAPPING");
                this.db.createStatement().executeUpdate("CREATE TABLE fileMapping (userID INTEGER NOT NULL, externalFilename VARCHAR(256) NOT NULL, internalFilename CHAR(32) NOT NULL, PRIMARY KEY (userID, externalFilename))");
            }
        }
        catch (SQLException e) {
            this.log.fatal((Object)("Error creating table FILEMAPPING: " + e.getMessage()));
            e.printStackTrace();
        }
        try {
            if (!tableNames.contains("METADATA")) {
                this.log.info((Object)"Creating table METADATA");
                this.db.createStatement().executeUpdate("CREATE TABLE metadata (externalFilename VARCHAR(256) NOT NULL, internalFilename CHAR(32) NOT NULL, defaultTask VARCHAR(256), attributeType VARCHAR(256), numberOfInstances INTEGER, numberOfAttributes INTEGER, missingValues BOOLEAN, PRIMARY KEY (internalFilename))");
            }
        }
        catch (SQLException e) {
            this.log.fatal((Object)("Error creating table METADATA: " + e.getMessage()));
            e.printStackTrace();
        }
        try {
            if (!tableNames.contains("RESULTS")) {
                this.log.info((Object)"Creating table RESULTS");
                this.db.createStatement().executeUpdate("CREATE TABLE results (userID INTEGER NOT NULL, agentName VARCHAR (256), agentType VARCHAR (256), options VARCHAR (256), dataFile VARCHAR (50), testFile VARCHAR (50), errorRate DOUBLE, kappaStatistic DOUBLE, meanAbsoluteError DOUBLE, rootMeanSquaredError DOUBLE, relativeAbsoluteError DOUBLE,rootRelativeSquaredError DOUBLE, objectFilename VARCHAR(256), start TIMESTAMP, finish TIMESTAMP, duration INTEGER )");
            }
        }
        catch (SQLException e) {
            this.log.fatal((Object)("Error creating table RESULTS: " + e.getMessage()));
        }
        try {
            if (!tableNames.contains("FILEMETADATA")) {
                this.log.info((Object)"Creating view FILEMETADATA");
                this.db.createStatement().executeUpdate("CREATE VIEW filemetadata AS SELECT userid, filemapping.internalfilename, filemapping.externalfilename, defaulttask, attributetype, numberofattributes, numberofinstances, missingvalues FROM filemapping JOIN metadata ON filemapping.internalfilename = metadata.internalfilename");
            }
        }
        catch (SQLException e) {
            this.log.fatal((Object)("Error creating table FILEMETADATA: " + e.getMessage()));
        }
        try {
            if (!tableNames.contains("RESULTSEXTERNAL")) {
                this.log.info((Object)"Creating view RESULTSEXTERNAL");
                this.db.createStatement().executeUpdate("CREATE VIEW RESULTSEXTERNAL AS SELECT results.*,filemapping.externalFilename AS trainFileExt, filemapping2.externalFilename AS testFileExt FROM results JOIN filemapping ON results.userID = filemapping.userID AND results.dataFile = filemapping.internalFilename JOIN filemapping AS filemapping2 ON results.userID = filemapping2.userID AND results.testFile = filemapping2.internalFilename");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            if (!triggerNames.contains("PREPAREMETADATA")) {
                this.db.createStatement().execute("CREATE TRIGGER prepareMetadata AFTER INSERT ON filemapping REFERENCING NEW ROW AS newrow FOR EACH ROW INSERT INTO metadata (internalfilename, externalfilename) VALUES (newrow.internalfilename, newrow.externalfilename)");
            }
        }
        catch (SQLException e) {
            this.log.fatal((Object)("Error creating trigger prepareMetadata: " + e.getMessage()));
        }
        MessageTemplate mt = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)this.ontology.getName()), (MessageTemplate)MessageTemplate.MatchPerformative((int)16));
        this.addBehaviour((Behaviour)new AchieveREResponder(this, mt){
            private static final long serialVersionUID = 1L;

            protected ACLMessage handleRequest(ACLMessage request) throws NotUnderstoodException, RefuseException {
                try {
                    Action a = (Action)Agent_DataManager.this.getContentManager().extractContent(request);
                    if (a.getAction() instanceof ImportFile) {
                        ImportFile im = (ImportFile)a.getAction();
                        String pathPrefix = System.getProperty("user.dir") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + "temp" + System.getProperty("file.separator");
                        if (im.isTempFile()) {
                            FileWriter fw = new FileWriter(pathPrefix + im.getExternalFilename());
                            fw.write(im.getFileContent());
                            fw.close();
                            ACLMessage reply = request.createReply();
                            reply.setPerformative(7);
                            Result r = new Result((Concept)im, (Object)(pathPrefix + im.getExternalFilename()));
                            Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                            return reply;
                        }
                        if (im.getFileContent() == null) {
                            String path = System.getProperty("user.dir") + System.getProperty("file.separator");
                            path = path + "incoming" + System.getProperty("file.separator") + im.getExternalFilename();
                            String internalFilename = Agent_DataManager.this.md5(path);
                            File f = new File(path);
                            Statement stmt = Agent_DataManager.this.db.createStatement();
                            String query = "SELECT COUNT(*) AS num FROM fileMapping WHERE internalFilename = '" + internalFilename + "'";
                            Agent_DataManager.this.log.info((Object)("Executing query " + query));
                            ResultSet rs = stmt.executeQuery(query);
                            rs.next();
                            int count = rs.getInt("num");
                            stmt.close();
                            if (count > 0) {
                                f.delete();
                                Agent_DataManager.this.log.info((Object)("File " + internalFilename + " already present in the database"));
                            } else {
                                stmt = Agent_DataManager.this.db.createStatement();
                                Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                                query = "INSERT into fileMapping (userId, externalFilename, internalFilename) VALUES (" + im.getUserID() + ",'" + im.getExternalFilename() + "','" + internalFilename + "')";
                                stmt.executeUpdate(query);
                                stmt.close();
                                String newName = System.getProperty("user.dir") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + internalFilename;
                                Agent_DataManager.move(f, new File(newName));
                            }
                            ACLMessage reply = request.createReply();
                            reply.setPerformative(7);
                            Result r = new Result((Concept)im, (Object)internalFilename);
                            Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                            return reply;
                        }
                        String fileContent = im.getFileContent();
                        String fileName = im.getExternalFilename();
                        String internalFilename = DigestUtils.md5Hex(fileContent);
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        String query = "SELECT COUNT(*) AS num FROM fileMapping WHERE internalFilename = '" + internalFilename + "'";
                        Agent_DataManager.this.log.info((Object)("Executing query " + query));
                        ResultSet rs = stmt.executeQuery(query);
                        rs.next();
                        int count = rs.getInt("num");
                        stmt.close();
                        if (count > 0) {
                            Agent_DataManager.this.log.info((Object)("File " + internalFilename + " already present in the database"));
                        } else {
                            stmt = Agent_DataManager.this.db.createStatement();
                            Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                            query = "INSERT into fileMapping (userId, externalFilename, internalFilename) VALUES (" + im.getUserID() + ",'" + im.getExternalFilename() + "','" + internalFilename + "')";
                            stmt.executeUpdate(query);
                            stmt.close();
                            String newName = System.getProperty("user.dir") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + internalFilename;
                            FileWriter file = new FileWriter(newName);
                            file.write(fileContent);
                            file.close();
                            Agent_DataManager.this.log.info((Object)("Created file: " + newName));
                        }
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Result r = new Result((Concept)im, (Object)internalFilename);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                        return reply;
                    }
                    if (a.getAction() instanceof TranslateFilename) {
                        TranslateFilename tf = (TranslateFilename)a.getAction();
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        String query = null;
                        query = tf.getInternalFilename() == null ? "SELECT internalFilename AS filename FROM fileMapping WHERE userID=" + tf.getUserID() + " AND externalFilename='" + tf.getExternalFilename() + "'" : "SELECT externalFilename AS filename FROM fileMapping WHERE userID=" + tf.getUserID() + " AND internalFilename='" + tf.getInternalFilename() + "'";
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        ResultSet rs = stmt.executeQuery(query);
                        String internalFilename = "error";
                        if (rs.next()) {
                            internalFilename = rs.getString("filename");
                        } else {
                            String pathPrefix = System.getProperty("user.dir") + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + "temp" + System.getProperty("file.separator");
                            String tempFileName = pathPrefix + tf.getExternalFilename();
                            if (new File(tempFileName).exists()) {
                                internalFilename = "temp" + System.getProperty("file.separator") + tf.getExternalFilename();
                            }
                        }
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Result r = new Result((Concept)tf, (Object)internalFilename);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                        return reply;
                    }
                    if (a.getAction() instanceof SaveResults) {
                        if (!new File("studentMode").exists()) {
                            SaveResults sr = (SaveResults)a.getAction();
                            Task res = sr.getTask();
                            Statement stmt = Agent_DataManager.this.db.createStatement();
                            String query = "INSERT INTO results (userID, agentName, agentType, options, dataFile, testFile,errorRate, kappaStatistic, meanAbsoluteError, rootMeanSquaredError, relativeAbsoluteError,rootRelativeSquaredError, start, finish, duration, objectFilename) VALUES ( 1, ";
                            query = query + "'" + res.getAgent().getName() + "',";
                            query = query + "'" + res.getAgent().getType() + "',";
                            query = query + "'" + res.getAgent().optionsToString() + "',";
                            query = query + "'" + res.getData().getTrain_file_name().split(Pattern.quote(System.getProperty("file.separator")))[2] + "',";
                            query = query + "'" + res.getData().getTest_file_name().split(Pattern.quote(System.getProperty("file.separator")))[2] + "',";
                            query = query + res.getResult().getError_rate() + ",";
                            query = query + res.getResult().getKappa_statistic() + ",";
                            query = query + res.getResult().getMean_absolute_error() + ",";
                            query = query + res.getResult().getRoot_mean_squared_error() + ",";
                            query = query + res.getResult().getRelative_absolute_error() + ",";
                            query = query + res.getResult().getRoot_relative_squared_error();
                            Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTime().getTime());
                            query = query + ",";
                            query = query + "'" + Timestamp.valueOf(res.getStart()) + "',";
                            query = query + "'" + currentTimestamp + "',";
                            query = query + "'" + res.getResult().getDuration() + "',";
                            query = query + "'" + res.getResult().getObject_filename() + "'";
                            query = query + ")";
                            Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                            stmt.executeUpdate(query);
                        }
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        return reply;
                    }
                    if (a.getAction() instanceof SaveMetadata) {
                        SaveMetadata saveMetadata = (SaveMetadata)a.getAction();
                        Metadata metadata = saveMetadata.getMetadata();
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        String query = "UPDATE metadata SET ";
                        query = query + "numberOfInstances=" + metadata.getNumber_of_instances() + ", ";
                        query = query + "numberOfAttributes=" + metadata.getNumber_of_attributes() + ", ";
                        query = query + "missingValues=" + metadata.getMissing_values();
                        if (metadata.getAttribute_type() != null) {
                            query = query + ", attributeType='" + metadata.getAttribute_type() + "' ";
                        }
                        if (metadata.getDefault_task() != null) {
                            query = query + ", defaultTask='" + metadata.getDefault_task() + "' ";
                        }
                        query = query + " WHERE internalFilename='" + metadata.getInternal_name().split(Pattern.quote(System.getProperty("file.separator")))[2] + "'";
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        stmt.executeUpdate(query);
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        return reply;
                    }
                    if (a.getAction() instanceof GetAllMetadata) {
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        String query = "SELECT * FROM metadata";
                        ArrayList allMetadata = new ArrayList();
                        ResultSet rs = stmt.executeQuery(query);
                        while (rs.next()) {
                            Metadata m = new Metadata();
                            m.setAttribute_type(rs.getString("attributeType"));
                            m.setDefault_task(rs.getString("defaultTask"));
                            m.setExternal_name(rs.getString("externalFilename"));
                            m.setInternal_name(rs.getString("internalFilename"));
                            m.setMissing_values(rs.getBoolean("missingValues"));
                            m.setNumber_of_attributes(rs.getInt("numberOfAttributes"));
                            m.setNumber_of_instances(rs.getInt("numberOfInstances"));
                            query = "SELECT COUNT(*) AS n FROM results WHERE dataFile='" + rs.getString("internalFilename") + "'";
                            System.out.println(query);
                            ResultSet rs_number = stmt.executeQuery(query);
                            rs_number.next();
                            m.setNumber_of_tasks_in_db(rs_number.getInt("n"));
                            allMetadata.add((Object)m);
                        }
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Result _result = new Result(a.getAction(), (Object)allMetadata);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)_result);
                        return reply;
                    }
                    if (a.getAction() instanceof GetTheBestAgent) {
                        String query;
                        GetTheBestAgent g = (GetTheBestAgent)a.getAction();
                        String name = g.getNearest_file_name();
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        ResultSet rs = stmt.executeQuery(query = "SELECT * FROM results WHERE dataFile ='" + name + "'" + "AND errorRate = (SELECT MIN(errorRate) FROM results " + "WHERE dataFile ='" + name + "')");
                        if (rs == null) {
                            ACLMessage reply = request.createReply();
                            reply.setPerformative(6);
                            reply.setContent("There are no results for this file in the database.");
                            return reply;
                        }
                        rs.next();
                        Agent agent = new Agent();
                        agent.setName(rs.getString("agentName"));
                        agent.setType(rs.getString("agentType"));
                        System.out.println("**** options: " + rs.getString("options"));
                        agent.setOptions(agent.stringToOptions(rs.getString("options")));
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Result _result = new Result(a.getAction(), (Object)agent);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)_result);
                        return reply;
                    }
                    if (a.getAction() instanceof GetFileInfo) {
                        GetFileInfo gfi = (GetFileInfo)a.getAction();
                        String query = "SELECT * FROM filemetadata WHERE " + gfi.toSQLCondition();
                        System.err.println(query);
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        ResultSet rs = stmt.executeQuery(query);
                        ArrayList fileInfos = new ArrayList();
                        while (rs.next()) {
                            Metadata m = new Metadata();
                            m.setAttribute_type(rs.getString("attributeType"));
                            m.setDefault_task(rs.getString("defaultTask"));
                            m.setExternal_name(rs.getString("externalFilename"));
                            m.setInternal_name(rs.getString("internalFilename"));
                            m.setMissing_values(rs.getBoolean("missingValues"));
                            m.setNumber_of_attributes(rs.getInt("numberOfAttributes"));
                            m.setNumber_of_instances(rs.getInt("numberOfInstances"));
                            fileInfos.add((Object)m);
                        }
                        Result r = new Result(a.getAction(), (Object)fileInfos);
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                        System.err.println("Sending reply");
                        return reply;
                    }
                    if (a.getAction() instanceof UpdateMetadata) {
                        UpdateMetadata updateMetadata = (UpdateMetadata)a.getAction();
                        Metadata metadata = updateMetadata.getMetadata();
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        String query = "UPDATE metadata SET ";
                        query = query + "numberOfInstances=" + metadata.getNumber_of_instances() + ", ";
                        query = query + "numberOfAttributes=" + metadata.getNumber_of_attributes() + ", ";
                        query = query + "missingValues=" + metadata.getMissing_values() + "";
                        if (metadata.getAttribute_type() != null) {
                            query = query + ", attributeType='" + metadata.getAttribute_type() + "' ";
                        }
                        if (metadata.getDefault_task() != null) {
                            query = query + ", defaultTask='" + metadata.getDefault_task() + "' ";
                        }
                        query = query + " WHERE internalFilename ='" + metadata.getInternal_name() + "'";
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        stmt.executeUpdate(query);
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        return reply;
                    }
                    if (a.getAction() instanceof GetFiles) {
                        GetFiles gf = (GetFiles)a.getAction();
                        String query = "SELECT * FROM filemapping WHERE userid = " + gf.getUserID();
                        Agent_DataManager.this.log.info((Object)("Executing query: " + query));
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        ResultSet rs = stmt.executeQuery(query);
                        ArrayList files = new ArrayList();
                        while (rs.next()) {
                            files.add((Object)rs.getString("externalFilename"));
                        }
                        Result r = new Result(a.getAction(), (Object)files);
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                        return reply;
                    }
                    if (a.getAction() instanceof LoadResults) {
                        LoadResults lr = (LoadResults)a.getAction();
                        System.err.println(lr.asText());
                        String query = "SELECT * FROM resultsExternal " + lr.asSQLCondition();
                        System.err.println(query);
                        Agent_DataManager.this.log.info((Object)query);
                        Statement stmt = Agent_DataManager.this.db.createStatement();
                        ResultSet rs = stmt.executeQuery(query);
                        ArrayList results = new ArrayList();
                        while (rs.next()) {
                            SavedResult sr = new SavedResult();
                            sr.setAgentType(rs.getString("agentType"));
                            sr.setAgentOptions(rs.getString("options"));
                            sr.setTrainFile(rs.getString("trainFileExt"));
                            sr.setTestFile(rs.getString("testFileExt"));
                            sr.setErrorRate(rs.getDouble("errorRate"));
                            sr.setKappaStatistic(rs.getDouble("kappaStatistic"));
                            sr.setMeanAbsError(rs.getDouble("meanAbsoluteError"));
                            sr.setRMSE(rs.getDouble("rootMeanSquaredError"));
                            sr.setRootRelativeSquaredError(rs.getDouble("rootRelativeSquaredError"));
                            sr.setRelativeAbsoluteError(rs.getDouble("relativeAbsoluteError"));
                            sr.setDate("nodate");
                            results.add((Object)sr);
                        }
                        Result r = new Result(a.getAction(), (Object)results);
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        Agent_DataManager.this.getContentManager().fillContent(reply, (ContentElement)r);
                        return reply;
                    }
                    if (a.getAction() instanceof DeleteTempFiles) {
                        String path = "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + "temp" + System.getProperty("file.separator");
                        File tempDir = new File(path);
                        String[] files = tempDir.list();
                        if (files != null) {
                            for (String file : files) {
                                File d = new File(path + file);
                                d.delete();
                            }
                        }
                        ACLMessage reply = request.createReply();
                        reply.setPerformative(7);
                        return reply;
                    }
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                    Agent_DataManager.this.log.error((Object)("Problem extracting content: " + e.getMessage()));
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                    Agent_DataManager.this.log.error((Object)("Codec problem: " + e.getMessage()));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Agent_DataManager.this.log.error((Object)("SQL error: " + e.getMessage()));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ACLMessage failure = request.createReply();
                failure.setPerformative(6);
                Agent_DataManager.this.log.error((Object)("Failure responding to request: " + request.getContent()));
                return failure;
            }
        });
    }

    private String md5(String path) {
        StringBuffer sb = null;
        try {
            int ch;
            FileInputStream fs = new FileInputStream(path);
            sb = new StringBuffer();
            while ((ch = fs.read()) != -1) {
                sb.append((char)ch);
            }
            fs.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.log.error((Object)("File not found: " + path + " -- " + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.error((Object)("Error reading file: " + path + " -- " + e.getMessage()));
        }
        String md5 = DigestUtils.md5Hex(sb.toString());
        this.log.info((Object)("MD5 hash of file " + path + " is " + md5));
        return md5;
    }

    public static synchronized void move(File src, File dest) throws FileNotFoundException, IOException {
        Agent_DataManager.copy(src, dest);
        src.delete();
    }

    public static synchronized void copy(File src, File dest) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

