/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.gui.GuiAgent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.proto.SubscriptionInitiator;
import jade.util.leap.ArrayList;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import pikater.DataManagerService;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.Data;
import pikater.ontology.messages.Execute;
import pikater.ontology.messages.GetData;
import pikater.ontology.messages.GetOptions;
import pikater.ontology.messages.Interval;
import pikater.ontology.messages.LoadAgent;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Metadata;
import pikater.ontology.messages.Method;
import pikater.ontology.messages.Option;
import pikater.ontology.messages.Problem;
import pikater.ontology.messages.Solve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Agent_GUI
extends GuiAgent {
    private static final long serialVersionUID = -8991685806920963921L;
    private String path = System.getProperty("user.dir") + System.getProperty("file.separator");
    protected Codec codec = new SLCodec();
    protected Ontology ontology = MessagesOntology.getInstance();
    private int default_timeout = 30000;
    protected Vector<Problem> problems = new Vector();
    private int problem_id = 0;
    private int agent_id = 0;
    private int data_id = 0;
    private long timeout = 10000L;
    private HashMap<String, String> agentTypes;
    private HashMap<String, Object[]> agentOptions;
    private int default_number_of_values_to_try = 10;
    private float default_error_rate = 0.3f;
    protected String default_method = "Random";
    private int default_maximum_tries = 10;
    private String default_get_results = "after_each_computation";
    private String myAgentName;

    protected abstract String getAgentType();

    protected abstract void displayResult(ACLMessage var1);

    protected abstract void displayResurrectedResult(ACLMessage var1);

    protected abstract void displayFileImportProgress(int var1, int var2);

    protected abstract void mySetup();

    protected abstract void allOptionsReceived(int var1);

    protected abstract void displayPartialResult(ACLMessage var1);

    protected abstract void displayTaskResult(ACLMessage var1);

    protected abstract void DisplayWrongOption(int var1, String var2, String var3, String var4);

    protected void setDefault_number_of_values_to_try(int number) {
        this.default_number_of_values_to_try = number;
    }

    protected void setDefault_error_rate(double value) {
        this.default_error_rate = (float)value;
    }

    protected String[] getComputingAgents() {
        String type = "ComputingAgent";
        String[] ComputingAgents = null;
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription CAsd = new ServiceDescription();
        CAsd.setType(type);
        template.addServices(CAsd);
        try {
            DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
            System.out.println("Found the following agents:");
            ComputingAgents = new String[result.length];
            for (int i = 0; i < result.length; ++i) {
                ComputingAgents[i] = result[i].getName().getLocalName();
                System.out.println(ComputingAgents[i]);
            }
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.out.println("No " + type + " found.");
        }
        return ComputingAgents;
    }

    protected jade.util.leap.List getOptions(String agentType) throws Codec.CodecException, OntologyException, FIPAException {
        Result result;
        long _timeout = System.currentTimeMillis() + 2000L;
        AID aid = null;
        String newName = null;
        while (aid == null && System.currentTimeMillis() < _timeout) {
            aid = this.getAgentByType(agentType);
            if (aid != null) continue;
            newName = this.generateName(agentType);
            if (this.agentTypes == null) {
                this.createAgentTypesHashMap();
            }
            System.out.println("Creating agent " + newName + ", type: " + agentType);
            aid = this.createAgent(this.agentTypes.get(agentType), newName, this.agentOptions.get(agentType));
            this.doWait(100L);
        }
        if (aid == null) {
            throw new FailureException("Agent of the " + agentType + " type could not be found or created.");
        }
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(aid);
        msg.setProtocol("fipa-request");
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.ontology.getName());
        msg.setConversationId("options only");
        msg.setReplyByDate(new Date(System.currentTimeMillis() + 2000L));
        GetOptions get = new GetOptions();
        Action a = new Action();
        a.setAction((Concept)get);
        a.setActor(this.getAID());
        this.getContentManager().fillContent(msg, (ContentElement)a);
        ACLMessage reply = FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)msg);
        jade.util.leap.List options = null;
        ContentElement content = this.getContentManager().extractContent(reply);
        if (content instanceof Result && (result = (Result)content).getValue() instanceof Agent) {
            Agent agent = (Agent)result.getValue();
            options = agent.getOptions();
        }
        return options;
    }

    protected void getAgentOptions(String receiver) {
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(new AID(receiver, false));
        msg.setProtocol("fipa-request");
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.ontology.getName());
        msg.setReplyByDate(new Date(System.currentTimeMillis() + 30000L));
        GetOptions get = new GetOptions();
        Action a = new Action();
        a.setAction((Concept)get);
        a.setActor(this.getAID());
        try {
            this.getContentManager().fillContent(msg, (ContentElement)a);
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
        AchieveREInitiator behav = new AchieveREInitiator((jade.core.Agent)this, msg){

            protected void handleInform(ACLMessage inform) {
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + inform.getSender().getName() + " replied.");
                System.out.println("Conversation id:" + inform.getConversationId());
                try {
                    Result result;
                    ContentElement content = Agent_GUI.this.getContentManager().extractContent(inform);
                    if (content instanceof Result && (result = (Result)content).getValue() instanceof Agent) {
                        Agent agent = (Agent)result.getValue();
                        Agent_GUI.this.refreshOptions(agent, inform.getPerformative());
                        Agent_GUI.this.checkProblems();
                    }
                }
                catch (UngroundedException e) {
                    e.printStackTrace();
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
            }

            protected void handleRefuse(ACLMessage refuse) {
                Agent agent = new Agent();
                agent.setName(refuse.getSender().getName());
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + refuse.getSender().getName() + " refused to perform the requested action");
                Agent_GUI.this.refreshOptions(agent, refuse.getPerformative());
                Agent_GUI.this.checkProblems();
                Agent_GUI.this.displayResult(refuse);
            }

            protected void handleFailure(ACLMessage failure) {
                String requestKey = this.REQUEST_KEY;
                ACLMessage request = (ACLMessage)this.getDataStore().get((Object)requestKey);
                jade.util.leap.Iterator receivers = request.getAllIntendedReceiver();
                String agentName = ((AID)receivers.next()).getLocalName();
                Agent agent = new Agent();
                agent.setName(agentName);
                if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
                    System.out.println("Agent " + this.myAgent.getLocalName() + "Responder " + agentName + " does not exist.");
                } else {
                    System.out.println("Agent " + this.myAgent.getLocalName() + ": Agent " + agentName + " failed to perform the requested action");
                }
                Agent_GUI.this.checkProblems();
                Agent_GUI.this.displayResult(failure);
            }
        };
        this.addBehaviour((Behaviour)behav);
    }

    protected void sendProblem(int _problem_id) {
        Problem problem = null;
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (Integer.parseInt(next_problem.getGui_id()) != _problem_id || next_problem.getSent()) continue;
            problem = next_problem;
        }
        if (problem == null) {
            return;
        }
        problem.setStart(this.getDateTime());
        ACLMessage msg = new ACLMessage(16);
        msg.addReceiver(new AID("manager", false));
        msg.setProtocol("fipa-request");
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.ontology.getName());
        msg.setReplyByDate(new Date(System.currentTimeMillis() + 30000L));
        msg.setConversationId(problem.getGui_id() + this.getLocalName());
        Solve solve = new Solve();
        solve.setProblem(problem);
        Action a = new Action();
        a.setAction((Concept)solve);
        a.setActor(this.getAID());
        try {
            this.getContentManager().fillContent(msg, (ContentElement)a);
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
        AchieveREInitiator send_problem = new AchieveREInitiator((jade.core.Agent)this, msg){

            protected void handleAgree(ACLMessage agree) {
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + agree.getSender().getName() + " agreed.");
                Agent_GUI.this.updateProblemId(agree.getContent());
            }

            protected void handleInform(ACLMessage inform) {
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + inform.getSender().getName() + " replied.");
            }

            protected void handleRefuse(ACLMessage refuse) {
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + refuse.getSender().getName() + " refused to perform the requested action");
                Agent_GUI.this.displayResult(refuse);
            }

            protected void handleFailure(ACLMessage failure) {
                if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
                    System.out.println("Responder does not exist");
                } else {
                    System.out.println("Agent " + failure.getSender().getName() + " failed to perform the requested action");
                }
                Agent_GUI.this.displayResult(failure);
            }
        };
        this.addBehaviour((Behaviour)send_problem);
        problem.setSent(true);
        ACLMessage subscrmsg = new ACLMessage(19);
        subscrmsg.addReceiver(new AID("manager", false));
        subscrmsg.setProtocol("fipa-request");
        subscrmsg.setConversationId("subscription" + msg.getConversationId());
        subscrmsg.setLanguage(this.codec.getName());
        subscrmsg.setOntology(this.ontology.getName());
        SubscriptionInitiator receive_results = new SubscriptionInitiator((jade.core.Agent)this, subscrmsg){

            protected void handleInform(ACLMessage inform) {
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + inform.getSender().getName() + " replied.");
                Agent_GUI.this.displayResult(inform);
            }

            protected void handleRefuse(ACLMessage refuse) {
                System.out.println(Agent_GUI.this.getLocalName() + ": Agent " + refuse.getSender().getName() + " refused to perform the requested action");
                Agent_GUI.this.displayResult(refuse);
            }

            protected void handleFailure(ACLMessage failure) {
                if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
                    System.out.println("Responder does not exist");
                } else {
                    System.out.println("Agent " + failure.getSender().getName() + " failed to perform the requested action");
                }
                Agent_GUI.this.displayResult(failure);
            }
        };
        if (problem.getGet_results().equals("after_each_computation")) {
            this.addBehaviour((Behaviour)receive_results);
        }
    }

    protected int createNewProblem(String timeout, String get_results) {
        Problem problem = new Problem();
        problem.setGui_id(Integer.toString(this.problem_id));
        int _timeout = timeout == null ? this.default_timeout : Integer.parseInt(timeout);
        String _get_results = get_results == null ? this.default_get_results : get_results;
        Method method = new Method();
        method.setName(this.default_method);
        method.setError_rate(Float.valueOf(this.default_error_rate));
        method.setMaximum_tries(this.default_maximum_tries);
        problem.setMethod(method);
        problem.setTimeout(_timeout);
        problem.setAgents((jade.util.leap.List)new ArrayList());
        problem.setData((jade.util.leap.List)new ArrayList());
        problem.setSent(false);
        problem.setGet_results(_get_results);
        problem.setGui_agent(this.myAgentName);
        this.problems.add(problem);
        return this.problem_id++;
    }

    protected int addAgentToProblem(int _problem_id, String name, String type, String optString) throws FailureException {
        AID aid = null;
        String newName = null;
        if (type != null && type.contains("?")) {
            this.addAgent(_problem_id, this.agent_id, name, type, optString);
            this.checkProblems();
            return this.agent_id++;
        }
        long _timeout = this.timeout + System.currentTimeMillis();
        if (type != null) {
            while (aid == null && System.currentTimeMillis() < _timeout) {
                aid = this.getAgentByType(type);
                if (aid != null) continue;
                newName = this.generateName(type);
                aid = this.createAgent(this.agentTypes.get(type), newName, this.agentOptions.get(type));
                this.doWait(100L);
            }
            if (aid == null) {
                throw new FailureException("Agent of the " + type + " type could not be found or created.");
            }
            newName = aid.getLocalName();
        }
        if (name != null) {
            if (!this.exists(newName)) {
                throw new FailureException("Agent " + name + " could not be found.");
            }
            newName = name;
        }
        this.addAgent(_problem_id, this.agent_id, name, type, optString);
        this.getAgentOptions(newName);
        return this.agent_id++;
    }

    protected boolean exists(String name) {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setName(name);
        template.addServices(sd);
        try {
            DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
            if (result.length > 0) {
                return true;
            }
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        return false;
    }

    protected void removeAgentFromAllProblems(int _agent_id) {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (next_problem.getSent()) continue;
            for (Agent next_agent : next_problem.getAgents()) {
                if (Integer.parseInt(next_agent.getGui_id()) != _agent_id) continue;
                next_problem.getAgents().remove((Object)next_agent);
            }
        }
    }

    private String generateName(String agentType) {
        int number = 0;
        String name = agentType + number;
        boolean success = false;
        while (!success) {
            DFAgentDescription template = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setName(name);
            template.addServices(sd);
            try {
                DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
                if (result.length > 0) {
                    name = agentType + ++number;
                    continue;
                }
                success = true;
                return name;
            }
            catch (FIPAException fe) {
                fe.printStackTrace();
            }
        }
        return null;
    }

    private void addAgent(int _problem_id, int _agent_id, String name, String type, String optString) {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (next_problem.getSent() || Integer.parseInt(next_problem.getGui_id()) != _problem_id) continue;
            Agent agent = new Agent();
            agent.setName(name);
            agent.setType(type);
            agent.setGui_id(Integer.toString(_agent_id));
            if (optString == null) {
                agent.setOptions((jade.util.leap.List)new ArrayList());
            } else {
                jade.util.leap.List options = agent.stringToOptions(optString);
                for (Option opt : options) {
                    opt.setNumber_of_values_to_try(this.default_number_of_values_to_try);
                }
                agent.setOptions(options);
            }
            jade.util.leap.List agents = next_problem.getAgents();
            agents.add((Object)agent);
            next_problem.setAgents(agents);
        }
    }

    protected void addOptionToAgent(int _problem_id, int _agent_id, String option_name, String option_value, String lower, String upper, String number_of_values_to_try, String set) {
        System.err.println("Add option to agent");
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (next_problem.getSent() || Integer.parseInt(next_problem.getGui_id()) != _problem_id) continue;
            for (Agent next_agent : next_problem.getAgents()) {
                if (Integer.parseInt(next_agent.getGui_id()) != _agent_id) continue;
                Option option = new Option();
                option.setName(option_name);
                if (option_value == null) {
                    option_value = "True";
                }
                if (option_value.indexOf("?") > -1) {
                    option.setMutable(true);
                    option.setUser_value(option_value);
                    if (lower != null && upper != null) {
                        Interval interval = new Interval();
                        interval.setMin(Float.valueOf(lower));
                        interval.setMax(Float.valueOf(upper));
                        option.setRange(interval);
                        option.setIs_a_set(false);
                    }
                    if (set != null) {
                        String[] set_array = set.replace(" ", "").split(",");
                        ArrayList set_list = new ArrayList();
                        for (int i = 0; i < set_array.length; ++i) {
                            set_list.add((Object)set_array[i]);
                        }
                        option.setSet((jade.util.leap.List)set_list);
                        option.setIs_a_set(true);
                    }
                }
                option.setValue(option_value);
                if (next_problem.getMethod().getName().equals("ChooseXValues")) {
                    if (number_of_values_to_try == null) {
                        option.setNumber_of_values_to_try(this.default_number_of_values_to_try);
                    } else {
                        option.setNumber_of_values_to_try(Integer.parseInt(number_of_values_to_try));
                    }
                }
                jade.util.leap.List options = next_agent.getOptions();
                options.add((Object)option);
                next_agent.setOptions(options);
            }
        }
    }

    protected int addDatasetToProblem(int _problem_id, String _train, String _test, String _label, String _output, String _mode) {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (next_problem.getSent() || Integer.parseInt(next_problem.getGui_id()) != _problem_id) continue;
            jade.util.leap.List data = next_problem.getData();
            Data d = new Data();
            d.setExternal_test_file_name(_test);
            d.setExternal_train_file_name(_train);
            d.setTrain_file_name("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + DataManagerService.translateFilename((jade.core.Agent)this, 1, _train, null));
            d.setTest_file_name("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + DataManagerService.translateFilename((jade.core.Agent)this, 1, _test, null));
            if (_label != null) {
                d.setLabel_file_name("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + DataManagerService.translateFilename((jade.core.Agent)this, 1, _label, null));
            }
            if (_output != null) {
                d.setOutput(_output);
            }
            if (_mode != null) {
                d.setMode(_mode);
            }
            data.add((Object)d);
            next_problem.setData(data);
        }
        return this.data_id++;
    }

    protected void addMetadataToDataset(int d_id, String file_name, String missing_values, String number_of_attributes, String number_of_instances, String attribute_type, String default_task) {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            for (Data next_data : next_problem.getData()) {
                if (next_data.getGui_id() != d_id) continue;
                Metadata m = new Metadata();
                m.setAttribute_type(attribute_type);
                m.setDefault_task(default_task);
                m.setExternal_name(file_name);
                if (missing_values != null) {
                    if (missing_values.equals("True")) {
                        m.setMissing_values(true);
                    } else {
                        m.setMissing_values(false);
                    }
                }
                m.setNumber_of_attributes(Integer.parseInt(number_of_attributes));
                m.setNumber_of_instances(Integer.parseInt(number_of_instances));
                next_data.setMetadata(m);
            }
        }
    }

    protected void addMethodToProblem(int problem_id, String name, String errorRate, String maximumTries) {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (Integer.parseInt(next_problem.getGui_id()) != problem_id || next_problem.getSent()) continue;
            Method method = new Method();
            method.setName(name);
            if (name.equals("Random")) {
                if (errorRate == null) {
                    method.setError_rate(Float.valueOf(this.default_error_rate));
                } else {
                    method.setError_rate(Float.valueOf(Float.parseFloat(errorRate)));
                }
                if (maximumTries == null) {
                    method.setMaximum_tries(this.default_maximum_tries);
                } else {
                    method.setMaximum_tries(Integer.parseInt(maximumTries));
                }
            }
            next_problem.setMethod(method);
        }
    }

    private void checkProblems() {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (next_problem.getSent()) continue;
            boolean done = true;
            for (Agent next_agent : next_problem.getAgents()) {
                String type = "";
                if (next_agent.getType() != null) {
                    type = next_agent.getType();
                }
                if (type.contains("?") && next_agent.getName() == null) continue;
                if (next_agent.getOptions() == null) {
                    next_agent.setOptions((jade.util.leap.List)new ArrayList());
                }
                if (next_agent.getOptions().size() <= 0 || ((Option)next_agent.getOptions().iterator().next()).getData_type() != null) continue;
                done = false;
            }
            if (!done) continue;
            this.allOptionsReceived(Integer.parseInt(next_problem.getGui_id()));
        }
    }

    private void refreshOptions(Agent agent, int performative) {
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (next_problem.getSent()) continue;
            if (performative == 7) {
                for (Agent next_agent : next_problem.getAgents()) {
                    if (next_agent.getName() != null && next_agent.getName().equals(agent.getName())) {
                        next_agent.setType(agent.getType());
                        next_agent.setOptions(this._refreshOptions(next_agent, agent, next_problem));
                    }
                    if (next_agent.getType() == null || !next_agent.getType().equals(agent.getType())) continue;
                    next_agent.setOptions(this._refreshOptions(next_agent, agent, next_problem));
                }
                continue;
            }
            this.removeAgentFromAllProblems(Integer.parseInt(agent.getGui_id()));
        }
    }

    private jade.util.leap.List _refreshOptions(Agent next_agent, Agent agent, Problem next_problem) {
        ArrayList newOptions = null;
        if (agent.getOptions() != null) {
            java.util.ArrayList<Option> mergedOptions = new java.util.ArrayList<Option>();
            for (Option next_option : agent.getOptions()) {
                Option o = new Option();
                o.setData_type(next_option.getData_type());
                o.setDefault_value(next_option.getDefault_value());
                o.setName(next_option.getName());
                o.setNumber_of_args(next_option.getNumber_of_args());
                o.setRange(next_option.getRange());
                o.setSet(next_option.getSet());
                o.setValue(next_option.getDefault_value());
                mergedOptions.add(o);
            }
            for (Option next_problem_option : next_agent.getOptions()) {
                ListIterator<Option> ocaitr = mergedOptions.listIterator();
                while (ocaitr.hasNext()) {
                    Option next_merged_option = (Option)ocaitr.next();
                    if (!next_problem_option.getName().equals(next_merged_option.getName())) continue;
                    if (next_problem_option.getMutable()) {
                        next_merged_option.setMutable(true);
                        next_merged_option.setUser_value(next_problem_option.getValue());
                        if (next_problem_option.getIs_a_set()) {
                            next_merged_option.setIs_a_set(true);
                        }
                        if (next_problem_option.getRange() != null) {
                            next_merged_option.getRange().setMin(next_problem_option.getRange().getMin());
                            next_merged_option.getRange().setMax(next_problem_option.getRange().getMax());
                            next_merged_option.setIs_a_set(false);
                        }
                        next_merged_option.setNumber_of_values_to_try(next_problem_option.getNumber_of_values_to_try());
                    }
                    if (!next_merged_option.getData_type().equals("BOOLEAN") && next_problem_option.getValue().equals("True")) {
                        this.DisplayWrongOption(Integer.parseInt(next_problem.getGui_id()), next_agent.getName(), next_problem_option.getName(), next_problem_option.getName() + " is not a BOOLEAN type option.");
                    } else {
                        next_merged_option.setValue(next_problem_option.getValue());
                    }
                    if (next_problem_option.getSet() != null) {
                        next_merged_option.setSet(next_problem_option.getSet());
                    }
                    if (next_problem_option.getNumber_of_args() != null) {
                        next_merged_option.setNumber_of_args(next_problem_option.getNumber_of_args());
                    }
                    ocaitr.set(next_merged_option);
                }
            }
            ArrayList mergedOptionsArrayList = new ArrayList();
            mergedOptionsArrayList.fromList(mergedOptions);
            newOptions = mergedOptionsArrayList;
        }
        return newOptions;
    }

    protected void createAgentTypesHashMap() {
        this.agentTypes = new HashMap();
        this.agentOptions = new HashMap();
        try {
            FileReader input = new FileReader(this.path + "agent_types");
            BufferedReader bufRead = new BufferedReader(input);
            String line = bufRead.readLine();
            while (line != null) {
                String[] agentClass = line.split(":");
                this.agentTypes.put(agentClass[0], agentClass[1]);
                if (agentClass.length > 2) {
                    Object[] opts = new Object[agentClass.length - 2];
                    for (int i = 0; i < opts.length; ++i) {
                        opts[i] = agentClass[i + 2];
                    }
                    this.agentOptions.put(agentClass[0], opts);
                }
                line = bufRead.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Vector<String> offerAgentTypes() {
        if (this.agentTypes == null) {
            this.createAgentTypesHashMap();
        }
        Vector<String> agents = new Vector<String>();
        agents.addAll(this.agentTypes.keySet());
        return agents;
    }

    protected AID createAgent(String type, String name, Object[] options) {
        AgentContainer container = this.getContainerController();
        try {
            AgentController agent = container.createNewAgent(name, type, options);
            agent.start();
            return new AID(name, false);
        }
        catch (ControllerException e) {
            return null;
        }
    }

    protected AID getAgentByType(String agentType) {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType(agentType);
        template.addServices(sd);
        try {
            DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
            System.out.println("Found the following " + agentType + " agents:");
            AID[] Agents = new AID[result.length];
            for (int i = 0; i < result.length; ++i) {
                Agents[i] = result[i].getName();
                System.out.println(Agents[i].getName());
            }
            if (Agents.length > 0) {
                Random generator = new Random();
                int rnd = generator.nextInt(Agents.length);
                return Agents[rnd];
            }
            return null;
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
            return null;
        }
    }

    protected void setup() {
        this.myAgentName = this.getLocalName();
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        this.addBehaviour((Behaviour)new CompAgentResultsServer((jade.core.Agent)this));
        DFAgentDescription dfd = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType(this.getAgentType());
        sd.setName(this.getName());
        dfd.setName(this.getAID());
        dfd.addServices(sd);
        sd = new ServiceDescription();
        sd.setType("GUIAgent");
        sd.setName(this.getName());
        dfd.addServices(sd);
        try {
            DFService.register((jade.core.Agent)this, (DFAgentDescription)dfd);
        }
        catch (FIPAException e) {
            System.err.println(this.getLocalName() + " registration with DF unsucceeded. Reason: " + e.getMessage());
            this.doDelete();
        }
        String incomingFilesPath = System.getProperty("user.dir") + System.getProperty("file.separator") + "incoming" + System.getProperty("file.separator");
        File incomingFiles = new File(incomingFilesPath);
        int incomingFilesNumber = incomingFiles.list().length;
        int currenInFile = 0;
        for (String fileName : incomingFiles.list()) {
            this.displayFileImportProgress(currenInFile, incomingFilesNumber);
            ++currenInFile;
            DataManagerService.importFile((jade.core.Agent)this, 1, fileName, null);
            String internalFilename = DataManagerService.translateFilename((jade.core.Agent)this, 1, fileName, null);
            internalFilename = "data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + internalFilename;
            sd = new ServiceDescription();
            sd.setType("ARFFReader");
            dfd = new DFAgentDescription();
            dfd.addServices(sd);
            try {
                DFAgentDescription[] readers = DFService.search((jade.core.Agent)this, (DFAgentDescription)dfd);
                if (readers.length == 0) {
                    System.err.println("No readers found");
                    break;
                }
                AID reader = readers[0].getName();
                GetData gd = new GetData();
                gd.setFile_name(internalFilename);
                gd.setSaveMetadata(true);
                Action a = new Action();
                a.setAction((Concept)gd);
                a.setActor(this.getAID());
                ACLMessage req = new ACLMessage(16);
                req.addReceiver(reader);
                req.setLanguage(this.codec.getName());
                req.setOntology(this.ontology.getName());
                req.setProtocol("fipa-request");
                this.getContentManager().fillContent(req, (ContentElement)a);
                ACLMessage response = FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)req);
                if (response.getPerformative() == 7) continue;
                System.err.println("Error reading file");
            }
            catch (Codec.CodecException ce) {
                ce.printStackTrace();
            }
            catch (FIPAException fe) {
                fe.printStackTrace();
            }
            catch (OntologyException oe) {
                oe.printStackTrace();
            }
        }
        this.displayFileImportProgress(incomingFilesNumber, incomingFilesNumber);
        System.out.println("GUI agent " + this.getLocalName() + " is alive and waiting...");
        this.mySetup();
    }

    protected void getProblemsFromXMLFile(String fileName) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build("file:" + System.getProperty("file.separator") + System.getProperty("file.separator") + System.getProperty("user.dir") + System.getProperty("file.separator") + fileName);
        System.out.println("file:\\" + System.getProperty("user.dir") + System.getProperty("file.separator") + fileName);
        Element root_element = doc.getRootElement();
        List _problems = root_element.getChildren("experiment");
        for (Element next_problem : _problems) {
            int p_id = this.createNewProblem(next_problem.getAttributeValue("timeout"), next_problem.getAttributeValue("get_results"));
            List method = next_problem.getChildren("method");
            Iterator m_itr = method.iterator();
            if (method.size() == 0) {
                // empty if block
            }
            if (method.size() > 1) {
                // empty if block
            }
            while (m_itr.hasNext()) {
                Element next_method = (Element)m_itr.next();
                this.addMethodToProblem(p_id, next_method.getAttributeValue("name"), next_method.getAttributeValue("error_rate"), next_method.getAttributeValue("maximum_tries"));
            }
            List dataset = next_problem.getChildren("dataset");
            for (Element next_dataset : dataset) {
                int d_id = this.addDatasetToProblem(p_id, next_dataset.getAttributeValue("train"), next_dataset.getAttributeValue("test"), next_dataset.getAttributeValue("label"), next_dataset.getAttributeValue("output"), next_dataset.getAttributeValue("mode"));
                List metadata = next_dataset.getChildren("metadata");
                if (metadata.size() <= 0) continue;
                Iterator md_itr = metadata.iterator();
                Element next_metadata = (Element)md_itr.next();
                this.addMetadataToDataset(d_id, next_dataset.getAttributeValue("train"), next_metadata.getAttributeValue("missing_values"), next_metadata.getAttributeValue("number_of_attributes"), next_metadata.getAttributeValue("number_of_instances"), next_metadata.getAttributeValue("attribute_type"), next_metadata.getAttributeValue("default_task"));
            }
            List _agents = next_problem.getChildren("agent");
            for (Element next_agent : _agents) {
                String agent_name = next_agent.getAttributeValue("name");
                String agent_type = next_agent.getAttributeValue("type");
                int a_id = -1;
                try {
                    a_id = this.addAgentToProblem(p_id, agent_name, agent_type, null);
                }
                catch (FailureException e) {
                    System.err.println(e.getLocalizedMessage());
                }
                List _options = next_agent.getChildren("parameter");
                for (Element next_option : _options) {
                    this.addOptionToAgent(p_id, a_id, next_option.getAttributeValue("name"), next_option.getAttributeValue("value"), next_option.getAttributeValue("lower"), next_option.getAttributeValue("upper"), next_option.getAttributeValue("number_of_values_to_try"), next_option.getAttributeValue("set"));
                }
            }
        }
    }

    private void updateProblemId(String ids) {
        String[] ID = ids.split(" ");
        String guiId = ID[0];
        String id = ID[1];
        Enumeration<Problem> pe = this.problems.elements();
        while (pe.hasMoreElements()) {
            Problem next_problem = pe.nextElement();
            if (!next_problem.getGui_id().equals(guiId)) continue;
            next_problem.setId(id);
        }
    }

    protected void loadAgent(String _filename, Execute action, byte[] object) throws FIPAException {
        LoadAgent _loadAgent = new LoadAgent();
        _loadAgent.setFilename(_filename);
        _loadAgent.setFirst_action(action);
        _loadAgent.setObject(object);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("agentManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(this.codec.getName());
        request.setConversationId("resurrected-results");
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(this.getAID());
        a.setAction((Concept)_loadAgent);
        try {
            this.getContentManager().fillContent(request, (ContentElement)a);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)request);
    }

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
        Date date = new Date();
        return dateFormat.format(date);
    }

    protected class CompAgentResultsServer
    extends CyclicBehaviour {
        private static final long serialVersionUID = -8456018173216610239L;
        private MessageTemplate partialMsgTemplate;
        private MessageTemplate resurrectedMsgTemplate;
        private MessageTemplate afterTaskMsgTemplate;

        public CompAgentResultsServer(jade.core.Agent agent) {
            super(agent);
            this.partialMsgTemplate = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)7), (MessageTemplate)MessageTemplate.MatchConversationId((String)"partial-results"));
            this.resurrectedMsgTemplate = MessageTemplate.MatchConversationId((String)"resurrected-results");
            this.afterTaskMsgTemplate = MessageTemplate.MatchConversationId((String)"result_after_task");
        }

        public void action() {
            ACLMessage res = Agent_GUI.this.receive(this.resurrectedMsgTemplate);
            ACLMessage par = Agent_GUI.this.receive(this.partialMsgTemplate);
            ACLMessage aft = Agent_GUI.this.receive(this.afterTaskMsgTemplate);
            if (res != null) {
                Agent_GUI.this.displayResurrectedResult(res);
                return;
            }
            if (par != null) {
                Agent_GUI.this.displayPartialResult(par);
                return;
            }
            if (aft != null) {
                Agent_GUI.this.displayTaskResult(aft);
                return;
            }
            this.block();
        }
    }
}

