/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.gui.GuiEvent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREResponder;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.util.Vector;
import pikater.Agent_GUI;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Results;
import pikater.ontology.messages.Task;
import pikater.ontology.webservices.GetAgents;
import pikater.ontology.webservices.GetOptions;
import pikater.ontology.webservices.GetResults;
import pikater.ontology.webservices.Option;
import pikater.ontology.webservices.SetProblem;
import pikater.ontology.webservices.WS_Ontology;
import pikater.ontology.webservices.WS_Results;

public class Agent_GUI_WS
extends Agent_GUI {
    private static final long serialVersionUID = -5322630455326259706L;
    private LinkedList results = new LinkedList();
    private Codec codec;
    private Ontology wsOntology;
    private Ontology messagesOntology;

    protected void displayResult(ACLMessage inform) {
        this.displayPartialResult(inform);
        System.out.println("Displaying the result ;)");
    }

    protected String getAgentType() {
        return "WS GUI Agent";
    }

    protected void mySetup() {
        this.wsOntology = WS_Ontology.getInstance();
        this.messagesOntology = MessagesOntology.getInstance();
        this.codec = new SLCodec();
        this.getContentManager().registerOntology(this.wsOntology);
        this.getContentManager().registerOntology(this.messagesOntology);
        DFAgentDescription df = new DFAgentDescription();
        df.setName(this.getAID());
        try {
            df = DFService.search((jade.core.Agent)this, (DFAgentDescription)df)[0];
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        ServiceDescription sd = new ServiceDescription();
        sd.addOntologies("WS_Ontology");
        sd.addLanguages(this.codec.getName());
        sd.addProtocols("fipa-request");
        sd.addProperties(new Property("wsig", (Object)"true"));
        sd.setType("WS_GUI_Agent");
        sd.setName("WS_GUI");
        df.addOntologies(this.wsOntology.getName());
        df.addServices(sd);
        try {
            DFService.modify((jade.core.Agent)this, (DFAgentDescription)df);
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        MessageTemplate mt = MessageTemplate.MatchOntology((String)"WS_Ontology");
        this.addBehaviour((Behaviour)new AchieveREResponder((jade.core.Agent)this, mt){
            private static final long serialVersionUID = -5929855198528929475L;

            protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
                return null;
            }

            protected ACLMessage handleRequest(ACLMessage request) {
                try {
                    System.err.print("Agent " + this.myAgent.getName() + ":");
                    Action a = (Action)Agent_GUI_WS.this.getContentManager().extractContent(request);
                    if (a.getAction() instanceof SetProblem) {
                        SetProblem sp = (SetProblem)a.getAction();
                        Iterator it = sp.getFileNames().iterator();
                        int problemID = Agent_GUI_WS.this.createNewProblem("30000", null);
                        while (it.hasNext()) {
                            String s = (String)it.next();
                            Agent_GUI_WS.this.addDatasetToProblem(problemID, s, s, null, null, null);
                        }
                        it = sp.getAgentDescriptions().iterator();
                        try {
                            while (it.hasNext()) {
                                String[] params = ((String)it.next()).split("[ ]+", 2);
                                Agent_GUI_WS.this.addAgentToProblem(problemID, null, params[0], params[1]);
                            }
                        }
                        catch (FailureException e) {
                            e.printStackTrace();
                        }
                        ACLMessage response = request.createReply();
                        response.setPerformative(7);
                        response.setContent("OK");
                        return response;
                    }
                    if (a.getAction() instanceof GetAgents) {
                        Vector<String> agents = Agent_GUI_WS.this.offerAgentTypes();
                        ArrayList agentsList = new ArrayList();
                        for (String s : agents) {
                            agentsList.add((Object)s);
                        }
                        ACLMessage response = request.createReply();
                        response.setPerformative(7);
                        Result r = new Result(a.getAction(), (Object)agentsList);
                        Agent_GUI_WS.this.getContentManager().fillContent(response, (ContentElement)r);
                        return response;
                    }
                    if (a.getAction() instanceof GetResults) {
                        Results r2;
                        ACLMessage response = request.createReply();
                        response.setPerformative(7);
                        ArrayList res = new ArrayList();
                        for (Results r2 : Agent_GUI_WS.this.results) {
                            for (Task t : r2.getResults()) {
                                WS_Results wres = new WS_Results();
                                wres.setOptions(t.getAgent().optionsToString());
                                wres.setErrorRate(t.getResult().getError_rate());
                                res.add((Object)wres);
                            }
                        }
                        r2 = new Result(a.getAction(), (Object)res);
                        Agent_GUI_WS.this.getContentManager().fillContent(response, (ContentElement)r2);
                        return response;
                    }
                    if (a.getAction() instanceof GetOptions) {
                        ACLMessage response = request.createReply();
                        GetOptions go = (GetOptions)a.getAction();
                        String agentName = Agent_GUI_WS.this.getAgentByType(go.getAgentName()).getLocalName();
                        Agent ag = Agent_GUI_WS.this.onlyGetAgentOptions(agentName);
                        if (ag == null) {
                            response.setPerformative(6);
                            return response;
                        }
                        List mOptions = ag.getOptions();
                        ArrayList options = new ArrayList();
                        for (pikater.ontology.messages.Option o : mOptions) {
                            String name = o.getName();
                            String synopsis = o.getSynopsis();
                            String description = o.getDescription();
                            String value = o.getValue();
                            options.add((Object)new Option(name, synopsis, description, value));
                        }
                        response.setPerformative(7);
                        Result r = new Result(a.getAction(), (Object)options);
                        Agent_GUI_WS.this.getContentManager().fillContent(response, (ContentElement)r);
                        return response;
                    }
                }
                catch (UngroundedException e) {
                    e.printStackTrace();
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private Agent onlyGetAgentOptions(String agent) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID(agent, false));
        request.setProtocol("fipa-request");
        request.setLanguage(this.codec.getName());
        request.setOntology(this.messagesOntology.getName());
        pikater.ontology.messages.GetOptions get = new pikater.ontology.messages.GetOptions();
        Action a = new Action();
        a.setAction((Concept)get);
        a.setActor(this.getAID());
        try {
            this.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)request);
            if (inform == null) {
                return null;
            }
            Result r = (Result)this.getContentManager().extractContent(inform);
            return (Agent)r.getItems().get(0);
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        return null;
    }

    protected void displayPartialResult(ACLMessage inform) {
        try {
            Result r = (Result)this.getContentManager().extractContent(inform);
            this.results.add(r.getValue());
        }
        catch (UngroundedException e) {
            e.printStackTrace();
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
    }

    protected void allOptionsReceived(int problemId) {
        this.sendProblem(problemId);
    }

    protected void DisplayWrongOption(int problemGuiId, String agentName, String optionName, String errorMessage) {
    }

    private String optionsToWekaString(List options) {
        Iterator it = options.iterator();
        String str = "";
        while (it.hasNext()) {
            pikater.ontology.messages.Option o = (pikater.ontology.messages.Option)it.next();
            str = str + "-" + o.getName() + " " + o.getValue() + " ";
        }
        return str.trim();
    }

    protected void onGuiEvent(GuiEvent arg0) {
    }

    protected void displayResurrectedResult(ACLMessage inform) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void displayFileImportProgress(int completed, int all) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void displayTaskResult(ACLMessage inform) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

