/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.core.behaviours.Behaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.AchieveREInitiator;
import jade.proto.AchieveREResponder;
import jade.proto.SubscriptionResponder;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.wrapper.AgentContainer;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;
import jade.wrapper.StaleProxyException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import pikater.DataManagerService;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.Computation;
import pikater.ontology.messages.Compute;
import pikater.ontology.messages.Data;
import pikater.ontology.messages.Evaluation;
import pikater.ontology.messages.GetOptions;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Metadata;
import pikater.ontology.messages.Option;
import pikater.ontology.messages.Problem;
import pikater.ontology.messages.Results;
import pikater.ontology.messages.Solve;
import pikater.ontology.messages.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent_Manager
extends jade.core.Agent {
    private HashMap<String, String> agentTypes = new HashMap();
    private HashMap<String, Object[]> agentOptions = new HashMap();
    private static final long serialVersionUID = -5140758757320827589L;
    private String path = System.getProperty("user.dir") + System.getProperty("file.separator");
    private int problem_i = 0;
    private long timeout = 10000L;
    private Codec codec = new SLCodec();
    private Ontology ontology = MessagesOntology.getInstance();
    private Set subscriptions = new HashSet();
    double minAttributes = 2.147483647E9;
    double maxAttributes = -2.147483648E9;
    double minInstances = 2.147483647E9;
    double maxInstances = -2.147483648E9;
    Vector<AID> busyAgents = new Vector();

    public Agent_Manager() {
        try {
            FileReader input = new FileReader(this.path + "agent_types");
            BufferedReader bufRead = new BufferedReader(input);
            String line = bufRead.readLine();
            while (line != null) {
                String[] agentClass = line.split(":");
                this.agentTypes.put(agentClass[0], agentClass[1]);
                if (agentClass.length > 2) {
                    Object[] opts = new Object[agentClass.length - 2];
                    for (int i = 0; i < opts.length; ++i) {
                        opts[i] = agentClass[i + 2];
                    }
                    this.agentOptions.put(agentClass[0], opts);
                }
                line = bufRead.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.agentTypes.put("ChooseXValues", "pikater.Agent_ChooseXValues");
        this.agentTypes.put("Random", "pikater.Agent_Random");
    }

    protected void setup() {
        this.getContentManager().registerLanguage(this.codec);
        this.getContentManager().registerOntology(this.ontology);
        DFAgentDescription dfd = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("Manager");
        sd.setName(this.getName());
        dfd.setName(this.getAID());
        dfd.addServices(sd);
        try {
            DFService.register((jade.core.Agent)this, (DFAgentDescription)dfd);
        }
        catch (FIPAException e) {
            System.err.println(this.getLocalName() + " registration with DF unsucceeded. Reason: " + e.getMessage());
            this.doDelete();
        }
        System.out.println("Manager " + this.getLocalName() + " is alive and waiting...");
        SubscriptionResponder.SubscriptionManager subscriptionManager = new SubscriptionResponder.SubscriptionManager(){

            public boolean register(SubscriptionResponder.Subscription s) {
                Agent_Manager.this.subscriptions.add(s);
                return true;
            }

            public boolean deregister(SubscriptionResponder.Subscription s) {
                Agent_Manager.this.subscriptions.remove(s);
                return true;
            }
        };
        MessageTemplate mt = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchOntology((String)this.ontology.getName()), (MessageTemplate)MessageTemplate.or((MessageTemplate)MessageTemplate.MatchPerformative((int)19), (MessageTemplate)MessageTemplate.MatchPerformative((int)2)));
        SubscriptionResponder send_results = new SubscriptionResponder(this, mt, subscriptionManager){};
        this.addBehaviour((Behaviour)send_results);
        MessageTemplate template_inform = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchProtocol((String)"fipa-request"), (MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchPerformative((int)16), (MessageTemplate)MessageTemplate.and((MessageTemplate)MessageTemplate.MatchLanguage((String)this.codec.getName()), (MessageTemplate)MessageTemplate.MatchOntology((String)this.ontology.getName()))));
        AchieveREResponder receive_problem = new AchieveREResponder(this, template_inform){

            protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
                System.out.println("Agent " + Agent_Manager.this.getLocalName() + ": REQUEST received from " + request.getSender().getName());
                ACLMessage agree = request.createReply();
                agree.setPerformative(1);
                try {
                    ContentElement content = Agent_Manager.this.getContentManager().extractContent(request);
                    if (((Action)content).getAction() instanceof Solve) {
                        Action action = (Action)content;
                        Solve solve = (Solve)action.getAction();
                        Problem problem = solve.getProblem();
                        agree.setContent(problem.getGui_id() + " " + Agent_Manager.this.generateProblemID());
                        return agree;
                    }
                }
                catch (UngroundedException e) {
                    e.printStackTrace();
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
                agree.setPerformative(14);
                return agree;
            }

            protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) throws FailureException {
                Agent_Manager.this.addBehaviour((Behaviour)new SendComputation(this.myAgent, request, response));
                return null;
            }
        };
        this.addBehaviour((Behaviour)receive_problem);
    }

    protected Vector<ACLMessage> prepareComputations(SendComputation behav, ACLMessage request, String problemId, ACLMessage failure) {
        Vector<ACLMessage> msgVector = new Vector<ACLMessage>();
        try {
            ContentElement content = this.getContentManager().extractContent(request);
            System.out.println("Agent " + this.getLocalName() + ": " + content);
            if (((Action)content).getAction() instanceof Solve) {
                Action action = (Action)content;
                Solve solve = (Solve)action.getAction();
                Problem problem = solve.getProblem();
                problem.setId(problemId);
                int computation_i = 0;
                for (Data next_data : problem.getData()) {
                    if (next_data.getMetadata() != null) {
                        next_data.getMetadata().setInternal_name(next_data.getTrain_file_name());
                    }
                    for (Agent a_next : problem.getAgents()) {
                        Agent a_next_copy = new Agent();
                        a_next_copy.setGui_id(a_next.getGui_id());
                        a_next_copy.setName(a_next.getName());
                        a_next_copy.setOptions(a_next.getOptions());
                        a_next_copy.setType(a_next.getType());
                        if (a_next_copy.getName() == null) {
                            String agentType = a_next.getType();
                            boolean getOptions = false;
                            if (agentType.contains("?")) {
                                Metadata metadata;
                                if (next_data.getMetadata() == null) {
                                    metadata = new Metadata();
                                    metadata.setInternal_name(next_data.getTest_file_name());
                                } else {
                                    metadata = next_data.getMetadata();
                                }
                                a_next = this.chooseTheBestAgent(metadata);
                                if (a_next == null) {
                                    ACLMessage msg = new ACLMessage(6);
                                    msg.setContent("No metadata available.");
                                    behav.sendSubscription(msg);
                                } else {
                                    getOptions = true;
                                    agentType = a_next.getType();
                                    a_next_copy.setType(agentType);
                                }
                            }
                            if (a_next != null) {
                                AID aid = null;
                                String agentName = null;
                                while (aid == null) {
                                    aid = this.getAgentByType(agentType);
                                }
                                if (aid == null) {
                                    ACLMessage msg = new ACLMessage(6);
                                    msg.setContent(agentType + " agent could not be created.");
                                    behav.sendSubscription(msg);
                                } else {
                                    agentName = aid.getLocalName();
                                    a_next_copy.setName(agentName);
                                    if (getOptions) {
                                        Agent agent_options = this.onlyGetAgentOptions(agentName);
                                        a_next_copy.setOptions(this.mergeOptions(agent_options.getOptions(), a_next.getOptions()));
                                        System.out.println("********** Agent " + agentType + " recommended. Options: " + a_next_copy.optionsToString() + "**********");
                                    }
                                }
                            }
                        }
                        if (a_next == null) continue;
                        Computation computation = new Computation();
                        computation.setAgent(a_next_copy);
                        computation.setData(next_data);
                        computation.setProblem_id(problemId);
                        computation.setId(problemId + "_" + computation_i);
                        computation.setTimeout(problem.getTimeout());
                        computation.setMethod(problem.getMethod());
                        computation.setStart(problem.getStart());
                        computation.setGet_results(problem.getGet_results());
                        computation.setGui_agent(problem.getGui_agent());
                        ++computation_i;
                        msgVector.add(this.Compute(computation));
                    }
                    if (next_data.getMetadata() == null) continue;
                    DataManagerService.saveMetadata(this, next_data.getMetadata());
                }
            }
        }
        catch (UngroundedException e) {
            e.printStackTrace();
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        return msgVector;
    }

    private List mergeOptions(List o1_CA, List o2) {
        ArrayList new_options = new ArrayList();
        if (o1_CA != null) {
            for (Option next_option : o2) {
                for (Option next_CA_option : o1_CA) {
                    if (!next_option.getName().equals(next_CA_option.getName())) continue;
                    next_CA_option.setValue(next_option.getValue());
                    next_CA_option.setMutable(false);
                    new_options.add((Object)next_CA_option);
                }
            }
        }
        return new_options;
    }

    private boolean isBusy(AID agent) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(agent);
        request.setProtocol("fipa-request");
        request.setLanguage(this.codec.getName());
        request.setOntology(this.ontology.getName());
        request.setReplyByDate(new Date(System.currentTimeMillis() + 200L));
        GetOptions get = new GetOptions();
        Action a = new Action();
        a.setAction((Concept)get);
        a.setActor(this.getAID());
        try {
            this.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage r = FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)request);
            if (r != null) {
                return false;
            }
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        return true;
    }

    public AID getAgentByType(String agentType) {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType(agentType);
        template.addServices(sd);
        try {
            int i;
            DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
            System.out.println("Found the following " + agentType + " agents:");
            AID[] Agents = new AID[result.length];
            for (i = 0; i < result.length; ++i) {
                Agents[i] = result[i].getName();
                System.out.println(Agents[i].getName());
            }
            if (Agents.length == 0) {
                String agentName = this.generateName(agentType);
                AID a = this.createAgent(this.agentTypes.get(agentType), agentName, this.agentOptions.get(agentType));
                this.busyAgents.add(a);
                return a;
            }
            for (i = 0; i < Agents.length && (this.isBusy(Agents[i]) || this.busyAgents.contains(Agents[i])); ++i) {
            }
            if (i < Agents.length) {
                this.busyAgents.add(Agents[i]);
                return Agents[i];
            }
            String agentName = this.generateName(agentType);
            AID a = this.createAgent(this.agentTypes.get(agentType), agentName, this.agentOptions.get(agentType));
            this.busyAgents.add(a);
            return a;
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
            return null;
        }
    }

    public Vector<String> offerAgentTypes() {
        return new Vector<String>(this.agentTypes.keySet());
    }

    private Agent onlyGetAgentOptions(String agent) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID(agent, false));
        request.setProtocol("fipa-request");
        request.setLanguage(this.codec.getName());
        request.setOntology(this.ontology.getName());
        GetOptions get = new GetOptions();
        Action a = new Action();
        a.setAction((Concept)get);
        a.setActor(this.getAID());
        try {
            this.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)this, (ACLMessage)request);
            if (inform == null) {
                return null;
            }
            Result r = (Result)this.getContentManager().extractContent(inform);
            return (Agent)r.getItems().get(0);
        }
        catch (Codec.CodecException ce) {
            ce.printStackTrace();
        }
        catch (OntologyException oe) {
            oe.printStackTrace();
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        return null;
    }

    public String generateName(String agentType) {
        int number = 0;
        String name = agentType + number;
        boolean success = false;
        while (!success) {
            DFAgentDescription template = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setName(name);
            template.addServices(sd);
            try {
                DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
                if (result.length > 0) {
                    name = agentType + ++number;
                    continue;
                }
                success = true;
                return name;
            }
            catch (FIPAException fe) {
                fe.printStackTrace();
            }
        }
        return null;
    }

    public boolean exists(String name) {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setName(name);
        template.addServices(sd);
        try {
            DFAgentDescription[] result = DFService.search((jade.core.Agent)this, (DFAgentDescription)template);
            if (result.length > 0) {
                return true;
            }
        }
        catch (FIPAException fe) {
            fe.printStackTrace();
        }
        return false;
    }

    public AID createAgent(String type, String name, Object[] options) {
        AgentContainer container = this.getContainerController();
        try {
            AgentController agent = container.createNewAgent(name, type, options);
            agent.start();
            return new AID(name, false);
        }
        catch (ControllerException e) {
            System.err.println("Exception while adding agent: " + (Object)((Object)e));
            e.printStackTrace();
            return null;
        }
    }

    protected ACLMessage Compute(Computation computation) {
        String option_manager_name = computation.getId();
        AgentContainer container = this.getContainerController();
        try {
            AgentController agent = container.createNewAgent(option_manager_name, this.agentTypes.get(computation.getMethod().getName()), (Object[])new String[0]);
            agent.start();
        }
        catch (Exception e) {
            System.err.println("Exception while adding agent" + computation.getId() + ": " + e);
            e.printStackTrace();
        }
        ACLMessage msg = new ACLMessage(16);
        msg.setLanguage(this.codec.getName());
        msg.setOntology(this.ontology.getName());
        try {
            Compute compute = new Compute();
            compute.setComputation(computation);
            Action a = new Action();
            a.setAction((Concept)compute);
            a.setActor(this.getAID());
            this.getContentManager().fillContent(msg, (ContentElement)a);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        msg.addReceiver(new AID(option_manager_name, false));
        msg.setProtocol("fipa-request");
        msg.setReplyByDate(new Date(System.currentTimeMillis() + 10000L));
        return msg;
    }

    protected Results prepareComputationResults(ACLMessage result) {
        Results results = null;
        try {
            Result _result;
            ContentElement content = this.getContentManager().extractContent(result);
            if (content instanceof Result && (_result = (Result)content).getValue() instanceof Results) {
                results = (Results)_result.getValue();
                List listOfResults = results.getResults();
                float sumError_rate = 0.0f;
                float sumKappa_statistic = 0.0f;
                float sumMean_absolute_error = 0.0f;
                float sumRoot_mean_squared_error = 0.0f;
                float sumRelative_absolute_error = 0.0f;
                float sumRoot_relative_squared_error = 0.0f;
                if (listOfResults == null) {
                    return null;
                }
                for (Task next : listOfResults) {
                    Evaluation evaluation;
                    if (next.getResult() == null) {
                        evaluation = new Evaluation();
                        evaluation.setError_rate(2.1474836E9f);
                        next.setResult(evaluation);
                    } else {
                        evaluation = next.getResult();
                    }
                    sumError_rate += evaluation.getError_rate();
                    sumKappa_statistic += evaluation.getKappa_statistic();
                    sumMean_absolute_error += evaluation.getMean_absolute_error();
                    sumRoot_mean_squared_error += evaluation.getRoot_mean_squared_error();
                    sumRelative_absolute_error += evaluation.getRelative_absolute_error();
                    sumRoot_relative_squared_error += evaluation.getRoot_relative_squared_error();
                }
                if (sumError_rate > -1.0f) {
                    results.setAvg_error_rate(sumError_rate / (float)listOfResults.size());
                }
                if (sumKappa_statistic > -1.0f) {
                    results.setAvg_kappa_statistic(sumKappa_statistic / (float)listOfResults.size());
                }
                if (sumMean_absolute_error > -1.0f) {
                    results.setAvg_mean_absolute_error(sumMean_absolute_error / (float)listOfResults.size());
                }
                if (sumRoot_mean_squared_error > -1.0f) {
                    results.setAvg_root_mean_squared_error(sumRoot_mean_squared_error / (float)listOfResults.size());
                }
                if (sumRelative_absolute_error > -1.0f) {
                    results.setAvg_relative_absolute_error(sumRelative_absolute_error / (float)listOfResults.size());
                }
                if (sumRoot_relative_squared_error > -1.0f) {
                    results.setAvg_root_relative_squared_error(sumRoot_relative_squared_error / (float)listOfResults.size());
                }
            }
        }
        catch (UngroundedException e) {
        }
        catch (Codec.CodecException e) {
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        return results;
    }

    protected boolean writeXMLResults(Results results) {
        boolean success;
        String file_name = "xml" + System.getProperty("file.separator") + results.getComputation_id() + ".xml";
        boolean exists = new File("xml").exists();
        if (!exists && !(success = new File("xml").mkdir())) {
            System.out.println("Directory: xml could not be created");
        }
        Document doc = new Document(new Element("result"));
        Element root = doc.getRootElement();
        List _results = results.getResults();
        if (_results != null) {
            for (Task next_task : _results) {
                Agent agent = next_task.getAgent();
                Element newExperiment = new Element("experiment");
                Element newSetting = new Element("setting");
                Element newAlgorithm = new Element("algorithm");
                newAlgorithm.setAttribute("name", agent.getName());
                newAlgorithm.setAttribute("libname", "weka");
                List Options = agent.getOptions();
                if (Options != null) {
                    for (Option next_o : Options) {
                        Element newParameter = new Element("parameter");
                        newParameter.setAttribute("name", next_o.getName());
                        String value = "";
                        if (next_o.getValue() != null) {
                            value = next_o.getValue();
                        }
                        newParameter.setAttribute("value", value);
                        newAlgorithm.addContent((Content)newParameter);
                    }
                }
                Element newDataSet = new Element("dataset");
                newDataSet.setAttribute("train", next_task.getData().getExternal_train_file_name());
                newDataSet.setAttribute("test", next_task.getData().getExternal_test_file_name());
                Element newEvaluation = new Element("evaluation");
                Element newMetric1 = new Element("metric");
                newMetric1.setAttribute("error_rate", this.getXMLValue(next_task.getResult().getError_rate()));
                Element newMetric2 = new Element("metric");
                newMetric2.setAttribute("kappa_statistic", this.getXMLValue(next_task.getResult().getKappa_statistic()));
                Element newMetric3 = new Element("metric");
                newMetric3.setAttribute("mean_absolute_error", this.getXMLValue(next_task.getResult().getMean_absolute_error()));
                Element newMetric4 = new Element("metric");
                newMetric4.setAttribute("root_mean_squared_error", this.getXMLValue(next_task.getResult().getRoot_mean_squared_error()));
                Element newMetric5 = new Element("metric");
                newMetric5.setAttribute("relative_absolute_error", this.getXMLValue(next_task.getResult().getRelative_absolute_error()));
                Element newMetric6 = new Element("metric");
                newMetric6.setAttribute("root_relative_squared_error", this.getXMLValue(next_task.getResult().getRoot_relative_squared_error()));
                newEvaluation.addContent((Content)newMetric1);
                newEvaluation.addContent((Content)newMetric2);
                newEvaluation.addContent((Content)newMetric3);
                newEvaluation.addContent((Content)newMetric4);
                newEvaluation.addContent((Content)newMetric5);
                newEvaluation.addContent((Content)newMetric6);
                newExperiment.addContent((Content)newSetting);
                newExperiment.addContent((Content)newEvaluation);
                newSetting.addContent((Content)newAlgorithm);
                newSetting.addContent((Content)newDataSet);
                root.addContent((Content)newExperiment);
            }
        }
        Element newStatistics = new Element("statistics");
        Element newMetric1 = new Element("metric");
        newMetric1.setAttribute("average_error_rate", this.getXMLValue(results.getAvg_error_rate()));
        Element newMetric2 = new Element("metric");
        newMetric2.setAttribute("average_kappa_statistic", this.getXMLValue(results.getAvg_kappa_statistic()));
        Element newMetric3 = new Element("metric");
        newMetric3.setAttribute("average_mean_absolute_error", this.getXMLValue(results.getAvg_mean_absolute_error()));
        Element newMetric4 = new Element("metric");
        newMetric4.setAttribute("average_root_mean_squared_error", this.getXMLValue(results.getAvg_root_mean_squared_error()));
        Element newMetric5 = new Element("metric");
        newMetric5.setAttribute("average_relative_absolute_error", this.getXMLValue(results.getAvg_relative_absolute_error()));
        Element newMetric6 = new Element("metric");
        newMetric6.setAttribute("average_root_relative_squared_error", this.getXMLValue(results.getAvg_root_relative_squared_error()));
        newStatistics.addContent((Content)newMetric1);
        newStatistics.addContent((Content)newMetric2);
        newStatistics.addContent((Content)newMetric3);
        newStatistics.addContent((Content)newMetric4);
        newStatistics.addContent((Content)newMetric5);
        newStatistics.addContent((Content)newMetric6);
        root.addContent((Content)newStatistics);
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        try {
            FileWriter fw = new FileWriter(file_name);
            BufferedWriter fout = new BufferedWriter(fw);
            out.output(root, (Writer)fout);
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String getXMLValue(float value) {
        if (value < 0.0f) {
            return "NA";
        }
        return Double.toString(value);
    }

    private Agent chooseTheBestAgent(Metadata metadata) {
        boolean hasMetadata = false;
        if (metadata.getNumber_of_attributes() > -1 && metadata.getNumber_of_instances() > -1) {
            hasMetadata = true;
        }
        List allMetadata = DataManagerService.getAllMetadata(this);
        for (Metadata next_md : allMetadata) {
            int ni;
            int na;
            if (!hasMetadata && ("data" + System.getProperty("file.separator") + "files" + System.getProperty("file.separator") + next_md.getInternal_name()).equals(metadata.getInternal_name())) {
                metadata = next_md;
                hasMetadata = true;
            }
            if ((double)(na = next_md.getNumber_of_attributes()) < this.minAttributes) {
                this.minAttributes = na;
            }
            if ((double)na > this.maxAttributes) {
                this.maxAttributes = na;
            }
            if ((double)(ni = next_md.getNumber_of_instances()) < this.minInstances) {
                this.minInstances = ni;
            }
            if (!((double)ni > this.maxInstances)) continue;
            this.maxInstances = ni;
        }
        if (!hasMetadata) {
            return null;
        }
        System.out.println("*********** files from the table: ");
        double d_best = 2.147483647E9;
        Metadata m_best = null;
        for (Metadata next_md : allMetadata) {
            double d_new = this.distance(metadata, next_md);
            if (next_md.getNumber_of_tasks_in_db() > 0 && d_new < d_best) {
                d_best = d_new;
                m_best = next_md;
            }
            System.out.println("    " + next_md.getExternal_name() + " d: " + d_new);
        }
        System.out.println("Nearest file: " + m_best.getExternal_name());
        String nearestInternalName = m_best.getInternal_name();
        Agent agent = DataManagerService.getTheBestAgent(this, nearestInternalName);
        if (agent == null) {
            return null;
        }
        agent.setName(null);
        return agent;
    }

    private double distance(Metadata m1, Metadata m2) {
        double wAttribute_type = 1.0;
        double wDefault_task = 1.0;
        double wMissing_values = 1.0;
        double wNumber_of_attributes = 1.0;
        double wNumber_of_instances = 1.0;
        double dAttribute_type = this.dCategory(m1.getAttribute_type(), m2.getAttribute_type());
        double dDefault_task = this.dCategory(m1.getDefault_task(), m2.getDefault_task());
        double dMissing_values = this.dBoolean(m1.getMissing_values(), m2.getMissing_values());
        double dNumber_of_attributes = this.d(m1.getNumber_of_attributes(), m2.getNumber_of_attributes(), this.minAttributes, this.maxAttributes);
        double dNumber_of_instances = this.d(m1.getNumber_of_instances(), m2.getNumber_of_instances(), this.minInstances, this.maxInstances);
        double distance = wAttribute_type * dAttribute_type + wDefault_task * dDefault_task + wMissing_values * dMissing_values + wNumber_of_attributes * dNumber_of_attributes + wNumber_of_instances * dNumber_of_instances;
        return distance;
    }

    private double d(double v1, double v2, double min, double max) {
        return Math.abs(v1 - v2) / (max - min);
    }

    private int dCategory(String v1, String v2) {
        if (v1 == null) {
            v1 = "null";
        }
        if (v2 == null) {
            v2 = "null";
        }
        if (v1.equals(v2)) {
            return 0;
        }
        return 1;
    }

    private int dBoolean(Boolean v1, Boolean v2) {
        if (v1 == v2) {
            return 0;
        }
        return 1;
    }

    protected String generateProblemID() {
        Date date = new Date();
        String problem_id = Long.toString(date.getTime()) + "_" + this.problem_i;
        ++this.problem_i;
        return problem_id;
    }

    private class SendComputation
    extends AchieveREInitiator {
        private static final long serialVersionUID = 8907460263463109088L;
        private ACLMessage failure;
        private ACLMessage incomingRequest;
        private ACLMessage incomingResponse;
        private String parentConversationID;

        public SendComputation(jade.core.Agent a, ACLMessage request, ACLMessage response) {
            super(a, request);
            this.failure = null;
            this.incomingRequest = null;
            this.incomingResponse = null;
            this.incomingRequest = request;
            this.incomingResponse = response;
            this.parentConversationID = this.incomingRequest.getConversationId();
            System.out.println(a.getLocalName() + ": SendComputation behavior created.");
        }

        protected Vector prepareRequests(ACLMessage request) {
            String[] ID = this.incomingResponse.getContent().split(" ");
            String problemId = ID[1];
            Vector<ACLMessage> v = Agent_Manager.this.prepareComputations(this, this.incomingRequest, problemId, this.failure);
            if (v.size() == 0) {
                this.storeNotification(6);
            }
            return v;
        }

        protected void handleInform(ACLMessage inform) {
            System.out.println("Agent:" + Agent_Manager.this.getLocalName() + ": Agent " + inform.getSender().getName() + " sent an inform.");
            this.sendSubscription(inform);
        }

        protected void handleFailure(ACLMessage failure) {
            System.out.println("Agent:" + Agent_Manager.this.getLocalName() + ": Agent " + failure.getSender().getName() + " sent a failure.");
            if (failure.getSender().equals((Object)this.myAgent.getAMS())) {
                System.out.println("Responder does not exist");
            } else {
                System.out.println("Agent " + failure.getSender().getName() + " failed to perform the requested action");
            }
            this.sendSubscription(failure);
        }

        protected void handleAllResultNotifications(Vector resultNotifications) {
            if (resultNotifications.size() == 0) {
                this.storeNotification(6);
            } else {
                this.storeNotification(7);
            }
        }

        private void sendSubscription(ACLMessage result) {
            ACLMessage msgOut = this.incomingRequest.createReply();
            msgOut.setPerformative(result.getPerformative());
            String problemGuiId = null;
            Results results = Agent_Manager.this.prepareComputationResults(result);
            if (results != null) {
                Iterator resIterator = results.getResults().iterator();
                while (resIterator.hasNext()) {
                    DataManagerService.saveResult(this.myAgent, (Task)resIterator.next());
                }
                Agent_Manager.this.writeXMLResults(results);
                msgOut.setPerformative(7);
                try {
                    ContentElement content = Agent_Manager.this.getContentManager().extractContent(this.incomingRequest);
                    if (((Action)content).getAction() instanceof Solve) {
                        Solve solve = (Solve)((Action)content).getAction();
                        problemGuiId = solve.getProblem().getGui_id();
                    }
                    Result _result = new Result((Concept)((Action)content), (Object)results);
                    Agent_Manager.this.getContentManager().fillContent(msgOut, (ContentElement)_result);
                }
                catch (UngroundedException e) {
                    e.printStackTrace();
                }
                catch (Codec.CodecException e) {
                    e.printStackTrace();
                }
                catch (OntologyException e) {
                    e.printStackTrace();
                }
            } else {
                msgOut.setPerformative(6);
                msgOut.setContent(result.getContent());
            }
            for (SubscriptionResponder.Subscription subscription : Agent_Manager.this.subscriptions) {
                if (!subscription.getMessage().getConversationId().equals("subscription" + this.incomingRequest.getConversationId())) continue;
                subscription.notify(msgOut);
            }
            try {
                String name = ((Task)results.getResults().iterator().next()).getAgent().getName();
                Agent_Manager.this.busyAgents.remove(new AID(name, false));
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        private void storeNotification(int performative) {
            ACLMessage msgOut = this.incomingRequest.createReply();
            msgOut.setPerformative(performative);
            if (performative == 6) {
                System.out.println("Agent: " + Agent_Manager.this.getLocalName() + ": no results from the option managers received.");
                msgOut.setContent("No results from the option managers received");
            } else {
                System.out.println("Agent: " + Agent_Manager.this.getLocalName() + ": all results sent.");
                msgOut.setContent("Finished");
            }
            Agent_Manager.this.send(msgOut);
        }

        private void killAgent(String name) {
            System.out.println("Agent:" + Agent_Manager.this.getLocalName() + ": Agent " + name + " is being killed.");
            AgentContainer container = Agent_Manager.this.getContainerController();
            try {
                container.getAgent(name).kill();
            }
            catch (StaleProxyException e) {
                e.printStackTrace();
            }
            catch (ControllerException e) {
                e.printStackTrace();
            }
        }
    }
}

