/*
 * Decompiled with CFR 0.152.
 */
package pikater;

import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.DeleteTempFiles;
import pikater.ontology.messages.GetAllMetadata;
import pikater.ontology.messages.GetFileInfo;
import pikater.ontology.messages.GetFiles;
import pikater.ontology.messages.GetTheBestAgent;
import pikater.ontology.messages.ImportFile;
import pikater.ontology.messages.MessagesOntology;
import pikater.ontology.messages.Metadata;
import pikater.ontology.messages.SaveMetadata;
import pikater.ontology.messages.SaveResults;
import pikater.ontology.messages.Task;
import pikater.ontology.messages.TranslateFilename;
import pikater.ontology.messages.UpdateMetadata;

public class DataManagerService
extends FIPAService {
    static final Codec codec = new SLCodec();

    public static String importFile(jade.core.Agent agent, int userID, String path, String content, boolean temp) {
        ImportFile im = new ImportFile();
        im.setUserID(userID);
        im.setExternalFilename(path);
        im.setFileContent(content);
        im.setTempFile(temp);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)im);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
        }
        catch (Codec.CodecException e1) {
            e1.printStackTrace();
        }
        catch (OntologyException e1) {
            e1.printStackTrace();
        }
        try {
            return FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request).getContent();
        }
        catch (FIPAException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String importFile(jade.core.Agent agent, int userID, String path, String content) {
        return DataManagerService.importFile(agent, userID, path, content, false);
    }

    public static String translateFilename(jade.core.Agent agent, int user, String externalFilename, String internalFilename) {
        TranslateFilename tf = new TranslateFilename();
        tf.setUserID(user);
        tf.setExternalFilename(externalFilename);
        tf.setInternalFilename(internalFilename);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)tf);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
            if (inform == null) {
                return null;
            }
            Result r = (Result)agent.getContentManager().extractContent(inform);
            return (String)r.getValue();
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveResult(jade.core.Agent agent, Task t) {
        SaveResults sr = new SaveResults();
        sr.setTask(t);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)sr);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
    }

    public static void saveMetadata(jade.core.Agent agent, Metadata m) {
        SaveMetadata saveMetadata = new SaveMetadata();
        saveMetadata.setMetadata(m);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)saveMetadata);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
    }

    public static List getAllMetadata(jade.core.Agent agent) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)new GetAllMetadata());
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
            Result r = (Result)agent.getContentManager().extractContent(inform);
            List allMetadata = (List)r.getValue();
            return allMetadata;
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Agent getTheBestAgent(jade.core.Agent agent, String fileName) {
        GetTheBestAgent g = new GetTheBestAgent();
        g.setNearest_file_name(fileName);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)g);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
            if (inform.getPerformative() == 6) {
                return null;
            }
            Result r = (Result)agent.getContentManager().extractContent(inform);
            Agent bestAgent = (Agent)r.getValue();
            return bestAgent;
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList getFilesInfo(jade.core.Agent agent, GetFileInfo gfi) {
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)gfi);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
            if (inform == null) {
                return new ArrayList();
            }
            Result r = (Result)agent.getContentManager().extractContent(inform);
            return (ArrayList)r.getValue();
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void updateMetadata(jade.core.Agent agent, Metadata m) {
        UpdateMetadata updateMetadata = new UpdateMetadata();
        updateMetadata.setMetadata(m);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)updateMetadata);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
    }

    public static void deleteTempFiles(jade.core.Agent agent) {
        DeleteTempFiles dtf = new DeleteTempFiles();
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)dtf);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getFiles(jade.core.Agent agent, int userID) {
        GetFiles gfi = new GetFiles();
        gfi.setUserID(userID);
        ACLMessage request = new ACLMessage(16);
        request.addReceiver(new AID("dataManager", false));
        request.setOntology(MessagesOntology.getInstance().getName());
        request.setLanguage(codec.getName());
        request.setProtocol("fipa-request");
        Action a = new Action();
        a.setActor(agent.getAID());
        a.setAction((Concept)gfi);
        try {
            agent.getContentManager().fillContent(request, (ContentElement)a);
            ACLMessage inform = FIPAService.doFipaRequestClient((jade.core.Agent)agent, (ACLMessage)request);
            if (inform == null) {
                return null;
            }
            Result r = (Result)agent.getContentManager().extractContent(inform);
            return (ArrayList)r.getValue();
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        catch (FIPAException e) {
            e.printStackTrace();
        }
        return null;
    }
}

