/*
 * Decompiled with CFR 0.152.
 */
package pikater.agents.computing;

import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.Vector;
import pikater.agents.computing.Agent_ComputingAgent;
import pikater.ontology.messages.Agent;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Evaluation;
import weka.core.Instances;

public class Agent_Regression
extends Agent_ComputingAgent {
    private static final long serialVersionUID = -8851061797450121602L;
    Vector<Double> coefs = new Vector();

    public String getAgentType() {
        return "Regression";
    }

    protected void getParameters() {
        this.agent_options = new Agent();
        this.agent_options.setName(this.getLocalName());
        this.agent_options.setType(this.getAgentType());
        ArrayList _options = new ArrayList();
        this.agent_options.setOptions((List)_options);
    }

    private void buildModel(Instances insts) throws Exception {
        if (insts.numAttributes() != 2) {
            throw new Exception("Wrong dimensionality of data for regression");
        }
        double sx = 0.0;
        double sy = 0.0;
        double sxy = 0.0;
        double sx2 = 0.0;
        int n = insts.numInstances();
        for (int i = 0; i < n; ++i) {
            double x = insts.instance(i).value(0);
            double y = insts.instance(i).value(1);
            sx += x;
            sy += y;
            sxy += x * y;
            sx2 += x * x;
        }
        double denom = sx2 * (double)n - sx * sx;
        double a = (sxy * (double)n - sx * sy) / denom;
        double b = (sx2 * sy - sx * sxy) / denom;
        this.coefs.add(b);
        this.coefs.add(a);
    }

    private float modelError(Instances insts) throws Exception {
        if (this.coefs.size() == 0) {
            throw new Exception("Model not trained");
        }
        double e = 0.0;
        for (int i = 0; i < insts.numInstances(); ++i) {
            double x = insts.instance(i).value(0);
            double y = insts.instance(i).value(1);
            double e1 = y - this.coefs.get(0) - x * this.coefs.get(1);
            e += e1 * e1;
        }
        return (float)Math.sqrt(e / (double)insts.numInstances());
    }

    protected Evaluation evaluateCA() {
        this.working = true;
        System.out.println("Agent " + this.getLocalName() + ": Testing...");
        Evaluation result = new Evaluation();
        try {
            result.setError_rate(this.modelError(this.test));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.working = false;
        return result;
    }

    protected void train() throws Exception {
        this.working = true;
        System.out.println("Agent " + this.getLocalName() + ": Training...");
        this.coefs.clear();
        if (this.OPTIONS.length > 0) {
            throw new Exception("Too much options");
        }
        this.buildModel(this.train);
        this.state = Agent_ComputingAgent.states.TRAINED;
        System.out.println(this.getLocalName() + " " + this.getOptions());
        this.working = false;
    }

    protected DataInstances getPredictions(Instances test, DataInstances onto_test) {
        return null;
    }
}

