/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.util.leap.ArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import pikater.ontology.messages.Metadata;

public class FileManagerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JSplitPane jSplitPane = null;
    private JPanel jPanel = null;
    private JPanel jPanel1 = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JTextField jTextField = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private GuiAgent myAgent = null;
    private FilesTableModel filesModel = null;
    String[] attributesTypes = new String[]{"Categorical", "Numerical", "Mixed"};
    String[] defaultTasks = new String[]{"Classification", "Regression", "Clustering"};

    public FileManagerPanel(GuiAgent a) {
        this.myAgent = a;
        this.filesModel = new FilesTableModel();
        this.initialize();
    }

    public void reloadFileInfo() {
        GuiEvent ge = new GuiEvent((Object)this, 0);
        ge.addParameter((Object)1);
        this.myAgent.postGuiEvent(ge);
    }

    public void setFiles(ArrayList data) {
        this.filesModel.setFiles(data);
        this.jTable.setModel(this.filesModel);
        this.jTable.createDefaultColumnsFromModel();
    }

    public FileManagerPanel() {
        this.initialize();
        this.filesModel = new FilesTableModel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setSize(520, 480);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJSplitPane(), gridBagConstraints);
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setDividerLocation(30);
            this.jSplitPane.setPreferredSize(new Dimension(520, 480));
            this.jSplitPane.setDividerSize(10);
            this.jSplitPane.setBottomComponent(this.getJPanel1());
            this.jSplitPane.setTopComponent(this.getJPanel());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new FlowLayout());
            this.jPanel.setPreferredSize(new Dimension(520, 30));
            this.jPanel.add((Component)this.getJTextField(), null);
            this.jPanel.add((Component)this.getJButton(), null);
            this.jPanel.add((Component)this.getJButton1(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = 0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJScrollPane(), gridBagConstraints1);
        }
        return this.jPanel1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
        }
        return this.jTable;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            this.jTextField = new JTextField();
            this.jTextField.setPreferredSize(new Dimension(200, 20));
        }
        return this.jTextField;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setPreferredSize(new Dimension(200, 20));
            this.jButton.setText("Choose file...");
            this.jButton.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    JFileChooser importFile = new JFileChooser();
                    importFile.setVisible(true);
                    if (importFile.showOpenDialog(FileManagerPanel.this) == 0) {
                        File f = importFile.getSelectedFile();
                        FileManagerPanel.this.jTextField.setText(f.getPath());
                    }
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setPreferredSize(new Dimension(90, 20));
            this.jButton1.setText("Import");
            this.jButton1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String fileName = FileManagerPanel.this.jTextField.getText();
                    File in = new File(fileName);
                    try {
                        BufferedReader fis = new BufferedReader(new FileReader(in));
                        StringBuffer data = new StringBuffer(10000);
                        System.err.println("Starting reading file");
                        char[] buf = new char[1024];
                        int numRead = 0;
                        while ((numRead = fis.read(buf)) != -1) {
                            String readData = String.valueOf(buf, 0, numRead);
                            data.append(readData);
                            buf = new char[1024];
                        }
                        fis.close();
                        System.err.println("Finished reading file");
                        GuiEvent ge = new GuiEvent((Object)FileManagerPanel.this, 4);
                        String[] names = fileName.split(Pattern.quote(System.getProperty("file.separator")));
                        ge.addParameter((Object)names[names.length - 1]);
                        ge.addParameter((Object)data.toString());
                        FileManagerPanel.this.myAgent.postGuiEvent(ge);
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return this.jButton1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5772409714155549244L;
        ArrayList data = new ArrayList();

        private String columnName(int index) {
            switch (index) {
                case 0: {
                    return "Filename";
                }
                case 1: {
                    return "Number of attributes";
                }
                case 2: {
                    return "Attributes type";
                }
                case 3: {
                    return "Number of instances";
                }
                case 4: {
                    return "Missing values";
                }
                case 5: {
                    return "Default task";
                }
            }
            return "";
        }

        private Object getColumnValue(Metadata m, int index) {
            switch (index) {
                case 0: {
                    return m.getExternal_name();
                }
                case 1: {
                    return m.getNumber_of_attributes();
                }
                case 2: {
                    return m.getAttribute_type();
                }
                case 3: {
                    return m.getNumber_of_instances();
                }
                case 4: {
                    return m.getMissing_values();
                }
                case 5: {
                    return m.getDefault_task();
                }
            }
            return "";
        }

        private void setColumnValue(Metadata m, int index, Object value) {
            switch (index) {
                case 0: {
                    m.setExternal_name((String)value);
                    break;
                }
                case 1: {
                    m.setNumber_of_attributes((Integer)value);
                    break;
                }
                case 2: {
                    m.setAttribute_type((String)value);
                    break;
                }
                case 3: {
                    m.setNumber_of_instances((Integer)value);
                    break;
                }
                case 4: {
                    m.setMissing_values((Boolean)value);
                    break;
                }
                case 5: {
                    m.setDefault_task((String)value);
                }
            }
        }

        public void setFiles(ArrayList data) {
            this.data = data;
        }

        public FilesTableModel() {
            FileManagerPanel.this.reloadFileInfo();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.data == null) {
                return String.class;
            }
            Object value = this.getColumnValue((Metadata)this.data.get(0), columnIndex);
            if (value == null) {
                return String.class;
            }
            return this.getColumnValue((Metadata)this.data.get(0), columnIndex).getClass();
        }

        @Override
        public int getColumnCount() {
            if (this.data.size() == 0) {
                return 0;
            }
            return 6;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnName(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = this.getColumnValue((Metadata)this.data.get(rowIndex), columnIndex);
            return value;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Metadata update = (Metadata)this.data.get(rowIndex);
            this.setColumnValue(update, columnIndex, aValue);
            GuiEvent ge = new GuiEvent((Object)this, 1);
            ge.addParameter((Object)update);
            FileManagerPanel.this.myAgent.postGuiEvent(ge);
        }
    }
}

