/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import pikater.Agent_GUI;
import pikater.gui.java.FileManagerPanel;
import pikater.gui.java.NewExperimentPanel;
import pikater.gui.java.ResultsPanel;
import pikater.ontology.messages.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainWindow
extends JFrame {
    public static final int GET_FILES_INFO = 0;
    public static final int UPDATE_METADATA = 1;
    public static final int ON_LOAD = 2;
    public static final int START_EXPERIMENT = 3;
    public static final int IMPORT_FILE = 4;
    private static final long serialVersionUID = 1L;
    private JSplitPane jSplitPane = null;
    private JPanel jPanel1 = null;
    private JTree jTree = null;
    private TreeModel menuModel = null;
    private Agent_GUI myAgent = null;
    private FileManagerPanel fileManager = null;
    private NewExperimentPanel experimentPanel = null;
    private ResultsPanel resultsPanel = null;

    public MainWindow(Agent_GUI myAgent) {
        this.myAgent = myAgent;
        this.fileManager = new FileManagerPanel(myAgent);
        this.experimentPanel = new NewExperimentPanel(myAgent);
        this.resultsPanel = new ResultsPanel();
        this.initialize();
    }

    public void displayError(String error) {
        JOptionPane.showMessageDialog(this, error, "Error", 0);
    }

    public void addResult(Task t) {
        if (t.getResult().getMean_absolute_error() < 0.0f) {
            JOptionPane.showMessageDialog(this, "There was a problem with the computing agent", "Error", 0);
        } else {
            this.resultsPanel.addResult(t);
        }
    }

    public void setAgents(Vector<String> agents) {
    }

    public MainWindow() {
        this.initialize();
    }

    public void addFile(String name) {
        this.experimentPanel.addFile(name);
    }

    private void initialize() {
        this.setSize(800, 600);
        this.setContentPane(this.getJSplitPane());
        this.setName("mainFrame");
        this.setTitle("Pikater");
        this.setVisible(true);
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerLocation(120);
            this.jSplitPane.setLeftComponent(this.getJTree());
            this.jSplitPane.setRightComponent(this.getJPanel1());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.setPreferredSize(new Dimension(520, 480));
        }
        return this.jPanel1;
    }

    private JTree getJTree() {
        if (this.jTree == null) {
            this.jTree = new JTree();
            this.jTree.setRootVisible(false);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            DefaultMutableTreeNode files = new DefaultMutableTreeNode(new TreePanel("Files", this.fileManager));
            DefaultMutableTreeNode experiments = new DefaultMutableTreeNode(new TreePanel("Experiments", this.experimentPanel));
            experiments.add(new DefaultMutableTreeNode(new TreePanel("New", this.experimentPanel)));
            experiments.add(new DefaultMutableTreeNode(new TreePanel("Results", this.resultsPanel)));
            root.add(files);
            root.add(experiments);
            this.menuModel = new DefaultTreeModel(root);
            this.jTree.setModel(this.menuModel);
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreePanel selectedPanel = (TreePanel)((DefaultMutableTreeNode)MainWindow.this.jTree.getLastSelectedPathComponent()).getUserObject();
                    MainWindow.this.jSplitPane.setRightComponent(selectedPanel.getPanel());
                }
            });
        }
        return this.jTree;
    }

    public void allResultsReceived() {
        this.experimentPanel.allResultsReceived();
    }

    private class TreePanel {
        String name;
        JPanel panel;

        public TreePanel(String name, JPanel panel) {
            this.name = name;
            this.panel = panel;
        }

        public String toString() {
            return this.name;
        }

        public JPanel getPanel() {
            return this.panel;
        }
    }
}

