/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java;

import jade.util.leap.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pikater.ontology.messages.Attribute;
import pikater.ontology.messages.DataInstances;

public class ResultDetailsFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private List dataInstances = null;
    private JTabbedPane jTabbedPane = null;
    private JButton jButton = null;
    private Vector<JTable> tables = null;

    public ResultDetailsFrame() {
        this.initialize();
    }

    public ResultDetailsFrame(List inst) {
        this.dataInstances = inst;
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Result details");
        this.tables = new Vector();
        for (int i = 0; i < this.dataInstances.size(); ++i) {
            DataInstances di = (DataInstances)this.dataInstances.get(i);
            JTable table = new JTable(new DataInstancesTableModel(di));
            this.jTabbedPane.insertTab(di.getName(), null, new JScrollPane(table), null, this.jTabbedPane.getComponentCount());
            this.tables.add(table);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.setSize(new Dimension(223, 212));
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getJButton(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
        }
        return this.jTabbedPane;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Export as CSV...");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fChooser = new JFileChooser();
                    fChooser.showSaveDialog(ResultDetailsFrame.this.jButton);
                    File output = fChooser.getSelectedFile();
                    if (output == null) {
                        return;
                    }
                    try {
                        int i;
                        FileWriter out = new FileWriter(output);
                        JScrollPane jScroll = (JScrollPane)ResultDetailsFrame.this.jTabbedPane.getSelectedComponent();
                        JTable jTable = (JTable)ResultDetailsFrame.this.tables.get(ResultDetailsFrame.this.jTabbedPane.getSelectedIndex());
                        for (i = 0; i < jTable.getColumnCount(); ++i) {
                            out.write("\"" + jTable.getColumnName(i) + "\"");
                            if (i >= jTable.getColumnCount() - 1) continue;
                            out.write(",");
                        }
                        out.write("\n");
                        for (i = 0; i < jTable.getModel().getRowCount(); ++i) {
                            for (int j = 0; j < jTable.getModel().getColumnCount(); ++j) {
                                if (j < 4) {
                                    out.write("\"" + jTable.getModel().getValueAt(i, j).toString() + "\"");
                                } else {
                                    out.write(jTable.getModel().getValueAt(i, j).toString());
                                }
                                if (j >= jTable.getModel().getColumnCount() - 1) continue;
                                out.write(",");
                            }
                            out.write("\n");
                        }
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.jButton;
    }

    private class DataInstancesTableModel
    extends AbstractTableModel {
        DataInstances instance = null;
        private static final long serialVersionUID = 8207067033399270730L;

        public DataInstancesTableModel(DataInstances instance) {
            this.instance = instance;
        }

        public int getColumnCount() {
            return this.instance.getAttributes().size();
        }

        public int getRowCount() {
            return this.instance.getInstances().size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.instance.toString(rowIndex, columnIndex);
        }

        public String getColumnName(int column) {
            return ((Attribute)this.instance.getAttributes().get(column)).getName();
        }
    }
}

