/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java;

import jade.util.leap.List;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import pikater.gui.java.ResultDetailsFrame;
import pikater.ontology.messages.Task;

public class ResultsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private String[] columns = new String[]{"Agent type", "Options", "Train file", "Test file", "Error rate", "Mean absolute error", "MSE", "Kappa"};
    private DefaultTableModel tableModel = new DefaultTableModel(this.columns, 0);
    private ArrayList<Task> tasks = new ArrayList();
    private JButton jButton = null;

    public ResultsPanel() {
        this.initialize();
    }

    public void addResult(Task t) {
        this.tasks.add(t);
        Vector<String> data = new Vector<String>();
        data.add(t.getAgent().getType());
        data.add(t.getAgent().optionsToString());
        data.add(t.getData().getTrain_file_name());
        data.add(t.getData().getTest_file_name());
        data.add(String.valueOf(t.getResult().getError_rate()));
        data.add(String.valueOf(t.getResult().getMean_absolute_error()));
        data.add(String.valueOf(t.getResult().getRoot_mean_squared_error()));
        data.add(String.valueOf(t.getResult().getKappa_statistic()));
        this.tableModel.addRow(data);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setSize(320, 251);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJButton(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable(this.tableModel);
            this.jTable.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    Point p = e.getPoint();
                    int row = ResultsPanel.this.jTable.rowAtPoint(p);
                    Task current = (Task)ResultsPanel.this.tasks.get(row);
                    List dataInstances = current.getResult().getLabeled_data();
                    if (dataInstances == null) {
                        return;
                    }
                    ResultDetailsFrame rdf = new ResultDetailsFrame(dataInstances);
                    rdf.setVisible(true);
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
        }
        return this.jTable;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Export as CSV...");
            this.jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fChooser = new JFileChooser();
                    fChooser.showSaveDialog(ResultsPanel.this.jButton);
                    File output = fChooser.getSelectedFile();
                    if (output == null) {
                        return;
                    }
                    try {
                        FileWriter out = new FileWriter(output);
                        for (String s : ResultsPanel.this.columns) {
                            out.write("\"" + s + "\"");
                            if (s.equals(ResultsPanel.this.columns[ResultsPanel.this.columns.length - 1])) continue;
                            out.write(",");
                        }
                        out.write("\n");
                        for (int i = 0; i < ResultsPanel.this.jTable.getModel().getRowCount(); ++i) {
                            for (int j = 0; j < ResultsPanel.this.jTable.getModel().getColumnCount(); ++j) {
                                if (j < 4) {
                                    out.write("\"" + ResultsPanel.this.jTable.getModel().getValueAt(i, j).toString() + "\"");
                                } else {
                                    out.write(ResultsPanel.this.jTable.getModel().getValueAt(i, j).toString());
                                }
                                if (j >= ResultsPanel.this.jTable.getModel().getColumnCount() - 1) continue;
                                out.write(",");
                            }
                            out.write("\n");
                        }
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.jButton;
    }
}

