/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import pikater.gui.java.improved.OptionPanel;
import pikater.ontology.messages.Option;

public class AgentOptionsDialog
extends JDialog {
    private GuiAgent myAgent;
    private String[] agentTypes;
    private java.util.LinkedList<OptionPanel> optionPanels;
    private List options;
    private boolean agentTypeChangedEnabled;
    private JButton jButton1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTabbedPane optionsPanel;

    public AgentOptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public AgentOptionsDialog(Frame parent, boolean modal, String[] agentTypes, GuiAgent myAgent) {
        this(parent, modal, agentTypes, myAgent, true);
    }

    public AgentOptionsDialog(Frame parent, boolean modal, String[] agentTypes, GuiAgent myAgent, boolean agentTypeChangedEnabled) {
        super(parent, modal);
        this.agentTypeChangedEnabled = agentTypeChangedEnabled;
        this.agentTypes = agentTypes;
        this.myAgent = myAgent;
        this.optionPanels = new java.util.LinkedList();
        this.initComponents();
        this.options = new LinkedList();
        this.jComboBox1.setSelectedIndex(1);
    }

    public void setAgentTypeChangedEventEnabled(boolean state) {
        this.agentTypeChangedEnabled = state;
    }

    public void setOption(Option o) {
        System.err.println("Setting option: " + o.getName());
        for (OptionPanel opt : this.optionPanels) {
            if (!opt.getOptionName().equals(o.getName())) continue;
            opt.setOption(o);
            return;
        }
    }

    public void setAgentType(String agentType) {
        this.jComboBox1.setSelectedItem(agentType);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.optionsPanel = new JTabbedPane();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(2);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.agentTypes));
        this.jComboBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                AgentOptionsDialog.this.jComboBox1ItemStateChanged(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.jLabel1.setText(bundle.getString("AGENT TYPE"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, 161, -2).addGap(76, 76, 76)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addContainerGap()));
        this.jScrollPane1.setViewportView(this.optionsPanel);
        this.jButton1.setText(bundle.getString("OK"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AgentOptionsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 378, Short.MAX_VALUE).addComponent(this.jPanel1, -2, 378, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 380, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        this.pack();
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        if (!this.agentTypeChangedEnabled) {
            return;
        }
        if (evt.getStateChange() == 1) {
            String agentType = this.jComboBox1.getSelectedItem().toString();
            this.optionPanels.clear();
            GuiEvent ge = new GuiEvent((Object)this, 6);
            ge.addParameter((Object)agentType);
            this.myAgent.postGuiEvent(ge);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void setAgentOptions(List options) {
        System.err.println("SETAGENTOPTIONS");
        this.options = options;
        this.optionsPanel.removeAll();
        this.optionPanels.clear();
        for (int i = 0; i < options.size(); ++i) {
            OptionPanel op = new OptionPanel((Option)options.get(i), this.getAgentType());
            this.optionPanels.add(op);
            this.optionsPanel.add(((Option)options.get(i)).getName(), op);
        }
        this.optionsPanel.revalidate();
    }

    public List getAgentOptions() {
        this.options.clear();
        for (int i = 0; i < this.optionPanels.size(); ++i) {
            if (this.optionPanels.get(i).getOption() == null) continue;
            this.options.add((Object)this.optionPanels.get(i).getOption());
        }
        return this.options;
    }

    public String getAgentType() {
        return this.jComboBox1.getSelectedItem().toString();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AgentOptionsDialog dialog = new AgentOptionsDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

