/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.Task;

public class CurrentResultsTableModel
extends AbstractTableModel {
    List results;
    HashMap<String, DataInstances> trainingFiles = new HashMap();
    String[] columns = new String[]{ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("DATE"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("TRAIN"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("TEST"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("AGENT TYPE"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("OPTIONS"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("ERROR"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("RMSE"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("KAPPA"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("RAE"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("MAE"), ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("RRSE")};

    public Task getResult(int index) {
        return (Task)this.results.get(index);
    }

    public CurrentResultsTableModel() {
        this.results = new LinkedList();
    }

    public void addTrainingFile(String name, DataInstances data) {
        this.trainingFiles.put(name, data);
    }

    public DataInstances getTrainingFile(String name) {
        return this.trainingFiles.get(name);
    }

    public void add(Task t) {
        t.setFinish(DateFormat.getDateTimeInstance(3, 2).format(new Date()));
        this.results.add((Object)t);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.results.size();
    }

    public int getColumnCount() {
        if (new File("studentMode").exists()) {
            return 6;
        }
        return 11;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Task t = (Task)this.results.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return t.getFinish();
            }
            case 1: {
                return t.getData().getExternal_train_file_name();
            }
            case 2: {
                return t.getData().getExternal_test_file_name();
            }
            case 3: {
                return t.getAgent().getType();
            }
            case 4: {
                return t.getAgent().optionsToString();
            }
            case 5: {
                return Float.valueOf(t.getResult().getError_rate());
            }
            case 6: {
                return Float.valueOf(t.getResult().getRoot_mean_squared_error());
            }
            case 7: {
                return Float.valueOf(t.getResult().getKappa_statistic());
            }
            case 8: {
                return Float.valueOf(t.getResult().getRelative_absolute_error());
            }
            case 9: {
                return Float.valueOf(t.getResult().getMean_absolute_error());
            }
            case 10: {
                return Float.valueOf(t.getResult().getRoot_mean_squared_error());
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.columns[column];
    }

    public void writeFile(String filename) {
        try {
            ObjectOutputStream encoder = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
            encoder.writeObject(this.results);
            encoder.writeObject(this.trainingFiles);
            encoder.close();
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void loadFile(String filename) {
        try {
            ObjectInputStream encoder = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filename)));
            this.results = (List)encoder.readObject();
            this.trainingFiles = (HashMap)encoder.readObject();
            encoder.close();
            super.fireTableDataChanged();
        }
        catch (FileNotFoundException fnf) {
            fnf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        catch (ClassNotFoundException cnf) {
            cnf.printStackTrace();
        }
    }
}

