/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelectDialog
extends JDialog {
    ArrayList<String> files;
    boolean multipleSelect;
    GuiAgent myAgent;
    String fileName = null;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public FileSelectDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public Object getSelectedFile() {
        if (this.jList1.isSelectionEmpty()) {
            return this.fileName;
        }
        return this.jList1.getSelectedValue();
    }

    public Object[] getSelectedFiles() {
        return this.jList1.getSelectedValues();
    }

    public FileSelectDialog(Frame parent, boolean modal, ArrayList<String> _files, GuiAgent myAgent) {
        super(parent, modal);
        this.myAgent = myAgent;
        this.files = _files;
        for (String s : this.files) {
            System.err.println(s);
        }
        this.initComponents();
        this.jList1.setModel(new AbstractListModel(){

            public int getSize() {
                return FileSelectDialog.this.files.size();
            }

            public Object getElementAt(int index) {
                return FileSelectDialog.this.files.get(index);
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("INTERNAL_FILE")));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton2.setText(bundle.getString("CANCEL"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelectDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton1.setText(bundle.getString("OK"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelectDialog.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 151, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButton1, this.jButton2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addContainerGap()));
        this.jButton3.setText(bundle.getString("SELECT_EXTERNAL_FILE"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileSelectDialog.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(130, Short.MAX_VALUE).addComponent(this.jButton3).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addContainerGap(69, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.jList1.clearSelection();
        JFileChooser open = new JFileChooser();
        FileNameExtensionFilter fnf = new FileNameExtensionFilter("CSV", "csv");
        open.setFileFilter(fnf);
        int result = open.showOpenDialog(this.getParent());
        if (result == 0) {
            File input = open.getSelectedFile();
            try {
                Scanner s = new Scanner(input);
                String line = s.nextLine();
                while (line.isEmpty()) {
                    line = s.nextLine();
                }
                String[] columns = line.split("[;,]");
                String arffHeader = "";
                arffHeader = arffHeader + "@RELATION " + input.getName() + "\n";
                for (int i = 0; i < columns.length - 1; ++i) {
                    arffHeader = arffHeader + "@ATTRIBUTE " + columns[i].trim() + " NUMERIC\n";
                }
                String arffContent = "@DATA\n";
                ArrayList<String> classes = new ArrayList<String>();
                while (s.hasNextLine()) {
                    line = s.nextLine();
                    if (line.isEmpty()) continue;
                    arffContent = arffContent + line.replaceAll("[;,]", ",") + "\n";
                    String className = line.split("[;,]")[columns.length - 1];
                    if (classes.contains(className)) continue;
                    classes.add(className);
                }
                String classList = "{";
                for (int i = 0; i < classes.size() - 1; ++i) {
                    classList = classList + (String)classes.get(i) + ",";
                }
                classList = classList + (String)classes.get(classes.size() - 1) + "}";
                arffHeader = arffHeader + "@ATTRIBUTE " + columns[columns.length - 1].trim() + " " + classList;
                this.fileName = input.getName();
                GuiEvent ge = new GuiEvent((Object)this, 8);
                ge.addParameter((Object)(arffHeader + "\n" + arffContent));
                ge.addParameter((Object)input.getName());
                this.myAgent.postGuiEvent(ge);
                this.setVisible(false);
            }
            catch (FileNotFoundException fne) {
                fne.printStackTrace();
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FileSelectDialog dialog = new FileSelectDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

