/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pikater.gui.java.improved.verifiers.IntegerSetInputVerifier;
import pikater.gui.java.improved.verifiers.MLPLayersVerifier;
import pikater.ontology.messages.Option;

public class MixedOptionPanel
extends JPanel {
    private JPanel autoPanel;
    private JRadioButton autoRadio;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JRadioButton defaultRadio;
    private JRadioButton intervalRadio;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSpinner lowerSpinner;
    private JPanel manualPanel;
    private JRadioButton manualRadio;
    private JTextField patternText;
    private JRadioButton setRadio;
    private JTextField setText;
    private JSpinner triesSpinner;
    private JSpinner upperSpinner;
    private JTextField userSpecifiedValueText;

    public MixedOptionPanel() {
        this.initComponents();
    }

    public MixedOptionPanel(Option o) {
        this.initComponents();
        this.userSpecifiedValueText.setText(o.getDefault_value());
        this.autoPanel.setVisible(false);
        this.manualPanel.setVisible(false);
    }

    public boolean isDefault() {
        return this.defaultRadio.isSelected();
    }

    public boolean isUserValue() {
        return this.manualRadio.isSelected();
    }

    public boolean isAutomatic() {
        return this.autoRadio.isSelected();
    }

    public String getUserValue() {
        return this.userSpecifiedValueText.getText();
    }

    public String getLower() {
        return this.lowerSpinner.getValue().toString();
    }

    public String getUpper() {
        return this.upperSpinner.getValue().toString();
    }

    public String getSet() {
        return this.setText.getText();
    }

    public boolean isRange() {
        return this.intervalRadio.isSelected();
    }

    public boolean isSet() {
        return this.setRadio.isSelected();
    }

    public String getPattern() {
        return this.patternText.getText();
    }

    public int getTries() {
        return (Integer)this.triesSpinner.getValue();
    }

    public void setOption(Option o) {
        if (o.getMutable()) {
            this.autoRadio.setSelected(true);
            this.patternText.setText(o.getValue());
            if (o.getRange().getMax() != null && o.getRange().getMin() != null) {
                this.intervalRadio.setSelected(true);
            }
            if (o.getIs_a_set()) {
                this.setRadio.setSelected(true);
                String set = "";
                for (int i = 0; i < o.getSet().size(); ++i) {
                    set = set + o.getSet().get(i).toString();
                    if (i == o.getSet().size() - 1) continue;
                    set = set + " ";
                }
                this.setText.setText(set);
            }
            this.triesSpinner.setValue(o.getNumber_of_values_to_try());
        } else {
            this.manualRadio.setSelected(true);
            this.userSpecifiedValueText.setText(o.getValue());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.defaultRadio = new JRadioButton();
        this.autoRadio = new JRadioButton();
        this.manualRadio = new JRadioButton();
        this.autoPanel = new JPanel();
        this.lowerSpinner = new JSpinner();
        this.setText = new JTextField();
        this.jLabel1 = new JLabel();
        this.upperSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.setRadio = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.intervalRadio = new JRadioButton();
        this.patternText = new JTextField();
        this.jLabel5 = new JLabel();
        this.triesSpinner = new JSpinner();
        this.manualPanel = new JPanel();
        this.userSpecifiedValueText = new JTextField();
        this.jLabel4 = new JLabel();
        this.buttonGroup1.add(this.defaultRadio);
        this.defaultRadio.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.defaultRadio.setText(bundle.getString("KEEP DEFAULT VALUE"));
        this.buttonGroup1.add(this.autoRadio);
        this.autoRadio.setText(bundle.getString("THIS OPTION IS SET AUTOMATICALLY"));
        this.autoRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MixedOptionPanel.this.autoRadioStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.manualRadio);
        this.manualRadio.setText(bundle.getString("USE MANUAL VALUE"));
        this.manualRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MixedOptionPanel.this.manualRadioStateChanged(evt);
            }
        });
        ResourceBundle bundle1 = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.autoPanel.setBorder(BorderFactory.createTitledBorder(bundle1.getString("AUTO_SETTINGS")));
        this.lowerSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.lowerSpinner.setEnabled(false);
        this.setText.setEnabled(false);
        this.setText.setInputVerifier(new IntegerSetInputVerifier(this, "ai"));
        this.jLabel1.setText(bundle.getString("OPTION PATTERN"));
        this.jLabel1.setEnabled(false);
        this.upperSpinner.setModel(new SpinnerNumberModel(100, 1, 1000, 1));
        this.upperSpinner.setEnabled(false);
        this.jLabel3.setText(bundle.getString("TO"));
        this.jLabel3.setEnabled(false);
        this.buttonGroup2.add(this.setRadio);
        this.setRadio.setText(bundle.getString("SET"));
        this.setRadio.setEnabled(false);
        this.jLabel2.setText(bundle.getString("CHOOSE VALUES FROM"));
        this.jLabel2.setEnabled(false);
        this.buttonGroup2.add(this.intervalRadio);
        this.intervalRadio.setSelected(true);
        this.intervalRadio.setText(bundle.getString("INTERVAL"));
        this.intervalRadio.setEnabled(false);
        this.patternText.setText("?");
        this.patternText.setEnabled(false);
        this.patternText.setInputVerifier(new MLPLayersVerifier(this, "?ai"));
        this.patternText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MixedOptionPanel.this.patternTextActionPerformed(evt);
            }
        });
        this.jLabel5.setText(bundle.getString("MAXIMUM TRIES"));
        this.jLabel5.setEnabled(false);
        this.triesSpinner.setModel(new SpinnerNumberModel(5, 1, 20, 1));
        this.triesSpinner.setEnabled(false);
        GroupLayout autoPanelLayout = new GroupLayout(this.autoPanel);
        this.autoPanel.setLayout(autoPanelLayout);
        autoPanelLayout.setHorizontalGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addContainerGap()).addGroup(autoPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.patternText, -1, 159, Short.MAX_VALUE).addGap(6, 6, 6)))).addGroup(autoPanelLayout.createSequentialGroup().addContainerGap().addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoPanelLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.triesSpinner, -2, 73, -2)).addGroup(autoPanelLayout.createSequentialGroup().addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intervalRadio).addComponent(this.setRadio)).addGap(6, 6, 6).addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(autoPanelLayout.createSequentialGroup().addComponent(this.lowerSpinner, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upperSpinner, -2, 68, -2)).addComponent(this.setText)))).addContainerGap()));
        autoPanelLayout.linkSize(0, this.lowerSpinner, this.upperSpinner);
        autoPanelLayout.setVerticalGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(autoPanelLayout.createSequentialGroup().addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternText, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upperSpinner, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.lowerSpinner, -2, -1, -2).addComponent(this.intervalRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setRadio).addComponent(this.setText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(autoPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.triesSpinner, -2, -1, -2)).addGap(12, 12, 12)));
        this.manualPanel.setBorder(BorderFactory.createTitledBorder(bundle1.getString("MANUAL_SETTINGS")));
        this.userSpecifiedValueText.setEnabled(false);
        this.userSpecifiedValueText.setInputVerifier(new MLPLayersVerifier(this, "ai"));
        this.userSpecifiedValueText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MixedOptionPanel.this.userSpecifiedValueTextActionPerformed(evt);
            }
        });
        this.jLabel4.setText(bundle.getString("VALUE"));
        this.jLabel4.setEnabled(false);
        GroupLayout manualPanelLayout = new GroupLayout(this.manualPanel);
        this.manualPanel.setLayout(manualPanelLayout);
        manualPanelLayout.setHorizontalGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manualPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userSpecifiedValueText, -1, 205, Short.MAX_VALUE).addContainerGap()));
        manualPanelLayout.setVerticalGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(manualPanelLayout.createSequentialGroup().addContainerGap().addGroup(manualPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.userSpecifiedValueText, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manualRadio).addComponent(this.autoRadio).addComponent(this.defaultRadio).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.autoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.manualPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.defaultRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualPanel, -2, -1, -2)));
    }

    private void userSpecifiedValueTextActionPerformed(ActionEvent evt) {
    }

    private void autoRadioStateChanged(ChangeEvent evt) {
        for (Component c : this.autoPanel.getComponents()) {
            c.setEnabled(this.autoRadio.isSelected());
        }
        this.autoPanel.setVisible(this.autoRadio.isSelected());
    }

    private void manualRadioStateChanged(ChangeEvent evt) {
        for (Component c : this.manualPanel.getComponents()) {
            c.setEnabled(this.manualRadio.isSelected());
        }
        this.manualPanel.setVisible(this.manualRadio.isSelected());
    }

    private void patternTextActionPerformed(ActionEvent evt) {
    }
}

