/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.util.leap.List;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import pikater.gui.java.improved.CurrentResultsTableModel;
import pikater.gui.java.improved.DataInstancesTableModel;
import pikater.gui.java.improved.VisualisationFactory;
import pikater.ontology.messages.DataInstances;

public class ResultDetailsFrame
extends JFrame {
    LinkedList<JTable> tables;
    JTable trainData;
    GuiAgent myAgent;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JSlider jSlider1;
    private JTabbedPane jTabbedPane1;
    private JPanel visualizationPanel;
    private JComboBox xComboBox;
    private JComboBox yComboBox;

    public ResultDetailsFrame(List dataInstances, String trainFileName, GuiAgent myAgent, CurrentResultsTableModel currentResults) {
        this.initComponents();
        this.tables = new LinkedList();
        this.myAgent = myAgent;
        for (int i = 0; i < dataInstances.size(); ++i) {
            DataInstances di = (DataInstances)dataInstances.get(i);
            JTable table = new JTable(new DataInstancesTableModel(di));
            this.jTabbedPane1.insertTab(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("TEST_DATA") + ": " + di.getName(), null, new JScrollPane(table), null, this.jTabbedPane1.getComponentCount() - 1);
            this.tables.add(table);
        }
        this.setTrainData(currentResults.getTrainingFile(trainFileName));
    }

    public void setTrainData(DataInstances di) {
        DataInstancesTableModel ditm = new DataInstancesTableModel(di);
        this.trainData = new JTable(ditm);
        for (int i = 0; i < ditm.getColumnCount(); ++i) {
            this.xComboBox.addItem(ditm.getColumnName(i));
            this.yComboBox.addItem(ditm.getColumnName(i));
        }
        this.xComboBox.setSelectedIndex(0);
        this.yComboBox.setSelectedIndex(1);
        this.jTabbedPane1.insertTab(ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("TRAIN_DATA") + ": " + di.getName(), null, new JScrollPane(this.trainData), null, 0);
        this.jButton1ActionPerformed(null);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.xComboBox = new JComboBox();
        this.yComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel3 = new JLabel();
        this.jButton1 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.visualizationPanel = new JPanel();
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setText("X");
        this.jLabel2.setText("Y");
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setMaximum(20);
        this.jSlider1.setValue(5);
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.jLabel3.setText(bundle.getString("POINT_SIZE"));
        this.jButton1.setText(bundle.getString("UPDATE_PLOT"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultDetailsFrame.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.yComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.xComboBox, 0, 132, Short.MAX_VALUE)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addContainerGap(113, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider1, -1, 24, Short.MAX_VALUE).addComponent(this.xComboBox, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.yComboBox, -2, -1, -2).addComponent(this.jButton1)).addContainerGap()));
        this.visualizationPanel.setLayout(new GridBagLayout());
        this.jScrollPane2.setViewportView(this.visualizationPanel);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 564, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 280, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(bundle.getString("VISALISATION"), this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 593, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 418, Short.MAX_VALUE).addGap(38, 38, 38)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        LinkedList<DataInstancesTableModel> data = new LinkedList<DataInstancesTableModel>();
        data.add((DataInstancesTableModel)this.trainData.getModel());
        for (JTable table : this.tables) {
            data.add((DataInstancesTableModel)table.getModel());
        }
        this.visualizationPanel.removeAll();
        this.visualizationPanel.add((Component)VisualisationFactory.getChartPanel(data, this.xComboBox.getSelectedIndex(), this.yComboBox.getSelectedIndex(), this.jSlider1.getValue()));
        this.visualizationPanel.revalidate();
    }
}

