/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import jade.gui.GuiAgent;
import jade.gui.GuiEvent;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import pikater.gui.java.improved.CurrentResultsTableModel;
import pikater.gui.java.improved.DataInputFrame;
import pikater.gui.java.improved.GuiConstants;
import pikater.gui.java.improved.ResultDetailsFrame;
import pikater.gui.java.improved.ResultsFilterDialog;
import pikater.gui.java.improved.SavedResultsTableModel;
import pikater.gui.java.improved.TableColumnAdjuster;
import pikater.ontology.messages.DataInstances;
import pikater.ontology.messages.LoadResults;
import pikater.ontology.messages.Task;

public class ResultsBrowserFrame
extends JFrame
implements GuiConstants {
    GuiAgent myAgent;
    LoadResults filter;
    ResultsFilterDialog rfd = new ResultsFilterDialog((Frame)this, true);
    CurrentResultsTableModel currentResults = new CurrentResultsTableModel();
    DataInputFrame did = null;
    int currentResultsLastSelected = -1;
    boolean userHidden = false;
    int mouseOverRow = -1;
    private JButton currentResultsExportButton;
    private JTable currentResultsTable;
    private JButton editFilterButton;
    private JTextArea filterText;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JButton labelDataButton;
    private JButton loadCurrentResultsButton;
    private JButton loadResultsButton;
    private JButton saveResultsButton;
    private JButton savedResultsExportButton;
    private JTable savedResultsTable;
    private JButton showDetailsButton;

    public ResultsBrowserFrame() {
        this.initComponents();
    }

    public ResultsBrowserFrame(GuiAgent myAgent) {
        System.err.println(this.getClass() + " started");
        this.initComponents();
        this.filter = new LoadResults();
        this.filter.setUserID(1);
        this.filterText.setText(this.filter.asText());
        this.myAgent = myAgent;
        System.err.println(this.getClass() + " created");
        if (new File("studentMode").exists()) {
            System.err.println("Student Mode");
            this.jTabbedPane1.remove(this.jPanel3);
        } else {
            System.err.println("Normal Mode");
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.loadResultsButton = new JButton();
        this.editFilterButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.filterText = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.savedResultsTable = new JTable();
        this.savedResultsExportButton = new JButton();
        this.jPanel4 = new JPanel();
        this.currentResultsExportButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.currentResultsTable = new JTable();
        this.saveResultsButton = new JButton();
        this.loadCurrentResultsButton = new JButton();
        this.showDetailsButton = new JButton();
        this.labelDataButton = new JButton();
        this.jPopupMenu1.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ResultsBrowserFrame.this.jPopupMenu1PopupMenuWillBecomeVisible(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("pikater/gui/java/improved/Strings");
        this.jMenuItem1.setText(bundle.getString("DETAILS"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText(bundle.getString("LABEL_DATA"));
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem2);
        ResourceBundle bundle1 = ResourceBundle.getBundle("pikater/gui/java/improved/Bundle");
        this.setTitle(bundle1.getString("PIKATER 1.0 - RESULTS BROWSER"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                ResultsBrowserFrame.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                ResultsBrowserFrame.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Results Filter"));
        this.loadResultsButton.setText(bundle.getString("LOAD_RESULTS"));
        this.loadResultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.loadResultsButtonActionPerformed(evt);
            }
        });
        this.editFilterButton.setText(bundle.getString("EDIT_FILTER"));
        this.editFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.editFilterButtonActionPerformed(evt);
            }
        });
        this.filterText.setColumns(20);
        this.filterText.setLineWrap(true);
        this.filterText.setRows(5);
        this.filterText.setEnabled(false);
        this.jScrollPane2.setViewportView(this.filterText);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 664, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.editFilterButton).addComponent(this.loadResultsButton)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.editFilterButton, this.loadResultsButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.editFilterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadResultsButton)).addComponent(this.jScrollPane2, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Results"));
        this.savedResultsTable.setModel(new SavedResultsTableModel((List)new LinkedList()));
        this.savedResultsTable.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.savedResultsTable);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 779, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 447, Short.MAX_VALUE).addContainerGap()));
        this.savedResultsExportButton.setText(bundle1.getString("EXPORT CSV"));
        this.savedResultsExportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.savedResultsExportButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 711, Short.MAX_VALUE).addComponent(this.savedResultsExportButton))).addGap(2, 2, 2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.savedResultsExportButton).addContainerGap()));
        this.jTabbedPane1.addTab(bundle.getString("SAVED_RESULTS"), this.jPanel3);
        this.currentResultsExportButton.setText(bundle1.getString("EXPORT CSV"));
        this.currentResultsExportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.currentResultsExportButtonActionPerformed(evt);
            }
        });
        this.currentResultsTable.setAutoCreateRowSorter(true);
        this.currentResultsTable.setModel(this.currentResults);
        this.currentResultsTable.setAutoResizeMode(0);
        this.currentResultsTable.setComponentPopupMenu(this.jPopupMenu1);
        this.currentResultsTable.setCursor(new Cursor(0));
        this.currentResultsTable.setSelectionMode(0);
        this.currentResultsTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                ResultsBrowserFrame.this.currentResultsTableMouseMoved(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.currentResultsTable);
        this.saveResultsButton.setText(bundle.getString("SAVE_RESULTS"));
        this.saveResultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.saveResultsButtonActionPerformed(evt);
            }
        });
        this.loadCurrentResultsButton.setText(bundle.getString("LOAD_RESULTS"));
        this.loadCurrentResultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.loadCurrentResultsButtonActionPerformed(evt);
            }
        });
        this.showDetailsButton.setText(bundle.getString("DETAILS"));
        this.showDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.showDetailsButtonActionPerformed(evt);
            }
        });
        this.labelDataButton.setText(bundle.getString("LABEL_DATA"));
        this.labelDataButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsBrowserFrame.this.labelDataButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.showDetailsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelDataButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 157, Short.MAX_VALUE).addComponent(this.loadCurrentResultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveResultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currentResultsExportButton)).addComponent(this.jScrollPane3, -1, 815, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.linkSize(0, this.currentResultsExportButton, this.labelDataButton, this.loadCurrentResultsButton, this.saveResultsButton, this.showDetailsButton);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 618, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadCurrentResultsButton).addComponent(this.saveResultsButton).addComponent(this.currentResultsExportButton).addComponent(this.showDetailsButton).addComponent(this.labelDataButton)).addContainerGap()));
        this.jTabbedPane1.addTab(bundle.getString("CURRENT_RESULTS"), this.jPanel4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 844, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    public DataInputFrame getDataInputDialog() {
        return this.did;
    }

    public void showResults(List results) {
        this.savedResultsTable.setModel(new SavedResultsTableModel(results));
        TableColumnAdjuster tca = new TableColumnAdjuster(this.savedResultsTable);
        tca.adjustColumns();
    }

    public void addResult(Task t) {
        this.currentResultsLastSelected = this.currentResultsTable.getSelectedRow();
        this.currentResults.add(t);
        TableColumnAdjuster tca = new TableColumnAdjuster(this.currentResultsTable);
        tca.adjustColumns();
        if (this.currentResults.getTrainingFile(t.getData().getExternal_train_file_name()) == null) {
            GuiEvent ge = new GuiEvent((Object)this, 3);
            ge.addParameter((Object)t.getData().getExternal_train_file_name());
            this.myAgent.postGuiEvent(ge);
        }
        this.jTabbedPane1.setSelectedComponent(this.jPanel4);
        if (!this.isVisible() && !this.userHidden) {
            this.setVisible(true);
        }
        this.currentResultsTable.getSelectionModel().setSelectionInterval(this.currentResultsLastSelected, this.currentResultsLastSelected);
    }

    public void addTrainingFile(String name, DataInstances data) {
        this.currentResults.addTrainingFile(name, data);
    }

    private void loadResultsButtonActionPerformed(ActionEvent evt) {
        GuiEvent ge = new GuiEvent((Object)this, 4);
        ge.addParameter((Object)this.filter);
        this.myAgent.postGuiEvent(ge);
    }

    private void editFilterButtonActionPerformed(ActionEvent evt) {
        this.rfd.setVisible(true);
        LoadResults lr = this.rfd.getFilter();
        if (lr == null) {
            return;
        }
        this.filter = lr;
        this.filterText.setText(this.filter.asText());
    }

    private void currentResultsExportButtonActionPerformed(ActionEvent evt) {
        JFileChooser fChooser = new JFileChooser(){

            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.getAbsolutePath().endsWith(".csv")) {
                    f = new File(f.getAbsolutePath() + ".csv");
                }
                this.setSelectedFile(f);
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("FILE_EXISTS"), null, 0);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            super.setSelectedFile(null);
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        FileNameExtensionFilter fnef = new FileNameExtensionFilter("CSV (*.csv)", "csv");
        fChooser.setFileFilter(fnef);
        fChooser.setAcceptAllFileFilterUsed(false);
        fChooser.showSaveDialog(this);
        File output = fChooser.getSelectedFile();
        if (output == null) {
            return;
        }
        try {
            int i;
            FileWriter out = new FileWriter(output);
            for (i = 0; i < this.currentResultsTable.getColumnCount(); ++i) {
                String s = this.currentResultsTable.getModel().getColumnName(i);
                out.write("\"" + s + "\"");
                if (s.equals(this.currentResults.columns[this.currentResults.columns.length - 1])) continue;
                out.write(",");
            }
            out.write("\n");
            for (i = 0; i < this.currentResultsTable.getModel().getRowCount(); ++i) {
                for (int j = 0; j < this.currentResultsTable.getModel().getColumnCount(); ++j) {
                    if (j < 3 || j == 4) {
                        out.write("\"" + this.currentResultsTable.getModel().getValueAt(i, j).toString() + "\"");
                    } else {
                        out.write(this.currentResultsTable.getModel().getValueAt(i, j).toString());
                    }
                    if (j >= this.currentResultsTable.getModel().getColumnCount() - 1) continue;
                    out.write(",");
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void savedResultsExportButtonActionPerformed(ActionEvent evt) {
        int columns = this.savedResultsTable.getModel().getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < columns; ++i) {
            columnNames.add(this.savedResultsTable.getModel().getColumnName(i));
        }
        JFileChooser fChooser = new JFileChooser();
        fChooser.showSaveDialog(this);
        File output = fChooser.getSelectedFile();
        if (output == null) {
            return;
        }
        try {
            FileWriter out = new FileWriter(output);
            for (String s : columnNames) {
                out.write("\"" + s + "\"");
                if (s.equals(columnNames.get(columnNames.size() - 1))) continue;
                out.write(",");
            }
            out.write("\n");
            for (int i = 0; i < this.savedResultsTable.getModel().getRowCount(); ++i) {
                for (int j = 0; j < this.savedResultsTable.getModel().getColumnCount(); ++j) {
                    if (j < 3) {
                        out.write("\"" + this.savedResultsTable.getModel().getValueAt(i, j).toString() + "\"");
                    } else {
                        out.write(this.savedResultsTable.getModel().getValueAt(i, j).toString());
                    }
                    if (j >= this.savedResultsTable.getModel().getColumnCount() - 1) continue;
                    out.write(",");
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void saveResultsButtonActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser(){

            public void approveSelection() {
                File f = this.getSelectedFile();
                if (!f.getAbsolutePath().endsWith(".bres")) {
                    f = new File(f.getAbsolutePath() + ".bres");
                }
                this.setSelectedFile(f);
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("FILE_EXISTS"), null, 0);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            super.setSelectedFile(null);
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        FileNameExtensionFilter fnf = new FileNameExtensionFilter("BANG results file", "bres");
        choose.setFileFilter(fnf);
        choose.setAcceptAllFileFilterUsed(false);
        choose.showSaveDialog(this);
        File f = choose.getSelectedFile();
        if (f == null) {
            System.err.println("Selection canceled");
            return;
        }
        this.currentResults.writeFile(f.getAbsolutePath());
    }

    private void loadCurrentResultsButtonActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        FileNameExtensionFilter fnf = new FileNameExtensionFilter("BANG results file", "bres");
        choose.setFileFilter(fnf);
        choose.setAcceptAllFileFilterUsed(false);
        choose.showOpenDialog(this);
        File f = choose.getSelectedFile();
        if (f == null) {
            return;
        }
        this.currentResults.loadFile(f.getAbsolutePath());
        TableColumnAdjuster tca = new TableColumnAdjuster(this.currentResultsTable);
        tca.adjustColumns();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        int row = this.currentResultsTable.getSelectedRow();
        Task t = this.currentResults.getResult(row);
        List data = t.getResult().getLabeled_data();
        if (data == null || data.size() == 0) {
            System.err.println("No data");
        }
        ResultDetailsFrame rdf = new ResultDetailsFrame(data, t.getData().getExternal_train_file_name(), this.myAgent, this.currentResults);
        rdf.setVisible(true);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        if (this.did != null) {
            JOptionPane.showMessageDialog(this, "Cannot open two label windows", "Error", 0);
            return;
        }
        int row = this.currentResultsTable.getSelectedRow();
        this.did = new DataInputFrame(this, this.currentResults.getTrainingFile(this.currentResults.getResult(row).getData().getExternal_train_file_name()), this.myAgent, this.currentResults.getResult(row).getResult().getObject());
        this.did.setVisible(true);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.userHidden = true;
    }

    private void formWindowClosing(WindowEvent evt) {
        this.userHidden = true;
    }

    private void currentResultsTableMouseMoved(MouseEvent evt) {
        int row;
        Point p = evt.getPoint();
        this.mouseOverRow = row = this.currentResultsTable.rowAtPoint(p);
    }

    private void jPopupMenu1PopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.currentResultsTable.getSelectionModel().setSelectionInterval(this.mouseOverRow, this.mouseOverRow);
    }

    private void showDetailsButtonActionPerformed(ActionEvent evt) {
        this.jMenuItem1ActionPerformed(null);
    }

    private void labelDataButtonActionPerformed(ActionEvent evt) {
        this.jMenuItem2ActionPerformed(null);
    }

    public void dataInputDialogClosed() {
        this.did = null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new ResultsBrowserFrame().setVisible(true);
            }
        });
    }
}

