/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved;

import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.ChartColor;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.util.ShapeUtilities;
import pikater.gui.java.improved.DataInstancesTableModel;
import pikater.ontology.messages.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationFactory {
    public static ChartPanel getChartPanel(List<DataInstancesTableModel> dataList, int x, int y, float radius) {
        Shape[] shapes = new Shape[]{new Ellipse2D.Float(-radius / 2.0f, -radius / 2.0f, radius, radius), new Ellipse2D.Float(-radius / 4.0f, -radius / 4.0f, radius / 2.0f, radius / 2.0f), ShapeUtilities.createRegularCross((float)(radius / 2.0f), (float)(radius / 2.0f)), ShapeUtilities.createDiagonalCross((float)(radius / 2.0f), (float)(radius / 2.0f)), ShapeUtilities.createDiamond((float)(radius / 2.0f))};
        Paint[] paints = ChartColor.createDefaultPaintArray();
        DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
        renderer.setBaseLinesVisible(false);
        renderer.setBaseShapesFilled(false);
        renderer.setBaseShapesVisible(true);
        XYSeriesCollection dataset = new XYSeriesCollection();
        int series = 0;
        for (DataInstancesTableModel data : dataList) {
            String[] classes;
            HashMap classLists = new HashMap();
            for (String s : classes = data.getClasses()) {
                classLists.put(s, new LinkedList());
            }
            for (int i = 0; i < data.getRowCount(); ++i) {
                String iClass = data.getValueAt(i, data.getClassIndex()).toString();
                ((LinkedList)classLists.get(iClass)).add(data.getInstance(i));
            }
            for (String s : classes) {
                XYSeries dataSeries = new XYSeries((Comparable)((Object)s));
                for (Instance i : (LinkedList)classLists.get(s)) {
                    dataSeries.add((double)Float.parseFloat(i.getValues().get(x).toString()), (double)Float.parseFloat(i.getValues().get(y).toString()));
                }
                dataset.addSeries(dataSeries);
            }
            for (int i = series * classes.length; i < series * classes.length + classes.length; ++i) {
                renderer.setSeriesShape(i, shapes[series]);
                renderer.setSeriesPaint(i, paints[i - series * classes.length]);
            }
            ++series;
        }
        NumberAxis domainAxis = new NumberAxis(dataList.get(0).getColumnName(x));
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis(dataList.get(0).getColumnName(y));
        rangeAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart((Plot)plot);
        ChartPanel panel = new ChartPanel(chart, true);
        panel.setPreferredSize(new Dimension(500, 500));
        panel.setMinimumDrawHeight(10);
        panel.setMaximumDrawHeight(2000);
        panel.setMinimumDrawWidth(20);
        panel.setMaximumDrawWidth(2000);
        panel.setVisible(true);
        return panel;
    }
}

