/*
 * Decompiled with CFR 0.152.
 */
package pikater.gui.java.improved.verifiers;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ResourceBundle;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class MLPLayersVerifier
extends InputVerifier {
    JComponent comp = null;
    String additionalChars = null;

    public MLPLayersVerifier(JComponent comp, String additionalChars) {
        this.comp = comp;
        this.additionalChars = additionalChars;
    }

    public boolean verify(JComponent input) {
        String[] values;
        JTextField textField = (JTextField)input;
        for (String value : values = textField.getText().split(",")) {
            if ((value = value.trim()).length() == 1 && this.additionalChars.indexOf(value) != -1) continue;
            ParsePosition pos = new ParsePosition(0);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.parse(value, pos);
            if (pos.getIndex() == value.length()) continue;
            if (this.additionalChars.indexOf("?") != -1) {
                JOptionPane.showMessageDialog(this.comp, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("MLP_LAYERS_ERROR"), null, 0);
            } else {
                JOptionPane.showMessageDialog(this.comp, ResourceBundle.getBundle("pikater/gui/java/improved/Strings").getString("MLP_LAYERS_ERROR_NO_?"), null, 0);
            }
            return false;
        }
        return true;
    }
}

