/*
 * Decompiled with CFR 0.152.
 */
package pikater.ontology.messages;

import jade.content.Concept;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import pikater.ontology.messages.Option;

public class Agent
implements Concept {
    private static final long serialVersionUID = 6257129995443147585L;
    private String _name;
    private String _type;
    private List _options;
    private String _gui_id;
    private byte[] object;

    public void setOptions(List options) {
        this._options = options;
    }

    public List getOptions() {
        return this._options;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void setGui_id(String gui_id) {
        this._gui_id = gui_id;
    }

    public String getGui_id() {
        return this._gui_id;
    }

    public void setObject(byte[] object) {
        this.object = object;
    }

    public byte[] getObject() {
        return this.object;
    }

    public List stringToOptions(String optString) {
        String[] optArray = optString.split("[ ]+");
        ArrayList optList = new ArrayList();
        for (int i = 0; i < optArray.length; ++i) {
            String value;
            if (!optArray[i].startsWith("-")) continue;
            String name = optArray[i].replaceFirst("-", "");
            Option opt = new Option();
            if (i == optArray.length - 1) {
                value = "True";
                opt.setData_type("BOOLEAN");
            } else if (optArray[i + 1].matches("\\-[A-Z]")) {
                value = "True";
                opt.setData_type("BOOLEAN");
            } else {
                value = optArray[i + 1];
            }
            opt.setName(name);
            opt.setValue(value);
            if (opt.getUser_value() == null) {
                if (value.contains("?")) {
                    opt.setMutable(true);
                }
                opt.setUser_value(value);
            }
            optList.add((Object)opt);
        }
        return optList;
    }

    public String optionsToString() {
        String str = "";
        if (this._options == null) {
            return str;
        }
        for (Option next_opt : this._options) {
            if (next_opt.getData_type().equals("BOOLEAN")) {
                if (!next_opt.getValue().equals("True")) continue;
                str = str + "-" + next_opt.getName() + " ";
                continue;
            }
            str = str + "-" + next_opt.getName() + " " + next_opt.getValue() + " ";
        }
        return str;
    }

    public Option getOptionByName(String name) {
        for (int i = 0; i < this.getOptions().size(); ++i) {
            Option o = (Option)this._options.get(i);
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public String toGuiString() {
        if (this._options == null) {
            return "";
        }
        String str = "";
        for (Option next_opt : this._options) {
            if (next_opt.getData_type().equals("BOOLEAN")) {
                if (next_opt.getValue().equals("True")) {
                    str = str + "-" + next_opt.getName() + " ";
                }
                if (!next_opt.getMutable()) continue;
                str = str + "-" + next_opt.getName() + " ? ";
                continue;
            }
            if (!next_opt.getMutable()) {
                str = str + "-" + next_opt.getName() + " " + next_opt.getValue() + " ";
                continue;
            }
            str = str + "-" + next_opt.getName() + " " + next_opt.getValue() + "/";
            if (!next_opt.getIs_a_set()) {
                str = str + "<" + next_opt.getRange().getMin() + "," + next_opt.getRange().getMax() + ">";
            } else {
                String set = "";
                for (int i = 0; i < next_opt.getSet().size(); ++i) {
                    set = set + next_opt.getSet().get(i);
                    if (i == next_opt.getSet().size() - 1) continue;
                    set = set + " ";
                }
                str = str + "{" + set + "}";
            }
            str = str + "/" + next_opt.getNumber_of_values_to_try() + " ";
        }
        return str;
    }
}

