/*
 * Decompiled with CFR 0.152.
 */
package pikater.ontology.messages;

import jade.content.Concept;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import pikater.ontology.messages.Attribute;
import pikater.ontology.messages.Instance;
import weka.core.FastVector;
import weka.core.Instances;

public class DataInstances
implements Concept {
    private static final long serialVersionUID = 4166896666680482675L;
    private List attributes;
    private List instances;
    private String name;
    private int class_index;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public List getInstances() {
        return this.instances;
    }

    public void setInstances(List instances) {
        this.instances = instances;
    }

    public int getClass_index() {
        return this.class_index == -1 ? this.getAttributes().size() - 1 : this.class_index;
    }

    public void setClass_index(int classIndex) {
        this.class_index = classIndex;
    }

    public Instances toWekaInstances() {
        FastVector wattrs = new FastVector();
        for (Attribute attr : this.attributes) {
            wattrs.addElement((Object)attr.toWekaAttribute());
        }
        Instances winsts = new Instances(this.name, wattrs, this.instances.size());
        for (Instance inst : this.instances) {
            Iterator itrval = inst.getValues().iterator();
            Iterator itrmis = inst.getMissing().iterator();
            double[] vals = new double[wattrs.size()];
            for (int i = 0; i < wattrs.size(); ++i) {
                vals[i] = (Boolean)itrmis.next() != false ? weka.core.Instance.missingValue() : (Double)itrval.next();
            }
            weka.core.Instance winst = new weka.core.Instance(1.0, vals);
            winst.setDataset(winsts);
            winsts.add(winst);
        }
        winsts.setClassIndex(this.class_index);
        return winsts;
    }

    public void fillWekaInstances(Instances winsts) {
        this.setName(winsts.relationName());
        ArrayList onto_attrs = new ArrayList();
        for (int i = 0; i < winsts.numAttributes(); ++i) {
            Attribute a = new Attribute();
            a.fillWekaAttribute(winsts.attribute(i));
            onto_attrs.add((Object)a);
        }
        this.setAttributes((List)onto_attrs);
        ArrayList onto_insts = new ArrayList();
        for (int i = 0; i < winsts.numInstances(); ++i) {
            Instance inst = new Instance();
            weka.core.Instance winst = winsts.instance(i);
            ArrayList instvalues = new ArrayList();
            ArrayList instmis = new ArrayList();
            for (int j = 0; j < winst.numValues(); ++j) {
                if (winst.isMissing(j)) {
                    instvalues.add((Object)new Double(0.0));
                    instmis.add((Object)new Boolean(true));
                    continue;
                }
                instvalues.add((Object)new Double(winst.value(j)));
                instmis.add((Object)new Boolean(false));
            }
            inst.setValues((List)instvalues);
            inst.setMissing((List)instmis);
            onto_insts.add((Object)inst);
        }
        this.setInstances((List)onto_insts);
        this.setClass_index(winsts.classIndex());
    }

    public String toString() {
        if (this.instances == null) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        for (Instance inst : this.instances) {
            text.append(inst.toString(this));
            text.append('\n');
        }
        return text.toString();
    }

    public String toString(int row, int index) {
        if (this.instances == null) {
            return "";
        }
        Instance inst = (Instance)this.instances.get(row);
        return inst.toString(this, index);
    }
}

