/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.Term;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.onto.AggregateHelper;
import jade.content.onto.BasicOntology;
import jade.content.onto.Introspector;
import jade.content.onto.NotASpecialType;
import jade.content.onto.NotAnAggregate;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.SlotAccessData;
import jade.content.onto.SlotKey;
import jade.content.schema.ObjectSchema;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanIntrospector
implements Introspector {
    private static final long serialVersionUID = 6896919407513408002L;
    private static final String ENUM_SLOT_NAME = "name";
    private Map<SlotKey, SlotAccessData> accessors = new HashMap<SlotKey, SlotAccessData>();

    BeanIntrospector() {
    }

    void addAccessors(Map<SlotKey, SlotAccessData> accessors) {
        this.accessors.putAll(accessors);
    }

    private Object invokeGetterMethod(Method method, Object obj) throws OntologyException {
        Object result = null;
        try {
            result = method.invoke(obj, (Object[])null);
            if (result != null && Calendar.class.isAssignableFrom(result.getClass())) {
                result = ((Calendar)result).getTime();
            }
        }
        catch (IllegalArgumentException iae) {
            result = new Object();
        }
        catch (Exception e) {
            throw new OntologyException("Error invoking getter method " + method.getName() + " on object " + obj, e);
        }
        return result;
    }

    private void invokeSetterMethod(Method method, Object obj, Object value, Class clazz) throws OntologyException {
        try {
            if (Calendar.class.isAssignableFrom(clazz)) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime((Date)value);
                value = calendar;
            } else {
                value = BasicOntology.adjustPrimitiveValue(value, clazz);
            }
            Object[] params = new Object[]{value};
            method.invoke(obj, params);
        }
        catch (Exception e) {
            throw new OntologyException("Error invoking setter method " + method.getName() + " on object " + obj + " with parameter " + value, e);
        }
    }

    @Override
    public void checkClass(ObjectSchema schema, Class javaClass, Ontology onto) throws OntologyException {
    }

    @Override
    public Object getSlotValue(String slotName, Object obj, ObjectSchema schema) throws OntologyException {
        SlotAccessData slotAccessData = this.accessors.get(new SlotKey(schema.getTypeName(), slotName));
        if (slotAccessData == null) {
            throw new OntologyException("cannot retrieve a getter for slot " + slotName + ", class " + obj.getClass());
        }
        return this.invokeGetterMethod(slotAccessData.getter, obj);
    }

    @Override
    public void setSlotValue(String slotName, Object slotValue, Object obj, ObjectSchema schema) throws OntologyException {
        SlotAccessData slotAccessData = this.accessors.get(new SlotKey(schema.getTypeName(), slotName));
        if (slotAccessData == null) {
            throw new OntologyException("cannot retrieve a setter for slot " + slotName + ", class " + obj.getClass());
        }
        this.invokeSetterMethod(slotAccessData.setter, obj, slotValue, slotAccessData.type);
    }

    @Override
    public AbsAggregate externalizeAggregate(String slotName, Object slotValue, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        AbsAggregate absAggregate = null;
        Class<?> valueClass = slotValue.getClass();
        boolean slotTypized = false;
        if (schema != null) {
            SlotAccessData slotAccessData = this.accessors.get(new SlotKey(schema.getTypeName(), slotName));
            slotTypized = slotAccessData.isTypized();
        }
        if (valueClass.isArray() && valueClass != byte[].class) {
            if (!slotTypized) {
                throw new OntologyException("Impossible manage array into a not typized slot");
            }
            absAggregate = new AbsAggregate("sequence");
            for (int i = 0; i < Array.getLength(slotValue); ++i) {
                Object object = Array.get(slotValue, i);
                absAggregate.add((AbsTerm)Ontology.externalizeSlotValue(object, this, referenceOnto));
            }
        } else {
            String aggregateType;
            Iterator iter;
            if (slotValue instanceof Collection) {
                iter = ((Collection)slotValue).iterator();
                aggregateType = slotValue instanceof java.util.List ? "sequence" : "set";
            } else if (slotValue instanceof jade.util.leap.Collection) {
                if (!slotTypized) {
                    throw new OntologyException("Impossible manage jade collection into a not typized slot");
                }
                iter = ((jade.util.leap.Collection)slotValue).iterator();
                aggregateType = slotValue instanceof List ? "sequence" : "set";
            } else {
                throw new NotAnAggregate();
            }
            if (iter.hasNext() || schema.isMandatory(slotName)) {
                absAggregate = new AbsAggregate(aggregateType);
                try {
                    while (iter.hasNext()) {
                        Object object = iter.next();
                        absAggregate.add((AbsTerm)Ontology.externalizeSlotValue(object, this, referenceOnto));
                    }
                }
                catch (ClassCastException cce) {
                    throw new OntologyException("Non term object in aggregate");
                }
            }
        }
        return absAggregate;
    }

    @Override
    public Object internalizeAggregate(String slotName, AbsAggregate absAggregate, ObjectSchema schema, Ontology referenceOnto) throws OntologyException {
        Object result;
        block12: {
            SlotAccessData slotAccessData = this.accessors.get(new SlotKey(schema.getTypeName(), slotName));
            if (slotAccessData == null) {
                Class containerClazz = referenceOnto.getClassForElement(schema.getTypeName());
                throw new OntologyException("cannot retrieve a setter for slot " + slotName + ", class " + containerClazz);
            }
            Class elementClazz = slotAccessData.aggregateClass;
            Class aggregateClass = slotAccessData.type;
            if (aggregateClass == null || aggregateClass == Object.class || aggregateClass == Term.class || aggregateClass == jade.util.leap.Collection.class || aggregateClass == Collection.class) {
                aggregateClass = "sequence".equals(absAggregate.getTypeName()) ? ArrayList.class : HashSet.class;
            }
            Iterator iterator = absAggregate.iterator();
            try {
                if (aggregateClass.isArray()) {
                    int index = 0;
                    result = Array.newInstance(elementClazz, absAggregate.size());
                    while (iterator.hasNext()) {
                        Array.set(result, index, Ontology.internalizeSlotValue((AbsTerm)iterator.next(), this, referenceOnto));
                        ++index;
                    }
                    break block12;
                }
                if (Collection.class.isAssignableFrom(aggregateClass)) {
                    Collection javaCollection = AggregateHelper.createConcreteJavaCollection(aggregateClass);
                    if (javaCollection == null) {
                        throw new OntologyException("cannot create a concrete collection for class " + aggregateClass.getName());
                    }
                    result = javaCollection;
                    while (iterator.hasNext()) {
                        javaCollection.add(Ontology.internalizeSlotValue((AbsTerm)iterator.next(), this, referenceOnto));
                    }
                    break block12;
                }
                if (jade.util.leap.Collection.class.isAssignableFrom(aggregateClass)) {
                    jade.util.leap.Collection jadeCollection = AggregateHelper.createConcreteJadeCollection(aggregateClass);
                    result = jadeCollection;
                    while (iterator.hasNext()) {
                        jadeCollection.add(Ontology.internalizeSlotValue((AbsTerm)iterator.next(), this, referenceOnto));
                    }
                    break block12;
                }
                throw new OntologyException("don't know how to handle aggregate slot of class " + aggregateClass.getName());
            }
            catch (InstantiationException ie) {
                throw new OntologyException("cannot instantiate aggregate slot of non-concrete class " + aggregateClass.getName(), ie);
            }
            catch (IllegalAccessException iae) {
                throw new OntologyException("cannot instantiate aggregate slot through unaccessible default constructor of class " + aggregateClass.getName(), iae);
            }
        }
        return result;
    }

    @Override
    public AbsObject externalizeSpecialType(Object obj, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws OntologyException {
        if (!javaClass.isEnum()) {
            throw new NotASpecialType();
        }
        AbsObject abs = schema.newInstance();
        AbsHelper.setAttribute(abs, ENUM_SLOT_NAME, AbsPrimitive.wrap(obj.toString()));
        return abs;
    }

    @Override
    public Object internalizeSpecialType(AbsObject abs, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws OntologyException {
        if (!javaClass.isEnum()) {
            throw new NotASpecialType();
        }
        AbsPrimitive absEnumValue = (AbsPrimitive)abs.getAbsObject(ENUM_SLOT_NAME);
        String strEnumValue = absEnumValue.getString();
        return Enum.valueOf(javaClass, strEnumValue);
    }
}

