/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.FrontEndContainer;
import jade.core.IMTPException;
import jade.core.MicroAgentControllerImpl;
import jade.core.NotFoundException;
import jade.util.Logger;
import jade.util.leap.Properties;
import jade.wrapper.AgentController;
import jade.wrapper.ControllerException;

public class MicroRuntime {
    public static final String AGENTS_KEY = "agents";
    public static final String SERVICES_KEY = "services";
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    public static final String PROTO_KEY = "proto";
    public static final String SOCKET_PROTOCOL = "socket";
    public static final String SSL_PROTOCOL = "ssl";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String CONN_MGR_CLASS_KEY = "connection-manager";
    public static final String CONTAINER_NAME_KEY = "container-name";
    public static final String PLATFORM_KEY = "platform-id";
    public static final String PLATFORM_ADDRESSES_KEY = "addresses";
    public static final String BE_REQUIRED_SERVICES_KEY = "be-required-services";
    public static final String JVM_KEY = "jvm";
    public static final String J2SE = "j2se";
    public static final String PJAVA = "pjava";
    public static final String MIDP = "midp";
    private static Runnable terminator;
    private static FrontEndContainer myFrontEnd;
    private static boolean terminated;

    public static void startJADE(Properties p, Runnable r) {
        if (myFrontEnd == null) {
            terminator = r;
            terminated = false;
            myFrontEnd = new FrontEndContainer(p);
            if (terminated) {
                myFrontEnd = null;
            }
        }
    }

    public static void stopJADE() {
        if (myFrontEnd != null) {
            try {
                myFrontEnd.exit(true);
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
        }
    }

    public static boolean isRunning() {
        return myFrontEnd != null;
    }

    public static void startAgent(String name, String className, String[] args) throws Exception {
        if (myFrontEnd != null) {
            try {
                myFrontEnd.createAgent(name, className, args);
            }
            catch (IMTPException imtpe) {
                throw (Exception)imtpe.getNested();
            }
        }
    }

    public static void killAgent(String name) throws NotFoundException {
        if (myFrontEnd != null) {
            try {
                myFrontEnd.killAgent(name);
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
        }
    }

    public static AgentController getAgent(String localName) throws ControllerException {
        if (myFrontEnd == null) {
            throw new ControllerException("FrontEndContainer  not found");
        }
        Agent instance = myFrontEnd.getLocalAgent(localName);
        if (instance == null) {
            throw new ControllerException("Agent " + localName + " not found.");
        }
        return new MicroAgentControllerImpl(localName, myFrontEnd);
    }

    public static void detach() {
        if (myFrontEnd != null) {
            myFrontEnd.detach();
        }
    }

    static void handleTermination(boolean self) {
        terminated = true;
        myFrontEnd = null;
        Thread t = null;
        if (self) {
            t = new Thread(terminator);
        } else {
            final Thread current = Thread.currentThread();
            t = new Thread(new Runnable(){

                public void run() {
                    try {
                        current.join();
                    }
                    catch (InterruptedException ie) {
                        Logger logger = Logger.getMyLogger(this.getClass().getName());
                        logger.log(Logger.SEVERE, "Interrupted in join");
                    }
                    if (terminator != null) {
                        terminator.run();
                    }
                }
            });
        }
        t.start();
    }
}

