/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.content.ContentManager;
import jade.content.lang.Codec;
import jade.content.lang.leap.LEAPCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.core.behaviours.SequentialBehaviour;
import jade.domain.mobility.BehaviourLoadingOntology;
import jade.domain.mobility.LoadBehaviour;
import jade.domain.mobility.Parameter;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class LoaderBehaviour
extends Behaviour {
    private Codec codec = new LEAPCodec();
    private Ontology onto = BehaviourLoadingOntology.getInstance();
    private ContentManager myContentManager = new ContentManager();
    private ClassLoader localLoader;
    private MessageTemplate myTemplate = MessageTemplate.and(MessageTemplate.MatchPerformative(16), MessageTemplate.and(MessageTemplate.MatchLanguage(this.codec.getName()), MessageTemplate.MatchOntology(this.onto.getName())));
    private boolean finished = false;

    public LoaderBehaviour() {
        this.init();
    }

    public LoaderBehaviour(Agent a) {
        super(a);
        this.init();
    }

    public LoaderBehaviour(Agent a, ClassLoader cl) {
        super(a);
        this.init();
        this.localLoader = cl;
    }

    public final void action() {
        if (!this.finished) {
            ACLMessage msg = this.myAgent.receive(this.myTemplate);
            if (msg != null) {
                ACLMessage reply = msg.createReply();
                if (this.accept(msg)) {
                    try {
                        Action actionExpr = (Action)this.myContentManager.extractContent(msg);
                        LoadBehaviour lb = (LoadBehaviour)actionExpr.getAction();
                        String className = lb.getClassName();
                        Behaviour b = null;
                        byte[] code = lb.getCode();
                        byte[] zip = lb.getZip();
                        b = code != null ? this.loadFromCode(className, code) : (zip != null ? this.loadFromZip(className, zip) : (this.localLoader != null ? (Behaviour)this.localLoader.loadClass(className).newInstance() : (Behaviour)Class.forName(className).newInstance()));
                        List params = lb.getParameters();
                        this.setInputParameters(b, params);
                        SequentialBehaviour sb = new SequentialBehaviour(this.myAgent);
                        sb.addSubBehaviour(b);
                        sb.addSubBehaviour(new ResultCollector(b, params, actionExpr, msg));
                        this.myAgent.addBehaviour(sb);
                        reply.setPerformative(1);
                    }
                    catch (Codec.CodecException ce) {
                        ce.printStackTrace();
                        reply.setPerformative(10);
                        reply.setContent("((unrecognised-value content))");
                    }
                    catch (OntologyException oe) {
                        oe.printStackTrace();
                        reply.setPerformative(10);
                        reply.setContent("((unrecognised-value content))");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reply.setPerformative(6);
                        reply.setContent("((internal-error \"" + e.toString() + "\"))");
                    }
                } else {
                    reply.setPerformative(14);
                }
                this.myAgent.send(reply);
            } else {
                this.block();
            }
        }
    }

    public boolean done() {
        return this.finished;
    }

    public void stop() {
        this.finished = true;
        this.restart();
    }

    protected void addBehaviour(Behaviour b, ACLMessage request) {
        this.myAgent.addBehaviour(b);
    }

    protected boolean accept(ACLMessage msg) {
        return true;
    }

    private void init() {
        this.myContentManager.registerLanguage(this.codec);
        this.myContentManager.registerOntology(this.onto);
        this.localLoader = this.getClass().getClassLoader();
    }

    private Behaviour loadFromCode(String className, byte[] code) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Hashtable<String, byte[]> classes = new Hashtable<String, byte[]>(1);
        classes.put(className, code);
        return this.load(className, classes);
    }

    private Behaviour loadFromZip(String className, byte[] zip) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Hashtable<String, byte[]> classes = new Hashtable<String, byte[]>();
        try {
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] tmp = new byte[1024];
                int k = zis.read(tmp, 0, tmp.length);
                while (k > 0) {
                    baos.write(tmp, 0, k);
                    k = zis.read(tmp, 0, tmp.length);
                }
                classes.put(ze.getName(), baos.toByteArray());
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            return this.load(className, classes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassNotFoundException("Error reading zip for class " + className + ". " + e);
        }
    }

    private Behaviour load(String className, Hashtable classes) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        HashClassLoader loader = new HashClassLoader(classes, this.getClass().getClassLoader());
        Class<?> c = loader.loadClass(className);
        return (Behaviour)c.newInstance();
    }

    private void setInputParameters(Behaviour b, List params) {
        DataStore ds = b.getDataStore();
        if (params != null) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Parameter p = (Parameter)it.next();
                if (p.getMode() != 0 && p.getMode() != 2) continue;
                ds.put(p.getName(), p.getValue());
            }
        }
    }

    private void getOutputParameters(Behaviour b, List params) {
        DataStore ds = b.getDataStore();
        if (params != null) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Parameter p = (Parameter)it.next();
                if (p.getMode() != 1 && p.getMode() != 2) continue;
                p.setValue(ds.get(p.getName()));
            }
        }
    }

    private class ResultCollector
    extends OneShotBehaviour {
        private Behaviour myBehaviour;
        private List myParams;
        private Action actionExpr;
        private ACLMessage request;

        ResultCollector(Behaviour b, List l, Action a, ACLMessage m) {
            this.myBehaviour = b;
            this.myParams = l;
            this.actionExpr = a;
            this.request = m;
        }

        public void action() {
            LoadBehaviour lb = (LoadBehaviour)this.actionExpr.getAction();
            lb.setCode(null);
            lb.setZip(null);
            LoaderBehaviour.this.getOutputParameters(this.myBehaviour, this.myParams);
            Result r = new Result(this.actionExpr, this.myParams);
            ACLMessage notification = this.request.createReply();
            try {
                LoaderBehaviour.this.myContentManager.fillContent(notification, r);
                notification.setPerformative(7);
            }
            catch (Exception e) {
                e.printStackTrace();
                notification.setPerformative(6);
                notification.setContent("((internal-error \"" + e.toString() + "\"))");
            }
            this.myAgent.send(notification);
        }
    }

    private class HashClassLoader
    extends ClassLoader {
        private Hashtable classes;

        public HashClassLoader(Hashtable ht, ClassLoader parent) {
            super(parent);
            this.classes = ht;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            String fileName = name.replace('.', '/') + ".class";
            byte[] code = (byte[])this.classes.get(fileName);
            if (code != null) {
                return this.defineClass(name, code, 0, code.length);
            }
            throw new ClassNotFoundException("Class " + name + " does not exist");
        }
    }
}

