/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends ClassLoader {
    public static final int BUFFER_SIZE = 1024;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private JarFile[] jarFiles;
    private File[] files;

    public JarClassLoader(File f, ClassLoader parent) throws IOException {
        this(new File[]{f}, parent);
    }

    public JarClassLoader(File[] ff, ClassLoader parent) throws IOException {
        super(parent);
        this.files = ff != null ? ff : new File[]{};
        this.jarFiles = new JarFile[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            this.jarFiles[i] = new JarFile(this.files[i]);
        }
    }

    public void close() {
        for (int i = 0; i < this.files.length; ++i) {
            try {
                this.jarFiles[i].close();
                continue;
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, "Error closing Jar file: " + this.jarFiles[i].getName());
            }
        }
    }

    public String getJarFileName() {
        if (this.files != null && this.files.length > 0) {
            return this.files[0].getAbsolutePath();
        }
        return null;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream is = this.getResourceAsStream(resourceName);
        if (is != null) {
            try {
                byte[] rawClass = this.readFully(is);
                is.close();
                return this.defineClass(className, rawClass, 0, rawClass.length);
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("Error getting class " + className + " from JAR file " + this.getJarFileName() + " " + ioe);
            }
        }
        throw new ClassNotFoundException("Class " + className + " not found in JAR file: " + this.getJarFileName());
    }

    public URL findResource(String name) {
        String entryName = name.startsWith("/") ? name.substring(1) : name;
        for (int i = 0; i < this.jarFiles.length; ++i) {
            ZipEntry zEntry = this.jarFiles[i].getEntry(name);
            if (zEntry == null) continue;
            try {
                return new URL("jar:file:" + this.jarFiles[i].getName() + "!/" + entryName);
            }
            catch (MalformedURLException murle) {
                return null;
            }
        }
        return null;
    }

    private byte[] readFully(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int read = 0;
        while ((read = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

