/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.PersistentDeliveryFilter;
import jade.core.messaging.PersistentDeliveryManager;
import jade.core.messaging.PersistentDeliverySlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.io.IOException;

public class PersistentDeliveryService
extends BaseService {
    public static final String PERSISTENT_DELIVERY_FILTER = "persistent-delivery-filter";
    public static final String PERSISTENT_DELIVERY_SENDFAILUREPERIOD = "persistent-delivery-sendfailureperiod";
    public static final String PERSISTENT_DELIVERY_STORAGEMETHOD = "persistent-delivery-storagemethod";
    public static final String PERSISTENT_DELIVERY_BASEDIR = "persistent-delivery-basedir";
    static final String ACL_USERDEF_DUE_DATE = "JADE-persistentdelivery-duedate";
    private AgentContainer myContainer;
    private ServiceFinder myServiceFinder;
    private PersistentDeliveryManager myManager;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandOutgoingFilter outFilter = new CommandOutgoingFilter();
    private final CommandIncomingFilter inFilter = new CommandIncomingFilter();
    private PersistentDeliveryFilter messageFilter;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.myServiceFinder = this.myContainer.getServiceFinder();
    }

    public String getName() {
        return "jade.core.messaging.PersistentDelivery";
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.messaging.PersistentDeliverySlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean direction) {
        if (!direction) {
            return this.inFilter;
        }
        return this.outFilter;
    }

    public void boot(Profile myProfile) throws ServiceException {
        try {
            MessageManager.Channel ch = (MessageManager.Channel)((Object)this.myServiceFinder.findService("jade.core.messaging.Messaging"));
            if (ch == null) {
                throw new ServiceException("Can't locate delivery channel");
            }
            this.myManager = PersistentDeliveryManager.instance(myProfile, ch);
            this.myManager.start();
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
            throw new ServiceException("Cannot retrieve the delivery channel", imtpe);
        }
        try {
            String className = myProfile.getParameter(PERSISTENT_DELIVERY_FILTER, null);
            if (className != null) {
                Class<?> c = Class.forName(className);
                this.messageFilter = (PersistentDeliveryFilter)c.newInstance();
                this.myLogger.log(Logger.INFO, "Using message filter of type " + this.messageFilter.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new ServiceException("Exception in message filter initialization", e);
        }
    }

    private void flushMessages(final AID target) {
        Thread t = new Thread(){

            public void run() {
                try {
                    Service.Slice[] slices = PersistentDeliveryService.this.getAllSlices();
                    for (int i = 0; i < slices.length; ++i) {
                        PersistentDeliverySlice slice = (PersistentDeliverySlice)slices[i];
                        try {
                            slice.flushMessages(target);
                            continue;
                        }
                        catch (Exception e) {
                            PersistentDeliveryService.this.myLogger.log(Logger.WARNING, "Error trying to flush messages for agent " + target.getName() + " on node " + slice.getNode().getName());
                        }
                    }
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
            }
        };
        t.start();
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return PersistentDeliveryService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return PersistentDeliveryService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            VerticalCommand result = null;
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("5")) {
                    String storeName = (String)params[0];
                    ACLMessage acl = (ACLMessage)params[1];
                    Envelope env = (Envelope)params[2];
                    byte[] payload = (byte[])params[3];
                    Boolean foreignRecv = (Boolean)params[4];
                    String traceId = (String)params[5];
                    GenericMessage msg = new GenericMessage();
                    msg.update(acl, env, payload);
                    msg.setTraceID(traceId);
                    msg.setForeignReceiver(foreignRecv);
                    AID receiver = (AID)params[6];
                    boolean stored = this.storeMessage(storeName, msg, receiver);
                    cmd.setReturnValue(new Boolean(stored));
                } else if (cmdName.equals("6")) {
                    AID receiver = (AID)params[0];
                    this.flushMessages(receiver);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return result;
        }

        private boolean storeMessage(String storeName, GenericMessage msg, AID receiver) throws IMTPException, ServiceException {
            if (PersistentDeliveryService.this.messageFilter != null) {
                long dueDate;
                long now;
                boolean firstTime;
                block10: {
                    firstTime = false;
                    dueDate = now = System.currentTimeMillis();
                    try {
                        String dd = msg.getACLMessage().getUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE);
                        dueDate = Long.parseLong(dd);
                    }
                    catch (Exception e) {
                        long delay = PersistentDeliveryService.this.messageFilter.delayBeforeExpiration(msg.getACLMessage());
                        if (delay == 0L) break block10;
                        dueDate = delay == -1L ? delay : now + delay;
                        msg.getACLMessage().addUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE, String.valueOf(dueDate));
                        firstTime = true;
                    }
                }
                if (dueDate > now || dueDate == -1L) {
                    try {
                        if (firstTime) {
                            if (PersistentDeliveryService.this.myLogger.isLoggable(Logger.INFO)) {
                                PersistentDeliveryService.this.myLogger.log(Logger.INFO, "Storing message\n" + MessageManager.stringify(msg) + " for agent " + receiver.getName() + "\nDue date is " + dueDate);
                            }
                        } else if (PersistentDeliveryService.this.myLogger.isLoggable(Logger.FINE)) {
                            PersistentDeliveryService.this.myLogger.log(Logger.FINE, "Re-storing message\n" + MessageManager.stringify(msg) + " for agent " + receiver.getName() + "\nDue date is " + dueDate);
                        }
                        PersistentDeliveryService.this.myManager.storeMessage(storeName, msg, receiver);
                        return true;
                    }
                    catch (IOException ioe) {
                        throw new ServiceException("I/O Error in message storage", ioe);
                    }
                }
            }
            return false;
        }

        private void flushMessages(AID receiver) {
            int cnt = PersistentDeliveryService.this.myManager.flushMessages(receiver);
            if (cnt > 0) {
                PersistentDeliveryService.this.myLogger.log(Logger.INFO, "Delivered " + cnt + " messages to agent " + receiver);
            }
        }
    }

    private class CommandIncomingFilter
    extends Filter {
        private CommandIncomingFilter() {
        }

        public void postProcess(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
        }

        private void handleInformCreated(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            PersistentDeliveryService.this.flushMessages(agentID);
        }
    }

    private class CommandOutgoingFilter
    extends Filter {
        private CommandOutgoingFilter() {
        }

        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Notify-Failure")) {
                    return this.handleNotifyFailure(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
            return true;
        }

        private boolean handleNotifyFailure(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            GenericMessage msg = (GenericMessage)params[0];
            AID receiver = (AID)params[1];
            ACLMessage acl = msg.getACLMessage();
            if (PersistentDeliveryService.this.myLogger.isLoggable(Logger.FINE)) {
                PersistentDeliveryService.this.myLogger.log(Logger.FINE, "Processing failed message " + MessageManager.stringify(msg) + " for agent " + receiver.getName());
            }
            Service.Slice[] slices = PersistentDeliveryService.this.getAllSlices();
            for (int i = 0; i < slices.length; ++i) {
                PersistentDeliverySlice slice = (PersistentDeliverySlice)slices[i];
                try {
                    boolean firstTime = acl.getUserDefinedParameter(PersistentDeliveryService.ACL_USERDEF_DUE_DATE) == null;
                    boolean accepted = false;
                    try {
                        accepted = slice.storeMessage(null, msg, receiver);
                    }
                    catch (IMTPException imtpe) {
                        slice = (PersistentDeliverySlice)PersistentDeliveryService.this.getFreshSlice(slice.getNode().getName());
                        accepted = slice.storeMessage(null, msg, receiver);
                    }
                    if (!accepted) continue;
                    PersistentDeliveryService.this.myLogger.log(firstTime ? Logger.INFO : Logger.FINE, "Message " + MessageManager.stringify(msg) + " for agent " + receiver.getName() + " stored on node " + slice.getNode().getName());
                    return false;
                }
                catch (Exception e) {
                    PersistentDeliveryService.this.myLogger.log(Logger.WARNING, "Error trying to store message " + MessageManager.stringify(msg) + " for agent " + receiver.getName() + " on node " + slice.getNode().getName());
                }
            }
            return true;
        }
    }
}

