/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Specifier;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.JICPPeer;
import jade.mtp.TransportAddress;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Enumeration;
import java.util.Vector;

public class MaskableJICPPeer
extends JICPPeer {
    private Vector masks = new Vector();

    public TransportAddress activate(ICP.Listener l, String peerID, Profile p) throws ICPException {
        try {
            int idLength;
            StringBuffer sb = null;
            if (peerID != null) {
                sb = new StringBuffer(peerID);
                sb.append('-');
                idLength = sb.length();
            } else {
                sb = new StringBuffer();
                idLength = 0;
            }
            sb.append("unreachable");
            List ls = p.getSpecifiers(sb.toString());
            if (ls != null) {
                Iterator it = ls.iterator();
                while (it.hasNext()) {
                    Specifier s = (Specifier)it.next();
                    this.updateMask(s.getClassName());
                }
            }
        }
        catch (ProfileException pe) {
            throw new ICPException("Profile error. " + pe.getMessage());
        }
        return super.activate(l, peerID, p);
    }

    public byte[] deliverCommand(TransportAddress ta, byte[] payload, boolean requireFreshConnection) throws ICPException {
        if (!this.isMasked(ta.getHost())) {
            return super.deliverCommand(ta, payload, requireFreshConnection);
        }
        throw new ICPException("Destination masked");
    }

    private void updateMask(String m) throws ICPException {
        int[] mask = this.parseIP(m);
        this.masks.addElement(mask);
    }

    private boolean isMasked(String host) {
        try {
            int[] ipAddr = this.parseIP(host);
            Enumeration e = this.masks.elements();
            while (e.hasMoreElements()) {
                int[] mask = (int[])e.nextElement();
                boolean masked = true;
                for (int i = 0; i < mask.length; ++i) {
                    if (ipAddr[i] == mask[i]) continue;
                    masked = false;
                    break;
                }
                if (!masked) continue;
                return true;
            }
            return false;
        }
        catch (ICPException icpe) {
            return false;
        }
    }

    private int[] parseIP(String addr) throws ICPException {
        int n;
        int[] abcd = new int[4];
        int first = 0;
        try {
            boolean stop = false;
            for (n = 0; n < 3 && !stop; ++n) {
                int last = addr.indexOf(46, first);
                if (last < 0) {
                    last = addr.length();
                    stop = true;
                }
                String tmp = addr.substring(first, last);
                abcd[n] = Integer.parseInt(tmp);
                first = last + 1;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (n == 0) {
            throw new ICPException("Wrong mask");
        }
        int[] ipAddr = new int[n];
        for (int i = 0; i < n; ++i) {
            ipAddr[i] = abcd[i];
        }
        abcd = null;
        return ipAddr;
    }
}

